/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.TLManagerFactory;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.common.tl.processor.impl.LingeringObjectExpiredCommand;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class LingeringObjectRegistry {
    private static final Logger logger = Logger.getLogger(LingeringObjectRegistry.class);
    private Hashtable<String, RegistryEntry> lingeringObjectTable;
    private Peer localPeer;
    private Random random;
    private int counter;

    LingeringObjectRegistry(Peer peer) {
        ValidationHelper.checkForNull((String)"Peer", (Object)peer);
        this.localPeer = peer;
        this.lingeringObjectTable = new Hashtable();
        this.random = new Random();
        Thread thread = new Thread(new EvictionRunner());
        thread.setName("LingeringObjectEviction");
        thread.setPriority(1);
        thread.start();
    }

    public String bindObject(Object object, int n, PeerID peerID) {
        return this.instanceBindObject(object, n, peerID);
    }

    private void closeObject(Object object) throws Exception {
        Method method = object.getClass().getDeclaredMethod("close", new Class[0]);
        method.invoke(object, new Object[0]);
    }

    public Object get(String string) {
        return this.instanceGet(string);
    }

    private synchronized String getNextID() {
        ++this.counter;
        return this.random.nextLong() + "." + Integer.toString(this.counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String instanceBindObject(Object object, int n, PeerID peerID) {
        String string = this.getNextID();
        Hashtable<String, RegistryEntry> hashtable = this.lingeringObjectTable;
        synchronized (hashtable) {
            this.lingeringObjectTable.put(string, new RegistryEntry(object, n, peerID, string));
            logger.trace((Object)("Lingering object bound " + string + " = " + object.getClass().getName()));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceGet(String string) {
        Hashtable<String, RegistryEntry> hashtable = this.lingeringObjectTable;
        synchronized (hashtable) {
            RegistryEntry registryEntry = this.lingeringObjectTable.get(string);
            if (registryEntry == null) {
                return null;
            }
            if (registryEntry.isExpired()) {
                this.instanceRemove(string);
                return null;
            }
            registryEntry.resetTimer();
            return registryEntry.getObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instanceRemove(String string) {
        Hashtable<String, RegistryEntry> hashtable = this.lingeringObjectTable;
        synchronized (hashtable) {
            RegistryEntry registryEntry = this.lingeringObjectTable.remove(string);
            if (registryEntry != null) {
                Object object = registryEntry.getObject();
                if (registryEntry.isExpired() && object != null) {
                    logger.trace((Object)("Lingering object expired " + string + " = " + object.getClass().getName()));
                    this.notifyPeer(registryEntry.getPeerID(), registryEntry.getObjectID());
                }
                try {
                    this.closeObject(object);
                }
                catch (Exception exception) {
                    logger.debug((Object)("Exception thrown when closing expired lingering object " + string + " = " + object.getClass().getName()), (Throwable)exception);
                }
                logger.trace((Object)("Lingering Object removed: " + string));
            }
        }
        return null;
    }

    public Object remove(String string) {
        return this.instanceRemove(string);
    }

    private void notifyPeer(PeerID peerID, String string) {
        if (peerID == null || this.localPeer == null) {
            return;
        }
        logger.trace((Object)("Notifying peer " + peerID + " that lingering object " + string + " has expired."));
        try {
            LingeringObjectExpiredCommand lingeringObjectExpiredCommand = new LingeringObjectExpiredCommand(string);
            lingeringObjectExpiredCommand.setSource(this.localPeer.getRemotePeerID());
            Envelope envelope = new Envelope();
            envelope.setDestination(peerID);
            envelope.setPayload(lingeringObjectExpiredCommand);
            this.localPeer.sendEnvelope(envelope);
        }
        catch (Exception exception) {
            logger.trace((Object)("Tried to notify peer " + peerID + " that lingering object " + string + " had expired."), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runEviction() {
        HashSet<PeerID> hashSet = new HashSet<PeerID>();
        hashSet.addAll(Arrays.asList(this.localPeer.getPeersFromRoutingTable()));
        ArrayList<PeerID> arrayList = new ArrayList<PeerID>(Arrays.asList(this.localPeer.getGatewaysFromRoutingTable()));
        Hashtable<String, RegistryEntry> hashtable = this.lingeringObjectTable;
        synchronized (hashtable) {
            Set<Map.Entry<String, RegistryEntry>> set = this.lingeringObjectTable.entrySet();
            Iterator<Map.Entry<String, RegistryEntry>> iterator = set.iterator();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            block3: while (iterator.hasNext()) {
                Map.Entry<String, RegistryEntry> entry = iterator.next();
                RegistryEntry object = entry.getValue();
                if (object.isExpired()) {
                    logger.trace((Object)("Remote Lingering Object " + entry.getKey() + " has expired and will be removed."));
                    arrayList2.add(entry.getKey());
                    continue;
                }
                PeerID peerID = object.pd;
                while (!hashSet.contains(peerID)) {
                    if (arrayList.size() == 0) {
                        logger.trace((Object)("Remote Lingering Object " + entry.getKey() + " will be removed because peer " + peerID + " is no longer reachable."));
                        arrayList2.add(entry.getKey());
                        continue block3;
                    }
                    PeerID peerID2 = (PeerID)arrayList.remove(0);
                    this.fetchPeers(peerID2, hashSet);
                }
            }
            if (arrayList2.size() > 0) {
                for (String string : arrayList2) {
                    this.instanceRemove(string);
                }
            }
        }
    }

    private void fetchPeers(PeerID peerID, HashSet<PeerID> hashSet) {
        try {
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)TLManagerFactory.createProxy(IPeerInfoManager.class, this.localPeer, peerID, "PEER.PeerInfoManager");
            PeerID[] peerIDArray = iPeerInfoManager.getPeersFromRoutingTable();
            hashSet.addAll(Arrays.asList(peerIDArray));
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to get a listing of peers from host " + peerID), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfoHTML() {
        RegistryEntry[] registryEntryArray = null;
        Serializable serializable = this.lingeringObjectTable;
        synchronized (serializable) {
            Collection<RegistryEntry> collection = this.lingeringObjectTable.values();
            registryEntryArray = new RegistryEntry[collection.size()];
            collection.toArray(registryEntryArray);
        }
        Arrays.sort(registryEntryArray, new Comparator<RegistryEntry>(){

            @Override
            public int compare(RegistryEntry registryEntry, RegistryEntry registryEntry2) {
                String string = registryEntry.getPeerID().getPeerDescriptor().findPrintableAddress();
                String string2 = registryEntry2.getPeerID().getPeerDescriptor().findPrintableAddress();
                return string.compareTo(string2);
            }
        });
        serializable = new StringBuffer();
        if (registryEntryArray.length == 0) {
            ((StringBuffer)serializable).append("No entries.\n");
        } else {
            ((StringBuffer)serializable).append("<table border=\"1\" bordercolor=\"gray\" cellspacing=\"0\">\n");
            ((StringBuffer)serializable).append("<tr><td><b>Peer</b></td>");
            ((StringBuffer)serializable).append("<td><b>ObjectID</b></td>");
            ((StringBuffer)serializable).append("<td><b>Object</b></td>");
            ((StringBuffer)serializable).append("<td><b>Expires</b></td>");
            ((StringBuffer)serializable).append("</tr>\n");
            for (int i = 0; i < registryEntryArray.length; ++i) {
                ((StringBuffer)serializable).append("<tr><td>");
                ((StringBuffer)serializable).append(registryEntryArray[i].getPeerID().getPeerDescriptor().findPrintableAddress());
                ((StringBuffer)serializable).append("</td><td>");
                ((StringBuffer)serializable).append(registryEntryArray[i].objectID);
                ((StringBuffer)serializable).append("</td><td>");
                ((StringBuffer)serializable).append(registryEntryArray[i].getObject().getClass().getName());
                ((StringBuffer)serializable).append("</td><td>");
                if (registryEntryArray[i].timeout < 0L) {
                    ((StringBuffer)serializable).append("never");
                } else {
                    Date date = new Date(registryEntryArray[i].expirationTime);
                    ((StringBuffer)serializable).append(date.toString());
                }
                ((StringBuffer)serializable).append("</td></tr>\n");
            }
            ((StringBuffer)serializable).append("</table>\n");
        }
        return ((StringBuffer)serializable).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryEntry[] getEntries() {
        RegistryEntry[] registryEntryArray = null;
        Hashtable<String, RegistryEntry> hashtable = this.lingeringObjectTable;
        synchronized (hashtable) {
            registryEntryArray = new RegistryEntry[this.lingeringObjectTable.size()];
            int n = 0;
            Iterator<RegistryEntry> iterator = this.lingeringObjectTable.values().iterator();
            while (iterator.hasNext()) {
                registryEntryArray[n] = iterator.next();
                ++n;
            }
        }
        return registryEntryArray;
    }

    class EvictionRunner
    implements Runnable {
        EvictionRunner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LingeringObjectRegistry.this.runEviction();
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"EvictionRunner ended in error.", throwable);
                return;
            }
        }
    }

    public class RegistryEntry {
        private long expirationTime;
        private long timeout;
        private Object object;
        private PeerID pd;
        private String objectID;

        public RegistryEntry(Object object, long l, PeerID peerID, String string) {
            this.object = object;
            this.timeout = l;
            this.pd = peerID;
            this.objectID = string;
            this.resetTimer();
        }

        public Object getObject() {
            return this.object;
        }

        public String getObjectID() {
            return this.objectID;
        }

        public boolean isExpired() {
            if (this.timeout < 0L) {
                return false;
            }
            return this.expirationTime <= System.currentTimeMillis();
        }

        public void resetTimer() {
            this.expirationTime = System.currentTimeMillis() + this.timeout;
        }

        public PeerID getPeerID() {
            return this.pd;
        }
    }
}

