/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.tl.IDFactory;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.processor.Processable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public final class Envelope
extends CommonVersionedObject {
    private static final long serialVersionUID = -5697447678504066717L;
    public static final int PAYLOAD_SERIALIZED = 16;
    public static final int PAYLOAD_DESERIALIZED = 32;
    private String arbitraryID = IDFactory.nextEnvelopeID();
    private String responseID;
    private PeerID source;
    private PeerID destination;
    private PeerID firstHop;
    private byte[] payload;
    private String payloadClassname;
    private ArrayList<PeerID> routeList = new ArrayList();
    private int remainingHops = 3;
    private int priority;
    transient Processable deserializedPayload;
    private Locale senderLocale = Locale.getDefault();
    private HashSet<PeerID> uselessPeerSet = new HashSet();

    public void appendToRoute(PeerID peerID) {
        this.routeList.add(peerID);
    }

    public void addUselessPeer(PeerID peerID) {
        this.uselessPeerSet.add(peerID);
    }

    protected void beforeWriting() throws IOException {
        if ((this.getPayloadState() & 0x10) == 0 && this.deserializedPayload != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.deserializedPayload);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            this.setPayloadBytes(byteArrayOutputStream.toByteArray(), this.deserializedPayload.getClass().getName());
        }
    }

    public String getArbitraryID() {
        return this.arbitraryID;
    }

    public PeerID getDestination() {
        return this.destination;
    }

    public Processable getPayload() throws IOException, ClassNotFoundException {
        if (this.deserializedPayload != null) {
            return this.deserializedPayload;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.payload);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.deserializedPayload = (Processable)objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return this.deserializedPayload;
    }

    public byte[] getPayloadBytes() {
        return this.payload;
    }

    public String getPayloadClassname() {
        return this.payloadClassname;
    }

    public int getRemainingHops() {
        return this.remainingHops;
    }

    public PeerID getFirstHop() {
        return this.firstHop;
    }

    public void setFirstHop(PeerID peerID) {
        this.firstHop = peerID;
    }

    public String getResponseToEnvelopeID() {
        return this.responseID;
    }

    public PeerID[] getRoute() {
        PeerID[] peerIDArray = new PeerID[this.routeList.size()];
        this.routeList.toArray(peerIDArray);
        return peerIDArray;
    }

    public int getPriority() {
        return this.priority;
    }

    public Locale getSenderLocale() {
        return this.senderLocale;
    }

    public PeerID getSource() {
        return this.source;
    }

    public PeerID[] getUselessPeers() {
        PeerID[] peerIDArray = new PeerID[this.uselessPeerSet.size()];
        this.uselessPeerSet.toArray(peerIDArray);
        return peerIDArray;
    }

    public boolean isUselessPeer(PeerID peerID) {
        return this.uselessPeerSet.contains(peerID);
    }

    void setArbitraryID(String string) {
        this.arbitraryID = string;
    }

    public void setDestination(PeerID peerID) {
        this.destination = peerID;
    }

    void setDeserializedPayload(Processable processable) {
        this.deserializedPayload = processable;
    }

    int getPayloadState() {
        int n = 0;
        if (this.deserializedPayload != null) {
            n |= 0x20;
        }
        if (this.payload != null && this.payloadClassname != null) {
            n |= 0x10;
        }
        return n;
    }

    public void setPayload(Processable processable) {
        this.deserializedPayload = processable;
        this.payloadClassname = processable.getClass().getName();
    }

    void setPayloadBytes(byte[] byArray, String string) {
        this.payload = byArray;
        this.payloadClassname = string;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void setResponseToEnvelopeID(String string) {
        this.responseID = string;
    }

    public void setRemainingHops(int n) {
        this.remainingHops = n;
    }

    public void setSource(PeerID peerID) {
        this.source = peerID;
    }

    public String toString() {
        return this.payloadClassname + " ID= " + this.getArbitraryID();
    }

    public String toVerboseString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Processing envelope ");
        stringBuffer.append(this.getArbitraryID());
        stringBuffer.append("\n   Source : ");
        stringBuffer.append(this.getSource());
        stringBuffer.append("\n   Dest   : ");
        stringBuffer.append(this.getDestination());
        PeerID[] peerIDArray = this.getRoute();
        if (peerIDArray.length > 1) {
            stringBuffer.append("\n   Route  : ");
            for (int i = 0; i < peerIDArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" --> ");
                }
                stringBuffer.append(peerIDArray[i]);
            }
            stringBuffer.append(" --> ");
            stringBuffer.append(this.getDestination());
        }
        stringBuffer.append("\n   Payload: ");
        stringBuffer.append(this.getPayloadClassname());
        stringBuffer.append("\n   OtherID: ");
        stringBuffer.append(this.getResponseToEnvelopeID());
        return stringBuffer.toString();
    }
}

