/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.IRemoteLingeringObject;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.ex.ObjectExpiredException;
import com.helpsystems.common.tl.processor.CommandResponse;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.impl.LingeringObjectCommand;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class RemoteLingeringObject
extends CommonVersionedObject
implements IRemoteLingeringObject {
    private static final long serialVersionUID = 4632421334322102864L;
    private static final Logger logger = Logger.getLogger(RemoteLingeringObject.class);
    private static final int TIMEOUT = 60000;
    protected String objectID;
    protected PeerID remotePeerID;
    protected PeerID firstHopPeerID;
    protected transient Peer localPeer;
    private boolean expired;
    private static HashMap<PeerID, DelivererThread> deliveryTable = new HashMap();

    protected RemoteLingeringObject() {
    }

    public RemoteLingeringObject(String string, PeerID peerID) {
        this.setObjectID(string);
        this.setRemotePeerID(peerID);
    }

    public Peer getLocalPeer() {
        return this.localPeer;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public PeerID getRemotePeerID() {
        return this.remotePeerID;
    }

    public PeerID getFirstHop() {
        return this.firstHopPeerID;
    }

    public void setFirstHop(PeerID peerID) {
        this.firstHopPeerID = peerID;
    }

    public void close() throws Exception {
    }

    public boolean isExpired() {
        return this.expired;
    }

    protected Object invokeMethod(String string, Class[] classArray, Object[] objectArray) {
        return this.invokeMethod(string, classArray, objectArray, true, false);
    }

    protected Object invokeMethod(String string, Class[] classArray, Object[] objectArray, boolean bl, boolean bl2) {
        Object object;
        if (this.isExpired()) {
            throw new ObjectExpiredException("This object has expired and is  no longer available on the server.\n");
        }
        if (this.localPeer == null) {
            throw new NullPointerException("The local peer is null.");
        }
        if (this.remotePeerID == null) {
            throw new NullPointerException("The remote peer information is null.");
        }
        if (this.objectID == null) {
            throw new NullPointerException("The object ID is null.");
        }
        Envelope envelope = new Envelope();
        envelope.setDestination(this.remotePeerID);
        envelope.setFirstHop(this.firstHopPeerID);
        LingeringObjectCommand lingeringObjectCommand = new LingeringObjectCommand(this.objectID, string, classArray, objectArray);
        lingeringObjectCommand.setFinishedWithObject(bl2);
        lingeringObjectCommand.setSource(this.localPeer.getRemotePeerID());
        Envelope envelope2 = null;
        CommandResponse commandResponse = null;
        try {
            envelope.setPayload((Processable)lingeringObjectCommand);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to prepare envelope to " + this.remotePeerID.getPeerDescriptor(), exception);
        }
        if (bl) {
            try {
                envelope2 = this.localPeer.sendEnvelopeAndWait(envelope);
                commandResponse = (CommandResponse)envelope2.getPayload();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to send an envelope to " + this.remotePeerID.getPeerDescriptor(), exception);
            }
        } else {
            object = RemoteLingeringObject.getDeliveryThread(this.localPeer, this.remotePeerID);
            ((DelivererThread)object).enqueue(this, string, envelope);
        }
        if (commandResponse == null) {
            return null;
        }
        object = commandResponse.getResponse();
        if (object != null && object instanceof Throwable) {
            throw new RuntimeException("Error processing the request on the remote server " + this.remotePeerID.getPeerDescriptor(), (Throwable)object);
        }
        return object;
    }

    protected void handleFailure(String string, Throwable throwable) {
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
    }

    public void setLocalPeer(Peer peer) {
        this.localPeer = peer;
    }

    public void setObjectID(String string) {
        this.objectID = string;
    }

    public void setRemotePeerID(PeerID peerID) {
        this.remotePeerID = peerID;
    }

    public boolean equals(Object object) {
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        RemoteLingeringObject remoteLingeringObject = (RemoteLingeringObject)((Object)object);
        return super.equals(object) && Equal.isEqual((Object)this.objectID, (Object)remoteLingeringObject.objectID) && Equal.isEqual((Object)this.remotePeerID, (Object)remoteLingeringObject.remotePeerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DelivererThread getDeliveryThread(Peer peer, PeerID peerID) {
        HashMap<PeerID, DelivererThread> hashMap = deliveryTable;
        synchronized (hashMap) {
            DelivererThread delivererThread = deliveryTable.get(peerID);
            if (delivererThread == null || !delivererThread.isRunning()) {
                long l = SkybotStackSize.getStackSize();
                delivererThread = l != 0L ? new DelivererThread(peer, peerID, l) : new DelivererThread(peer, peerID);
                deliveryTable.put(peerID, delivererThread);
                delivererThread.start();
            }
            return delivererThread;
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static class QueueEntry {
        Envelope envelope;
        RemoteLingeringObject rlo;
        String methodName;

        QueueEntry(RemoteLingeringObject remoteLingeringObject, String string, Envelope envelope) {
            this.envelope = envelope;
            this.rlo = remoteLingeringObject;
            this.methodName = string;
        }
    }

    static class DelivererThread
    extends Thread {
        ArrayList<QueueEntry> queue;
        Peer localPeer;
        PeerID remotePeerID;
        boolean exiting;

        DelivererThread(Peer peer, PeerID peerID) {
            this.initDelivererThread(peer, peerID);
        }

        DelivererThread(Peer peer, PeerID peerID, long l) {
            super(null, null, "DelivererThread", l);
            this.initDelivererThread(peer, peerID);
        }

        private void initDelivererThread(Peer peer, PeerID peerID) {
            this.localPeer = peer;
            this.remotePeerID = peerID;
            this.queue = new ArrayList();
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(RemoteLingeringObject remoteLingeringObject, String string, Envelope envelope) {
            ArrayList<QueueEntry> arrayList = this.queue;
            synchronized (arrayList) {
                this.queue.add(new QueueEntry(remoteLingeringObject, string, envelope));
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isRunning() {
            ArrayList<QueueEntry> arrayList = this.queue;
            synchronized (arrayList) {
                return this.isAlive() & !this.exiting;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void updateName() {
            int n = this.queue.size();
            if (this.exiting) {
                this.setName("Remote Dispatch thread exiting: " + this.remotePeerID);
            }
            if (n == 0) {
                this.setName("Nothing to send to " + this.remotePeerID);
            } else if (n == 1) {
                this.setName("Sending an envelope to " + this.remotePeerID);
            } else {
                this.setName("Sending " + n + " envelopes to " + this.remotePeerID);
            }
        }
    }
}

