/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.dataset.DataSetWithAttributes;
import com.helpsystems.common.core.access.dataset.ReloadableDataSet;
import com.helpsystems.common.core.access.dataset.ReloadableMultiCountDataSet;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.IRemoteLingeringObject;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.ChameleonThrowable;
import com.helpsystems.common.tl.busobj.TunnelEndpointSocket;
import com.helpsystems.common.tl.ex.RemoteManagerNotFoundException;
import com.helpsystems.common.tl.processor.Command;
import com.helpsystems.common.tl.processor.CommandResponse;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.common.tl.processor.impl.DataManagerCommand;
import com.helpsystems.transport.moduleimpl.processor.RemoteDataSetWithAttributes;
import com.helpsystems.transport.moduleimpl.processor.RemoteLingeringDataSet;
import com.helpsystems.transport.moduleimpl.processor.RemoteLingeringFileHandle;
import com.helpsystems.transport.moduleimpl.processor.RemoteLingeringTunnelEndpointSocket;
import com.helpsystems.transport.moduleimpl.processor.RemoteReloadableLingeringDataSet;
import com.helpsystems.transport.moduleimpl.processor.RemoteReloadableMultiCountLingeringDataSet;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class DataManagerProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(DataManagerProcessor.class);
    public static final int NEVER_TIMEOUT = -1;
    public static final int DATA_SET_THRESHOLD = 200;

    public String[] listCommands() {
        return new String[]{DataManagerCommand.class.getName()};
    }

    protected void processCommand(HeavyweightPeer heavyweightPeer, Envelope envelope, DataManagerCommand dataManagerCommand) {
        Class<?> clazz;
        Method method;
        String string;
        PeerID peerID = envelope.getSource();
        if (logger.isTraceEnabled()) {
            this.printDetails(peerID, dataManagerCommand);
        }
        if ((string = dataManagerCommand.getDataManagerName()) == null) {
            throw new NullPointerException("The data manager name in the command is null.");
        }
        IAbstractManager iAbstractManager = ManagerRegistry.getManager((String)string);
        if (iAbstractManager == null) {
            throw new RemoteManagerNotFoundException(heavyweightPeer.getRemotePeerID().getPeerDescriptor(), string, 0);
        }
        String string2 = dataManagerCommand.getMethodName();
        if (string2 == null) {
            throw new NullPointerException("The method name in the command is null.");
        }
        Object object2 = null;
        Class[] classArray = dataManagerCommand.getParameterTypes();
        if (classArray == null) {
            classArray = new Class[]{};
        }
        if ((method = XMLReflector.findMethod(clazz = iAbstractManager.getClass(), (String)string2, (Class[])classArray)) == null) {
            throw new NullPointerException("The method " + string2 + " does not exist in " + clazz);
        }
        Object[] objectArray = dataManagerCommand.getParameters();
        if (objectArray != null) {
            for (Object object : objectArray) {
                IRemoteLingeringObject iRemoteLingeringObject;
                if (!(object instanceof IRemoteLingeringObject) || (iRemoteLingeringObject = (IRemoteLingeringObject)object).getLocalPeer() != null) continue;
                iRemoteLingeringObject.setLocalPeer((Peer)heavyweightPeer);
            }
        }
        try {
            object2 = method.invoke((Object)iAbstractManager, objectArray);
            logger.trace((Object)("Method '" + string2 + "' returned " + object2));
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = new Exception("The DataManagerProcessor on server " + heavyweightPeer.getLocalPeerDescriptor() + " was unable to invoke the method " + method.getName() + " on object " + iAbstractManager.getClass().getName() + " due to an IllegalAccessException", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object2 = new Exception("The DataManagerProcessor on server " + heavyweightPeer.getLocalPeerDescriptor() + " was unable to invoke the method " + method.getName() + " on object " + iAbstractManager.getClass().getName() + " due to an IllegalArgumentException", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = new ChameleonThrowable(invocationTargetException.getCause());
            logger.trace((Object)("Method '" + string2 + "' threw " + invocationTargetException.getCause().getClass().getName() + ": " + invocationTargetException.getCause().getMessage()));
        }
        if (object2 != null && object2 instanceof DataSet) {
            DataSet dataSet = (DataSet)object2;
            int n = -1;
            try {
                n = dataSet.size();
            }
            catch (DataSetException dataSetException) {
                // empty catch block
            }
            if (n > 200 || !(dataSet instanceof Serializable)) {
                Object object;
                String string3 = heavyweightPeer.getRemoteObjectRegistry().bindObject((Object)dataSet, -1, peerID);
                object = null;
                object = dataSet instanceof ReloadableMultiCountDataSet ? new RemoteReloadableMultiCountLingeringDataSet(string3, heavyweightPeer.getRemotePeerID()) : (dataSet instanceof ReloadableDataSet ? new RemoteReloadableLingeringDataSet(string3, heavyweightPeer.getRemotePeerID()) : (dataSet instanceof DataSetWithAttributes ? new RemoteDataSetWithAttributes(string3, heavyweightPeer.getRemotePeerID()) : new RemoteLingeringDataSet(string3, heavyweightPeer.getRemotePeerID())));
                ((RemoteLingeringDataSet)((Object)object)).setSize(n);
                object2 = object;
                logger.trace((Object)("The object is a 'large' DataSet, so I'll send back a " + object2));
            }
        }
        if (object2 != null && object2 instanceof FileHandle) {
            String string4 = heavyweightPeer.getRemoteObjectRegistry().bindObject(object2, -1, peerID);
            RemoteLingeringFileHandle remoteLingeringFileHandle = new RemoteLingeringFileHandle(string4, heavyweightPeer.getRemotePeerID());
            object2 = remoteLingeringFileHandle;
        }
        if (object2 != null && object2 instanceof TunnelEndpointSocket) {
            String string5 = heavyweightPeer.getRemoteObjectRegistry().bindObject(object2, -1, peerID);
            RemoteLingeringTunnelEndpointSocket remoteLingeringTunnelEndpointSocket = new RemoteLingeringTunnelEndpointSocket(string5, heavyweightPeer.getRemotePeerID());
            object2 = remoteLingeringTunnelEndpointSocket;
        }
        CommandResponse commandResponse = new CommandResponse(object2);
        commandResponse.setSource(heavyweightPeer.getRemotePeerID());
        commandResponse.setCommand((Command)dataManagerCommand);
        try {
            this.sendReplyEnvelope(heavyweightPeer, envelope, (Processable)commandResponse);
        }
        catch (Exception exception) {
            logger.debug((Object)("Error sending a response to " + envelope.getSource()), (Throwable)exception);
        }
    }

    public void processObject(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) {
        if (processable instanceof DataManagerCommand) {
            this.processCommand(heavyweightPeer, envelope, (DataManagerCommand)processable);
            return;
        }
        logger.debug((Object)("The DataManagerProcessor doesn't care about " + processable.getClass().getName()));
    }

    private void printDetails(PeerID peerID, DataManagerCommand dataManagerCommand) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Peer ");
        stringBuffer.append(peerID);
        stringBuffer.append(" invoking DataManagerCommand:\n");
        stringBuffer.append("\tDM Name: " + dataManagerCommand.getDataManagerName() + "\n");
        stringBuffer.append("\tMethod : " + dataManagerCommand.getMethodName() + "\n");
        Class[] classArray = dataManagerCommand.getParameterTypes();
        Object[] objectArray = dataManagerCommand.getParameters();
        if (classArray.length == 0) {
            stringBuffer.append("\tParams : None.\n");
        } else {
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append("\tParam  : ");
                Class<?> clazz = classArray[i];
                boolean bl = false;
                if (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                    bl = true;
                }
                stringBuffer.append(clazz.getName());
                if (bl) {
                    stringBuffer.append("[]");
                }
                stringBuffer.append(" = ");
                if (i >= objectArray.length) {
                    stringBuffer.append("[Missing]");
                } else {
                    Object object = objectArray[i];
                    if (object == null) {
                        stringBuffer.append("null");
                    } else if (object instanceof Object[]) {
                        Object[] objectArray2 = (Object[])object;
                        stringBuffer.append(objectArray2.getClass().getComponentType().getName());
                        stringBuffer.append("[");
                        stringBuffer.append(objectArray2.length);
                        stringBuffer.append("]");
                    } else {
                        stringBuffer.append(objectArray[i]);
                    }
                }
                stringBuffer.append("\n");
            }
        }
        logger.trace((Object)stringBuffer.toString());
    }
}

