/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.Trace;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SessionTimeoutChecker
implements AutoJobRunner.AutoJob {
    private static long checkPeriod = 300000L;
    private static long waitTime = 600000L;
    private long lastExecution;
    private boolean checkIsAlive;
    private Map<String, ? extends Context> contexts;

    SessionTimeoutChecker(Map<String, ? extends Context> contexts, boolean checkIsAlive) {
        this.checkIsAlive = checkIsAlive;
        this.contexts = contexts;
    }

    @Override
    public final void execute() {
        long now = System.currentTimeMillis();
        this.lastExecution = System.currentTimeMillis();
        SessionReferenceProvider sessionRefProvider = RuntimeEnvironment.getSessionReferenceProvider();
        JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
        if (sessionRefProvider != null) {
            Context[] copy = this.contexts.values().toArray(new Context[this.contexts.size()]);
            for (int i = 0; i < copy.length; ++i) {
                try {
                    String sessionID = copy[i].getSessionID();
                    if (sessionID == null || now <= copy[i].lastAccess + waitTime || this.checkIsAlive && sessionRefProvider.isSessionAlive(sessionID)) continue;
                    copy[i].clearServerConnection();
                    runtime.releaseRuntimeContext(copy[i]);
                    continue;
                }
                catch (Throwable th) {
                    if (!Trace.isOn(8)) continue;
                    Trace.fireTrace(8, "Exception thrown by the application code from isSessionAlive", th);
                }
            }
        }
    }

    static void setTimeout(long interval) {
        waitTime = interval;
    }

    static void setTimeoutCheckInterval(long interval) {
        checkPeriod = interval;
    }

    @Override
    public long getExecutePeriode() {
        return checkPeriod;
    }

    @Override
    public long getLastExecutionTime() {
        return this.lastExecution;
    }
}

