/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.client.components.HSJDialog;
import com.helpsystems.common.client.components.HSJFrame;
import com.helpsystems.common.client.components.HelpMapID;
import com.helpsystems.common.client.components.throwabledialog.ThrowableDialog;
import com.helpsystems.common.client.util.SwingWorkerTarget;
import com.helpsystems.common.core.xml.ObjectPair;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.enterprise.RBEHelpManager;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceConfig;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.service.DuplicatePortNumberException;
import com.helpsystems.enterprise.service.FileExistsException;
import com.helpsystems.enterprise.tray.AgentConfigPanel;
import com.helpsystems.enterprise.tray.ServerEntryConfigPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Document;

public class ServerEntryConfigDialog
extends HSJDialog {
    public static final int MODE_ADD = 0;
    public static final int MODE_EDIT = 1;
    public static final int MODE_COPY = 2;
    private static final Insets STANDARD_INSET = new Insets(6, 6, 6, 6);
    private boolean isReplace = false;
    public static final String DEFAULT_PATH_ENTRY = System.getProperty("user.dir");
    private AgentServiceEntry originalServiceEntry;
    private AgentServiceEntry serviceEntry;
    private AgentConfigPanel extendedConfigPanel = null;
    private GridBagConstraints gbcExt = null;
    private AgentPeerConfig config;
    private AgentServiceAM validator = null;
    private int mode = 1;
    ServerEntryConfigPanel configPanel = null;
    JPanel commandPanel = null;
    Action okAction = new AbstractAction("OK"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                    boolean wasSaved = false;

                    public void construct() {
                        int n = -1;
                        try {
                            ServerEntryConfigDialog.this.serviceEntry = ServerEntryConfigDialog.this.configPanel.getConfig();
                            n = ServerEntryConfigDialog.this.extendedConfigPanel.getNotifyPort();
                            if (ServerEntryConfigDialog.this.mode != 1 && ServerEntryConfigDialog.this.validator != null && !ServerEntryConfigDialog.this.validator.okToAddEntry(ServerEntryConfigDialog.this.serviceEntry, n, false)) {
                                ServerEntryConfigDialog.this.serviceEntry = null;
                                this.wasSaved = false;
                                return;
                            }
                        }
                        catch (DuplicatePortNumberException duplicatePortNumberException) {
                            if (JOptionPane.showConfirmDialog((Component)((Object)ServerEntryConfigDialog.this), "The Local Agent Port " + n + " is already defined" + " in another Agent configuration.  Continue anyway?", "Warning", 0) != 0) {
                                ServerEntryConfigDialog.this.serviceEntry = null;
                                this.wasSaved = false;
                                return;
                            }
                        }
                        catch (Exception exception) {
                            String string = exception.getLocalizedMessage();
                            if (string == null || string.trim().length() == 0) {
                                string = "Could not create the Agent Configuration.";
                            }
                            ThrowableDialog.showThrowable((Component)((Object)ServerEntryConfigDialog.this), (String)string, (Throwable)exception);
                            ServerEntryConfigDialog.this.serviceEntry = null;
                            this.wasSaved = false;
                            return;
                        }
                        if (ServerEntryConfigDialog.this.originalServiceEntry != null) {
                            try {
                                ServerEntryConfigDialog.this.config = ServerEntryConfigDialog.this.originalServiceEntry.loadPeerConfig();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                throw new RuntimeException("The configuration file to copy does not exist.", fileNotFoundException);
                            }
                        }
                        String string = "log4j.appender.R.File";
                        ServerEntryConfigDialog.this.config.removeLog4jSetting(string);
                        ObjectPair objectPair = new ObjectPair();
                        objectPair.setKey((Object)string);
                        String string2 = ServerEntryConfigDialog.this.serviceEntry.getLogFileName();
                        objectPair.setValue((Object)string2);
                        ServerEntryConfigDialog.this.config.addLog4jSetting(objectPair);
                        try {
                            ServerEntryConfigDialog.this.extendedConfigPanel.captureAgentConfig(ServerEntryConfigDialog.this.config);
                        }
                        catch (Exception exception) {
                            String string3 = exception.getLocalizedMessage();
                            if (string3 == null || string3.trim().length() == 0) {
                                string3 = "Could not create the Agent Configuration.";
                            }
                            ThrowableDialog.showThrowable((Component)((Object)ServerEntryConfigDialog.this), (String)string3, (Throwable)exception);
                            this.wasSaved = false;
                            ServerEntryConfigDialog.this.setMode(1);
                            return;
                        }
                        boolean bl = true;
                        if (bl) {
                            try {
                                ServerEntryConfigDialog.this.serviceEntry.savePeerConfig(ServerEntryConfigDialog.this.config, ServerEntryConfigDialog.this.isReplace);
                                this.wasSaved = true;
                            }
                            catch (FileExistsException fileExistsException) {
                                String string4 = fileExistsException.getLocalizedMessage();
                                if (string4 == null || string4.trim().length() == 0) {
                                    string4 = "Duplicate file name while saving agent configuration.";
                                }
                                ThrowableDialog.showThrowable((Component)((Object)ServerEntryConfigDialog.this), (String)string4, (Throwable)fileExistsException);
                                this.wasSaved = false;
                                ServerEntryConfigDialog.this.pack();
                                return;
                            }
                            catch (Throwable throwable) {
                                ThrowableDialog.showThrowable((Component)((Object)ServerEntryConfigDialog.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                                this.wasSaved = false;
                                ServerEntryConfigDialog.this.pack();
                                return;
                            }
                        }
                    }

                    public void finished() {
                        if (this.wasSaved) {
                            ServerEntryConfigDialog.this.defaultCancelButtonAction();
                        }
                    }
                };
                swingWorkerTarget.setForceFinishedCall(true);
                ServerEntryConfigDialog.this.suspendAndRun(swingWorkerTarget);
            }
            catch (Exception exception) {
                String string = exception.getLocalizedMessage();
                if (string == null || string.trim().length() == 0) {
                    string = "Error saving agent configuration.";
                }
                ThrowableDialog.showThrowable((Component)((Object)ServerEntryConfigDialog.this), (String)string, (Throwable)exception);
            }
        }
    };
    JButton btnOK = new JButton(this.okAction);
    Action cancelAction = new AbstractAction("Cancel"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerEntryConfigDialog.this.cancelButtonAction();
        }
    };
    JButton btnCancel = new JButton(this.cancelAction);

    public ServerEntryConfigDialog() {
        this.init();
    }

    public ServerEntryConfigDialog(HSJDialog hSJDialog, int n) {
        super((Dialog)hSJDialog);
        this.init();
        this.setMode(n);
    }

    public ServerEntryConfigDialog(HSJFrame hSJFrame, int n) {
        super((Frame)hSJFrame);
        this.init();
        this.setMode(n);
    }

    public ServerEntryConfigDialog(HSJFrame hSJFrame, AgentServiceEntry agentServiceEntry, int n) throws FileNotFoundException {
        super((Frame)hSJFrame);
        this.init();
        this.setMode(n);
        this.load(agentServiceEntry);
    }

    public void setMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Mode is not a supported mode.  MODE=" + n);
        }
        this.mode = n;
        if (this.extendedConfigPanel == null) {
            this.extendedConfigPanel = new AgentConfigPanel((Window)((Object)this));
        }
        this.add(this.extendedConfigPanel, this.gbcExt);
        this.extendedConfigPanel.invalidate();
        if (n == 1) {
            this.configPanel.setFileNameEnabled(false);
        } else {
            this.configPanel.setFileNameEnabled(true);
        }
        this.pack();
    }

    public void load(AgentServiceEntry agentServiceEntry) throws FileNotFoundException {
        this.serviceEntry = agentServiceEntry;
        if (this.serviceEntry == null) {
            this.setMode(0);
            this.serviceEntry = new AgentServiceEntry();
            this.serviceEntry.setFilename("");
            this.serviceEntry.setAutostart(true);
            this.config = AgentPeerConfig.getDefaultAgentPeer();
            PeerDescriptor peerDescriptor = this.config.getMaster();
            peerDescriptor.addAddress("CYBRKING");
            this.config.setMaster(peerDescriptor);
        } else {
            this.isReplace = true;
            try {
                this.config = this.serviceEntry.loadPeerConfig();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.config = AgentPeerConfig.getDefaultAgentPeer();
                this.config.setListenPort(7471);
                PeerDescriptor peerDescriptor = this.config.getMaster();
                peerDescriptor.addAddress("");
                this.config.setMaster(peerDescriptor);
                this.setMode(1);
            }
        }
        this.configPanel.loadConfig(this.serviceEntry);
        this.loadExtended(this.serviceEntry);
    }

    void loadExtended(AgentServiceEntry agentServiceEntry) {
        try {
            this.config = agentServiceEntry.loadPeerConfig();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.config = AgentPeerConfig.getDefaultAgentPeer();
            this.config.setListenPort(7471);
            PeerDescriptor peerDescriptor = this.config.getMaster();
            peerDescriptor.addAddress("");
            this.config.setMaster(peerDescriptor);
        }
        catch (IllegalStateException illegalStateException) {
            this.config = AgentPeerConfig.getDefaultAgentPeer();
            this.config.setListenPort(7471);
            PeerDescriptor peerDescriptor = this.config.getMaster();
            peerDescriptor.addAddress("");
            this.config.setMaster(peerDescriptor);
        }
        this.extendedConfigPanel.loadAgentConfig(this.config);
        this.pack();
    }

    public void loadCopy(AgentServiceEntry agentServiceEntry) throws FileNotFoundException {
        this.mode = 2;
        if (agentServiceEntry == null) {
            throw new NullPointerException("The AgentServiceEntry to copy is null.");
        }
        this.originalServiceEntry = agentServiceEntry;
        this.serviceEntry = new AgentServiceEntry();
        this.serviceEntry.setAutostart(this.originalServiceEntry.getAutostart());
        this.isReplace = false;
        this.originalServiceEntry.loadPeerConfig();
        this.configPanel.loadConfig(this.serviceEntry);
        this.extendedConfigPanel.loadAgentConfig(this.originalServiceEntry.loadPeerConfig());
    }

    public ServerEntryConfigDialog(JDialog jDialog, AgentServiceEntry agentServiceEntry) throws FileNotFoundException {
        super((Dialog)jDialog);
        this.init();
        this.load(agentServiceEntry);
    }

    private void init() {
        this.setTitle("Agent Configuration");
        this.setDefaultHelp((HelpMapID)RBEHelpManager.SKYSCH_AGENT_CONFIG);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.configPanel = new ServerEntryConfigPanel(this);
        this.add(this.configPanel.getMainPanel(), gridBagConstraints);
        this.extendedConfigPanel = new AgentConfigPanel((Window)((Object)this));
        this.gbcExt = new GridBagConstraints();
        this.gbcExt.gridx = 0;
        this.gbcExt.gridy = 1;
        this.gbcExt.gridheight = 1;
        this.gbcExt.gridwidth = 1;
        this.gbcExt.fill = 1;
        this.gbcExt.weightx = 1.0;
        this.gbcExt.weighty = 1.0;
        this.gbcExt.anchor = 17;
        this.add(this.extendedConfigPanel, this.gbcExt);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.commandPanel = this.buildCommandPanel();
        this.add(this.commandPanel, gridBagConstraints);
    }

    private JPanel buildCommandPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = STANDARD_INSET;
        jPanel.add((Component)this.btnOK, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.btnCancel, gridBagConstraints);
        return jPanel;
    }

    public static AgentServiceEntry copyServiceEntry(HSJFrame hSJFrame, AgentServiceEntry agentServiceEntry, AgentServiceAM agentServiceAM) throws FileNotFoundException {
        ServerEntryConfigDialog serverEntryConfigDialog = new ServerEntryConfigDialog(hSJFrame, 2);
        serverEntryConfigDialog.setValidator(agentServiceAM);
        serverEntryConfigDialog.loadCopy(agentServiceEntry);
        serverEntryConfigDialog.setVisible(true);
        return serverEntryConfigDialog.getAgentServiceEntry();
    }

    public static void main(String[] stringArray) {
        ServerEntryConfigDialog serverEntryConfigDialog = new ServerEntryConfigDialog();
        AgentServiceEntry agentServiceEntry = null;
        try {
            AgentServiceConfig agentServiceConfig;
            Document document = XMLUtil.loadXML((String)DEFAULT_PATH_ENTRY);
            Object object = XMLReflector.readObject((Document)document);
            if (object instanceof AgentServiceConfig && (agentServiceConfig = (AgentServiceConfig)object).getEntries().length > 0) {
                agentServiceEntry = agentServiceConfig.getEntry(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            serverEntryConfigDialog.load(agentServiceEntry);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        serverEntryConfigDialog.setVisible(true);
    }

    public AgentServiceEntry getAgentServiceEntry() {
        return this.serviceEntry;
    }

    public void loadNewPath(String string) {
        this.setMode(1);
        this.serviceEntry.setFilename(string);
        try {
            this.config = this.serviceEntry.loadPeerConfig();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.config = AgentPeerConfig.getDefaultAgentPeer();
            this.config.setListenPort(7471);
            PeerDescriptor peerDescriptor = this.config.getMaster();
            peerDescriptor.addAddress("");
            this.config.setMaster(peerDescriptor);
            this.setMode(1);
        }
        this.extendedConfigPanel.loadAgentConfig(this.config);
        this.isReplace = true;
        this.pack();
    }

    public void setValidator(AgentServiceAM agentServiceAM) {
        this.validator = agentServiceAM;
    }

    public void okToAddEntry() throws DuplicatePortNumberException {
        this.serviceEntry = this.configPanel.getConfig();
        int n = this.extendedConfigPanel.getNotifyPort();
        if (this.mode != 1 && this.validator != null) {
            this.validator.okToAddEntry(this.serviceEntry, n, false);
        }
    }

    public void cancelButtonAction() {
        this.serviceEntry = null;
        super.cancelButtonAction();
    }

    private void defaultCancelButtonAction() {
        super.cancelButtonAction();
    }
}

