/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AgentTrayIcon
extends TrayIcon {
    private static JPopupMenu menu;
    private static JDialog dialog;
    private static PopupMenuListener popupListener;

    public AgentTrayIcon(Image image) {
        super(image);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AgentTrayIcon.this.showJPopupMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AgentTrayIcon.this.showJPopupMenu(mouseEvent);
            }
        });
    }

    protected void showJPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && menu != null) {
            Dimension dimension = menu.getPreferredSize();
            this.showJPopupMenu(mouseEvent.getX(), mouseEvent.getY() - dimension.height);
        }
    }

    private void showJPopupMenu(int n, int n2) {
        dialog.setLocation(n, n2);
        dialog.setVisible(true);
        menu.show(dialog.getContentPane(), 0, 0);
        dialog.toFront();
    }

    public void setJPopupMenu(JPopupMenu jPopupMenu) {
        if (menu != null) {
            menu.removePopupMenuListener(popupListener);
        }
        menu = jPopupMenu;
        jPopupMenu.addPopupMenuListener(popupListener);
    }

    public JPopupMenu getJPopupMenu() {
        return menu;
    }

    static {
        dialog = new JDialog((Frame)null);
        dialog.setUndecorated(true);
        dialog.setAlwaysOnTop(true);
        popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                dialog.setVisible(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                dialog.setVisible(false);
            }
        };
    }
}

