/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.client.components.DataLabel;
import com.helpsystems.common.client.components.RestrictedInputTextField;
import com.helpsystems.common.client.components.throwabledialog.ThrowableDialog;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.service.DuplicatePortNumberException;
import com.helpsystems.enterprise.tray.ServerEntryConfigDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.Socket;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AgentConfigPanel
extends JPanel {
    private static final Insets STANDARD_INSET = new Insets(6, 6, 6, 6);
    private static final int TEXT_PREF_HEIGHT = 20;
    private Window parentWindow = null;
    private JPanel pnlEntServer = null;
    private RestrictedInputTextField txtServerAddress = null;
    private RestrictedInputTextField txtServerPort = null;
    private DataLabel lblWarning = new DataLabel();
    private JPanel pnlPort = null;
    private RestrictedInputTextField txtAgentPort = null;

    public AgentConfigPanel(Window window) {
        this.parentWindow = window;
        this.initialize();
    }

    public void loadAgentConfig(AgentPeerConfig agentPeerConfig) {
        if (agentPeerConfig == null) {
            throw new NullPointerException("Cannot load from a null AgentPeerConfig.");
        }
        PeerDescriptor peerDescriptor = agentPeerConfig.getMaster();
        if (peerDescriptor != null) {
            String[] stringArray = peerDescriptor.getAddresses();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().length() <= 0) continue;
                this.txtServerAddress.setText(stringArray[i].trim());
                break;
            }
            this.txtServerPort.setText(String.valueOf(peerDescriptor.getPort()));
        }
        this.txtAgentPort.setText(String.valueOf(agentPeerConfig.getListenPort()));
    }

    public void captureAgentConfig(AgentPeerConfig agentPeerConfig) {
        if (agentPeerConfig == null) {
            throw new NullPointerException("Cannot capture to a null AgentPeerConfig.");
        }
        PeerDescriptor peerDescriptor = agentPeerConfig.getMaster();
        if (peerDescriptor == null) {
            peerDescriptor = new PeerDescriptor();
            peerDescriptor.setType(6);
            agentPeerConfig.setMaster(peerDescriptor);
        }
        peerDescriptor.clearAddresses();
        String string = this.txtServerAddress.getText().trim();
        if (string.length() == 0) {
            throw new IllegalArgumentException("A value is required for the Server Address.");
        }
        peerDescriptor.addAddress(string);
        int n = this.parsePortOrFail(this.txtServerPort.getText().trim(), "Server Listen Port");
        peerDescriptor.setPort(n);
        int n2 = this.parsePortOrFail(this.txtAgentPort.getText().trim(), "Agent Listen Port");
        agentPeerConfig.setListenPort(n2);
    }

    private int parsePortOrFail(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("The field name for port parsing is null.");
        }
        if (string == null) {
            throw new NullPointerException(string2 + " is null.");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("A value is required for the " + string2 + ".");
        }
        int n = 1;
        int n2 = 65535;
        String string3 = "Invalid " + string2 + ": '" + string + "'. The value must be a number from " + n + " to " + n2 + ".";
        int n3 = -1;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string3);
        }
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException(string3);
        }
        return n3;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.pnlEntServer = this.buildEntServerPanel();
        this.add((Component)this.pnlEntServer, gridBagConstraints);
        this.pnlPort = this.buildPortPanel();
        ++gridBagConstraints.gridy;
        this.add((Component)this.pnlPort, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    private JPanel buildEntServerPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Automate Schedule Server Settings");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Address:");
        this.txtServerAddress = new RestrictedInputTextField(256, false, RestrictedInputTextField.FORCE_NEITHER);
        this.txtServerAddress.setPreferredSize(new Dimension(200, 20));
        JLabel jLabel2 = new JLabel("Listen Port:");
        this.txtServerPort = new RestrictedInputTextField(5, true, RestrictedInputTextField.FORCE_NEITHER);
        this.txtServerPort.setValidCharacters("0123456789");
        this.txtServerPort.setPreferredSize(new Dimension(160, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = STANDARD_INSET;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtServerAddress, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.txtServerPort, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildPortPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Local Agent Settings");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Listen Port:");
        this.txtAgentPort = new RestrictedInputTextField(5, true, RestrictedInputTextField.FORCE_NEITHER);
        this.txtAgentPort.setValidCharacters("0123456789");
        this.txtAgentPort.setPreferredSize(new Dimension(80, 20));
        Action action = this.makeTestAction();
        JButton jButton = new JButton(action);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = STANDARD_INSET;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.txtAgentPort, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.lblWarning.setText("<html>If you are using firewall software on this PC, it must allow<br>incoming connections to the Local Agent Settings Listen Port number.<br>(Press F1 for Help on this topic.)</html>");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.lblWarning, gridBagConstraints);
        return jPanel;
    }

    private Action makeTestAction() {
        AbstractAction abstractAction = new AbstractAction("Test"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = AgentConfigPanel.this.parsePortOrFail(AgentConfigPanel.this.txtAgentPort.getText().trim(), "Agent Listen Port");
                    String string = this.testSocket("localhost", n);
                    String string2 = "Test Local Port: " + n;
                    int n2 = 2;
                    String string3 = "<html>Port " + n + " is currently in use.  Recovery options:<br>" + "<ul>" + "<li>Select a different port.</li>" + "<li>Reconfigure the process currently using that port.</li>" + "</ul></html>";
                    if (string != null) {
                        n2 = 1;
                        string3 = "Port " + n + " is currently available.";
                        if (AgentConfigPanel.this.parentWindow instanceof ServerEntryConfigDialog) {
                            ServerEntryConfigDialog serverEntryConfigDialog = (ServerEntryConfigDialog)((Object)AgentConfigPanel.this.parentWindow);
                            try {
                                serverEntryConfigDialog.okToAddEntry();
                            }
                            catch (DuplicatePortNumberException duplicatePortNumberException) {
                                n2 = 2;
                                string3 = "Port " + n + " is not currently" + " in use but is defined in another Agent configuration.";
                            }
                        }
                    }
                    JOptionPane.showMessageDialog(AgentConfigPanel.this.parentWindow, string3, string2, n2);
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)AgentConfigPanel.this.parentWindow, (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String testSocket(String string, int n) {
                Socket socket = null;
                try {
                    socket = new Socket(string, n);
                    String string2 = null;
                    return string2;
                }
                catch (Exception exception) {
                    String string3 = exception.getLocalizedMessage();
                    return string3;
                }
                finally {
                    try {
                        if (socket != null && !socket.isClosed()) {
                            socket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
        return abstractAction;
    }

    public int getNotifyPort() {
        return this.parsePortOrFail(this.txtAgentPort.getText().trim(), "Agent Listen Port");
    }
}

