/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.enterprise.module.windows.ProcessSnapshot;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.service.AgentProcess;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentProcessListener;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceConfig;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.service.DuplicatePortNumberException;
import com.helpsystems.enterprise.tray.SystemTrayControl;
import java.awt.SystemTray;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.w3c.dom.Document;

public class AgentServiceAMImpl
extends AbstractManager
implements AgentServiceAM {
    public static final String LOG_FILENAME = "agentService.log";
    private static final Logger logger = Logger.getLogger(AgentServiceAMImpl.class);
    public static final String AGENT_CONFIG = "agent.xml";
    private HashMap<AgentServiceEntry, AgentProcess> processMap = new HashMap();
    private HashMap<AgentProcess, ClusterAgentProcessListener> processMonitor = new HashMap();
    private List<AgentProcessListener> listenerList = new ArrayList<AgentProcessListener>();
    private ScheduledThreadPoolExecutor executor;
    private AgentServiceConfig config;

    public AgentServiceAMImpl(String string) {
        this.setName("ENTERPRISE.AgentServiceAM");
        File file = new File(string);
        this.config = AgentServiceAMImpl.loadOrCreateConfig(file);
        this.executor = new ScheduledThreadPoolExecutor(1);
        AgentServiceEntry[] agentServiceEntryArray = this.config.getEntries();
        if (agentServiceEntryArray.length == 0) {
            logger.warn((Object)("There are no Agent configs defined in the file " + file.getAbsolutePath()));
        } else {
            this.startAllAgents(agentServiceEntryArray);
        }
    }

    static AgentServiceConfig loadOrCreateConfig(File file) {
        Object object;
        AgentServiceConfig agentServiceConfig = null;
        if (file.exists()) {
            object = file.getAbsolutePath();
            try {
                agentServiceConfig = (AgentServiceConfig)XMLUtil.loadObjectFromFile((String)object);
            }
            catch (Exception exception) {
                logger.fatal((Object)("Unable to load the config file " + (String)object), (Throwable)exception);
            }
        }
        if (agentServiceConfig == null) {
            Object object2;
            agentServiceConfig = new AgentServiceConfig();
            object = new File(DefaultConfigPath.getDefaultPath() + File.separator + AGENT_CONFIG);
            if (((File)object).exists()) {
                object2 = new AgentServiceEntry();
                ((AgentServiceEntry)object2).setFilename(AGENT_CONFIG);
                ((AgentServiceEntry)object2).setLabel("Default");
                ((AgentServiceEntry)object2).setAutostart(true);
                try {
                    agentServiceConfig.addEntry((AgentServiceEntry)object2);
                }
                catch (DuplicatePortNumberException duplicatePortNumberException) {}
            } else {
                logger.warn((Object)"Could not find any installed agent configurations.");
            }
            try {
                object2 = XMLUtil.documentToString((Document)XMLReflector.writeObject((XMLSerializable)agentServiceConfig, null));
                FileWriter fileWriter = new FileWriter(file);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.println((String)object2);
                printWriter.close();
                fileWriter.close();
            }
            catch (Exception exception) {
                logger.warn((Object)("Unable to save new service config file " + file.getAbsolutePath()), (Throwable)exception);
            }
        }
        return agentServiceConfig;
    }

    public AgentServiceConfig getConfig() {
        return this.config;
    }

    public static void main(String[] stringArray) {
        String string = DefaultConfigPath.getDefaultPath() + File.separator + "agentService.config";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        ManagerRegistry.registerManager((IAbstractManager)new AgentServiceAMImpl(string));
    }

    private void startAllAgents(AgentServiceEntry[] agentServiceEntryArray) {
        for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray) {
            if (!agentServiceEntry.getAutostart()) continue;
            this.startAgent(agentServiceEntry);
        }
    }

    @Override
    public void writeToProcess(AgentServiceEntry agentServiceEntry, String string) {
        AgentProcess agentProcess = this.processMap.get(agentServiceEntry);
        if (agentProcess == null) {
            throw new RuntimeException("Process does not exist");
        }
        agentProcess.write(string);
    }

    @Override
    public void writeThreadDump(AgentServiceEntry agentServiceEntry) {
        AgentProcess agentProcess = this.processMap.get(agentServiceEntry);
        if (agentProcess == null) {
            throw new RuntimeException("Process does not exist");
        }
        if (agentProcess.isAlive()) {
            agentProcess.runThreadDump();
        }
    }

    @Override
    public void startAgent(AgentServiceEntry agentServiceEntry) {
        try {
            AgentProcess agentProcess = new AgentProcess(agentServiceEntry, this.executor, this);
            this.fireProcessStartedEvent(agentProcess);
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to start agent " + agentServiceEntry.getLabel()), (Throwable)exception);
            return;
        }
    }

    @Override
    public void stopAgent(AgentServiceEntry agentServiceEntry, boolean bl) {
        try {
            AgentProcess agentProcess = this.getRealProcess(agentServiceEntry);
            agentProcess.shutdown(bl);
            this.fireProcessEndedEvent(agentProcess);
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to stop agent " + agentServiceEntry.getLabel()), (Throwable)exception);
            return;
        }
    }

    @Override
    public AgentServiceEntry[] getEntries() {
        return this.config.getEntries();
    }

    @Override
    public void addEntry(AgentServiceEntry agentServiceEntry) {
        this.getConfig().addEntry(agentServiceEntry);
        this.saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(AgentServiceEntry agentServiceEntry) {
        this.getConfig().removeEntry(agentServiceEntry);
        HashMap<AgentServiceEntry, AgentProcess> hashMap = this.processMap;
        synchronized (hashMap) {
            this.processMap.remove(agentServiceEntry);
        }
        this.saveConfig();
    }

    @Override
    public void addListener(AgentProcessListener agentProcessListener) {
        this.listenerList.add(agentProcessListener);
    }

    @Override
    public void removeListener(AgentProcessListener agentProcessListener) {
        this.listenerList.remove(agentProcessListener);
    }

    void fireLogEvent(AgentProcess agentProcess, String[] stringArray) {
        for (String string : stringArray) {
            System.out.println(string);
        }
        for (AgentProcessListener agentProcessListener : this.listenerList) {
            agentProcessListener.logGrew(agentProcess.getInfo(), stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProcessStartedEvent(AgentProcess agentProcess) {
        HashMap<AgentServiceEntry, AgentProcess> hashMap = this.processMap;
        synchronized (hashMap) {
            this.processMap.put(agentProcess.getEntry(), agentProcess);
        }
        for (AgentProcessListener agentProcessListener : this.listenerList) {
            agentProcessListener.processStarted(agentProcess.getInfo());
        }
    }

    void fireProcessEndedEvent(AgentProcess agentProcess) {
        for (AgentProcessListener agentProcessListener : this.listenerList) {
            agentProcessListener.processEnded(agentProcess.getInfo());
        }
    }

    public AgentProcess getRealProcess(AgentServiceEntry agentServiceEntry) {
        return this.processMap.get(agentServiceEntry);
    }

    @Override
    public AgentProcessInfo getProcess(AgentServiceEntry agentServiceEntry) {
        AgentProcess agentProcess = this.getRealProcess(agentServiceEntry);
        if (agentProcess == null) {
            return null;
        }
        return agentProcess.getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentProcess[] getRealProcesses() {
        HashMap<AgentServiceEntry, AgentProcess> hashMap = this.processMap;
        synchronized (hashMap) {
            AgentProcess[] agentProcessArray = new AgentProcess[this.processMap.size()];
            this.processMap.values().toArray(agentProcessArray);
            return agentProcessArray;
        }
    }

    @Override
    public AgentProcessInfo[] getProcesses() {
        AgentProcess[] agentProcessArray = this.getRealProcesses();
        AgentProcessInfo[] agentProcessInfoArray = new AgentProcessInfo[agentProcessArray.length];
        for (int i = 0; i < agentProcessArray.length; ++i) {
            agentProcessInfoArray[i] = agentProcessArray[i].getInfo();
        }
        return agentProcessInfoArray;
    }

    @Override
    public void shutdownAndExit(boolean bl) {
        if (bl) {
            this.executor.shutdownNow();
        }
        for (AgentProcess agentProcess : this.getRealProcesses()) {
            if (!agentProcess.isAlive()) continue;
            agentProcess.shutdown(bl);
        }
        SystemTray systemTray = SystemTray.getSystemTray();
        systemTray.remove(SystemTrayControl.getTheInstance().getTrayIcon());
        System.exit(0);
    }

    @Override
    public void shutdownAgent(AgentServiceEntry agentServiceEntry, boolean bl, boolean bl2) {
        AgentProcess agentProcess = this.processMap.get(agentServiceEntry);
        if (agentProcess == null) {
            throw new RuntimeException("Process does not exist");
        }
        if (agentProcess.isAlive()) {
            if (bl) {
                agentProcess.shutdownAndRestart(bl2);
            } else {
                agentProcess.shutdown(bl2);
            }
        }
    }

    @Override
    public void write(AgentServiceEntry agentServiceEntry, String string) throws ActionFailedException {
        this.getRealProcessOrFail(agentServiceEntry).write(string);
    }

    @Override
    public void runThreadDump(AgentServiceEntry agentServiceEntry) throws ActionFailedException {
        this.getRealProcessOrFail(agentServiceEntry).runThreadDump();
    }

    private AgentProcess getRealProcessOrFail(AgentServiceEntry agentServiceEntry) throws ActionFailedException {
        AgentProcess agentProcess = this.getRealProcess(agentServiceEntry);
        if (agentProcess == null) {
            throw new ActionFailedException("Process not found");
        }
        if (!agentProcess.isAlive()) {
            throw new ActionFailedException("Process is not active");
        }
        return agentProcess;
    }

    @Override
    public String[] getLog(AgentServiceEntry agentServiceEntry) throws ActionFailedException {
        AgentProcess agentProcess = this.getRealProcess(agentServiceEntry);
        if (agentProcess == null) {
            throw new ActionFailedException("Process not found");
        }
        return agentProcess.getLog();
    }

    private void saveConfig() {
        String string = DefaultConfigPath.getDefaultPath() + File.separator + "agentService.config";
        AgentServiceConfig.saveAgentServiceConfig(this.config, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentProcessInfo[] getAllProcessInfo() {
        HashMap<AgentServiceEntry, AgentProcess> hashMap = this.processMap;
        synchronized (hashMap) {
            AgentProcessInfo[] agentProcessInfoArray = new AgentProcessInfo[this.processMap.size()];
            int n = 0;
            for (AgentProcess agentProcess : this.processMap.values()) {
                agentProcessInfoArray[n] = agentProcess.getInfo();
                ++n;
            }
            return agentProcessInfoArray;
        }
    }

    @Override
    public boolean okToAddEntry(AgentServiceEntry agentServiceEntry, int n, boolean bl) {
        if (this.config != null) {
            return this.config.okToAddEntry(agentServiceEntry, n, bl);
        }
        return false;
    }

    @Override
    public int getLocalListeningPort() {
        if (this.config == null) {
            return -1;
        }
        return this.config.getLocalListenPort();
    }

    @Override
    public void setLoggingLevel(AgentServiceEntry agentServiceEntry, int n) {
        AgentProcess agentProcess = this.processMap.get(agentServiceEntry);
        if (agentProcess == null) {
            throw new RuntimeException("Process does not exist, logging will not be set.");
        }
        if (agentProcess.isAlive()) {
            agentProcess.setLoggingLevel(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessMonitor(int n, AgentServiceEntry agentServiceEntry, String string) {
        AgentProcess agentProcess = this.getRealProcess(agentServiceEntry);
        ClusterAgentProcessListener clusterAgentProcessListener = null;
        String string2 = null;
        if (agentProcess != null && agentProcess.isAlive()) {
            string2 = agentProcess.getCurrentComputerName();
            if (string2.equalsIgnoreCase(string)) {
                HashMap<AgentProcess, ClusterAgentProcessListener> hashMap = this.processMonitor;
                synchronized (hashMap) {
                    if (this.processMonitor.containsKey(agentProcess)) {
                        clusterAgentProcessListener = this.processMonitor.get(agentProcess);
                        if (clusterAgentProcessListener != null) {
                            clusterAgentProcessListener.stop();
                        }
                        clusterAgentProcessListener = new ClusterAgentProcessListener(n, agentServiceEntry);
                    } else {
                        clusterAgentProcessListener = new ClusterAgentProcessListener(n, agentServiceEntry);
                    }
                    this.processMonitor.put(agentProcess, clusterAgentProcessListener);
                }
            } else {
                String string3 = "Cannot register with Agent as " + string + " because it is running as " + string2;
                logger.debug((Object)string3, null);
                throw new IllegalStateException(string3);
            }
        }
    }

    @Override
    public void startAgentAs(AgentServiceEntry agentServiceEntry, String string) {
        try {
            AgentProcess agentProcess = null;
            agentProcess = string != null && string.trim().length() > 0 ? new AgentProcess(agentServiceEntry, this.executor, this, string) : new AgentProcess(agentServiceEntry, this.executor, this);
            this.fireProcessStartedEvent(agentProcess);
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to start agent " + agentServiceEntry.getLabel()), (Throwable)exception);
            return;
        }
    }

    static {
        PatternLayout patternLayout = new PatternLayout("%d{yyyy-MM-dd HH:mm:ss,SSS} %5p [%t] - %m%n");
        try {
            RollingFileAppender rollingFileAppender = new RollingFileAppender((Layout)patternLayout, LOG_FILENAME, false);
            rollingFileAppender.setMaxFileSize("5MB");
            rollingFileAppender.setMaxBackupIndex(2);
            Logger.getRootLogger().addAppender((Appender)rollingFileAppender);
            logger.info((Object)"Service started");
        }
        catch (Exception exception) {
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)patternLayout, "System.out"));
            logger.warn((Object)"Unable to write to log agentService.log");
        }
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }

    public class ClusterAgentProcessListener {
        private AgentServiceEntry ent;
        private int pid = -1;
        private Thread watcher = null;
        private boolean keeprunning = true;
        Runnable onTheWall = new Runnable(){

            @Override
            public void run() {
                while (ClusterAgentProcessListener.this.keeprunning) {
                    ClusterAgentProcessListener.this.keeprunning = false;
                    try {
                        BasicProcessInfo[] basicProcessInfoArray = ClusterAgentProcessListener.this.listProcesses();
                        for (int i = 0; i < basicProcessInfoArray.length; ++i) {
                            BasicProcessInfo basicProcessInfo = basicProcessInfoArray[i];
                            if (!basicProcessInfo.getPid().equals(Integer.toString(ClusterAgentProcessListener.this.pid))) continue;
                            ClusterAgentProcessListener.this.keeprunning = true;
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)("Cluster Process is still alive (" + ClusterAgentProcessListener.this.pid + ")..."));
                        }
                        if (ClusterAgentProcessListener.this.keeprunning) {
                            Thread.sleep(3000L);
                            continue;
                        }
                        AgentServiceAMImpl.this.shutdownAgent(ClusterAgentProcessListener.this.ent, false, true);
                    }
                    catch (Throwable throwable) {
                        logger.trace((Object)("Cluster Process exception on (" + ClusterAgentProcessListener.this.pid + ")..."), throwable);
                        AgentServiceAMImpl.this.shutdownAgent(ClusterAgentProcessListener.this.ent, false, true);
                    }
                }
            }
        };

        public ClusterAgentProcessListener(int n, AgentServiceEntry agentServiceEntry) {
            this.pid = n;
            this.ent = agentServiceEntry;
            logger.debug((Object)("Creating Cluster Process for (" + n + ")..."));
            if (n > 0) {
                this.watcher = new Thread(this.onTheWall);
                this.watcher.setName("Skybot Scheduler Windows Cluster Agent Monitor (" + n + ")");
                this.watcher.start();
            }
        }

        public void stop() {
            if (this.watcher != null) {
                this.watcher.interrupt();
            }
        }

        protected BasicProcessInfo[] listProcesses() throws ResourceUnavailableException {
            return ProcessSnapshot.getList();
        }
    }
}

