/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.Advapi32;
import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.helpsystems.enterprise.module.windows.ProcessCreationException;
import com.helpsystems.enterprise.module.windows.ProcessInformation;
import com.helpsystems.enterprise.module.windows.SID_IDENTIFIER_AUTHORITY;
import com.helpsystems.enterprise.module.windows.SecurityAttributes;
import com.helpsystems.enterprise.module.windows.StartupInfo;
import com.helpsystems.enterprise.module.windows.User32Ext;
import com.helpsystems.enterprise.module.windows.WindowsSocketProcess;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WindowsProcessLauncher {
    private static final Logger logger = Logger.getLogger(WindowsProcessLauncher.class);
    public static final String DFT_STATION = "hsAgentz01";
    public static final String DFT_DESKTOP = "agentProcesses";
    public static final String RTS_BITS_SYSTEM_PROPERTY = "helpsystems.schent.rts_bits";
    public static final String ROBOT_TERM_32_EXEC = "bin\\Win32\\RobotTermSocket.exe ";
    public static final String ROBOT_TERM_64_EXEC = "bin\\Win64\\RobotTermSocket64.exe ";
    public static final int CREATE_PROCESS_TIMEOUT = 10;
    private static String ROBOT_TERM_EXEC;
    private ServerSocket ss;
    private int listenPort;
    private Map<String, WindowsSocketProcess> socketMap = new HashMap<String, WindowsSocketProcess>();

    public WindowsProcessLauncher(int n) throws IOException {
        this.ss = new ServerSocket(n, 0, InetAddress.getByName("127.0.0.1"));
        this.listenPort = this.ss.getLocalPort();
        logger.info((Object)("Listening for local RobotTerm processes to connect on port " + this.listenPort));
        WindowsProcessLauncher.CreateWindowStation();
        Thread thread = new Thread(new Acceptor());
        thread.start();
    }

    public static String getExecutable() {
        if (ROBOT_TERM_EXEC == null) {
            ROBOT_TERM_EXEC = WindowsProcessLauncher.resolveExecutable();
        }
        return ROBOT_TERM_EXEC;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String resolveExecutable() {
        String string = System.getProperty(RTS_BITS_SYSTEM_PROPERTY);
        logger.trace((Object)("System property helpsystems.schent.rts_bits = " + string));
        String string2 = System.getProperty("sun.arch.data.model");
        logger.trace((Object)("System property sun.arch.data.model = " + string2));
        if (string != null) {
            if ("32".equals(string)) {
                logger.info((Object)("The system property 'helpsystems.schent.rts_bits' has been set to " + string + ", which will force all jobs to run in 32-bit mode."));
                return ROBOT_TERM_32_EXEC;
            }
            if ("64".equals(string)) {
                if (!"32".equals(string2)) {
                    logger.info((Object)("The system property 'helpsystems.schent.rts_bits' has been set to " + string + ", which will force all jobs to run in 64-bit mode."));
                    return ROBOT_TERM_64_EXEC;
                }
                logger.info((Object)("The system property 'helpsystems.schent.rts_bits' has been set to " + string + ", but is not valid because this is a 32-bit operating system."));
            } else {
                logger.info((Object)("The system property 'helpsystems.schent.rts_bits' has been set to " + string + " which is not recognized."));
            }
        }
        if ("64".equals(string2)) {
            logger.info((Object)"The 64 bit environment will be used to run jobs on this agent.");
            return ROBOT_TERM_64_EXEC;
        }
        logger.info((Object)"The 32 bit environment will be used to run jobs on this agent.");
        return ROBOT_TERM_32_EXEC;
    }

    public WindowsSocketProcess start(String string, String string2, String string3, String string4) throws IOException {
        String string5 = string2;
        String string6 = "";
        if (string2 == null) {
            string5 = "";
        }
        String string7 = new String(string + " " + string5 + " " + this.listenPort + " " + string3 + " " + string4);
        StartupInfo startupInfo = new StartupInfo();
        startupInfo.lpDesktop = new WString("hsAgentz01\\agentProcesses");
        startupInfo.write();
        ProcessInformation processInformation = new ProcessInformation();
        String string8 = WindowsProcessLauncher.getExecutable() + string7;
        logger.trace((Object)("Starting process with: " + string8));
        boolean bl = Kernel32Ext.INSTANCE.CreateProcess(null, string8, null, null, true, 16, null, null, startupInfo.getPointer(), processInformation.getPointer());
        if (!bl) {
            string6 = "Unable to launch the process, error " + Kernel32.INSTANCE.GetLastError();
        }
        processInformation.read();
        if (!Kernel32.INSTANCE.CloseHandle(processInformation.hProcess)) {
            logger.debug((Object)("Unable to close process handle for job " + string3 + ", error= " + Kernel32.INSTANCE.GetLastError()));
        }
        if (!Kernel32.INSTANCE.CloseHandle(processInformation.hThread)) {
            logger.debug((Object)("Unable to close process handle for job " + string3 + ", error= " + Kernel32.INSTANCE.GetLastError()));
        }
        if (!bl) {
            throw new IOException(string6);
        }
        return this.waitForProcess(string3, 10);
    }

    private static void CreateWindowStation() throws ProcessCreationException {
        WinNT.HANDLE hANDLE;
        WinNT.HANDLE hANDLE2;
        SecurityAttributes securityAttributes = new SecurityAttributes();
        securityAttributes.bInheritHandle = true;
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = WindowsProcessLauncher.getSECURITY_DESCRIPTOR();
        securityAttributes.lpSecurityDescriptor = sECURITY_DESCRIPTOR == null ? Pointer.NULL : sECURITY_DESCRIPTOR.getPointer();
        securityAttributes.write();
        WinNT.HANDLE hANDLE3 = User32Ext.INSTANCE.GetProcessWindowStation();
        if (hANDLE3 == null) {
            WindowsProcessLauncher.ErrorExit("Could not get the original Windows Station.");
        }
        if ((hANDLE2 = User32Ext.INSTANCE.OpenWindowStation(new WString(DFT_STATION), false, 393216)) == null) {
            hANDLE2 = User32Ext.INSTANCE.CreateWindowStation(new WString(DFT_STATION), 0, 983935, securityAttributes.getPointer());
            if (hANDLE2 != null) {
                WindowsProcessLauncher.AllowAccess(hANDLE2, "new Windows Station");
            } else {
                WindowsProcessLauncher.ErrorExit("Could not initialize our WindowStation.");
            }
        } else {
            WindowsProcessLauncher.AllowAccess(hANDLE2, "existing Windows Station");
        }
        if (!User32Ext.INSTANCE.SetProcessWindowStation(hANDLE2)) {
            WindowsProcessLauncher.ErrorExit("Could not set the new Windows Station.");
        }
        if ((hANDLE = User32Ext.INSTANCE.OpenDesktop(new WString(DFT_DESKTOP), 0, true, 0x10000000)) == null) {
            hANDLE = User32Ext.INSTANCE.CreateDesktop(new WString(DFT_DESKTOP), Pointer.NULL, Pointer.NULL, 0, 0x10000000, securityAttributes.getPointer());
            if (hANDLE != null) {
                WindowsProcessLauncher.AllowAccess(hANDLE, "Desktop");
            } else {
                WindowsProcessLauncher.ErrorExit("Could not open the desktop.");
            }
        } else {
            WindowsProcessLauncher.AllowAccess(hANDLE, "Desktop");
        }
    }

    private static void AllowAccess(WinNT.HANDLE hANDLE, String string) throws ProcessCreationException {
        int n;
        SID_IDENTIFIER_AUTHORITY sID_IDENTIFIER_AUTHORITY = SID_IDENTIFIER_AUTHORITY.getWorldUsers();
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = WindowsProcessLauncher.getSECURITY_DESCRIPTOR();
        PointerByReference pointerByReference = new PointerByReference();
        WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = new WinBase.SECURITY_ATTRIBUTES();
        sECURITY_ATTRIBUTES.bInheritHandle = true;
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = Pointer.NULL;
        sECURITY_ATTRIBUTES.dwLength = new WinDef.DWORD((long)sECURITY_ATTRIBUTES.size());
        int n2 = n = 7;
        if (!Advapi32.INSTANCE.AllocateAndInitializeSid(sID_IDENTIFIER_AUTHORITY.getPointer(), 1, sID_IDENTIFIER_AUTHORITY, 0, 0, 0, 0, 0, 0, 0, pointerByReference.getPointer())) {
            WindowsProcessLauncher.ErrorExit("Could not get an SID for group.");
        }
        if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(sECURITY_DESCRIPTOR, true, null, false)) {
            WindowsProcessLauncher.ErrorExit("Could not set the security DACL " + string);
        }
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = sECURITY_DESCRIPTOR.getPointer();
        if (Advapi32.INSTANCE.SetSecurityInfo(hANDLE, n2, -1073741824, null, null, null, null) != 0) {
            WindowsProcessLauncher.ErrorExit("Could not set the user object security " + string);
        }
        if (sID_IDENTIFIER_AUTHORITY != null) {
            Advapi32.INSTANCE.FreeSid(pointerByReference.getValue());
        }
    }

    private static void ErrorExit(String string) throws ProcessCreationException {
        throw new ProcessCreationException(WindowsProcessLauncher.getLastExitMessage(string));
    }

    private static String getLastExitMessage(String string) {
        int n = Kernel32.INSTANCE.GetLastError();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(", Error Code: ");
        stringBuffer.append(n);
        stringBuffer.append(" - ");
        stringBuffer.append(WindowsProcessLauncher.getFormattedMessage(n));
        return stringBuffer.toString();
    }

    private static Advapi32.SECURITY_DESCRIPTOR getSECURITY_DESCRIPTOR() throws ProcessCreationException {
        Advapi32.SECURITY_DESCRIPTOR sECURITY_DESCRIPTOR = new Advapi32.SECURITY_DESCRIPTOR();
        sECURITY_DESCRIPTOR.Dacl = null;
        sECURITY_DESCRIPTOR.write();
        int n = 1;
        if (!Advapi32.INSTANCE.InitializeSecurityDescriptor(sECURITY_DESCRIPTOR.getPointer(), n)) {
            WindowsProcessLauncher.ErrorExit("Could not get a new security descriptor.");
        }
        sECURITY_DESCRIPTOR.read();
        if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(sECURITY_DESCRIPTOR, true, null, false)) {
            WindowsProcessLauncher.ErrorExit("Could not set the security descriptor.");
        }
        return sECURITY_DESCRIPTOR;
    }

    private static String getFormattedMessage(int n) {
        String[] stringArray = new String[1];
        String string = null;
        int n2 = Kernel32Ext.INSTANCE.FormatMessage(4352, Pointer.NULL, n, 0, stringArray, 80, Pointer.NULL);
        string = n2 == 0 ? " Format message failed - " + Kernel32.INSTANCE.GetLastError() : stringArray[0];
        if (stringArray[0] != null) {
            stringArray[0] = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowsSocketProcess waitForProcess(String string, int n) throws IOException {
        int n2 = n * 1000;
        int n3 = 0;
        int n4 = 0;
        int n5 = 100;
        while (n3 <= n2) {
            Map<String, WindowsSocketProcess> map = this.socketMap;
            synchronized (map) {
                WindowsSocketProcess windowsSocketProcess = this.socketMap.remove(string);
                if (windowsSocketProcess != null) {
                    logger.trace((Object)("Returning process socket " + string));
                    return windowsSocketProcess;
                }
            }
            try {
                if (n5 < 1000 && n4 >= 10) {
                    n5 = 1000;
                }
                Thread.sleep(n5);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n3 += n5;
            ++n4;
        }
        logger.debug((Object)("Timeout waiting for process socket: " + string));
        throw new IOException("Process failed to start");
    }

    class SocketReader
    implements Runnable {
        WindowsSocketProcess wsp;

        SocketReader(Socket socket) throws IOException {
            this.wsp = new WindowsSocketProcess(socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                InputStream inputStream = this.wsp.getInputStream();
                while (this.wsp.isAlive()) {
                    char c;
                    int n = inputStream.read();
                    if (n < 0) {
                        n += 256;
                    }
                    if ((c = (char)n) >= ' ') {
                        stringBuilder.append(c);
                    }
                    if (c != '\n' && c != '\r') continue;
                    logger.trace((Object)("Binding process socket " + stringBuilder.toString()));
                    Map map = WindowsProcessLauncher.this.socketMap;
                    synchronized (map) {
                        WindowsProcessLauncher.this.socketMap.put(stringBuilder.toString(), this.wsp);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to read the session ID from a socket.", (Throwable)exception);
            }
        }
    }

    class Acceptor
    implements Runnable {
        Acceptor() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WindowsProcessLauncherAcceptor");
            while (!WindowsProcessLauncher.this.ss.isClosed()) {
                try {
                    Socket socket = WindowsProcessLauncher.this.ss.accept();
                    Thread thread = new Thread(new SocketReader(socket));
                    thread.start();
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error acepting a socket", (Throwable)exception);
                }
            }
        }
    }
}

