/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.HandleInputStream;
import com.helpsystems.enterprise.module.windows.HandleOutputStream;
import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WindowsNamedPipe {
    private String name;
    private static WinNT.HANDLE pipeHandle;
    private HandleInputStream inputStream;
    private HandleOutputStream outputStream;
    boolean isClosed;

    private WindowsNamedPipe(String string) throws IOException {
        this.name = string;
    }

    public static WindowsNamedPipe create(String string, int n, int n2) throws IOException {
        WindowsNamedPipe windowsNamedPipe = new WindowsNamedPipe(string);
        windowsNamedPipe.startNamedPipe(n, n2);
        return windowsNamedPipe;
    }

    public static WindowsNamedPipe connect(String string) throws IOException {
        WindowsNamedPipe windowsNamedPipe = new WindowsNamedPipe(string);
        windowsNamedPipe.connectToPipe();
        return windowsNamedPipe;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new HandleInputStream(pipeHandle);
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new HandleOutputStream(pipeHandle);
        }
        return this.outputStream;
    }

    public void close() {
        if (pipeHandle != null) {
            Kernel32.INSTANCE.CloseHandle(pipeHandle);
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getName() {
        return this.name;
    }

    public void waitForConnection() throws IOException {
        boolean bl = Kernel32Ext.INSTANCE.ConnectNamedPipe(pipeHandle, null);
        if (!bl && Kernel32.INSTANCE.GetLastError() != 535) {
            throw new IOException("Error waiting for connection, error " + Kernel32.INSTANCE.GetLastError());
        }
    }

    private void startNamedPipe(int n, int n2) throws IOException {
        pipeHandle = Kernel32Ext.INSTANCE.CreateNamedPipe(this.name, 3, n, n2, 10240, 10240, 1000, null);
        if (pipeHandle == null || pipeHandle.equals((Object)WinNT.INVALID_HANDLE_VALUE)) {
            throw new IOException("Unable to open named pipe, error " + Kernel32.INSTANCE.GetLastError());
        }
    }

    private void connectToPipe() throws IOException {
        pipeHandle = Kernel32.INSTANCE.CreateFile(this.name, 0x40000000, 2, null, 3, 0, null);
        if (pipeHandle == null || pipeHandle.equals((Object)WinNT.INVALID_HANDLE_VALUE)) {
            throw new IOException("Unable to connect to named pipe, error " + Kernel32.INSTANCE.GetLastError());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

