/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.enterprise.module.windows.Kernel32Ext;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.OutputStream;

public class HandleOutputStream
extends OutputStream {
    private static final int BUFSIZE = 8192;
    private WinNT.HANDLE handle;
    private WinNT.HANDLE otherHandle;
    private boolean isClosed;
    Memory writeBuffer;
    IntByReference bytesWritten;

    public HandleOutputStream(WinNT.HANDLE hANDLE) {
        this(hANDLE, null);
    }

    public HandleOutputStream(WinNT.HANDLE hANDLE, WinNT.HANDLE hANDLE2) {
        this.handle = hANDLE;
        this.otherHandle = hANDLE2;
        this.writeBuffer = new Memory(8192L);
        this.bytesWritten = new IntByReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Memory memory = this.writeBuffer;
        synchronized (memory) {
            this.isClosed = true;
        }
        Kernel32Ext.INSTANCE.CloseHandle(this.handle);
        this.handle = null;
        if (this.otherHandle != null) {
            Kernel32Ext.INSTANCE.CloseHandle(this.otherHandle);
        }
        this.otherHandle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n2;
        while ((long)n4 > this.writeBuffer.size()) {
            this.write(byArray, n3, (int)this.writeBuffer.size());
            n4 = (int)((long)n4 - this.writeBuffer.size());
            n3 = (int)((long)n3 + this.writeBuffer.size());
        }
        Memory memory = this.writeBuffer;
        synchronized (memory) {
            this.checkIfClosed();
            this.writeBuffer.setMemory(0L, this.writeBuffer.size(), (byte)0);
            this.writeBuffer.write(0L, byArray, n3, n4);
            if (!Kernel32Ext.INSTANCE.WriteFile(this.handle, (Pointer)this.writeBuffer, n4, this.bytesWritten, null)) {
                throw new IOException("Unable to write, error " + Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Memory memory = this.writeBuffer;
        synchronized (memory) {
            this.checkIfClosed();
            this.writeBuffer.setMemory(0L, this.writeBuffer.size(), (byte)0);
            this.writeBuffer.setByte(0L, (byte)n);
            if (!Kernel32Ext.INSTANCE.WriteFile(this.handle, (Pointer)this.writeBuffer, 1, this.bytesWritten, null)) {
                throw new IOException("Unable to write, error " + Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    private void checkIfClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed.");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

