/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.Role;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.RoleDM;
import com.helpsystems.enterprise.core.dm.TranslationDM;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.SecurityReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.SecurityReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SecurityReport
extends AbstractJasperReport
implements Serializable {
    public static final String REPORT_NAME = "SecurityReport";
    public static final String HEADER_DATE = "HEADER_DATE";
    public static final String FIELD_GROUPING = "GROUPING";
    public static final String END_OF_REPORT = "END_OF_REPORT";
    public static final String NO_DATA_EXISTS = "NO_DATA_EXISTS";
    public static final String ONELINEFIELD = "ONELINEFIELD";
    public static final String FIELD_SHOW_COLUMN_BACK_COLOR = "SHOW_COLUMN_BACK_COLOR";
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    public static final String NAMEFIELD = "NAMEFIELD";
    public static final String VALUEFIELD = "VALUEFIELD";
    private RoleDM roleDM = null;
    private static final Logger logger = Logger.getLogger(SecurityReport.class);
    private SecurityReportFilter filter = new SecurityReportFilter();
    private ArrayList<HashMap<String, Object>> securityListToShow;
    private String[] securedAreas = new String[]{"AgentEventHistories", "Audits", "AutomateScheduleVariables", "Dashboards", "Log_Manager", "ImportFile", "JobHistories", "JobMonitorEvents", "SchedulerControl", "ManagedJobHistory", "Notification_List", "OutputDistributionHistories", "Sap", "ScheduleActivityMonitor", "SnmpTrapEvents", "SystemMessage", "SystemSettings", "Tag_Manager", "UniversalConnector", "UsersRoles"};
    private String[] securedActions = new String[]{"AgentEventHistoryReports", "AuditHistoryReports", "CreateAgentEnvironments", "CreateAgentEventMonitors", "CreateAgentGroups", "CreateAutomateSystemDefinitions", "CreateCalendars", "CreateCommandSets", "CreateDateObjects", "CreateFileTransferSystems", "CreateForecastDefinitions", "CreateIbmiAgentEnvironments", "CreateIbmiCommandSets", "CreateInformaticaCloudServers", "CreateInformaticaRepositories", "CreateJobFlowGraphs", "CreateJobQueues", "CreateJobSuites", "CreateJobs", "CreateOracleSystemDefinitions", "CreateRemoteServers", "CreateReturnCodes", "CreateSapAbapStepSets", "CreateSapJobDefinitions", "CreateSapSystemDefinitions", "CreateSnmpTrapMonitors", "CreateSqlServerDefinitions", "CreateWebServerDefinitions", "ForecastReports", "GoodMorningReports", "JobHistoryReports", "JobMonitorHistoryReports", "JobSetupReports", "LockUnlockJobQueue", "OutputDistributionHistoryReports", "SapAbapStepSetReports", "SapInterceptedJobHistoryReports", "SapJobDefinitionReports", "SapSystemDefinitionReports", "SecurityReports", "ServerHistoryReports", "SNMPTrapMonitorHistoryReports"};

    public SecurityReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.roleDM = (RoleDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RoleDM");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.SECURITY_REPORT.getReportID();
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() throws ReportException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SecurityReport.createReportDataBuilder();
        String[] stringArray = this.filter.getRolesNameList();
        this.securityListToShow = this.reportDM.getRolesList(stringArray);
        this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.parentParams.put("REPORT_NAME", REPORT_NAME);
        try {
            this.buildTableOfContentData(reportDataBuilder);
            this.buildParameterReport(this.parentParams);
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
        if (this.securityListToShow.size() == 0) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue(NO_DATA_EXISTS, "No Security records.");
        } else {
            for (int i = 0; i < this.securityListToShow.size(); ++i) {
                String string = "ROLE";
                Map map = this.securityListToShow.get(i);
                long l = (Long)map.get(string);
                try {
                    Role role = this.roleDM.get(l);
                    this.buildData(reportDataBuilder, map, role);
                    continue;
                }
                catch (DataException dataException) {
                    throw new ReportException("Unable check permission", dataException);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    throw new ReportException("Unable check permission", resourceUnavailableException);
                }
            }
            reportDataBuilder.setFieldValue(END_OF_REPORT, "*** End of Report ***");
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Security Report has been built.");
        return jasperReportData;
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (this.isEqualToKey(string) || string.equals("-") || !string.startsWith("-")) continue;
            String string2 = string.replaceAll("-", "val_");
            objectArray[i] = string2;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return false;
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        SecurityReportFilterParser securityReportFilterParser = new SecurityReportFilterParser();
        securityReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    private void buildTableOfContentData(AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap hashMap = new HashMap();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SecurityReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        for (int i = 0; i < this.securityListToShow.size(); ++i) {
            Map map = this.securityListToShow.get(i);
            String string = "ROLE";
            long l = (Long)map.get(string);
            Role role = this.roleDM.get(l);
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, role.getName());
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.TABLE_OF_CONTENT.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The Table of Content data has been built.");
    }

    private String buildParameterReport(Map<String, Object> map) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SecurityReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    private void buildData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, Map<String, Object> map, Role role) {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = reportDataBuilder;
        try {
            this.buildGeneralData(map, reportDataBuilder2, role);
            if (map.size() != 0) {
                String string = role.getPermissions();
                String[] stringArray = string.split(" ");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String[] stringArray2 = string2.split("_");
                    String string3 = stringArray2[0];
                    if (string3 == null) continue;
                    String string4 = string2.substring(string3.length() + 1, string2.length()).toLowerCase();
                    hashMap.put(string4, string3);
                }
                this.buildStepsData(hashMap, reportDataBuilder2, role);
                if (!role.isAdminRole()) {
                    this.buildSecuredActionsData(hashMap, reportDataBuilder2);
                    this.buildSecuredObjectData(hashMap, reportDataBuilder2, role);
                }
            }
            logger.trace((Object)("Security Report " + map.get("ROLE_NAME") + " has been built."));
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
    }

    private void buildGeneralData(Map<String, Object> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, Role role) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SecurityReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.GENERAL.name());
        reportDataBuilder.setFieldValue("ROLE_NAME", role.getName());
        hashMap.put("HEADER_NAME", role.getName());
        hashMap.put("JLR_SUB_TITLE", "General");
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Name:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, role.getName());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Description:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, role.getDescription());
        reportDataBuilder2.nextRow();
        reportDataBuilder2.setFieldValue(NAMEFIELD, "Role members:");
        reportDataBuilder2.setFieldValue(VALUEFIELD, map.get("ROLE_MEMBER").toString());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The general report data has been built.");
    }

    private void buildStepsData(Map<String, String> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, Role role) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SecurityReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        if (role.isAdminRole()) {
            hashMap.put("JLR_SUB_TITLE", "Security Settings");
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(ONELINEFIELD, "The Administrator role grants authority to all parts of the product and cannot be altered. ");
        } else {
            TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
            hashMap.put("JLR_SUB_TITLE", "Secured Areas");
            for (int i = 0; i < this.securedAreas.length; ++i) {
                String string = this.securedAreas[i].toLowerCase();
                String string2 = map.get(string);
                String string3 = translationDM.getTranslation("secured_area." + string);
                if (string3.indexOf("&reg;") != -1) {
                    int n = 174;
                    String string4 = new Character((char)n).toString();
                    string3 = ReportHelper.replace(string3, "&reg;", string4);
                }
                if (string2 == null) continue;
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, string3);
                reportDataBuilder2.setFieldValue(VALUEFIELD, " " + string2.substring(0, 1).toUpperCase() + string2.substring(1));
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.STEPS.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of security settings has been built!");
    }

    private void buildSecuredActionsData(Map<String, String> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SecurityReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
        hashMap.put("JLR_SUB_TITLE", "Secured Actions");
        for (int i = 0; i < this.securedActions.length; ++i) {
            String string = this.securedActions[i].toLowerCase();
            String string2 = map.get(string);
            String string3 = translationDM.getTranslation("secured_area." + string);
            if (string3.indexOf("&reg;") != -1) {
                int n = 174;
                String string4 = new Character((char)n).toString();
                string3 = ReportHelper.replace(string3, "&reg;", string4);
            }
            if (string2 == null) continue;
            reportDataBuilder2.nextRow();
            reportDataBuilder2.setFieldValue(NAMEFIELD, string3);
            reportDataBuilder2.setFieldValue(VALUEFIELD, "  " + string2.substring(0, 1).toUpperCase() + string2.substring(1));
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SECUREDACTIONS.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of security settings has been built!");
    }

    private void buildSecuredObjectData(Map<String, String> map, AbstractJasperReport.ReportDataBuilder reportDataBuilder, Role role) throws DataException, ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractJasperReport.ReportDataBuilder reportDataBuilder2 = SecurityReport.createReportDataBuilder();
        reportDataBuilder.nextRow();
        TranslationDM translationDM = (TranslationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.TranslationDM");
        hashMap.put("JLR_SUB_TITLE", "Secured Objects");
        for (SecuredObjects securedObjects : SecuredObjects.values()) {
            Object object;
            String string = securedObjects.toString().toLowerCase();
            String string2 = map.get(string);
            String string3 = translationDM.getTranslation("secured_area." + string);
            if (string3.indexOf("&reg;") != -1) {
                int n = 174;
                object = new Character((char)n).toString();
                string3 = ReportHelper.replace(string3, "&reg;", (String)object);
            }
            if (string2 != null) {
                reportDataBuilder2.nextRow();
                reportDataBuilder2.setFieldValue(NAMEFIELD, string3);
                reportDataBuilder2.setFieldValue(VALUEFIELD, " " + string2.substring(0, 1).toUpperCase() + string2.substring(1));
            }
            String string4 = string.equalsIgnoreCase("informaticarepositories") ? "informaticarepository" : (string.equalsIgnoreCase("informaticacloudservers") ? "informaticacloudserver" : string.substring(0, string.length() - 1));
            object = this.reportDM.getSecuredObjectRecordsList(role.getId(), string4, securedObjects.getTableName());
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string5;
                Map map2 = (Map)((ArrayList)object).get(i);
                String string6 = map2.get("ROLE_PERMISSION").toString();
                int n = Integer.parseInt(map2.get("ROLE_SECURABLE_ID").toString());
                if (string6 == null) continue;
                reportDataBuilder2.nextRow();
                String string7 = map2.get("ROLE_SECURABLE_TYPE").toString();
                if (string.equalsIgnoreCase("jobqueues") && (string5 = this.reportDM.getAgentNameByJobQueueId(n)) != null) {
                    string7 = string7 + " (" + string5 + ")";
                }
                reportDataBuilder2.setFieldValue(NAMEFIELD, "   " + string7);
                reportDataBuilder2.setFieldValue(VALUEFIELD, " " + string6.substring(0, 1).toUpperCase() + string6.substring(1));
            }
        }
        reportDataBuilder.setFieldValue(FIELD_GROUPING, Groupings.SECUREDOBJECTS.name());
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", hashMap);
        reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", reportDataBuilder2.toJRDataSource());
        logger.trace((Object)"The report data of security settings has been built!");
    }

    public static enum SecuredObjects {
        AGENTENVIRONMENTS("agent_environments"),
        AGENTEVENTMONITORS("agent_event_monitors"),
        AGENTGROUPS("agent_groups"),
        AGENTS("agents"),
        AUTOMATESYSTEMDEFINITIONS("automate_system_definitions"),
        CALENDARS("calendars"),
        COMMANDSETS("command_sets"),
        DATEOBJECTS("date_objects"),
        FILETRANSFERSYSTEMS("file_transfer_systems"),
        FORECASTDEFINITIONS("forecast_definitions"),
        IBMIAGENTENVIRONMENTS("ibmi_agent_environments"),
        IBMICOMMANDSETS("command_sets"),
        INFORMATICACLOUDSERVERS("informatica_cloud_servers"),
        INFORMATICAREPOSITORIES("informatica_repositories"),
        JOBFLOWGRAPHS("job_flow_graphs"),
        JOBQUEUES("job_queues"),
        JOBSUITES("jobs"),
        JOBS("jobs"),
        MEMBERJOBS("jobs"),
        ORACLESYSTEMDEFINITIONS("oracle_system_definitions"),
        REMOTESERVERS("remote_servers"),
        RETURNCODES("return_codes"),
        SAPABAPSTEPSETS("sap_abap_step_sets"),
        SAPJOBDEFINITIONS("sap_job_definitions"),
        SAPSYSTEMDEFINITIONS("sap_system_definitions"),
        SNMPTRAPMONITORS("snmp_trap_monitors"),
        SQLSERVERDEFINITIONS("sql_server_definitions"),
        WEBSERVERDEFINITIONS("web_server_definitions");

        private String tableName;

        private SecuredObjects(String string2) {
            this.tableName = string2;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    private static enum Groupings {
        TABLE_OF_CONTENT,
        GENERAL,
        STEPS,
        SECUREDACTIONS,
        SECUREDOBJECTS,
        Empty;

    }
}

