/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.dm.HistoryReportRowHandler;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.SNMPTrapMonitorHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.SNMPTrapMonitorHistoryReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SNMPTrapMonitorHistoryReport
extends AbstractJasperReport
implements Serializable,
HistoryReportRowHandler {
    private SNMPTrapMonitorDM snmpTrapMonitorDM;
    private static final long serialVersionUID = -871313742802236807L;
    private static final String ALL_JOBS = "All Jobs";
    public static final String REPORT_NAME = "SNMPTrapMonitorHistoryReport";
    private static final Logger logger = Logger.getLogger(SNMPTrapMonitorHistoryReport.class);
    private SNMPTrapMonitorHistoryReportFilter filter = new SNMPTrapMonitorHistoryReportFilter();
    private List<String> jobList = new ArrayList<String>();
    private List<String> agentList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    private ReportBuilder dataReportBuilder = null;
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private static final String AGENTS = "-agents";
    private static final String TAGS = "-tags";
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String SNMP_TRAP_MONITORS = "-snmpTrapMonitors";
    private static final String JOB_IDS = "-jobIds";
    private static final String SNMP_TRAP_MONITORS_IDS = "-snmpTrapMonitorIds";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public SNMPTrapMonitorHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.snmpTrapMonitorDM = (SNMPTrapMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.SNMPTrapMonitorDM");
    }

    @Override
    JasperReportData buildReportData() {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SNMPTrapMonitorHistoryReport.createReportDataBuilder();
        Long l = this.filter.getFromDate();
        Long l2 = this.filter.getToDate();
        this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
        this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l));
        this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l2));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.jobList.add(ALL_JOBS);
        this.agentList.add(ALL_JOBS);
        this.tagList.add(ALL_JOBS);
        this.parentParams.put("TITLE_JOB_LIST", this.jobList);
        this.parentParams.put("TITLE_AGENT_LIST", this.agentList);
        this.parentParams.put("TITLE_TAG_LIST", this.tagList);
        try {
            this.buildParameterReport(this.parentParams);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Could not build report parameters in title page", (Throwable)resourceUnavailableException);
        }
        catch (DataException dataException) {
            logger.error((Object)"Could not build report parameters in title page", (Throwable)dataException);
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("GROUPING", "HISTORY_LIST");
        this.reportDM.getSNMPTrapMonitorHistory(this.filter, this);
        if (this.dataReportBuilder != null) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", this.dataReportBuilder.getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", this.dataReportBuilder.getJRDataSource());
            this.log("The SNMP Trap Monitor History Data List has been built.");
            reportDataBuilder.nextRow();
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        this.log("SNMP Trap Monitor History Report data has been built.");
        return jasperReportData;
    }

    private String buildParameterReport(Map<String, Object> map) throws ResourceUnavailableException, DataException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = SNMPTrapMonitorHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    @Override
    public void handleRow(ResultSet resultSet) throws SQLException {
        int n;
        if (this.dataReportBuilder == null) {
            this.dataReportBuilder = new ReportBuilder();
        }
        this.dataReportBuilder.nextRow();
        this.dataReportBuilder.put("SERVER_TIME", "Server Time", new Date(resultSet.getLong("server_event_timestamp_utc")));
        this.dataReportBuilder.put("MONITOR_NAME", "Monitor Name", resultSet.getString("trap_monitor_name"));
        this.dataReportBuilder.put("IP_ADDRESS", "IP Address", resultSet.getString("ip_address"));
        this.dataReportBuilder.put("EVENT_ID", "Event ID", resultSet.getLong("id"));
        this.dataReportBuilder.put("EVENT_NOTE", "Note", ReportHelper.getSNMPTrapNotes(resultSet.getInt("error_code")));
        String string = resultSet.getString("event_data");
        if (string == null) {
            string = "";
        }
        if ((n = string.length()) > 0 && n > 100) {
            string = string.substring(0, 100);
        }
        this.dataReportBuilder.put("EVENT_DATA", "Event Data(first 250 characters)", string);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        SNMPTrapMonitorHistoryReportFilterParser sNMPTrapMonitorHistoryReportFilterParser = new SNMPTrapMonitorHistoryReportFilterParser();
        sNMPTrapMonitorHistoryReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(AGENTS) || string.equals(TAGS) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(SNMP_TRAP_MONITORS) || string.equals(USER_NAME) || string.equals(JOB_IDS) || string.equals(SNMP_TRAP_MONITORS_IDS) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.SNMP_TRAP_MONITOR_HISTORY_REPORT.getReportID();
    }
}

