/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilter;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobConditionR02M03;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.NotificationList;
import com.helpsystems.enterprise.core.busobj.ReactivityDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.SNMPTrapMonitor;
import com.helpsystems.enterprise.core.busobj.ScheduleDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.ScheduleDayOfWeekRanges;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceDays;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriterion;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.JobConditionDM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.dm.SNMPTrapMonitorDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.Prereq;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;

public class JobSetupReportHelper {
    private static final Logger logger = Logger.getLogger(JobSetupReportHelper.class);

    public static String getDaysOfWeekStr(DayOfWeekTimestampFilter dayOfWeekTimestampFilter) {
        String string;
        int n = dayOfWeekTimestampFilter.getStartTime();
        int n2 = dayOfWeekTimestampFilter.getEndTime();
        String string2 = ReportHelper.getFormattedTime(n);
        String string3 = ReportHelper.getFormattedTime(n2);
        ArrayList<DayOfWeekTimestampFilter.DayOption> arrayList = JobSetupReportHelper.getSpecInstanceWeekDaysValueList(dayOfWeekTimestampFilter);
        boolean bl = true;
        for (DayOfWeekTimestampFilter.DayOption object : arrayList) {
            if (object == DayOfWeekTimestampFilter.DayOption.EVERY) continue;
            bl = false;
            break;
        }
        if (bl) {
            string = n == n2 ? "Daily at " + string2 : "Daily between " + string2 + " and " + string3;
        } else {
            String string4 = JobSetupReportHelper.getSpecInstanceWeeksCountWord(dayOfWeekTimestampFilter);
            String string5 = string4.equals("") ? "" : " ";
            string = "Every " + (String)string4 + string5 + "Week";
            string = n == n2 ? string + " at " + string2 : string + " between " + string2 + " and " + string3;
            string = string + " on ";
            String string6 = JobSetupReportHelper.getSpecInstanceWeekDaysPart(dayOfWeekTimestampFilter);
            string = string + string6;
        }
        return string;
    }

    public static String getDaysOfPeriodStr(SpecialInstanceDays specialInstanceDays) {
        String string;
        int n = specialInstanceDays.getDayNumber();
        switch (n) {
            case -1: {
                string = "Last day of the Month";
                break;
            }
            case 1: {
                string = "First day of the Month";
                break;
            }
            default: {
                string = n < 0 ? "Day " + Math.abs(n) + " from the end (backwards) of the Month" : "Day " + n + " from the start of the Month";
            }
        }
        int n2 = specialInstanceDays.getStartTime();
        int n3 = specialInstanceDays.getEndTime();
        String string2 = ReportHelper.getFormattedTime(n2);
        String string3 = ReportHelper.getFormattedTime(n3);
        string = n2 == n3 ? string + " at " + string2 : string + " between " + string2 + " and " + string3;
        return string;
    }

    private static String getSpecInstanceWeekDaysPart(DayOfWeekTimestampFilter dayOfWeekTimestampFilter) {
        String string = "";
        if (dayOfWeekTimestampFilter.getDayOption_Sun() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Sun, ";
        }
        if (dayOfWeekTimestampFilter.getDayOption_Mon() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Mon, ";
        }
        if (dayOfWeekTimestampFilter.getDayOption_Tue() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Tue, ";
        }
        if (dayOfWeekTimestampFilter.getDayOption_Wed() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Wed, ";
        }
        if (dayOfWeekTimestampFilter.getDayOption_Thu() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Thu, ";
        }
        if (dayOfWeekTimestampFilter.getDayOption_Fri() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Fri, ";
        }
        if (dayOfWeekTimestampFilter.getDayOption_Sat() != DayOfWeekTimestampFilter.DayOption.NEVER) {
            string = string + "Sat";
        } else {
            string = string.trim();
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static ArrayList<DayOfWeekTimestampFilter.DayOption> getSpecInstanceWeekDaysValueList(DayOfWeekTimestampFilter dayOfWeekTimestampFilter) {
        ArrayList<DayOfWeekTimestampFilter.DayOption> arrayList = new ArrayList<DayOfWeekTimestampFilter.DayOption>();
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Mon());
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Tue());
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Wed());
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Thu());
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Fri());
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Sat());
        arrayList.add(dayOfWeekTimestampFilter.getDayOption_Sun());
        return arrayList;
    }

    private static String getSpecInstanceWeeksCountWord(DayOfWeekTimestampFilter dayOfWeekTimestampFilter) {
        String string = "";
        ArrayList<DayOfWeekTimestampFilter.DayOption> arrayList = JobSetupReportHelper.getSpecInstanceWeekDaysValueList(dayOfWeekTimestampFilter);
        for (DayOfWeekTimestampFilter.DayOption dayOption : arrayList) {
            if (dayOption == DayOfWeekTimestampFilter.DayOption.NEVER) continue;
            switch (dayOption) {
                case EVERY: {
                    string = "";
                    break;
                }
                case FIRST: {
                    string = "First";
                    break;
                }
                case SECOND: {
                    string = "Second";
                    break;
                }
                case THIRD: {
                    string = "Third";
                    break;
                }
                case FOURTH: {
                    string = "Fourth";
                    break;
                }
                case FIFTH: {
                    string = "Fifth";
                    break;
                }
                case LAST: {
                    string = "Last";
                }
            }
            break;
        }
        return string;
    }

    public static String getScheduleExceptionType(ScheduleInfo.NonWorkdayOption nonWorkdayOption) {
        switch (nonWorkdayOption) {
            case RUN_ON_NEAREST_PRIOR_WORKDAY: {
                return "Run on the preceding Working Day";
            }
            case RUN: {
                return "Run on all scheduled days";
            }
            case DO_NOT_RUN: {
                return "Run on scheduled Working Days only";
            }
            case RUN_ON_NEAREST_SUBSEQUENT_WORKDAY: {
                return "Run on the following Working Day";
            }
        }
        return null;
    }

    public static String getTimeFormatFromMinutes(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = n2 == 1 ? "" : "s";
        String string2 = n2 != 0 ? n2 + " Hour" + string + " " : "";
        string = n3 == 1 ? "" : "s";
        String string3 = n3 != 0 ? n3 + " Minute" + string : "";
        return string2 + string3;
    }

    public static void fillNotificationListData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, NotificationList notificationList, String string) {
        if (notificationList != null) {
            if (notificationList.isPublicList()) {
                reportDataBuilder.nextRow();
                reportDataBuilder.setFieldValue("NAMEFIELD", "Notification List to use:");
                reportDataBuilder.setFieldValue(string, notificationList.getName());
            } else {
                User[] userArray = notificationList.getUsers();
                String string2 = "";
                if (userArray.length > 0) {
                    string2 = userArray[0].getName();
                    for (int i = 1; i < userArray.length; ++i) {
                        string2 = string2 + ", ";
                        string2 = string2 + userArray[i].getName();
                    }
                    reportDataBuilder.nextRow();
                    reportDataBuilder.setFieldValue("NAMEFIELD", "Email to Users:");
                    reportDataBuilder.setFieldValue(string, string2);
                }
            }
        }
    }

    public static void fillNotificationListDataForMonitors(AbstractJasperReport.ReportDataBuilder reportDataBuilder, NotificationList notificationList, String string, String string2, String string3) {
        if (notificationList != null) {
            if (notificationList.isPublicList()) {
                reportDataBuilder.nextRow();
                reportDataBuilder.setFieldValue("NAMEFIELD", "Notification List to use:");
                reportDataBuilder.setFieldValue(string, notificationList.getName());
            } else {
                User[] userArray = notificationList.getUsers();
                String string4 = "";
                if (userArray.length > 0) {
                    string4 = userArray[0].getName();
                    for (int i = 1; i < userArray.length; ++i) {
                        string4 = string4 + ", ";
                        string4 = string4 + userArray[i].getName();
                    }
                    reportDataBuilder.nextRow();
                    reportDataBuilder.setFieldValue("NAMEFIELD", "Email to Users:");
                    reportDataBuilder.setFieldValue(string, string4);
                    reportDataBuilder.nextRow();
                    reportDataBuilder.setFieldValue("NAMEFIELD", "Custom Subject:");
                    reportDataBuilder.setFieldValue("VALUEFIELD", string2);
                    reportDataBuilder.nextRow();
                    reportDataBuilder.setFieldValue("NAMEFIELD", "Custom Text:");
                    reportDataBuilder.setFieldValue("VALUEFIELD", string3);
                }
            }
        }
    }

    public static void fillStatusNotificationData(AbstractJasperReport.ReportDataBuilder reportDataBuilder, long l, String string, boolean bl, String string2, String string3, JobStatusCode jobStatusCode, boolean bl2) throws NoDataException, BadDataException, ResourceUnavailableException {
        NotificationList notificationList = null;
        if (l != 0L) {
            NotificationListDM notificationListDM = (NotificationListDM)ManagerRegistry.getManager((String)"ENTERPRISE.NotificationListDM");
            try {
                notificationList = notificationListDM.get(l);
            }
            catch (NoDataException noDataException) {
                // empty catch block
            }
        }
        if (!bl && (l == 0L || notificationList == null || !notificationList.isPublicList() && notificationList.getUsers().length == 0)) {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("ONELINEFIELD", string + " will not occur");
        } else {
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("ONELINEFIELD", string);
            JobSetupReportHelper.fillSnmpTrapOption(reportDataBuilder, bl);
            JobSetupReportHelper.fillNotificationListData(reportDataBuilder, notificationList, "VALUEFIELD");
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("NAMEFIELD", "Custom Subject:");
            reportDataBuilder.setFieldValue("VALUEFIELD", string2);
            reportDataBuilder.nextRow();
            reportDataBuilder.setFieldValue("NAMEFIELD", "Custom Text:");
            reportDataBuilder.setFieldValue("VALUEFIELD", string3);
            switch (jobStatusCode) {
                case CANCELED: {
                    JobSetupReportHelper.fillSendJobLogOption(reportDataBuilder, bl2);
                    break;
                }
                case FAILED: {
                    JobSetupReportHelper.fillSendJobLogOption(reportDataBuilder, bl2);
                    break;
                }
                case COMPLETED: {
                    JobSetupReportHelper.fillSendJobLogOption(reportDataBuilder, bl2);
                    break;
                }
            }
        }
    }

    public static void fillSendJobLogOption(AbstractJasperReport.ReportDataBuilder reportDataBuilder, boolean bl) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Email Job Log");
        reportDataBuilder.setFieldValue("VALUEFIELD", bl ? "Yes" : "No");
    }

    public static void fillSnmpTrapOption(AbstractJasperReport.ReportDataBuilder reportDataBuilder, boolean bl) {
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("NAMEFIELD", "Send SNMP Trap:");
        reportDataBuilder.setFieldValue("VALUEFIELD", bl ? "Yes" : "No");
    }

    public static String getOutputDublicateOption(int n) {
        if (n == 0) {
            return "Increment Naming";
        }
        if (n == 1) {
            return "Replace Existing File";
        }
        if (n == 2) {
            return "Fail when Duplicate";
        }
        return null;
    }

    public static String getNoteListForOutput(NotificationList notificationList) {
        String string = "";
        if (notificationList != null) {
            if (notificationList.isPublicList()) {
                string = notificationList.getName();
            } else {
                User[] userArray = notificationList.getUsers();
                String string2 = "";
                if (userArray.length > 0) {
                    string2 = userArray[0].getName();
                    for (int i = 1; i < userArray.length; ++i) {
                        string2 = string2 + ", ";
                        string2 = string2 + userArray[i].getName();
                    }
                    string = string2;
                }
            }
        }
        return string;
    }

    public static String getPurgeHandleName(long l) {
        if (l == 1L) {
            return "Remove with History";
        }
        if (l == 0L) {
            return "Remove Manually";
        }
        if (l == 2L) {
            return "";
        }
        return "Wrong type of Purge Handeling";
    }

    public static String getPrerqData(ScheduleJob scheduleJob, Prereq prereq, String string) {
        long l = prereq.getPrereqObjectID();
        String string2 = JobSetupReportHelper.getPrereqStatusName(prereq.getReactToStatus());
        String string3 = prereq.isLatchStatus() ? " - Don't overwrite" : "";
        String string4 = prereq.isKeepStatus() ? " - Don't clear" : "";
        ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleJobDM");
        try {
            switch (prereq.getType()) {
                case JOB_STATUS_CHANGE: {
                    string2 = JobSetupReportHelper.getPrereqStatusName(prereq.getReactToStatus());
                    String string5 = scheduleJobDM.getScheduleJobProxy(l).getName();
                    return "Job " + string5 + " status is " + string2 + string + string3 + string4;
                }
                case AGENT_EVENT: {
                    AgentEventMonitorDM agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorDM");
                    AgentEventMonitor agentEventMonitor = agentEventMonitorDM.get(l, null);
                    return "Agent Event " + agentEventMonitor.getName() + " occurs" + string + string4;
                }
                case SNMP_TRAP_EVENT: {
                    SNMPTrapMonitorDM sNMPTrapMonitorDM = (SNMPTrapMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.SNMPTrapMonitorDM");
                    SNMPTrapMonitor sNMPTrapMonitor = sNMPTrapMonitorDM.get(l, null);
                    return "SNMP Trap " + sNMPTrapMonitor.getName() + " received" + string + string4;
                }
                case JOB_MONITOR_EVENT: {
                    String string6 = scheduleJobDM.getScheduleJobProxy(l).getName();
                    return "Job " + string6 + " " + string2 + " event occurs" + string + string3 + string4;
                }
                case JOB_SUITE_STATUS_CHANGE: {
                    String string7 = scheduleJobDM.getScheduleJobProxy(l).getName();
                    return "Job Suite " + string7 + " status is " + string2 + string + string3 + string4;
                }
                case JOB_SUITE_MONITOR_EVENT: {
                    String string8 = scheduleJobDM.getScheduleJobProxy(l).getName();
                    return "Job Suite " + string8 + " " + string2 + " event occurs" + string + string3 + string4;
                }
                case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                    ReportDM reportDM = (ReportDM)ManagerRegistry.getManager((String)"ENTERPRISE.ReportDM");
                    HashMap<String, Long> hashMap = reportDM.getJobIDsByPrereqObjectId(l);
                    String string9 = scheduleJobDM.getScheduleJobProxy(hashMap.get("MemberJob")).getName();
                    String string10 = scheduleJobDM.getScheduleJobProxy(hashMap.get("Suite")).getName();
                    return "Member Job " + string9 + " in " + string10 + " status is " + string2 + string + string3 + string4;
                }
                case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                    String string11 = scheduleJobDM.getScheduleJobProxy(l).getName();
                    return "Member Job " + string11 + " " + string2 + " event occurs" + string + string3 + string4;
                }
                case REMOTE_EVENT: {
                    StringBuilder stringBuilder = new StringBuilder();
                    RemoteEventDM remoteEventDM = (RemoteEventDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteEventDM");
                    RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServersDM");
                    RemoteEvent remoteEvent = remoteEventDM.get(prereq.getPrereqObjectID());
                    if (remoteEvent != null) {
                        RemoteEventType remoteEventType = remoteEvent.getEventType();
                        RemoteServer remoteServer = remoteServersDM.getServer(remoteEvent.getRemoteServerID());
                        RemoteServerType remoteServerType = remoteServersDM.getServerType(remoteEvent.getRemoteServerID());
                        if (RemoteServerType.SCHEDULE == remoteServerType) {
                            stringBuilder.append("Robot SCHEDULE");
                        } else if (RemoteServerType.SKYBOT == remoteServerType) {
                            stringBuilder.append("Automate Schedule");
                        }
                        if (RemoteEventType.JOB_STATUS_CHANGE == remoteEventType) {
                            stringBuilder.append(" Job ");
                        } else if (RemoteEventType.AGENT_EVENT == remoteEventType) {
                            stringBuilder.append(" Agent Event ");
                        } else if (RemoteEventType.JOB_MONITOR_EVENT == remoteEventType) {
                            stringBuilder.append(" Job Monitor ");
                        } else if (RemoteEventType.JOB_SUITE_MEMBER_STATUS_CHANGE == remoteEventType) {
                            stringBuilder.append(" Member Job ");
                        } else if (RemoteEventType.JOB_SUITE_MONITOR_EVENT == remoteEventType) {
                            stringBuilder.append(" Job Suite Monitor ");
                        } else if (RemoteEventType.JOB_SUITE_STATUS_CHANGE == remoteEventType) {
                            stringBuilder.append(" Job Suite ");
                        } else if (RemoteEventType.JOB_SUITE_MEMBER_MONITOR_EVENT == remoteEventType) {
                            stringBuilder.append(" Member Job Monitor ");
                        } else if (RemoteEventType.GROUP_JOB_STATUS_CHANGE == remoteEventType) {
                            stringBuilder.append(" Group Job ");
                        }
                        stringBuilder.append(remoteEvent.getRemoteObjectName());
                        if (RemoteEventType.JOB_SUITE_MEMBER_STATUS_CHANGE == remoteEventType) {
                            stringBuilder.append(" in ");
                            stringBuilder.append(remoteEvent.getJobSuiteName());
                        }
                        stringBuilder.append(" from ");
                        stringBuilder.append(remoteServer.getName());
                        stringBuilder.append(" status is ");
                        stringBuilder.append(string2);
                        stringBuilder.append(string);
                        stringBuilder.append(string3);
                        stringBuilder.append(string4);
                    }
                    return stringBuilder.toString();
                }
            }
        }
        catch (DataException dataException) {
            logger.error((Object)dataException.getMessage(), (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)resourceUnavailableException.getMessage(), (Throwable)resourceUnavailableException);
        }
        return null;
    }

    public static String getPrereqStatusName(PrereqStatusType prereqStatusType) {
        switch (prereqStatusType) {
            case COMPLETED: {
                return "Completed";
            }
            case CANCELED: {
                return "Canceled";
            }
            case BLANK: {
                return "";
            }
            case FAILED: {
                return "Failed";
            }
            case LATE_START: {
                return "Late Start";
            }
            case OCCURRED: {
                return "Occurred";
            }
            case ENDED: {
                return "Canceled, Completed, or Failed";
            }
            case OVER_RUN: {
                return "Overrun";
            }
            case UNDER_RUN: {
                return "Underrun";
            }
            case RUNNING: {
                return "Running";
            }
            case SUBMITTED: {
                return "Submitted";
            }
            case CONDITION_RETRY_WAIT: {
                return "Retry Wait";
            }
            case SKIPPED: {
                return "Skipped";
            }
        }
        return "Unknown status - " + prereqStatusType.persistanceCode();
    }

    public static String getPeriodTypeName(CalendarObject.PeriodType periodType) {
        switch (periodType) {
            case HALF_YEAR: {
                return "Half-Year";
            }
            case MONTH: {
                return "Month";
            }
            case QUARTER: {
                return "Quarter";
            }
            case YEAR: {
                return "Year";
            }
        }
        return null;
    }

    public static String getReacivityDayofPeriodLine(ReactivityDayOfPeriod reactivityDayOfPeriod) {
        int n = reactivityDayOfPeriod.getStartTime();
        int n2 = reactivityDayOfPeriod.getEndTime();
        int n3 = reactivityDayOfPeriod.getDayNumber();
        String string = "Run on day " + Math.abs(n3);
        string = string + " Of the " + JobSetupReportHelper.getPeriodTypeName(reactivityDayOfPeriod.getPeriodType());
        string = string + " Counting days";
        string = string + (n3 < 0 ? " from the end (backwards)" : " from the start");
        string = string + " Between " + ReportHelper.getFormattedTime(n);
        string = string + " and " + ReportHelper.getFormattedTime(n2);
        return string;
    }

    public static String getScheduleDayofPeriodLine(ScheduleDayOfPeriod scheduleDayOfPeriod) {
        String string;
        int n = scheduleDayOfPeriod.getDayNumber();
        int n2 = Math.abs(n);
        if (n2 == 1) {
            string = n < 0 ? "Last day" : "First day";
        } else {
            string = "Day " + n2;
            string = string + (n < 0 ? " from the end (backwards)" : " from the start");
        }
        string = string + " of the " + JobSetupReportHelper.getPeriodTypeName(scheduleDayOfPeriod.getPeriodType());
        string = string + " at " + ReportHelper.getFormattedTime(scheduleDayOfPeriod.getRuntime());
        return string;
    }

    public static String getScheduleDayOfWeekRanges(ArrayList<ScheduleDayOfWeekRanges> arrayList) {
        if (arrayList.size() == 1) {
            return JobSetupReportHelper.getDaysOfWeekStr(arrayList.get(0));
        }
        String string = null;
        if (arrayList.size() == 2) {
            boolean bl = arrayList.get(0).getStartTime() != 0;
            ScheduleDayOfWeekRanges scheduleDayOfWeekRanges = bl ? arrayList.get(0) : arrayList.get(1);
            ScheduleDayOfWeekRanges scheduleDayOfWeekRanges2 = bl ? arrayList.get(1) : arrayList.get(0);
            int n = scheduleDayOfWeekRanges.getStartTime();
            int n2 = scheduleDayOfWeekRanges2.getEndTime();
            String string2 = ReportHelper.getFormattedTime(n);
            String string3 = ReportHelper.getFormattedTime(n2);
            ArrayList<DayOfWeekTimestampFilter.DayOption> arrayList2 = JobSetupReportHelper.getSpecInstanceWeekDaysValueList(scheduleDayOfWeekRanges2);
            boolean bl2 = true;
            for (DayOfWeekTimestampFilter.DayOption dayOption : arrayList2) {
                if (dayOption == DayOfWeekTimestampFilter.DayOption.EVERY) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                string = "From " + string2 + " each day until " + string3 + " the next day";
            } else {
                String string4 = JobSetupReportHelper.getSpecInstanceWeeksCountWord(scheduleDayOfWeekRanges2);
                string = "From " + string2 + " until " + string3;
                string = string + " the next day every " + (String)string4 + " Week starting on ";
                string = string + JobSetupReportHelper.getSpecInstanceWeekDaysPart(scheduleDayOfWeekRanges2);
            }
        }
        return string;
    }

    public static String getDateStrFromYyyymmdd(int n) {
        int n2 = n / 10000;
        int n3 = (n - n2 * 10000) / 100;
        int n4 = n - n2 * 10000 - n3 * 100;
        return n3 + "/" + n4 + "/" + n2;
    }

    public static String getOneLineString(String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(", ");
        }
        n = stringBuffer.length();
        if (n > 2) {
            stringBuffer.deleteCharAt(n - 2);
        }
        return stringBuffer.toString();
    }

    public static String getOneLineString(Long[] longArray) {
        String[] stringArray = new String[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            stringArray[i] = String.valueOf(longArray[i]);
        }
        return JobSetupReportHelper.getOneLineString(stringArray);
    }

    public static String getTimeBySec(int n) {
        if (n % 3600 == 0) {
            int n2 = n / 3600;
            String string = n2 == 1 ? "" : "s";
            return n2 + " Hour" + string;
        }
        if (n % 60 == 0) {
            int n3 = n / 60;
            String string = n3 == 1 ? "" : "s";
            return n3 + " Minute" + string;
        }
        String string = n == 1 ? "" : "s";
        return n + " Second" + string;
    }

    public static String getCondStr(JobCondition jobCondition) throws ResourceUnavailableException, DataException {
        switch (jobCondition.getConditionType()) {
            case PROCESS: {
                return "A process that " + JobSetupReportHelper.getCondProcessVar(jobCondition.getConditionVar1()) + " \"" + jobCondition.getConditionData() + "\" is " + (jobCondition.isConditionChoice() ? "active" : "not active");
            }
            case DRIVE_SPACE: {
                return "Minimum Drive Space of " + jobCondition.getConditionVar2() + " " + JobSetupReportHelper.getCondSpaceVar(jobCondition.getConditionVar1()) + " is " + (jobCondition.isConditionChoice() ? "available" : "not available") + " in Directory " + jobCondition.getConditionData();
            }
            case SERVER_SERVICE_TCP: {
                return "TCP Server Name/IP named " + jobCondition.getConditionData() + " and Service/Port " + jobCondition.getConditionVar1() + " is " + (jobCondition.isConditionChoice() ? "available" : "not available");
            }
            case FILE_TRANSFER_SYSTEM: {
                return "TCP Server Name/IP named " + jobCondition.getConditionData() + " and Service/Port " + JobSetupReportHelper.getConditionFTPPort((JobConditionR02M03)jobCondition) + " is " + (jobCondition.isConditionChoice() ? "available" : "not available");
            }
            case FILE: {
                return "File named " + jobCondition.getConditionData() + " is " + (jobCondition.isConditionChoice() ? "present" : "not present");
            }
            case FOLDER: {
                return "Directory named " + jobCondition.getConditionData() + " is " + (jobCondition.isConditionChoice() ? "present" : "not present");
            }
        }
        return "Wrong condition type.";
    }

    private static int getConditionFTPPort(JobConditionR02M03 jobConditionR02M03) throws ResourceUnavailableException, DataException {
        JobConditionDM jobConditionDM = (JobConditionDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobConditionDM");
        jobConditionDM.fillJobConditionFromFTS(jobConditionR02M03);
        return jobConditionR02M03.getConditionVar1();
    }

    public static String[] getMergedJobNames(ArrayList<String> arrayList, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : arrayList) {
            hashSet.add(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        String[] stringArray2 = new String[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray2[n] = string = (String)iterator.next();
            ++n;
        }
        return stringArray2;
    }

    private static String getCondProcessVar(int n) {
        switch (n) {
            case 1: {
                return "begins with";
            }
            case 2: {
                return "contains";
            }
            case 3: {
                return "ends with";
            }
        }
        return "Wrong Conditions Process Var";
    }

    private static String getCondSpaceVar(int n) {
        switch (n) {
            case 1: {
                return "KB";
            }
            case 2: {
                return "MB";
            }
            case 3: {
                return "GB";
            }
            case 4: {
                return "TB";
            }
        }
        return "Wrong Conditions Unit Var";
    }

    public static String getReacivityDaysOfWeekLine(DayOfWeekTimestampFilter dayOfWeekTimestampFilter) {
        int n = dayOfWeekTimestampFilter.getStartTime();
        int n2 = dayOfWeekTimestampFilter.getEndTime();
        String string = ReportHelper.getFormattedTime(n);
        String string2 = ReportHelper.getFormattedTime(n2);
        String string3 = "Between " + string + " and " + string2;
        String string4 = JobSetupReportHelper.getSpecInstanceWeeksCountWord(dayOfWeekTimestampFilter);
        String string5 = string4.equals("") ? "" : " ";
        string3 = string3 + " Every " + string4 + string5 + "Week";
        string3 = string3 + " On ";
        String string6 = JobSetupReportHelper.getSpecInstanceWeekDaysPart(dayOfWeekTimestampFilter);
        string3 = string3 + string6;
        return string3;
    }

    public static AgentEnvironmentVariable[] getMergedAgtVariables(AgentEnvironmentVariable[] agentEnvironmentVariableArray, AgentEnvironmentVariable[] agentEnvironmentVariableArray2) {
        HashMap<String, AgentEnvironmentVariable> hashMap = new HashMap<String, AgentEnvironmentVariable>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<AgentEnvironmentVariable> arrayList = new ArrayList<AgentEnvironmentVariable>();
        if (agentEnvironmentVariableArray2 != null && agentEnvironmentVariableArray2.length > 0) {
            String string;
            String string2;
            SkybotVariable skybotVariable;
            AgentEnvironmentVariable agentEnvironmentVariable;
            int n;
            for (n = 0; n < agentEnvironmentVariableArray2.length; ++n) {
                hashMap.put(agentEnvironmentVariableArray2[n].getName(), agentEnvironmentVariableArray2[n]);
            }
            for (n = 0; n < agentEnvironmentVariableArray.length; ++n) {
                agentEnvironmentVariable = new AgentEnvironmentVariable();
                skybotVariable = new SkybotVariable();
                string2 = agentEnvironmentVariableArray[n].getName();
                string = agentEnvironmentVariableArray[n].getSkybotVariable() == null ? "" : agentEnvironmentVariableArray[n].getSkybotVariable().getName();
                String string3 = agentEnvironmentVariableArray[n].getVariable();
                long l = agentEnvironmentVariableArray[n].getOid();
                agentEnvironmentVariable.setOid(l);
                if (hashMap.containsKey(string2)) {
                    String string4;
                    hashSet.add(string2);
                    agentEnvironmentVariable.setName(string2);
                    AgentEnvironmentVariable agentEnvironmentVariable2 = (AgentEnvironmentVariable)((Object)hashMap.get(string2));
                    if (!agentEnvironmentVariable2.getVariable().equals(string3)) {
                        agentEnvironmentVariable.setVariable(string3 + "*");
                    } else {
                        agentEnvironmentVariable.setVariable(string3);
                    }
                    String string5 = string4 = ((AgentEnvironmentVariable)((Object)hashMap.get(string2))).getSkybotVariable() == null ? "" : ((AgentEnvironmentVariable)((Object)hashMap.get(string2))).getSkybotVariable().getName();
                    if (!string4.equals(string)) {
                        skybotVariable.setName(string + "*");
                    } else {
                        skybotVariable.setName(string);
                    }
                    agentEnvironmentVariable.setSkybotVariable(skybotVariable);
                } else {
                    string3 = string3.equals("") ? "" : string3 + "*";
                    string = string.equals("") ? "" : string + "*";
                    agentEnvironmentVariable.setName(string2 + "*");
                    agentEnvironmentVariable.setVariable(string3);
                    skybotVariable.setName(string);
                    agentEnvironmentVariable.setSkybotVariable(skybotVariable);
                }
                arrayList.add(agentEnvironmentVariable);
            }
            for (n = 0; n < agentEnvironmentVariableArray2.length; ++n) {
                agentEnvironmentVariable = new AgentEnvironmentVariable();
                skybotVariable = new SkybotVariable();
                string2 = agentEnvironmentVariableArray2[n].getName();
                string = agentEnvironmentVariableArray2[n].getVariable();
                long l = agentEnvironmentVariableArray2[n].getOid();
                agentEnvironmentVariable.setOid(l);
                if (hashSet.contains(agentEnvironmentVariableArray2[n].getName())) continue;
                String string6 = agentEnvironmentVariableArray2[n].getSkybotVariable() == null ? "" : agentEnvironmentVariableArray2[n].getSkybotVariable().getName();
                agentEnvironmentVariable.setName(string2);
                agentEnvironmentVariable.setVariable(string);
                skybotVariable.setName(string6);
                agentEnvironmentVariable.setSkybotVariable(skybotVariable);
                arrayList.add(agentEnvironmentVariable);
            }
        } else {
            for (int i = 0; i < agentEnvironmentVariableArray.length; ++i) {
                AgentEnvironmentVariable agentEnvironmentVariable = new AgentEnvironmentVariable();
                SkybotVariable skybotVariable = new SkybotVariable();
                String string = agentEnvironmentVariableArray[i].getName();
                String string7 = agentEnvironmentVariableArray[i].getVariable().equals("") ? "" : agentEnvironmentVariableArray[i].getVariable();
                long l = agentEnvironmentVariableArray[i].getOid();
                agentEnvironmentVariable.setOid(l);
                String string8 = agentEnvironmentVariableArray[i].getSkybotVariable() == null ? "" : agentEnvironmentVariableArray[i].getSkybotVariable().getName();
                agentEnvironmentVariable.setName(string);
                agentEnvironmentVariable.setVariable(string7);
                skybotVariable.setName(string8);
                agentEnvironmentVariable.setSkybotVariable(skybotVariable);
                arrayList.add(agentEnvironmentVariable);
            }
        }
        AgentEnvironmentVariable[] agentEnvironmentVariableArray3 = arrayList.toArray(new AgentEnvironmentVariable[arrayList.size()]);
        Arrays.sort(agentEnvironmentVariableArray3, new Comparator<AgentEnvironmentVariable>(){

            @Override
            public int compare(AgentEnvironmentVariable agentEnvironmentVariable, AgentEnvironmentVariable agentEnvironmentVariable2) {
                Long l = agentEnvironmentVariable.getOid();
                Long l2 = agentEnvironmentVariable2.getOid();
                return l2.compareTo(l);
            }
        });
        return agentEnvironmentVariableArray3;
    }

    public static void completeIndexPageNumbers(JasperPrint jasperPrint) {
        if (jasperPrint != null) {
            List list = jasperPrint.getPages();
            int n = list.size();
            if (list != null && n > 0) {
                String string = "TOC_INDEX_INDEX";
                int n2 = 0;
                JRPrintPage jRPrintPage = null;
                List list2 = null;
                JRPrintElement jRPrintElement = null;
                HashMap<String, Integer> hashMap = JobSetupReportHelper.getPageNumbers(list);
                boolean bl = false;
                block0: for (int i = 0; i < n && !bl; ++i) {
                    jRPrintPage = (JRPrintPage)list.get(i);
                    list2 = jRPrintPage.getElements();
                    int n3 = list2.size();
                    if (list2 == null || n3 <= 0) continue;
                    for (int j = 0; j < n3 && !bl; ++j) {
                        String string2;
                        jRPrintElement = (JRPrintElement)list2.get(j);
                        if (!(jRPrintElement instanceof JRPrintText) || !(string2 = ((JRPrintText)jRPrintElement).getText()).startsWith(string)) continue;
                        String string3 = string2.substring(string.length());
                        Integer n4 = hashMap.get(string3);
                        ((JRPrintText)jRPrintElement).setText(String.valueOf(n4));
                        if (++n2 != hashMap.size()) continue;
                        bl = true;
                        continue block0;
                    }
                }
            }
        }
    }

    public static HashMap<String, Integer> getPageNumbers(List list) {
        int n;
        String string = "BoOkMaRk";
        JRPrintPage jRPrintPage = null;
        List list2 = null;
        JRPrintElement jRPrintElement = null;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = n = list.size() - 1; i >= 0; --i) {
            jRPrintPage = (JRPrintPage)list.get(i);
            list2 = jRPrintPage.getElements();
            if (list2 == null || list2.size() <= 0) continue;
            for (int j = 0; j < list2.size(); ++j) {
                String string2;
                jRPrintElement = (JRPrintElement)list2.get(j);
                if (!(jRPrintElement instanceof JRPrintText) || !((JRPrintText)jRPrintElement).getText().startsWith(string) || hashMap.containsKey(string2 = ((JRPrintText)jRPrintElement).getText().substring(string.length())) && hashMap.get(string2) < new Integer(i + 1)) continue;
                hashMap.put(string2, new Integer(i + 1));
            }
        }
        return hashMap;
    }

    public static String getSAPRestrictedDays(SAPInterceptCriterion sAPInterceptCriterion) {
        String string = "";
        if (sAPInterceptCriterion.isRestrictedSunday()) {
            string = string + "Sun, ";
        }
        if (sAPInterceptCriterion.isRestrictedMonday()) {
            string = string + "Mon, ";
        }
        if (sAPInterceptCriterion.isRestrictedTuesday()) {
            string = string + "Tue, ";
        }
        if (sAPInterceptCriterion.isRestrictedWednesday()) {
            string = string + "Wed, ";
        }
        if (sAPInterceptCriterion.isRestrictedThursday()) {
            string = string + "Thu, ";
        }
        if (sAPInterceptCriterion.isRestrictedFriday()) {
            string = string + "Fri, ";
        }
        if (sAPInterceptCriterion.isRestrictedSaturday()) {
            string = string + "Sat";
        } else if ((string = string.trim()).length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

