/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitorProxy;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.HistoryReportRowHandler;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.core.reports.filter.AgentEventHistoryReportFilter;
import com.helpsystems.enterprise.core.reports.filter.parser.AgentEventHistoryReportFilterParser;
import com.helpsystems.enterprise.module.reports.ReportBuilder;
import com.helpsystems.enterprise.module.reports.ReportTitleHelper;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AgentEventHistoryReport
extends AbstractJasperReport
implements Serializable,
HistoryReportRowHandler {
    private AgentEventHistoryReportFilter filter = new AgentEventHistoryReportFilter();
    private AgentEventMonitorDM agentEventMonitorDM;
    private static final long serialVersionUID = -871313742802236807L;
    public static final String REPORT_NAME = "AgentEventHistoryReport";
    private static final String AGENTS = "-agents";
    private static final String AGENT_GROUPS = "-agentGroups";
    private static final String TAGS = "-tags";
    private static final String USER_NAME = "-userName";
    private static final String DATE_RANGE = "-dateRange";
    private static final String END_DATE_DURATION = "-endDateDuration";
    private static final String START_DATE_DURATION = "-startDateDuration";
    private static final String AGENT_EVENT_MONITORS = "-agentEventMonitors";
    private static final String EVENT_TYPES = "-eventTypes";
    private static final String JOB_IDS = "-jobIds";
    private static final String AGENT_EVENTS = "-agentEvents";
    private static final String EVENT_TYPE_IDS = "-eventTypeIds";
    private static final Logger logger = Logger.getLogger(AgentEventHistoryReport.class);
    private List<String> jobList = new ArrayList<String>();
    private List<String> agentList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    private ReportBuilder dataReportBuilder = null;

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    public AgentEventHistoryReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
        this.agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorDM");
    }

    @Override
    JasperReportData buildReportData() {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = AgentEventHistoryReport.createReportDataBuilder();
        Long l = this.filter.getFromDate();
        Long l2 = this.filter.getToDate();
        this.parentParams.put("HEADER_REPORT_NAME", REPORT_NAME);
        this.parentParams.put("HEADER_FROM_DATE", ReportHelper.getStartDate(l));
        this.parentParams.put("HEADER_TO_DATE", ReportHelper.getEndDate(l2));
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.jobList.add("All Jobs");
        this.agentList.add("All Jobs");
        this.tagList.add("All Jobs");
        this.parentParams.put("TITLE_JOB_LIST", this.jobList);
        this.parentParams.put("TITLE_AGENT_LIST", this.agentList);
        this.parentParams.put("TITLE_TAG_LIST", this.tagList);
        try {
            this.buildParameterReport(this.parentParams);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Could not build report parameters in title page", (Throwable)resourceUnavailableException);
        }
        catch (DataException dataException) {
            logger.error((Object)"Could not build report parameters in title page", (Throwable)dataException);
        }
        reportDataBuilder.nextRow();
        reportDataBuilder.setFieldValue("GROUPING", "HISTORY_LIST");
        this.reportDM.getAgentEventData(this.filter, this);
        if (this.dataReportBuilder != null) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_PARAMS", this.dataReportBuilder.getParams());
            reportDataBuilder.setFieldValue("GROUP_SUBREPORT_DATA", this.dataReportBuilder.getJRDataSource());
            logger.trace((Object)"The Agent Event  History Data  has been built.");
            reportDataBuilder.nextRow();
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Agent event History Report data has been built.");
        return jasperReportData;
    }

    private String buildParameterReport(Map<String, Object> map) throws ResourceUnavailableException, DataException {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = AgentEventHistoryReport.createReportDataBuilder();
        return ReportTitleHelper.getInstance().buildReportParameter(map, reportDataBuilder, this.filter);
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        AgentEventHistoryReportFilterParser agentEventHistoryReportFilterParser = new AgentEventHistoryReportFilterParser();
        this.replaceIfNotAKey(objectArray);
        agentEventHistoryReportFilterParser.parseParameters(this.filter, objectArray);
        this.setEmailToAddress(this.filter.getEmailToAddress());
        this.setEmailToNotificationList(this.filter.getEmailToNotificationList());
        this.setEmailToCurrentUser(this.filter.isEmailToCurrentUser());
        this.setSavedReportFileName(this.filter.getReportFileName());
        this.setSavedReportFilePath(this.filter.getReportPath());
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (n == 0 && this.isEqualToKey(string) && ++n == 1) continue;
            if (!string.equals("-") && string.startsWith("-") && n == 1) {
                String string2 = string.replaceAll("-", "val_");
                objectArray[i] = string2;
            }
            n = 0;
        }
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return string.equals(DATE_RANGE) || string.equals(AGENTS) || string.equals(AGENT_GROUPS) || string.equals(TAGS) || string.equals(END_DATE_DURATION) || string.equals(START_DATE_DURATION) || string.equals(AGENT_EVENT_MONITORS) || string.equals(EVENT_TYPES) || string.equals(USER_NAME) || string.equals(JOB_IDS) || string.equals(AGENT_EVENTS) || string.equals(EVENT_TYPE_IDS) || string.equals("-f");
    }

    @Override
    public int getReportID() {
        return Reports.ReportType.AGENT_EVENT_HISTORY_REPORT.getReportID();
    }

    @Override
    public void handleRow(ResultSet resultSet) throws SQLException {
        Cloneable cloneable;
        if (this.dataReportBuilder == null) {
            this.dataReportBuilder = new ReportBuilder();
        }
        this.dataReportBuilder.nextRow();
        this.dataReportBuilder.put("EVENT_ID", "Event ID", resultSet.getLong("id"));
        this.dataReportBuilder.put("AGENT", "Agent", resultSet.getString("agent_name"));
        this.dataReportBuilder.put("EVENT_NAME", "Event Name", resultSet.getString("event_monitor_name"));
        Calendar calendar = null;
        String string = resultSet.getString("agent_timezone");
        String string2 = null;
        if (string != null) {
            String string3;
            cloneable = TimeZone.getTimeZone(string);
            calendar = Calendar.getInstance();
            calendar.setTimeZone((TimeZone)cloneable);
            calendar.setTimeInMillis(resultSet.getLong("agent_timestamp_utc"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            simpleDateFormat.setCalendar(calendar);
            simpleDateFormat.setTimeZone((TimeZone)cloneable);
            string2 = string3 = simpleDateFormat.format(calendar.getTime());
        } else {
            cloneable = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            Date date = new Date(resultSet.getLong("agent_timestamp_utc"));
            string2 = ((DateFormat)cloneable).format(date);
        }
        this.dataReportBuilder.put("AGENT_TIME", "Agent Time", string2);
        this.dataReportBuilder.put("SERVER_TIME", "Server Time", new Date(resultSet.getLong("server_timestamp_utc")));
        this.dataReportBuilder.put("EVENT_TYPE", "Event Type", AgentEventMonitorProxy.getTypeDescription(resultSet.getInt("monitor_type")));
        this.dataReportBuilder.put("EVENT_NAME", "Event Name", resultSet.getString("event_monitor_name"));
        this.dataReportBuilder.put("EVENT_DATA", "Event Data(first 250 characters)", resultSet.getString("event_data"));
        this.dataReportBuilder.put("AGENT_GROUP", "Agent Group", resultSet.getString("agent_group_name"));
        int n = (int)resultSet.getLong("error_status");
        this.dataReportBuilder.put("EVENT_NOTE", "Note", AgentEventHistoryInfo.getErrorDescription(n));
    }
}

