/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.informatica;

import com.helpsystems.enterprise.core.busobj.informatica.ConsoleLogger;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaRepository;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.informatica.SkybotParam;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Attribute;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.DIServerDetails;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.DIServiceInfo;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.DataIntegrationInterface;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.FaultDetails;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.GetWorkflowLogRequest;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Log;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Parameter;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TaskDetails;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TaskRequest;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TypeGetWorkflowDetailsExRequest;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TypeStartWorkflowExRequest;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TypeStartWorkflowExResponse;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.VoidRequest;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.VoidResponse;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.WorkflowDetails;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.WorkflowRequest;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.module.informatica.ConnectionTracker;
import com.helpsystems.enterprise.module.informatica.GenericSupport;
import com.helpsystems.enterprise.module.informatica.InformaticaConnectionProvider;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;

public class DataIntegrationSupport {
    private static long POLLING_LOGGING_INTERVAL = 900000L;

    private WorkflowRequest loadWorkflowRequest(DIServiceInfo dIServiceInfo, InformaticaWorkflowCommand informaticaWorkflowCommand, SkybotParam skybotParam) {
        WorkflowRequest workflowRequest = new WorkflowRequest();
        workflowRequest.setDIServiceInfo(dIServiceInfo);
        workflowRequest.setWorkflowRunId(0);
        workflowRequest.setFolderName(informaticaWorkflowCommand.getFolderName());
        workflowRequest.setWorkflowName(informaticaWorkflowCommand.getWorkflowName());
        workflowRequest.setWorkflowRunInstanceName(informaticaWorkflowCommand.getRunInstanceName());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Automate Schedule Job:");
        stringBuilder.append(" " + skybotParam.getSkybotJobName());
        stringBuilder.append(" " + String.valueOf(skybotParam.getSkybotJobNumber()));
        workflowRequest.setReason(stringBuilder.toString());
        workflowRequest.setParameters(informaticaWorkflowCommand.getParameterArray());
        workflowRequest.setAttribute(informaticaWorkflowCommand.getAttributeArray());
        workflowRequest.setKey(informaticaWorkflowCommand.getKeyArray());
        workflowRequest.setRequestMode(informaticaWorkflowCommand.getRequestMode());
        workflowRequest.setIsAbort(informaticaWorkflowCommand.isAbort());
        workflowRequest.setParameterFileName(informaticaWorkflowCommand.getParameterFile());
        workflowRequest.setOSUser(informaticaWorkflowCommand.getOsUser());
        workflowRequest.setTaskInstancePath(informaticaWorkflowCommand.getTaskInstancePath());
        return workflowRequest;
    }

    protected final WorkflowRequest startWorkflow(DataIntegrationInterface dataIntegrationInterface, DIServiceInfo dIServiceInfo, InformaticaWorkflowCommand informaticaWorkflowCommand, SkybotParam skybotParam) throws RemoteException {
        ConsoleLogger.println("Preparing Start Workflow request at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "...");
        WorkflowRequest workflowRequest = this.loadWorkflowRequest(dIServiceInfo, informaticaWorkflowCommand, skybotParam);
        this.logWorkflowRequest(workflowRequest);
        if (informaticaWorkflowCommand.getTaskInstancePath() == null || informaticaWorkflowCommand.getTaskInstancePath().length() == 0) {
            ConsoleLogger.println("Starting Workflow " + workflowRequest.getWorkflowName() + " from the beginning.");
            TypeStartWorkflowExRequest typeStartWorkflowExRequest = this.loadTypeStartWorkflowExRequest(workflowRequest);
            TypeStartWorkflowExResponse typeStartWorkflowExResponse = dataIntegrationInterface.startWorkflowEx(typeStartWorkflowExRequest);
            if (typeStartWorkflowExResponse != null) {
                ConsoleLogger.println("Started workkflow " + workflowRequest.getWorkflowName() + " with Run ID: " + typeStartWorkflowExResponse.getRunId());
                workflowRequest.setWorkflowRunId(typeStartWorkflowExResponse.getRunId());
            }
        } else {
            workflowRequest.setTaskInstancePath(informaticaWorkflowCommand.getTaskInstancePath());
            ConsoleLogger.println("Starting Workflow " + workflowRequest.getWorkflowName() + " from task: " + workflowRequest.getTaskInstancePath());
            VoidResponse voidResponse = dataIntegrationInterface.startWorkflowFromTask(workflowRequest);
            if (voidResponse == null) {
                ConsoleLogger.printlnDebug("No response from startWorkflowFromTask...");
            }
        }
        return workflowRequest;
    }

    private TypeStartWorkflowExRequest loadTypeStartWorkflowExRequest(WorkflowRequest workflowRequest) {
        TypeStartWorkflowExRequest typeStartWorkflowExRequest = new TypeStartWorkflowExRequest();
        typeStartWorkflowExRequest.setDIServiceInfo(workflowRequest.getDIServiceInfo());
        typeStartWorkflowExRequest.setFolderName(workflowRequest.getFolderName());
        typeStartWorkflowExRequest.setWorkflowName(workflowRequest.getWorkflowName());
        typeStartWorkflowExRequest.setWorkflowRunInstanceName(workflowRequest.getWorkflowRunInstanceName());
        typeStartWorkflowExRequest.setReason(workflowRequest.getReason());
        typeStartWorkflowExRequest.setParameters(workflowRequest.getParameters());
        typeStartWorkflowExRequest.setAttribute(workflowRequest.getAttribute());
        typeStartWorkflowExRequest.setKey(workflowRequest.getKey());
        typeStartWorkflowExRequest.setRequestMode(workflowRequest.getRequestMode());
        typeStartWorkflowExRequest.setParameterFileName(workflowRequest.getParameterFileName());
        typeStartWorkflowExRequest.setOSUser(workflowRequest.getOSUser());
        typeStartWorkflowExRequest.setTaskInstancePath(workflowRequest.getTaskInstancePath());
        return typeStartWorkflowExRequest;
    }

    protected final void waitForWorkflow(DataIntegrationInterface dataIntegrationInterface, WorkflowRequest workflowRequest) {
        boolean bl = false;
        do {
            bl = false;
            try {
                ConsoleLogger.println();
                ConsoleLogger.println("Waiting for Workflow at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "... (" + this.buildQualifiedInstanceName(workflowRequest) + ")");
                VoidResponse voidResponse = dataIntegrationInterface.waitTillWorkflowComplete(workflowRequest);
                ConsoleLogger.printlnDebug("waitTillWorkflowComplete.result=" + voidResponse);
            }
            catch (FaultDetails faultDetails) {
                String string = "LMWSH_95219";
                if (string.equalsIgnoreCase(faultDetails.getErrorCode())) {
                    ConsoleLogger.println(faultDetails.getErrorCode() + ": The workflow is no longer active...");
                    return;
                }
                string = "LMWSH_95250";
                if (string.equalsIgnoreCase(faultDetails.getErrorCode())) {
                    ConsoleLogger.println(faultDetails.getErrorCode() + ": The workflow execution failed...");
                    return;
                }
                String string2 = "Fault error waiting for workflow.";
                System.err.println(string2);
                ConsoleLogger.println("-------------------------------------------------------------");
                faultDetails.printStackTrace();
                ConsoleLogger.println("-------------------------------------------------------------");
            }
            catch (Exception exception) {
                if (exception instanceof AxisFault && exception.getMessage() != null && exception.getMessage().toLowerCase().indexOf("SocketTimeoutException".toLowerCase()) > -1) {
                    ConsoleLogger.println("Waiting for workflow timed out...");
                    bl = true;
                    continue;
                }
                System.err.println("Error waiting for workflow.");
                ConsoleLogger.println("-------------------------------------------------------------");
                exception.printStackTrace();
                ConsoleLogger.println("-------------------------------------------------------------");
            }
        } while (bl);
    }

    protected final WorkflowDetails pollStatusForWorkflowCompletion(WorkflowRequest workflowRequest, DIServiceInfo dIServiceInfo, ConnectionTracker connectionTracker) throws Exception {
        WorkflowDetails workflowDetails = null;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        ConsoleLogger.println("Starting polling for completion of workflow " + workflowRequest.getWorkflowName() + " with Run ID " + workflowRequest.getWorkflowRunId() + " at " + ScheduleLogger.formatTimeStampSecs(l));
        while (workflowDetails == null) {
            WorkflowDetails workflowDetails2 = this.getWorkflowDetails(connectionTracker.getDiInterface(), workflowRequest, dIServiceInfo, true);
            if (workflowDetails2 != null) {
                String string = workflowDetails2.getWorkflowRunStatus().getValue().toString();
                if ("SUCCEEDED".equalsIgnoreCase(string) || "FAILED".equalsIgnoreCase(string) || "STOPPED".equalsIgnoreCase(string) || "ABORTED".equalsIgnoreCase(string) || "UNKNOWN".equalsIgnoreCase(string) || "TERMINATED".equalsIgnoreCase(string)) {
                    return workflowDetails2;
                }
                try {
                    long l3 = System.currentTimeMillis();
                    long l4 = l3 - l;
                    long l5 = connectionTracker.getStatusPollingInterval(l4);
                    if (l3 - l2 > POLLING_LOGGING_INTERVAL) {
                        l2 = l3;
                        ConsoleLogger.println(ScheduleLogger.formatTimeStampSecs(l3) + " - Current workflow status: " + string + " - Current polling interval: " + l5 + " milliseconds.");
                    }
                    Thread.sleep(l5);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            throw new RuntimeException("A Workflow Details object was not returned while polling.");
        }
        return workflowDetails;
    }

    private String buildQualifiedTaskName(TaskRequest taskRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(taskRequest.getWorkflowName());
        stringBuilder.append(".");
        stringBuilder.append(taskRequest.getWorkflowRunInstanceName());
        stringBuilder.append(".");
        stringBuilder.append(taskRequest.getWorkflowRunId());
        return stringBuilder.toString();
    }

    protected WorkflowDetails getWorkflowDetails(DataIntegrationInterface dataIntegrationInterface, WorkflowRequest workflowRequest, DIServiceInfo dIServiceInfo, boolean bl) {
        try {
            if (!bl) {
                ConsoleLogger.println();
                ConsoleLogger.println("Getting Workflow details at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "... (" + this.buildQualifiedInstanceName(workflowRequest) + ")");
            }
            TypeGetWorkflowDetailsExRequest typeGetWorkflowDetailsExRequest = new TypeGetWorkflowDetailsExRequest();
            typeGetWorkflowDetailsExRequest.setFolderName(workflowRequest.getFolderName());
            typeGetWorkflowDetailsExRequest.setWorkflowName(workflowRequest.getWorkflowName());
            typeGetWorkflowDetailsExRequest.setWorkflowRunInstanceName(workflowRequest.getWorkflowRunInstanceName());
            typeGetWorkflowDetailsExRequest.setDIServiceInfo(dIServiceInfo);
            typeGetWorkflowDetailsExRequest.setWorkflowRunId(workflowRequest.getWorkflowRunId());
            ConsoleLogger.printlnDebug("Getting Workflow Details: FolderName=" + typeGetWorkflowDetailsExRequest.getFolderName() + " WorkflowName=" + typeGetWorkflowDetailsExRequest.getWorkflowName() + " WorkflowRunInstanceName=" + typeGetWorkflowDetailsExRequest.getWorkflowRunInstanceName() + " WorkflowRunID=" + typeGetWorkflowDetailsExRequest.getWorkflowRunId().toString() + " DIServiceInfo.service=" + typeGetWorkflowDetailsExRequest.getDIServiceInfo().getServiceName() + " DIServiceInfo.domain=" + typeGetWorkflowDetailsExRequest.getDIServiceInfo().getDomainName());
            DIServerDetails dIServerDetails = dataIntegrationInterface.getWorkflowDetailsEx(typeGetWorkflowDetailsExRequest);
            WorkflowDetails[] workflowDetailsArray = dIServerDetails.getWorkflowDetails();
            int n = workflowDetailsArray.length;
            for (int i = 0; i < n; ++i) {
                ConsoleLogger.printlnDebug("Work flow index: " + i);
                if (workflowRequest.getWorkflowRunId() == 0) {
                    String string = workflowRequest.getWorkflowRunInstanceName();
                    String string2 = workflowDetailsArray[i].getWorkflowRunInstanceName();
                    if (string == null) {
                        string = "";
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string.equals(string2)) {
                        workflowRequest.setWorkflowRunId(workflowDetailsArray[i].getWorkflowRunId());
                        ConsoleLogger.println("Run ID search found matching WorkflowRunInstanceName '" + string + "' with Run ID: " + workflowRequest.getWorkflowRunId());
                        return workflowDetailsArray[i];
                    }
                    ConsoleLogger.printlnDebug("The Workflow Run Instance Name in details returned (" + string + ") did not match the expected Run Instance Name: " + string2);
                    continue;
                }
                if (workflowRequest.getWorkflowRunId().intValue() == workflowDetailsArray[i].getWorkflowRunId()) {
                    return workflowDetailsArray[i];
                }
                ConsoleLogger.println("The Workflow Run ID in details returned (" + workflowDetailsArray[i].getWorkflowRunId() + ") did not match the expected Run ID: " + workflowRequest.getWorkflowRunId());
            }
            return null;
        }
        catch (Exception exception) {
            if (workflowRequest.getWorkflowRunId() != 0 && workflowRequest.getWorkflowRunInstanceName() != null && workflowRequest.getWorkflowRunInstanceName().length() > 0) {
                ConsoleLogger.println("Checking for concurrent workflow details without run instance name.");
                workflowRequest.setWorkflowRunInstanceName(null);
                return this.getWorkflowDetails(dataIntegrationInterface, workflowRequest, dIServiceInfo, bl);
            }
            throw new RuntimeException("Error getting workflow details.", exception);
        }
    }

    private String buildQualifiedInstanceName(WorkflowRequest workflowRequest) {
        return workflowRequest.getWorkflowName() + "." + workflowRequest.getWorkflowRunInstanceName() + "." + workflowRequest.getWorkflowRunId();
    }

    protected final void logWorkflowDetails(WorkflowDetails workflowDetails) {
        ConsoleLogger.println("-------------------------------------------------------------");
        ConsoleLogger.println("Status. . . . : " + workflowDetails.getWorkflowRunStatus());
        ConsoleLogger.println("Start Time. . : " + this.formatTimestamp(workflowDetails.getStartTime().getUTCTime()));
        ConsoleLogger.println("End Time. . . : " + this.formatTimestamp(workflowDetails.getEndTime().getUTCTime()));
        ConsoleLogger.println("Run Id. . . . : " + workflowDetails.getWorkflowRunId());
        ConsoleLogger.println("Run Error Code: " + workflowDetails.getRunErrorCode());
        ConsoleLogger.println("Run Error Msg : " + workflowDetails.getRunErrorMessage());
        ConsoleLogger.println("Log File Name : " + workflowDetails.getLogFileName());
        ConsoleLogger.println("OS User . . . : " + workflowDetails.getOSUser());
        ConsoleLogger.println("User Name . . : " + workflowDetails.getUserName());
        ConsoleLogger.println("Workflow Name : " + workflowDetails.getWorkflowName());
        ConsoleLogger.println("Run Inst Name : " + workflowDetails.getWorkflowRunInstanceName());
        ConsoleLogger.println("Folder Name . : " + workflowDetails.getFolderName());
        ConsoleLogger.println("Log Code Page : " + workflowDetails.getLogFileCodePage());
        ConsoleLogger.println("Run Type  . . : " + workflowDetails.getWorkflowRunType());
        ConsoleLogger.print("Attributes. . : ");
        Attribute[] attributeArray = workflowDetails.getAttribute();
        if (attributeArray != null && attributeArray.length > 0) {
            for (int i = 0; i < attributeArray.length; ++i) {
                if (i > 0) {
                    ConsoleLogger.print(", ");
                }
                ConsoleLogger.print(attributeArray[i].getName() + "=" + attributeArray[i].getValue());
            }
        }
        ConsoleLogger.println();
        ConsoleLogger.println("-------------------------------------------------------------");
        ConsoleLogger.println();
    }

    protected final String formatTimestamp(int n) {
        long l = (long)n * 1000L;
        Date date = new Date(l);
        return date.toString();
    }

    protected final void getWorkflowLog(DataIntegrationInterface dataIntegrationInterface, WorkflowRequest workflowRequest) {
        try {
            ConsoleLogger.println("Getting Workflow log at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "... (" + this.buildQualifiedInstanceName(workflowRequest) + ")");
            GetWorkflowLogRequest getWorkflowLogRequest = new GetWorkflowLogRequest();
            getWorkflowLogRequest.setDIServiceInfo(workflowRequest.getDIServiceInfo());
            getWorkflowLogRequest.setFolderName(workflowRequest.getFolderName());
            getWorkflowLogRequest.setWorkflowName(workflowRequest.getWorkflowName());
            getWorkflowLogRequest.setWorkflowRunInstanceName(workflowRequest.getWorkflowRunInstanceName());
            getWorkflowLogRequest.setWorkflowRunId(workflowRequest.getWorkflowRunId());
            getWorkflowLogRequest.setTimeout(20);
            Log log = dataIntegrationInterface.getWorkflowLog(getWorkflowLogRequest);
            ConsoleLogger.println(log.getBuffer());
        }
        catch (Exception exception) {
            System.err.println("Error getting workflow log.");
            exception.printStackTrace();
        }
    }

    protected final void waitForTask(DataIntegrationInterface dataIntegrationInterface, TaskRequest taskRequest) {
        boolean bl = false;
        do {
            bl = false;
            try {
                ConsoleLogger.println();
                ConsoleLogger.println("Waiting for Task at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "...");
                VoidResponse voidResponse = dataIntegrationInterface.waitTillTaskComplete(taskRequest);
            }
            catch (FaultDetails faultDetails) {
                String string = "LMWSH_95219";
                if (string.equalsIgnoreCase(faultDetails.getErrorCode())) {
                    ConsoleLogger.printlnDebug(faultDetails.getErrorCode() + ": The Task is no longer active...");
                    return;
                }
                string = "LMWSH_95250";
                if (string.equalsIgnoreCase(faultDetails.getErrorCode())) {
                    ConsoleLogger.printlnDebug(faultDetails.getErrorCode() + ": The Task execution failed...");
                    return;
                }
                String string2 = "Fault error waiting for task.";
                System.err.println(string2);
                ConsoleLogger.println("-------------------------------------------------------------");
                faultDetails.printStackTrace();
                ConsoleLogger.println("-------------------------------------------------------------");
            }
            catch (Exception exception) {
                if (exception instanceof AxisFault && exception.getMessage() != null && exception.getMessage().toLowerCase().indexOf("SocketTimeoutException".toLowerCase()) > -1) {
                    ConsoleLogger.println("Waiting for task timed out...");
                    bl = true;
                    continue;
                }
                System.err.println("Error waiting for task.");
                ConsoleLogger.println("-------------------------------------------------------------");
                exception.printStackTrace();
                ConsoleLogger.println("-------------------------------------------------------------");
            }
        } while (bl);
    }

    protected final TaskDetails pollStatusForTaskCompletion(TaskRequest taskRequest, DIServiceInfo dIServiceInfo, ConnectionTracker connectionTracker) throws Exception {
        TaskDetails taskDetails = null;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        ConsoleLogger.println("Starting polling for completion of task " + taskRequest.getWorkflowName() + "." + taskRequest.getTaskInstancePath() + " at " + ScheduleLogger.formatTimeStampSecs(l));
        while (taskDetails == null) {
            TaskDetails taskDetails2 = this.getTaskDetails(connectionTracker.getDiInterface(), taskRequest, true);
            if (taskDetails2 != null) {
                String string = taskDetails2.getTaskRunStatus().getValue().toString();
                if ("SUCCEEDED".equalsIgnoreCase(string) || "FAILED".equalsIgnoreCase(string) || "DISABLED".equalsIgnoreCase(string) || "STOPPED".equalsIgnoreCase(string) || "ABORTED".equalsIgnoreCase(string) || "UNKNOWN".equalsIgnoreCase(string) || "TERMINATED".equalsIgnoreCase(string)) {
                    return taskDetails2;
                }
                try {
                    long l3 = System.currentTimeMillis();
                    long l4 = l3 - l;
                    long l5 = connectionTracker.getStatusPollingInterval(l4);
                    if (l3 - l2 > POLLING_LOGGING_INTERVAL) {
                        l2 = l3;
                        ConsoleLogger.println(ScheduleLogger.formatTimeStampSecs(l3) + " - Current task status: " + string + " - Current polling interval: " + l5 + " milliseconds.");
                    }
                    Thread.sleep(l5);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            throw new RuntimeException("A Task Details object was not returned while polling.");
        }
        return taskDetails;
    }

    protected final TaskRequest startTask(DataIntegrationInterface dataIntegrationInterface, DIServiceInfo dIServiceInfo, InformaticaWorkflowCommand informaticaWorkflowCommand, SkybotParam skybotParam) {
        try {
            ConsoleLogger.println("Preparing Start Task request...");
            TaskRequest taskRequest = new TaskRequest();
            taskRequest.setDIServiceInfo(dIServiceInfo);
            taskRequest.setWorkflowRunId(0);
            taskRequest.setFolderName(informaticaWorkflowCommand.getFolderName());
            taskRequest.setWorkflowName(informaticaWorkflowCommand.getWorkflowName());
            taskRequest.setWorkflowRunInstanceName(informaticaWorkflowCommand.getRunInstanceName());
            taskRequest.setTaskInstancePath(informaticaWorkflowCommand.getTaskInstancePath());
            taskRequest.setRequestMode(informaticaWorkflowCommand.getRequestMode());
            taskRequest.setIsAbort(informaticaWorkflowCommand.isAbort());
            taskRequest.setParameters(informaticaWorkflowCommand.getParameterArray());
            taskRequest.setParameterFileName(informaticaWorkflowCommand.getParameterFile());
            VoidResponse voidResponse = null;
            ConsoleLogger.println("Starting Task " + taskRequest.getWorkflowName() + "." + taskRequest.getTaskInstancePath() + " at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()));
            voidResponse = dataIntegrationInterface.startTask(taskRequest);
            if (voidResponse != null) {
                ConsoleLogger.printlnDebug("startTask.VoidResponse: " + voidResponse);
            }
            return taskRequest;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error starting task.", exception);
        }
    }

    protected final TaskDetails getTaskDetails(DataIntegrationInterface dataIntegrationInterface, TaskRequest taskRequest, boolean bl) {
        try {
            if (!bl) {
                ConsoleLogger.println();
                ConsoleLogger.println("Getting Task details at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "... (" + this.buildQualifiedTaskName(taskRequest) + ")");
            }
            TaskDetails taskDetails = dataIntegrationInterface.getTaskDetails(taskRequest);
            taskRequest.setWorkflowRunId(taskDetails.getWorkflowRunId());
            return taskDetails;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error getting task details.", exception);
        }
    }

    protected final void logTaskDetails(TaskDetails taskDetails) {
        ConsoleLogger.println("-------------------------------------------------------------");
        ConsoleLogger.println("Child Run ID. : " + taskDetails.getChildRunId());
        ConsoleLogger.println("Start Time. . : " + this.formatTimestamp(taskDetails.getStartTime().getUTCTime()));
        ConsoleLogger.println("End Time. . . : " + this.formatTimestamp(taskDetails.getEndTime().getUTCTime()));
        ConsoleLogger.println("WorkFlow RunId: " + taskDetails.getWorkflowRunId());
        ConsoleLogger.println("Run Error Code: " + taskDetails.getRunErrorCode());
        ConsoleLogger.println("Run Error Msg : " + taskDetails.getRunErrorMessage());
        ConsoleLogger.println("Workflow Name : " + taskDetails.getWorkflowName());
        ConsoleLogger.println("Run Inst Name : " + taskDetails.getWorkflowRunInstanceName());
        ConsoleLogger.println("Folder Name . : " + taskDetails.getFolderName());
        ConsoleLogger.println("Inst Name . . : " + taskDetails.getInstanceName());
        ConsoleLogger.println("Worklet Run ID: " + taskDetails.getWorkletRunId());
        ConsoleLogger.println("Task Run Sts. : " + taskDetails.getTaskRunStatus());
        ConsoleLogger.println("Worklet Ins Nm: " + taskDetails.getWorkletInstanceName());
        ConsoleLogger.print("Attributes. . : ");
        Attribute[] attributeArray = taskDetails.getAttribute();
        if (attributeArray != null && attributeArray.length > 0) {
            for (int i = 0; i < attributeArray.length; ++i) {
                if (i > 0) {
                    ConsoleLogger.print(", ");
                }
                ConsoleLogger.print(attributeArray[i].getName() + " = " + attributeArray[i].getValue());
            }
        }
        ConsoleLogger.println();
        ConsoleLogger.println("-------------------------------------------------------------");
        ConsoleLogger.println();
    }

    protected final void getTaskLog(DataIntegrationInterface dataIntegrationInterface, TaskRequest taskRequest) {
        try {
            ConsoleLogger.println("Getting Task log at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "... (" + this.buildQualifiedTaskName(taskRequest) + ")");
            GetWorkflowLogRequest getWorkflowLogRequest = new GetWorkflowLogRequest();
            getWorkflowLogRequest.setDIServiceInfo(taskRequest.getDIServiceInfo());
            getWorkflowLogRequest.setFolderName(taskRequest.getFolderName());
            getWorkflowLogRequest.setWorkflowName(taskRequest.getWorkflowName());
            getWorkflowLogRequest.setWorkflowRunInstanceName(taskRequest.getWorkflowRunInstanceName());
            getWorkflowLogRequest.setWorkflowRunId(taskRequest.getWorkflowRunId());
            getWorkflowLogRequest.setTimeout(20);
            Log log = dataIntegrationInterface.getWorkflowLog(getWorkflowLogRequest);
            ConsoleLogger.println(log.getBuffer());
        }
        catch (Exception exception) {
            System.err.println("Error getting Task log.");
            exception.printStackTrace();
        }
    }

    private void logWorkflowRequest(WorkflowRequest workflowRequest) {
        try {
            if (!ConsoleLogger.isDebug()) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Workflow Request:");
            stringBuffer.append(" WorkflowName=" + workflowRequest.getWorkflowName());
            stringBuffer.append(" FolderName=" + workflowRequest.getFolderName());
            stringBuffer.append(" OSUser=" + workflowRequest.getOSUser());
            stringBuffer.append(" ParamFile=" + workflowRequest.getParameterFileName());
            stringBuffer.append(" Reason=" + workflowRequest.getReason());
            stringBuffer.append(" TaskInstPath=" + workflowRequest.getTaskInstancePath());
            stringBuffer.append(" WorkflowRunInstName=" + workflowRequest.getWorkflowRunInstanceName());
            stringBuffer.append(" WorkflowRunID=" + workflowRequest.getWorkflowRunId());
            stringBuffer.append(" RequestMode=" + workflowRequest.getRequestMode().toString());
            Parameter[] parameterArray = workflowRequest.getParameters();
            if (parameterArray != null && parameterArray.length > 0) {
                stringBuffer.append(" Parameters=");
                for (int i = 0; i < parameterArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append("; ");
                    }
                    stringBuffer.append(parameterArray[i].getName() + ":" + parameterArray[i].getValue() + ":" + parameterArray[i].getScope());
                }
            }
            ConsoleLogger.printlnDebug(stringBuffer.toString());
            ConsoleLogger.printlnDebug();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void logIn(ConnectionTracker connectionTracker) throws Exception {
        InformaticaConnectionProvider informaticaConnectionProvider = connectionTracker.getConnectionProvider();
        InformaticaRepository informaticaRepository = connectionTracker.getInfaRepo();
        long l = connectionTracker.getLogin_attempts_max();
        long l2 = connectionTracker.getLogin_attempt_interval();
        String string = null;
        long l3 = 0L;
        DataIntegrationInterface dataIntegrationInterface = connectionTracker.getDiServiceLocator().getDataIntegration();
        while (string == null || string.length() == 0) {
            try {
                ++l3;
                string = informaticaConnectionProvider.login(informaticaRepository, dataIntegrationInterface);
                if (string == null || string.length() == 0) {
                    throw new RuntimeException("Unable to connect.  A Session ID was not returned.");
                }
                ((Stub)dataIntegrationInterface).setHeader(GenericSupport.createSessionHeader(string));
                connectionTracker.setDiInterface(dataIntegrationInterface);
                connectionTracker.setSessionID(string);
                return;
            }
            catch (Exception exception) {
                String string2 = exception.getMessage();
                if (string2 != null && string2.indexOf("java.net.ConnectException") > -1 && string2.indexOf("Connection refused") > -1) {
                    System.out.println("Login attempt failed. (" + l3 + " of " + l + ")");
                    if (l3 >= l) {
                        throw exception;
                    }
                    if (l3 == 1L) {
                        System.err.println(exception.getMessage());
                        System.err.flush();
                        exception.printStackTrace(System.err);
                        System.err.flush();
                        try {
                            Thread.sleep(l2 * 1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        Thread.sleep(l2 * 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw exception;
            }
        }
        throw new RuntimeException("The login routine was not able to login.");
    }

    protected void logout(ConnectionTracker connectionTracker) {
        ConsoleLogger.println("Logging out at " + ScheduleLogger.formatTimeStampSecs(System.currentTimeMillis()) + "...");
        if (connectionTracker == null) {
            return;
        }
        if (connectionTracker.getSessionID() == null) {
            return;
        }
        if (connectionTracker.getDiInterface() == null) {
            return;
        }
        try {
            VoidRequest voidRequest = new VoidRequest();
            connectionTracker.getDiInterface().logout(voidRequest);
        }
        catch (Exception exception) {
            ConsoleLogger.println("Error logging out.");
            exception.printStackTrace();
        }
        connectionTracker.resetAfterLogout();
    }
}

