/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.infocloud;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.util.Log4jInit;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudCommand;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudServer;
import com.helpsystems.enterprise.core.cmdlineobj.InfaCloudParamMarker;
import com.helpsystems.enterprise.core.infocloud.ICJobRunnerCommand;
import com.helpsystems.enterprise.core.infocloud.ICJobRunnerParms;
import com.helpsystems.enterprise.core.infocloud.ICServerInfo;
import com.helpsystems.enterprise.module.infocloud.ICJobExecutor;
import java.util.HashSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ICJobRunner {
    private ICJobRunner() {
    }

    public static void main(String[] stringArray) {
        ICJobRunner.configureLogging();
        try {
            String[] stringArray2 = stringArray;
            ICJobRunnerParms iCJobRunnerParms = new ICJobRunnerParms();
            try {
                ICJobRunner.parseParameters(stringArray2, iCJobRunnerParms);
            }
            catch (ActionFailedException actionFailedException) {
                System.out.println("Error parsing parameters: " + actionFailedException.getMessage());
                actionFailedException.printStackTrace();
                System.exit(1);
            }
            ICJobRunnerCommand iCJobRunnerCommand = new ICJobRunnerCommand(iCJobRunnerParms.getInfaCloudCmd());
            ICServerInfo iCServerInfo = new ICServerInfo(iCJobRunnerParms.getInfaCloudServer());
            ICJobExecutor iCJobExecutor = new ICJobExecutor();
            iCJobExecutor.runJob(iCServerInfo, iCJobRunnerCommand, iCJobRunnerParms);
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("ICJobRunner ended in error: " + exception.getMessage());
            System.out.println();
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void configureLogging() {
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().setLevel(Level.OFF);
        Log4jInit.setInitialized((boolean)true);
    }

    private static void parseParameters(String[] stringArray, ICJobRunnerParms iCJobRunnerParms) throws ActionFailedException {
        InformaticaCloudCommand informaticaCloudCommand = new InformaticaCloudCommand();
        InformaticaCloudServer informaticaCloudServer = new InformaticaCloudServer();
        iCJobRunnerParms.setInfaCloudCmd(informaticaCloudCommand);
        iCJobRunnerParms.setInfaCloudServer(informaticaCloudServer);
        String string = null;
        String string2 = null;
        HashSet<String> hashSet = InfaCloudParamMarker.getEnumValueSet();
        int n = stringArray.length;
        block22: for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            int n2 = stringArray2.length;
            if (n2 > 0) {
                string = stringArray2[0].trim();
            }
            if (n2 == 2) {
                string2 = stringArray2[1];
            } else if (n2 > 2) {
                int n3 = stringArray2[0].length();
                string2 = stringArray[i].substring(n3 + 1);
            } else {
                string2 = null;
            }
            try {
                if (!hashSet.contains(string)) continue;
                InfaCloudParamMarker infaCloudParamMarker = InfaCloudParamMarker.persistanceCodeToEnum(string);
                switch (infaCloudParamMarker) {
                    case USER_EMAIL: {
                        informaticaCloudServer.setUserEmail(string2);
                        break;
                    }
                    case PASSWORD: {
                        informaticaCloudServer.setEncryptedPassword(string2);
                        break;
                    }
                    case PASSWORD_SALT: {
                        informaticaCloudServer.setPasswordSalt(string2);
                        break;
                    }
                    case BASE_URL: {
                        informaticaCloudServer.setBaseURL(string2);
                        break;
                    }
                    case VERBOSE: {
                        if (!string2.equalsIgnoreCase("yes")) continue block22;
                        informaticaCloudServer.setVerboseLogging(true);
                        break;
                    }
                    case FIND_JOB_INTERVAL: {
                        informaticaCloudServer.setInitialPollingInterval(Integer.valueOf(string2));
                        break;
                    }
                    case FIND_JOB_MAX_TRIES: {
                        informaticaCloudServer.setInitialPollingAttempts(Integer.valueOf(string2));
                        break;
                    }
                    case STATUS_INTERVAL: {
                        informaticaCloudServer.setStatusPollingInterval(Integer.valueOf(string2));
                        break;
                    }
                    case TASK_NAME: {
                        informaticaCloudCommand.setTaskName(string2);
                        break;
                    }
                    case TASK_TYPE: {
                        informaticaCloudCommand.setTaskType(string2);
                        break;
                    }
                    case CONTINUE_IMMIDEATELY: {
                        if (!string2.equalsIgnoreCase("yes")) continue block22;
                        informaticaCloudCommand.setContinueImmediately(true);
                        break;
                    }
                    case SERVER_NAME: {
                        informaticaCloudServer.setName(string2);
                        break;
                    }
                    case SERVER_OID: {
                        try {
                            long l = Long.parseLong(string2);
                            informaticaCloudServer.setOID(l);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException(string2 + " is not a valid server OID.");
                        }
                    }
                    case SKYBOT_JOB_NAME: {
                        iCJobRunnerParms.setSkybotJobName(string2);
                        break;
                    }
                    case RUN_NUMBER: {
                        iCJobRunnerParms.setJobEventID(string2);
                        break;
                    }
                    case AGENT_PORT_NUMBER: {
                        iCJobRunnerParms.setLocalAgentport(string2);
                        break;
                    }
                    default: {
                        throw new ActionFailedException("Invalid option parameter: " + string + " full parm: " + stringArray[i]);
                    }
                }
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ActionFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
    }
}

