/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.infocloud;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.enterprise.core.dm.SkybotCommandDM;
import com.helpsystems.enterprise.core.infocloud.ICConnectionsExhausted;
import com.helpsystems.enterprise.core.infocloud.ICJobRunnerCommand;
import com.helpsystems.enterprise.core.infocloud.ICJobRunnerException;
import com.helpsystems.enterprise.core.infocloud.ICJobRunnerParms;
import com.helpsystems.enterprise.core.infocloud.ICJobStatus;
import com.helpsystems.enterprise.core.infocloud.ICLoginFailedException;
import com.helpsystems.enterprise.core.infocloud.ICServerInfo;
import com.helpsystems.enterprise.core.infocloud.busobj.ICActivityEntry;
import com.helpsystems.enterprise.core.infocloud.busobj.ICActivityLogEntry;
import com.helpsystems.enterprise.core.infocloud.busobj.ICActivityMonitorEntry;
import com.helpsystems.enterprise.core.infocloud.busobj.ICConnectionInfo;
import com.helpsystems.enterprise.core.infocloud.busobj.ICError;
import com.helpsystems.enterprise.core.infocloud.busobj.ICObject;
import com.helpsystems.enterprise.core.infocloud.busobj.ICServerTime;
import com.helpsystems.enterprise.core.infocloud.busobj.ICSharedConnectionInfo;
import com.helpsystems.enterprise.module.infocloud.ICHelper;
import com.helpsystems.enterprise.peer.SkybotCommandPeer;
import com.helpsystems.enterprise.peer.SkybotJobPeerException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public class ICJobExecutor {
    private ICServerInfo icServerInfo = null;
    private ICJobRunnerCommand icJobRunnerCommand = null;
    private ICSharedConnectionInfo icSharedConnectionInfo = null;
    private ICConnectionInfo icConnectionInfo = null;
    private ICJobRunnerParms icJobRunnerParms = null;
    private boolean privateConnectionOnly = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob(ICServerInfo iCServerInfo, ICJobRunnerCommand iCJobRunnerCommand, ICJobRunnerParms iCJobRunnerParms) {
        this.icServerInfo = iCServerInfo;
        this.icJobRunnerCommand = iCJobRunnerCommand;
        this.icJobRunnerParms = iCJobRunnerParms;
        HttpClient httpClient = null;
        try {
            String string = System.getenv("SKYBOT_IC_PRIVATE_CONN");
            if (string != null && string.trim().equalsIgnoreCase("true")) {
                this.privateConnectionOnly = true;
            }
            System.out.println();
            ICHelper.logWithLocalTime("Informatica Cloud Server Information:");
            this.icServerInfo.logStringArray("    ");
            System.out.println();
            ICHelper.logWithLocalTime("Informatica Cloud Task Information:");
            this.icJobRunnerCommand.logStringArray("    ");
            System.out.println();
            this.validateParameters();
            httpClient = this.getHttpClient();
            this.icServerLogin(httpClient, this.icServerInfo);
            this.sleeper("After-Connect");
            ICServerTime iCServerTime = this.getICServerTime(httpClient, this.icServerInfo.isVerbose());
            this.sleeper("After-GetServerTime");
            this.icStartJob(httpClient, this.icServerInfo.isVerbose());
            this.sleeper("After-StartJob");
            if (this.icJobRunnerCommand.isContinueImmediately()) {
                System.out.println("The 'continue immediately' option was specified.  We will not monitor the Informatica Cloud Task.");
                this.releaseValidatedConnection(httpClient, iCServerInfo, this.icSharedConnectionInfo);
                System.exit(0);
            } else {
                ICJobStatus iCJobStatus = this.icMonitorJob(iCServerTime, httpClient);
                this.sleeper("After-MonitrJob");
                System.out.println("===================================================================");
                ICHelper.logWithLocalTime("Informatica Cloud Job completed with status: " + iCJobStatus.getEndStatusText());
                System.out.println();
                iCJobStatus.getIcActivityEntry().logStringArray("    ");
                System.out.println("===================================================================");
                this.releaseValidatedConnection(httpClient, iCServerInfo, this.icSharedConnectionInfo);
                System.exit(iCJobStatus.getJobEndCode());
            }
            this.releaseValidatedConnection(httpClient, iCServerInfo, this.icSharedConnectionInfo);
        }
        catch (Throwable throwable) {
            try {
                ICHelper.logWithLocalTime("Error running Informatica Cloud Job.");
                throwable.printStackTrace(System.out);
                System.out.println();
                this.releaseValidatedConnection(httpClient, iCServerInfo, this.icSharedConnectionInfo);
                System.exit(1);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.releaseValidatedConnection(httpClient, iCServerInfo, this.icSharedConnectionInfo);
            }
        }
    }

    private void validateConnection(HttpClient httpClient, ICServerInfo iCServerInfo) {
        if (this.icSharedConnectionInfo != null && this.icSharedConnectionInfo.isSharedConnection() && this.icSharedConnectionInfo.isConnectionExpired()) {
            ICHelper.logWithLocalTime("Expired shared connection detected...");
            this.releaseValidatedConnection(httpClient, iCServerInfo, this.icSharedConnectionInfo);
            this.icSharedConnectionInfo = null;
            this.icConnectionInfo = null;
            this.icServerLogin(httpClient, iCServerInfo);
        }
    }

    private void icServerLogin(HttpClient httpClient, ICServerInfo iCServerInfo) {
        this.icSharedConnectionInfo = this.getValidatedConnection(httpClient, this.icServerInfo);
        this.icConnectionInfo = this.icSharedConnectionInfo.getIcConnectionInfo();
        if (this.icServerInfo.isVerbose()) {
            System.out.println("Connection Properties:");
            this.icSharedConnectionInfo.logStringArray("    ");
            System.out.println();
            System.out.println("Connection Info Properties:");
            this.icConnectionInfo.logStringArray("    ");
        }
    }

    private void sleeper(String string) {
    }

    private void validateParameters() {
        boolean bl = false;
        if (this.icServerInfo == null) {
            System.out.println("Server Information Object is null.");
            bl = true;
        } else {
            if (this.nullOrBlank(this.icServerInfo.getUserID())) {
                System.out.println("A user name was not specified.");
                bl = true;
            }
            if (this.nullOrBlank(this.icServerInfo.getPassword())) {
                System.out.println("A password was not specified.");
                bl = true;
            }
            if (this.nullOrBlank(this.icServerInfo.getBaseURL())) {
                System.out.println("A base url was not specified.");
                bl = true;
            }
            int n = 500;
            int n2 = 30000;
            int n3 = 1000;
            if (this.icServerInfo.getFindJobInterval() < (long)n || this.icServerInfo.getFindJobInterval() > (long)n2) {
                System.out.println("Interval for finding the job is not valid (" + n + "-" + n2 + ").  Using default (" + n3 + ").");
                this.icServerInfo.setFindJobInterval(n3);
            }
            int n4 = 5;
            int n5 = 1000;
            int n6 = 60;
            if (this.icServerInfo.getFindJobMaxTries() < (long)n4 || this.icServerInfo.getFindJobMaxTries() > (long)n5) {
                System.out.println("Max attempts for finding the job is not valid (" + n4 + "-" + n5 + ").  Using default (" + n6 + ").");
                this.icServerInfo.setFindJobInterval(n6);
            }
            int n7 = 500;
            int n8 = 1200000;
            int n9 = 0;
            if (this.icServerInfo.getStatusInterval() != (long)n9 && (this.icServerInfo.getStatusInterval() < (long)n7 || this.icServerInfo.getStatusInterval() > (long)n8)) {
                System.out.println("Status polling interval is not valid (" + n7 + "-" + n8 + ").  Using default (" + n9 + ").");
                this.icServerInfo.setStatusInterval(n9);
            }
        }
        if (this.icJobRunnerCommand == null) {
            System.out.println("Command Information Object is null.");
            bl = true;
        } else {
            if (this.nullOrBlank(this.icJobRunnerCommand.getTaskName())) {
                System.out.println("A Task Name was not specified.");
                bl = true;
            }
            if (this.nullOrBlank(this.icJobRunnerCommand.getTaskType())) {
                System.out.println("A Task Type was not specified.");
                bl = true;
            }
        }
        if (bl) {
            System.out.println("One or more validation errors were found.  See previous errors...");
            System.exit(1);
        }
    }

    private boolean nullOrBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void randomWaitAndLoginAgain(HttpClient httpClient, boolean bl) {
        long l = ICHelper.getRandomWait();
        System.out.println("Reconnecting after random wait time (milliseconds): " + l);
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new ICJobRunnerException("Interupted during reconnect interval.", interruptedException);
        }
        this.icSharedConnectionInfo = this.getValidatedConnection(httpClient, this.icServerInfo);
        this.icConnectionInfo = this.icSharedConnectionInfo.getIcConnectionInfo();
        if (bl) {
            System.out.println("Shared Connection Properties:");
            this.icSharedConnectionInfo.logStringArray("    ");
            System.out.println();
            System.out.println("Connection User Properties:");
            this.icConnectionInfo.logStringArray("    ");
        }
    }

    private HttpClient getHttpClient() {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        this.configureProxyServer((HttpClient)defaultHttpClient);
        return defaultHttpClient;
    }

    private void configureProxyServer(HttpClient httpClient) {
        String string = "SKYBOT_WS_PROXY_URL";
        String string2 = "SKYBOT_WS_PROXY_PORT";
        String string3 = "SKYBOT_WS_PROXY_PROTOCOL";
        try {
            String string4 = System.getenv(string);
            String string5 = System.getenv(string2);
            String string6 = System.getenv(string3);
            if (string4 != null && string5 != null && string6 != null) {
                System.out.println("Configuring Proxy Server: ");
                System.out.println("\tProxy URL: " + string4);
                System.out.println("\tProxy Port: " + string5);
                System.out.println("\tProxy Protocol: " + string6);
                System.out.println();
                int n = Integer.valueOf(string5);
                HttpHost httpHost = new HttpHost(string4, n, string6);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
            } else if (string4 != null || string5 != null || string6 != null) {
                System.out.println("Incomplete settings for configuring Proxy Server: ");
                System.out.println("\t" + string + ": " + string4);
                System.out.println("\t" + string2 + ": " + string5);
                System.out.println("\t" + string3 + ": " + string6);
                System.out.println();
            }
        }
        catch (Exception exception) {
            System.out.println("Error setting Proxy Server: " + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICServerTime getICServerTime(HttpClient httpClient, boolean bl) {
        Object object;
        InputStream inputStream = null;
        try {
            this.validateConnection(httpClient, this.icServerInfo);
            String string = this.icConnectionInfo.getServerUrl() + "/api/v2/server/serverTime";
            if (bl) {
                System.out.println("");
                System.out.println("===================================================================");
                ICHelper.logWithLocalTime("Getting Server Time:");
                System.out.println("    Server URL  . : " + string);
                System.out.println("    Session ID  . : " + this.icConnectionInfo.getIcSessionId());
                System.out.println();
            } else {
                ICHelper.logWithLocalTime("Getting server time...");
            }
            while (true) {
                ICObject iCObject;
                HttpGet httpGet = new HttpGet(string);
                httpGet.setHeader("Content-Type", "application/json");
                httpGet.setHeader("Accept", "application/json");
                httpGet.setHeader("icSessionId", this.icConnectionInfo.getIcSessionId());
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                int n = httpResponse.getStatusLine().getStatusCode();
                String string2 = httpResponse.getStatusLine().getReasonPhrase();
                if (bl) {
                    System.out.println();
                    ICHelper.logWithLocalTime("serverTime Response Code: " + n);
                    ICHelper.logWithLocalTime("serverTime Response Message: " + string2);
                    System.out.println();
                }
                HttpEntity httpEntity = httpResponse.getEntity();
                inputStream = httpEntity.getContent();
                if (n == 200) {
                    iCObject = this.parseServerTimeEntry(inputStream);
                    System.out.println("    Informatica Cloud Server Time=" + ((ICServerTime)iCObject).getTime());
                    if (bl) {
                        System.out.println("Server Time Properties: ");
                        iCObject.logStringArray("    ");
                    }
                    object = iCObject;
                    break;
                }
                if (n != 403) {
                    ICHelper.processResponseToConsole(inputStream, httpResponse);
                    throw new ICJobRunnerException("Informatica Cloud web service response code: " + n + " (" + string2 + ")");
                }
                iCObject = ICHelper.parseError(inputStream);
                object = "serverTime";
                if (!"UI_13406".equalsIgnoreCase(((ICError)iCObject).getCode())) {
                    ICHelper.logICError((ICError)iCObject, (String)object);
                    throw new RuntimeException(((ICError)iCObject).getSkybotErrorMsg((String)object));
                }
                this.randomWaitAndLoginAgain(httpClient, bl);
                continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new ICJobRunnerException("Error getting the server time from the Informatica Cloud server.", exception);
        }
        catch (Throwable throwable) {
            ICHelper.closeSomething(inputStream);
            throw throwable;
        }
        ICHelper.closeSomething(inputStream);
        return object;
    }

    private ICServerTime parseServerTimeEntry(InputStream inputStream) {
        Gson gson = new Gson();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return (ICServerTime)gson.fromJson((Reader)inputStreamReader, ICServerTime.class);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void icStartJob(HttpClient var1_1, boolean var2_2) {
        var3_3 = null;
        while (true) {
            try {
                this.validateConnection(var1_1, this.icServerInfo);
                var4_4 = this.icConnectionInfo.getServerUrl() + "/api/v2/job";
                if (var2_2) {
                    System.out.println("");
                    System.out.println("===================================================================");
                    ICHelper.logWithLocalTime("Starting Job:");
                    System.out.println("    Server URL  . : " + var4_4);
                    System.out.println("    Session ID  . : " + this.icConnectionInfo.getIcSessionId());
                    System.out.println("    Task Name . . : " + this.icJobRunnerCommand.getTaskName());
                    System.out.println("    Task Type . . : " + this.icJobRunnerCommand.getTaskType());
                    System.out.println();
                } else {
                    ICHelper.logWithLocalTime("Starting job: " + this.icJobRunnerCommand.getTaskName() + "/" + this.icJobRunnerCommand.getTaskType() + "...");
                }
                var5_6 = new HttpPost(var4_4);
                var5_6.setHeader("Content-Type", "application/json");
                var5_6.setHeader("Accept", "application/json");
                var5_6.setHeader("icSessionId", this.icConnectionInfo.getIcSessionId());
                var6_7 = "{\n" + ICHelper.getJSONLine("@type", "job") + "," + "\n" + ICHelper.getJSONLine("taskName", this.icJobRunnerCommand.getTaskName()) + "," + "\n" + ICHelper.getJSONLine("taskType", this.icJobRunnerCommand.getTaskType()) + "\n" + "}";
                var7_8 = new StringEntity(var6_7);
                var5_6.setEntity((HttpEntity)var7_8);
                var8_9 = var1_1.execute((HttpUriRequest)var5_6);
                var9_10 = var8_9.getStatusLine().getStatusCode();
                var10_11 = var8_9.getStatusLine().getReasonPhrase();
                if (var2_2) {
                    System.out.println();
                    ICHelper.logWithLocalTime("startJob Response Code: " + var9_10);
                    ICHelper.logWithLocalTime("startJob Response Message: " + var10_11);
                    System.out.println();
                }
                var11_12 = var8_9.getEntity();
                var3_3 = var11_12.getContent();
                if (var9_10 == 200) {
                }
                ** GOTO lbl-1000
            }
            catch (Exception var4_5) {
                throw new ICJobRunnerException("Error starting the job on the Informatica Cloud server.", var4_5);
            }
            catch (Throwable var14_15) {
                ICHelper.closeSomething(var3_3);
                throw var14_15;
            }
            ICHelper.closeSomething(var3_3);
            return;
lbl-1000:
            // 1 sources

            {
                if (var9_10 != 403) {
                    ICHelper.processResponseToConsole(var3_3, var8_9);
                    throw new ICJobRunnerException("Informatica Cloud web service response code: " + var9_10 + " (" + var10_11 + ")");
                }
                var12_13 = ICHelper.parseError(var3_3);
                var13_14 = "job";
                if (!"UI_13406".equalsIgnoreCase(var12_13.getCode())) {
                    ICHelper.logICError(var12_13, var13_14);
                    throw new RuntimeException(var12_13.getSkybotErrorMsg(var13_14));
                }
                this.randomWaitAndLoginAgain(var1_1, var2_2);
                continue;
            }
            break;
        }
    }

    private ICJobStatus icMonitorJob(ICServerTime iCServerTime, HttpClient httpClient) {
        ICActivityEntry iCActivityEntry;
        Object object;
        long l = System.currentTimeMillis();
        if (this.icServerInfo.isVerbose()) {
            System.out.println("");
            System.out.println("===================================================================");
            ICHelper.logWithLocalTime("Monitoring Job Instance: ");
            System.out.println("    Task Name . . . . . . : " + this.icJobRunnerCommand.getTaskName());
            System.out.println("    Task Type . . . . . . : " + this.icJobRunnerCommand.getTaskType());
            System.out.println("    From Server Time  . . : " + iCServerTime.getTime());
            System.out.println("    Find Job Interval . . : " + this.icServerInfo.getFindJobInterval());
            System.out.println("    Find Job Max Retries. : " + this.icServerInfo.getFindJobMaxTries());
            System.out.println("    Find Status Interval. : " + this.icServerInfo.getStatusInterval());
            System.out.println();
        } else {
            ICHelper.logWithLocalTime("Monitoring job instance...");
        }
        ICActivityEntry iCActivityEntry2 = null;
        int n = 0;
        do {
            ICHelper.logWithLocalTime("Searching for job instance...");
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                throw new ICJobRunnerException("Interrupted before finding the job instance.", interruptedException);
            }
            iCActivityEntry2 = this.findJobInstance(iCServerTime, httpClient, null, this.icServerInfo.isVerbose());
            if (iCActivityEntry2 instanceof ICActivityMonitorEntry && "INITIALIZED".equals(((ICActivityMonitorEntry)(object = (ICActivityMonitorEntry)iCActivityEntry2)).getExecutionState())) {
                iCActivityEntry2 = null;
                try {
                    Thread.sleep(this.icServerInfo.getFindJobInterval());
                }
                catch (InterruptedException interruptedException) {
                    throw new ICJobRunnerException("Interrupted while searching for the job instance.", interruptedException);
                }
            } else {
                if (iCActivityEntry2 != null) break;
                if ((long)(++n) >= this.icServerInfo.getFindJobMaxTries()) {
                    throw new ICJobRunnerException("A matching job instance was not found within " + this.icServerInfo.getFindJobMaxTries() + " intervals of " + this.icServerInfo.getFindJobInterval() + " milliseconds. Verify 'Task Name' and 'Task ID'.");
                }
                try {
                    Thread.sleep(this.icServerInfo.getFindJobInterval());
                }
                catch (InterruptedException interruptedException) {
                    throw new ICJobRunnerException("Interrupted while finding the job instance.", interruptedException);
                }
            }
        } while (iCActivityEntry2 == null);
        System.out.println();
        ICHelper.logWithLocalTime("Found Matching Informatica Cloud Job Instance:");
        iCActivityEntry2.logStringArray("    ");
        System.out.println();
        ICHelper.logWithLocalTime("Polling for job status updates...");
        object = null;
        if (iCActivityEntry2 instanceof ICActivityLogEntry) {
            iCActivityEntry = (ICActivityLogEntry)iCActivityEntry2;
            object = ((ICActivityLogEntry)iCActivityEntry).getStartTime();
        }
        if (iCActivityEntry2 instanceof ICActivityMonitorEntry) {
            iCActivityEntry = (ICActivityMonitorEntry)iCActivityEntry2;
            object = ((ICActivityMonitorEntry)iCActivityEntry).getStartTime();
        }
        while (iCActivityEntry2 != null) {
            long l2;
            if (iCActivityEntry2 instanceof ICActivityLogEntry) {
                ICActivityLogEntry iCActivityLogEntry = (ICActivityLogEntry)iCActivityEntry2;
                if ("1".equals(iCActivityLogEntry.getState())) {
                    return new ICJobStatus(1, iCActivityLogEntry);
                }
                if ("2".equals(iCActivityLogEntry.getState())) {
                    return new ICJobStatus(2, iCActivityLogEntry);
                }
                if ("3".equals(iCActivityLogEntry.getState())) {
                    return new ICJobStatus(3, iCActivityLogEntry);
                }
            }
            if (iCActivityEntry2 instanceof ICActivityMonitorEntry) {
                ICActivityMonitorEntry iCActivityMonitorEntry = (ICActivityMonitorEntry)iCActivityEntry2;
                if ("COMPLETED".equals(iCActivityMonitorEntry.getExecutionState())) {
                    return new ICJobStatus(1, iCActivityMonitorEntry);
                }
                if ("FAILED".equals(iCActivityMonitorEntry.getExecutionState())) {
                    return new ICJobStatus(3, iCActivityMonitorEntry);
                }
            }
            if ((l2 = this.icServerInfo.getStatusInterval()) < 1L) {
                l2 = this.getSmartPollingTime(l);
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                throw new ICJobRunnerException("Interrupted while polling the job status.", interruptedException);
            }
            int n2 = 0;
            int n3 = 20;
            do {
                if ((iCActivityEntry2 = this.findJobInstance(iCServerTime, httpClient, (String)object, this.icServerInfo.isVerbose())) != null) continue;
                System.out.println("Information for the current job is not available... (Attempt: " + ++n2 + ")");
                if (n2 > n3) {
                    throw new ICJobRunnerException("The job information is not longer available, therefore the current status cannot be determined. Start Time: " + (String)object);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new ICJobRunnerException("Interrupted while polling the job status.", interruptedException);
                }
            } while (iCActivityEntry2 == null);
        }
        throw new ICJobRunnerException("Unable to find a status for the job.");
    }

    private ICActivityEntry findJobInstance(ICServerTime iCServerTime, HttpClient httpClient, String string, boolean bl) {
        Date date;
        ICActivityMonitorEntry iCActivityMonitorEntry = null;
        ICActivityLogEntry iCActivityLogEntry = null;
        if (bl) {
            ICHelper.logWithLocalTime("Finding a job instance:");
            System.out.println("    Task Name . . . . . . . . . . : " + this.icJobRunnerCommand.getTaskName());
            System.out.println("    Task Type . . . . . . . . . . : " + this.icJobRunnerCommand.getTaskType());
            System.out.println("    IC Server Time  . . . . . . . : " + iCServerTime.getTime());
            System.out.println("    Matching Server Start Time  . : " + string);
            System.out.println();
        }
        String string2 = ICServerTime.getAdjustedTime(iCServerTime.getTime());
        Date date2 = ICServerTime.convertICTimeToTimestamp(string2);
        ICActivityMonitorEntry[] iCActivityMonitorEntryArray = this.getActivityMonitorEntries(httpClient, bl);
        if (bl) {
            System.out.println("Scanning " + iCActivityMonitorEntryArray.length + " Activity Monitor Entries...");
        }
        for (int i = 0; i < iCActivityMonitorEntryArray.length; ++i) {
            if (!this.icJobRunnerCommand.getTaskName().equalsIgnoreCase(iCActivityMonitorEntryArray[i].getTaskName()) || !this.icJobRunnerCommand.getTaskType().equalsIgnoreCase(iCActivityMonitorEntryArray[i].getType())) continue;
            if (string != null) {
                if (!string.equals(iCActivityMonitorEntryArray[i].getStartTime())) continue;
                return iCActivityMonitorEntryArray[i];
            }
            Date date3 = ICServerTime.convertICTimeToTimestamp(iCActivityMonitorEntryArray[i].getStartTime());
            if (date3.before(date2)) continue;
            if (iCActivityMonitorEntry == null) {
                iCActivityMonitorEntry = iCActivityMonitorEntryArray[i];
                continue;
            }
            date = ICServerTime.convertICTimeToTimestamp(iCActivityMonitorEntry.getStartTime());
            if (!date3.before(date)) continue;
            iCActivityMonitorEntry = iCActivityMonitorEntryArray[i];
        }
        ICActivityLogEntry[] iCActivityLogEntryArray = this.getActivityLogEntries(httpClient, bl);
        if (bl) {
            System.out.println("Scanning " + iCActivityLogEntryArray.length + " Activity Log Entries...");
        }
        for (int i = 0; i < iCActivityLogEntryArray.length; ++i) {
            if (!this.icJobRunnerCommand.getTaskName().equalsIgnoreCase(iCActivityLogEntryArray[i].getObjectName()) || !this.icJobRunnerCommand.getTaskType().equalsIgnoreCase(iCActivityLogEntryArray[i].getType())) continue;
            if (string != null) {
                if (!string.equals(iCActivityLogEntryArray[i].getStartTime())) continue;
                return iCActivityLogEntryArray[i];
            }
            date = ICServerTime.convertICTimeToTimestamp(iCActivityLogEntryArray[i].getStartTime());
            if (date.before(date2)) continue;
            if (iCActivityLogEntry == null) {
                iCActivityLogEntry = iCActivityLogEntryArray[i];
                continue;
            }
            Date date4 = ICServerTime.convertICTimeToTimestamp(iCActivityLogEntry.getStartTime());
            if (!date.before(date4)) continue;
            iCActivityLogEntry = iCActivityLogEntryArray[i];
        }
        if (iCActivityMonitorEntry != null && iCActivityLogEntry == null) {
            return iCActivityMonitorEntry;
        }
        if (iCActivityMonitorEntry == null && iCActivityLogEntry != null) {
            return iCActivityLogEntry;
        }
        if (iCActivityMonitorEntry != null && iCActivityLogEntry != null) {
            Date date5 = ICServerTime.convertICTimeToTimestamp(iCActivityMonitorEntry.getStartTime());
            date = ICServerTime.convertICTimeToTimestamp(iCActivityLogEntry.getStartTime());
            if (date.after(date5)) {
                return iCActivityMonitorEntry;
            }
            return iCActivityLogEntry;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICActivityMonitorEntry[] getActivityMonitorEntries(HttpClient httpClient, boolean bl) {
        Object object;
        InputStream inputStream = null;
        try {
            this.validateConnection(httpClient, this.icServerInfo);
            String string = this.icConnectionInfo.getServerUrl() + "/api/v2/activity/activityMonitor";
            if (bl) {
                System.out.println("");
                System.out.println("===================================================================");
                ICHelper.logWithLocalTime("Retrieving Activity Monitor Entries:");
                System.out.println("    Server URL  . : " + string);
                System.out.println("    Session ID  . : " + this.icConnectionInfo.getIcSessionId());
                System.out.println("    Task Name . . : " + this.icJobRunnerCommand.getTaskName());
                System.out.println("    Task Type . . : " + this.icJobRunnerCommand.getTaskType());
                System.out.println("");
            }
            while (true) {
                HttpGet httpGet = new HttpGet(string);
                httpGet.setHeader("Content-Type", "application/json");
                httpGet.setHeader("Accept", "application/json");
                httpGet.setHeader("icSessionId", this.icConnectionInfo.getIcSessionId());
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                int n = httpResponse.getStatusLine().getStatusCode();
                String string2 = httpResponse.getStatusLine().getReasonPhrase();
                if (bl) {
                    System.out.println();
                    ICHelper.logWithLocalTime("activityMonitor Response Code: " + n);
                    ICHelper.logWithLocalTime("activityMonitor Response Message: " + string2);
                    System.out.println();
                }
                HttpEntity httpEntity = httpResponse.getEntity();
                inputStream = httpEntity.getContent();
                if (n == 200) {
                    object = this.parseActivityMonitorEntries(inputStream);
                    break;
                }
                if (n != 403) {
                    ICHelper.processResponseToConsole(inputStream, httpResponse);
                    throw new ICJobRunnerException("Informatica Cloud activityMonitor response code: " + n + " (" + string2 + ")");
                }
                object = ICHelper.parseError(inputStream);
                String string3 = "activityMonitor";
                if (!"UI_13406".equalsIgnoreCase(((ICError)object).getCode())) {
                    ICHelper.logICError((ICError)object, string3);
                    throw new RuntimeException(((ICError)object).getSkybotErrorMsg(string3));
                }
                this.randomWaitAndLoginAgain(httpClient, bl);
                continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new ICJobRunnerException("Error getting activityMonitor list from the Informatica Cloud server.", exception);
        }
        catch (Throwable throwable) {
            ICHelper.closeSomething(inputStream);
            throw throwable;
        }
        ICHelper.closeSomething(inputStream);
        return object;
    }

    private long getSmartPollingTime(long l) {
        if (l < 1L) {
            return 2000L;
        }
        long l2 = System.currentTimeMillis() - l;
        if (l2 < 30000L) {
            return 2000L;
        }
        if (l2 < 300000L) {
            return 10000L;
        }
        return 20000L;
    }

    private ICActivityMonitorEntry[] parseActivityMonitorEntries(InputStream inputStream) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<ICActivityMonitorEntry>>(){}.getType();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        List list = (List)gson.fromJson((Reader)inputStreamReader, type);
        ICActivityMonitorEntry[] iCActivityMonitorEntryArray = new ICActivityMonitorEntry[]{};
        return list.toArray(iCActivityMonitorEntryArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICActivityLogEntry[] getActivityLogEntries(HttpClient httpClient, boolean bl) {
        Object object;
        InputStream inputStream = null;
        try {
            this.validateConnection(httpClient, this.icServerInfo);
            String string = this.icConnectionInfo.getServerUrl() + "/api/v2/activity/activityLog";
            if (bl) {
                System.out.println("");
                System.out.println("===================================================================");
                ICHelper.logWithLocalTime("Retrieving Activity Log Entries:");
                System.out.println("    Server URL  . : " + string);
                System.out.println("    Session ID  . : " + this.icConnectionInfo.getIcSessionId());
                System.out.println("    Task Name . . : " + this.icJobRunnerCommand.getTaskName());
                System.out.println("    Task Type . . : " + this.icJobRunnerCommand.getTaskType());
                System.out.println("");
            }
            while (true) {
                HttpGet httpGet = new HttpGet(string);
                httpGet.setHeader("Content-Type", "application/json");
                httpGet.setHeader("Accept", "application/json");
                httpGet.setHeader("icSessionId", this.icConnectionInfo.getIcSessionId());
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                int n = httpResponse.getStatusLine().getStatusCode();
                String string2 = httpResponse.getStatusLine().getReasonPhrase();
                if (bl) {
                    System.out.println();
                    ICHelper.logWithLocalTime("activityLog Response Code: " + n);
                    ICHelper.logWithLocalTime("activityLog Response Message: " + string2);
                    System.out.println();
                }
                HttpEntity httpEntity = httpResponse.getEntity();
                inputStream = httpEntity.getContent();
                if (n == 200) {
                    object = this.parseActivityLogEntries(inputStream);
                    break;
                }
                if (n != 403) {
                    ICHelper.processResponseToConsole(inputStream, httpResponse);
                    throw new ICJobRunnerException("Informatica Cloud activityLog response code: " + n + " (" + string2 + ")");
                }
                object = ICHelper.parseError(inputStream);
                String string3 = "activityLog";
                if (!"UI_13406".equalsIgnoreCase(((ICError)object).getCode())) {
                    ICHelper.logICError((ICError)object, string3);
                    throw new RuntimeException(((ICError)object).getSkybotErrorMsg(string3));
                }
                this.randomWaitAndLoginAgain(httpClient, bl);
                continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new ICJobRunnerException("Error getting activityLog list from the Informatica Cloud server.", exception);
        }
        catch (Throwable throwable) {
            ICHelper.closeSomething(inputStream);
            throw throwable;
        }
        ICHelper.closeSomething(inputStream);
        return object;
    }

    private ICActivityLogEntry[] parseActivityLogEntries(InputStream inputStream) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<ICActivityLogEntry>>(){}.getType();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        List list = (List)gson.fromJson((Reader)inputStreamReader, type);
        ICActivityLogEntry[] iCActivityLogEntryArray = new ICActivityLogEntry[]{};
        return list.toArray(iCActivityLogEntryArray);
    }

    private ICSharedConnectionInfo getValidatedConnection(HttpClient httpClient, ICServerInfo iCServerInfo) {
        if (!this.privateConnectionOnly) {
            try {
                ICSharedConnectionInfo iCSharedConnectionInfo = this.getSharedConnectionFromAgent(iCServerInfo);
                if (iCSharedConnectionInfo != null) {
                    return iCSharedConnectionInfo;
                }
            }
            catch (ICLoginFailedException iCLoginFailedException) {
                String string = "Login error getting shared connection from agent.";
                throw new RuntimeException(string, iCLoginFailedException);
            }
            catch (Throwable throwable) {
                ICHelper.logWithLocalTime("Error getting shared connection from agent.");
                throwable.printStackTrace(System.out);
                System.out.println();
            }
        }
        return this.getPrivateConnection(httpClient, iCServerInfo);
    }

    private ICSharedConnectionInfo getSharedConnectionFromAgent(ICServerInfo iCServerInfo) throws ICLoginFailedException {
        String string = this.makeAgentInstanceID(this.icJobRunnerParms);
        ICHelper.logWithLocalTime("Requesting shared IC Connection from the Agent process with Peer Instance ID: " + string);
        SkybotCommandPeer skybotCommandPeer = null;
        SkybotCommandDM skybotCommandDM = null;
        try {
            String string2 = this.makeJobID(this.icJobRunnerParms);
            skybotCommandPeer = SkybotCommandPeer.connectToAgentPeer((int)Integer.parseInt(this.icJobRunnerParms.getLocalAgentport()), (String)string);
            skybotCommandDM = (SkybotCommandDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)skybotCommandPeer.getAgentPeerID(), (String)"ENTERPRISE.SkybotCommandDM");
            if (skybotCommandDM != null) {
                ICSharedConnectionInfo iCSharedConnectionInfo = null;
                boolean bl = false;
                do {
                    bl = false;
                    try {
                        iCSharedConnectionInfo = skybotCommandDM.getICSharedConnectionInfo(iCServerInfo, string2);
                    }
                    catch (ICConnectionsExhausted iCConnectionsExhausted) {
                        bl = true;
                        long l = ICHelper.getRandomWait();
                        ICHelper.logWithLocalTime("Maximum Informatica Cloud connections are currently in use. Retrying for shared connection after waiting " + l + " milliseconds.");
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (bl);
                if (iCSharedConnectionInfo != null) {
                    String string3 = "New shared connection expiration: " + ICHelper.formatMillisecondTimestamp(iCSharedConnectionInfo.getAgentExpirationTime());
                    ICHelper.logWithLocalTime(string3);
                    ICSharedConnectionInfo iCSharedConnectionInfo2 = iCSharedConnectionInfo;
                    return iCSharedConnectionInfo2;
                }
            }
        }
        catch (ICLoginFailedException iCLoginFailedException) {
            throw iCLoginFailedException;
        }
        catch (SkybotJobPeerException skybotJobPeerException) {
            throw new RuntimeException("Error getting shared Informatica Cloud web server connection.", skybotJobPeerException);
        }
        finally {
            try {
                if (iCServerInfo.isVerbose()) {
                    ICHelper.logWithLocalTime("Shutting down the Automate Schedule Command Peer...");
                }
                if (skybotCommandPeer != null) {
                    skybotCommandPeer.shutdown();
                }
                if (iCServerInfo.isVerbose()) {
                    ICHelper.logWithLocalTime("Automate Schedule Command Peer shut down complete...");
                }
            }
            catch (Throwable throwable) {
                ICHelper.logWithLocalTime("Error disconnecting Automate Schedule Command Peer from agent.");
                throwable.printStackTrace(System.out);
                System.out.println();
            }
        }
        return null;
    }

    private ICSharedConnectionInfo getPrivateConnection(HttpClient httpClient, ICServerInfo iCServerInfo) {
        if (iCServerInfo.isVerbose()) {
            ICHelper.logWithLocalTime("Getting private connection...");
        }
        ICSharedConnectionInfo iCSharedConnectionInfo = new ICSharedConnectionInfo();
        ICConnectionInfo iCConnectionInfo = this.icServerPrivateLogin(httpClient, iCServerInfo);
        iCSharedConnectionInfo.setIcConnectionInfo(iCConnectionInfo);
        iCSharedConnectionInfo.setAgentExpirationTime(0L);
        iCSharedConnectionInfo.setSharedConnection(false);
        return iCSharedConnectionInfo;
    }

    private void releaseValidatedConnection(HttpClient httpClient, ICServerInfo iCServerInfo, ICSharedConnectionInfo iCSharedConnectionInfo) {
        if (iCSharedConnectionInfo == null) {
            return;
        }
        if (iCServerInfo.isVerbose()) {
            ICHelper.logWithLocalTime("Releasing validated connection...");
        }
        if (iCSharedConnectionInfo.isSharedConnection()) {
            this.releaseSharedConnection(iCSharedConnectionInfo, iCServerInfo);
        } else {
            ICJobExecutor.icServerLogout(httpClient, iCServerInfo, iCSharedConnectionInfo.getIcConnectionInfo());
        }
    }

    private String makeJobID(ICJobRunnerParms iCJobRunnerParms) {
        if (iCJobRunnerParms == null) {
            throw new NullPointerException("Job Runner Parms is null.");
        }
        return iCJobRunnerParms.getSkybotJobName() + "." + iCJobRunnerParms.getJobEventID();
    }

    private String makeAgentInstanceID(ICJobRunnerParms iCJobRunnerParms) {
        return "SKYJOB." + iCJobRunnerParms.getJobEventID() + "." + String.valueOf(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSharedConnection(ICSharedConnectionInfo iCSharedConnectionInfo, ICServerInfo iCServerInfo) {
        if (iCSharedConnectionInfo == null) {
            return;
        }
        String string = this.makeAgentInstanceID(this.icJobRunnerParms);
        if (iCServerInfo.isVerbose()) {
            ICHelper.logWithLocalTime("Releasing shared IC Connection with Peer Instance ID: " + string);
        }
        SkybotCommandPeer skybotCommandPeer = null;
        SkybotCommandDM skybotCommandDM = null;
        if (iCSharedConnectionInfo.isConnectionExpired()) {
            if (iCServerInfo.isVerbose()) {
                ICHelper.logWithLocalTime("The shared connection has expired, releasing is not required.");
            }
            return;
        }
        try {
            String string2 = this.makeJobID(this.icJobRunnerParms);
            skybotCommandPeer = SkybotCommandPeer.connectToAgentPeer((int)Integer.parseInt(this.icJobRunnerParms.getLocalAgentport()), (String)string);
            skybotCommandDM = (SkybotCommandDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)skybotCommandPeer.getAgentPeerID(), (String)"ENTERPRISE.SkybotCommandDM");
            if (skybotCommandDM != null) {
                skybotCommandDM.returnICSharedConnectionInfo(string2, iCServerInfo, iCSharedConnectionInfo);
            }
        }
        catch (Throwable throwable) {
            ICHelper.logWithLocalTime("Error releasing shared connection.");
            throwable.printStackTrace(System.out);
        }
        finally {
            try {
                if (iCServerInfo.isVerbose()) {
                    ICHelper.logWithLocalTime("Shutting down the Automate Schedule Command Peer...");
                }
                if (skybotCommandPeer != null) {
                    skybotCommandPeer.shutdown();
                }
                if (iCServerInfo.isVerbose()) {
                    ICHelper.logWithLocalTime("Automate Schedule Command Peer shut down complete...");
                }
            }
            catch (Throwable throwable) {
                ICHelper.logWithLocalTime("Error disconnecting Automate Schedule Command Peer from agent.");
                throwable.printStackTrace(System.out);
                System.out.println();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private ICConnectionInfo icServerPrivateLogin(HttpClient var1_1, ICServerInfo var2_2) {
        var3_3 = null;
        var4_4 = var2_2.getBaseURL() + "/ma/api/v2/user/login";
        if (var2_2.isVerbose()) {
            System.out.println("===================================================================");
            ICHelper.logWithLocalTime("Logging in: ");
            System.out.println("    User ID . . . : " + var2_2.getUserID());
            System.out.println("    Login URL . . : " + var4_4);
            System.out.println();
        } else {
            ICHelper.logWithLocalTime("Logging in...");
        }
        var5_5 = false;
        do {
            block17: {
                block16: {
                    block15: {
                        var6_6 = new HttpPost(var4_4);
                        var6_6.setHeader("Content-Type", "application/json");
                        var6_6.setHeader("Accept", "application/json");
                        var7_8 = "{\n" + ICHelper.getJSONLine("@type", "login") + "," + "\n" + ICHelper.getJSONLine("username", var2_2.getUserID()) + "," + "\n" + ICHelper.getJSONLine("password", var2_2.getPassword()) + "\n" + "}";
                        var8_9 = new StringEntity(var7_8);
                        var6_6.setEntity((HttpEntity)var8_9);
                        var9_10 = var1_1.execute((HttpUriRequest)var6_6);
                        var10_11 = var9_10.getStatusLine().getStatusCode();
                        var11_12 = var9_10.getStatusLine().getReasonPhrase();
                        if (var2_2.isVerbose()) {
                            System.out.println();
                            ICHelper.logWithLocalTime("login Response Code . . . : " + var10_11);
                            ICHelper.logWithLocalTime("login Response Message  . : " + var11_12);
                            System.out.println();
                        }
                        var12_13 = var9_10.getEntity();
                        var3_3 = var12_13.getContent();
                        if (var10_11 != 200) break block15;
                        var13_14 = this.parseConnectionEntry(var3_3);
                        if (var2_2.isVerbose()) {
                            ICHelper.logWithLocalTime("Connection User Properties: ");
                            var13_14.logStringArray("    ");
                        }
                        if (var13_14.getIcSessionId() == null || var13_14.getIcSessionId().trim().length() == 0) {
                            throw new ICJobRunnerException("An 'icSessionId' was not returned by the login request.");
                        }
                        if (var13_14.getServerUrl() == null || var13_14.getServerUrl().trim().length() == 0) {
                            throw new ICJobRunnerException("A 'serverUrl' was not returned by the login request.");
                        }
                        var14_15 = var13_14;
                        ICHelper.closeSomething(var3_3);
                        return var14_15;
                    }
                    if (var10_11 != 403) ** GOTO lbl61
                    var13_14 = ICHelper.parseError(var3_3);
                    var14_15 = "login";
                    if (var13_14.getCode() == null || !var13_14.getCode().trim().equalsIgnoreCase("APP_13408")) break block16;
                    var15_16 = ICHelper.getRandomWait();
                    ICHelper.logWithLocalTime("Maximum number of REST API sessions are already in use.  Connect retry random wait time (milliseconds): " + var15_16);
                    try {
                        Thread.sleep(var15_16);
                        break block17;
                    }
                    catch (InterruptedException var17_17) {
                        // empty catch block
                    }
                    break block17;
                }
                try {
                    try {
                        ICHelper.logICError((ICError)var13_14, (String)var14_15);
                        throw new RuntimeException(var13_14.getSkybotErrorMsg((String)var14_15));
lbl61:
                        // 1 sources

                        ICHelper.processResponseToConsole(var3_3, var9_10);
                        throw new ICJobRunnerException("Informatica Cloud web service response code: " + var10_11 + " (" + var11_12 + ")");
                    }
                    catch (Exception var6_7) {
                        throw new ICJobRunnerException("Error logging into the Informatica Cloud server.", var6_7);
                    }
                }
                catch (Throwable var18_18) {
                    ICHelper.closeSomething(var3_3);
                    throw var18_18;
                }
            }
            ICHelper.closeSomething(var3_3);
        } while (!var5_5);
        throw new IllegalStateException("Unable to connect with Informatica Cloud server.");
    }

    private ICConnectionInfo parseConnectionEntry(InputStream inputStream) {
        Gson gson = new Gson();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return (ICConnectionInfo)((Object)gson.fromJson((Reader)inputStreamReader, ICConnectionInfo.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void icServerLogout(HttpClient httpClient, ICServerInfo iCServerInfo, ICConnectionInfo iCConnectionInfo) {
        InputStream inputStream = null;
        try {
            System.out.println("===================================================================");
            ICHelper.logWithLocalTime("Logging out Informatica Cloud Session...");
            if (httpClient == null) {
                ICHelper.logWithLocalTime("Unable to logout.  An HTTP Client is not available.");
                return;
            }
            if (iCConnectionInfo == null) {
                ICHelper.logWithLocalTime("Unable to logout.  The connection info is not available.");
                return;
            }
            String string = iCConnectionInfo.getServerUrl() + "/api/v2/user/logout";
            if (iCServerInfo.isVerbose()) {
                System.out.println("===================================================================");
                ICHelper.logWithLocalTime("Logging out: ");
                System.out.println("    Session ID  . : " + iCConnectionInfo.getIcSessionId());
                System.out.println("    Logout URL  . : " + string);
                System.out.println();
            }
            HttpPost httpPost = new HttpPost(string);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("icSessionId", iCConnectionInfo.getIcSessionId());
            String string2 = "{\n}";
            StringEntity stringEntity = new StringEntity(string2);
            httpPost.setEntity((HttpEntity)stringEntity);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int n = httpResponse.getStatusLine().getStatusCode();
            String string3 = httpResponse.getStatusLine().getReasonPhrase();
            if (iCServerInfo.isVerbose()) {
                System.out.println();
                ICHelper.logWithLocalTime("Logout Response Code . . . : " + n);
                ICHelper.logWithLocalTime("Logout Response Message  . : " + string3);
                System.out.println();
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            inputStream = httpEntity.getContent();
            if (n == 200) {
                if (iCServerInfo.isVerbose()) {
                    System.out.println("Logout successful.");
                }
            } else {
                ICHelper.processResponseToConsole(inputStream, httpResponse);
                throw new ICJobRunnerException("Informatica Cloud logout web service response code: " + n + " (" + string3 + ")");
            }
            ICHelper.closeSomething(inputStream);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace(System.out);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        finally {
            ICHelper.closeSomething(inputStream);
        }
    }

    private void logWithAgentTime(String string) {
        System.out.println(this.getLocalAgentTime() + " - " + string);
    }

    private String getLocalAgentTime() {
        return ICHelper.formatterSecs.format(new Date(System.currentTimeMillis()));
    }
}

