/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.filetransfer;

import com.helpsystems.enterprise.core.busobj.FileTransferException;
import com.helpsystems.enterprise.module.exec.FTPWorker;
import com.helpsystems.enterprise.module.exec.Utils;
import com.helpsystems.enterprise.module.filetransfer.IPeerFileTransferClientFactory;
import com.helpsystems.enterprise.module.filetransfer.PeerSftpClient;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import java.net.ConnectException;

public class PeerSftpClientFactory
implements IPeerFileTransferClientFactory<PeerSftpClient> {
    protected boolean unknownHostChallenge;
    private FTPWorker ftpWorker;
    private int authenticationType = 1;
    private String privateKeyPathString = "";

    public PeerSftpClientFactory(boolean bl, int n, String string) {
        this.unknownHostChallenge = bl;
        this.ftpWorker = new FTPWorker();
        if (n == 2) {
            this.authenticationType = 2;
            this.privateKeyPathString = string;
        }
    }

    @Override
    public PeerSftpClient connect(String string, Integer n, String string2, String string3) throws ConnectException, JSchException, FileTransferException {
        String string4 = Utils.concatToStrings("Connecting to system:", string, "port:", n, "user:", string2);
        System.out.println(string4);
        PeerSftpClient peerSftpClient = null;
        ChannelSftp channelSftp = null;
        try {
            if (this.privateKeyPathString != null) {
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows") && this.privateKeyPathString.startsWith("~")) {
                    this.privateKeyPathString = this.privateKeyPathString.replaceFirst("~", System.getProperty("user.home"));
                }
                channelSftp = this.ftpWorker.connectSecureSftp(string, n, string2, string3, this.unknownHostChallenge, this.authenticationType, this.privateKeyPathString);
            }
            if (channelSftp == null) {
                throw new ConnectException("Username or password is/are incorrect");
            }
            peerSftpClient = new PeerSftpClient(channelSftp);
            String string5 = Utils.concatToStrings("Connected to SFTP server.");
            System.out.println(string5);
        }
        catch (FileTransferException fileTransferException) {
            String string6 = Utils.concatToStrings("Unable to connect to FTP server. File Transfer Exception: ", fileTransferException.getMessage());
            System.out.println(string6);
            throw fileTransferException;
        }
        catch (RuntimeException runtimeException) {
            String string7 = Utils.concatToStrings("Unable to connect to FTP server. Exception: ", runtimeException.getMessage());
            System.out.println(string7);
            throw runtimeException;
        }
        return peerSftpClient;
    }

    @Override
    public void close(PeerSftpClient peerSftpClient, String string) {
        try {
            String string2 = Utils.concatToStrings("Closing SFTP connection...");
            System.out.println(string2);
            ChannelSftp channelSftp = peerSftpClient.getChannelSftp();
            this.ftpWorker.closeSFTP(channelSftp, string);
            String string3 = Utils.concatToStrings("SFTP connection closed");
            System.out.println(string3);
        }
        catch (RuntimeException runtimeException) {
            String string4 = Utils.concatToStrings("Unable to close connection to SFTP server. Exception: ", runtimeException.getMessage());
            System.out.println(string4);
            throw runtimeException;
        }
    }
}

