/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.SqlServerJob;
import com.helpsystems.enterprise.core.busobj.SqlServerSystem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import sun.misc.BASE64Encoder;

public class SqlServerJobUtil {
    public static String buildSqlCommandLine(CommandSetCommand commandSetCommand, SqlServerJob sqlServerJob) throws Throwable {
        String string = SqlServerJobUtil.createExePath();
        StringBuilder stringBuilder = new StringBuilder();
        SqlServerSystem sqlServerSystem = sqlServerJob.get_sqlServerSystem();
        String string2 = sqlServerSystem.get_serverInstanceName();
        if (string2 != null && string2.trim().length() > 0) {
            SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "s", string2);
        }
        if (sqlServerJob.get_jobName() == null) {
            throw new Exception("Job name cannot be null!");
        }
        SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "j", sqlServerJob.get_jobName());
        if (sqlServerSystem.is_useTrustedConnection()) {
            SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "t", "");
        } else {
            SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "u", sqlServerSystem.get_userId());
            SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "p", sqlServerSystem.get_encrypted_password());
            SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "e", "");
        }
        if (sqlServerJob.is_verboseOutput()) {
            SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "v", "");
        }
        SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "x", sqlServerJob.getUniqueCommandIndentifier());
        SqlServerJobUtil.addCommandFlag(sqlServerJob, stringBuilder, "z", sqlServerJob.getSecurityToken());
        return string + " " + SqlServerJobUtil.encodeStringToBase64(stringBuilder.toString());
    }

    public static String encodeStringToBase64(String string) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = string.getBytes(Charset.forName("UTF-8"));
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string2 = bASE64Encoder.encode(byArray);
        string2 = string2.replaceAll("[\r\n]", "");
        return string2;
    }

    private static String createExePath() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new File("").getCanonicalPath();
        string = "\"" + string + "\\bin\\win32\\MsSqlJobExec.exe\"";
        string = string.replace("/", "\\");
        stringBuilder.append(string + " ");
        return stringBuilder.toString();
    }

    private static void addCommandFlag(SqlServerJob sqlServerJob, StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(sqlServerJob.getValueSeparator());
        stringBuilder.append(sqlServerJob.getCommandlineSwitch());
        stringBuilder.append(string);
        stringBuilder.append(sqlServerJob.getValueSeparator());
        stringBuilder.append(string2);
        stringBuilder.append("\n");
    }
}

