/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.module.exec.Platform;
import com.helpsystems.enterprise.module.exec.ProcessCommand;
import com.helpsystems.enterprise.module.exec.SqlServerJobUtil;
import com.helpsystems.enterprise.module.exec.WindowsPlatform;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProcessUtil {
    public static final String BIF_MARKER = ".B_I_F";
    public static final String FTU_MARKER = "AgentPCTFR";
    public static final String FTU_PROGRAM = "Automate Schedule Agent FTU.exe";
    private static final int SET_PWD_COMMAND = -10;
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);

    private ProcessUtil() {
    }

    static String findInLibraryPath(String string) {
        String[] stringArray;
        for (String string2 : stringArray = System.getProperty("java.library.path").split(System.getProperty("path.separator"))) {
            File file = new File(string2 + "/" + string);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    static Map<String, String> resolveEnvironment(ExecutableJob executableJob) {
        Map<String, String> map;
        Map<String, String> map2 = executableJob.getEventEnvVars();
        String string = System.getenv("SKYBOT_CONFIG_JOBINFO");
        if (string != null && string.trim().equalsIgnoreCase("true")) {
            ProcessUtil.loadJobConfigInfo(executableJob, map2);
        }
        AgentEnvironment agentEnvironment = executableJob.getPrivateAgentEnvironment();
        AgentEnvironment agentEnvironment2 = executableJob.getSharedAgentEnvironment();
        if (agentEnvironment2 != null && (map = agentEnvironment2.getMap()) != null) {
            map2.putAll(map);
        }
        if (agentEnvironment != null && (map = agentEnvironment.getMap()) != null) {
            map2.putAll(map);
        }
        return map2;
    }

    public static void loadJobConfigInfo(ExecutableJob executableJob, Map<String, String> map) {
        try {
            String string;
            long l = executableJob.getJobHistory().getId();
            if (l != 0L) {
                map.put("SKYBOT_JOB_RUN_ID", String.valueOf(l));
            }
            if ((l = executableJob.getJobHistory().getJobSuiteHistoryID()) != 0L) {
                map.put("SKYBOT_SUITE_RUN_ID", String.valueOf(l));
            }
            if ((string = executableJob.getJobHistory().getJobName()) != null && string.trim().length() > 0) {
                map.put("SKYBOT_JOB_NAME", String.valueOf(string));
            }
            if ((string = executableJob.getJobHistory().getJobSuiteName()) != null && string.trim().length() > 0) {
                map.put("SKYBOT_SUITE_NAME", String.valueOf(string));
            }
            if ((string = executableJob.getJobHistory().getAgentName()) != null && string.trim().length() > 0) {
                map.put("SKYBOT_AGENT_NAME", String.valueOf(string));
            }
            if ((l = executableJob.getJobHistory().getScheduledTime()) != 0L) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HHmmss");
                SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("SSS");
                Date date = new Date(l);
                map.put("SKYBOT_SCHEDULED_DATE", simpleDateFormat.format(date));
                map.put("SKYBOT_SCHEDULED_TIME", simpleDateFormat2.format(date));
                map.put("SKYBOT_SCHEDULED_MILLIS", simpleDateFormat3.format(date));
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error configuring Automate Schedule Job environment variables.", (Throwable)exception);
        }
    }

    static String resolveWorkingDir(ExecutableJob executableJob) {
        String string;
        AgentEnvironment agentEnvironment = executableJob.getPrivateAgentEnvironment();
        AgentEnvironment agentEnvironment2 = executableJob.getSharedAgentEnvironment();
        String string2 = null;
        if (agentEnvironment2 != null) {
            string2 = agentEnvironment2.getWorkingPath();
        }
        if (agentEnvironment != null && (string = agentEnvironment.getWorkingPath()) != null && !agentEnvironment.getWorkingPath().equals("*SHARED")) {
            string2 = agentEnvironment.getWorkingPath();
        }
        return string2;
    }

    public static int resolveRunType(ExecutableJob executableJob) {
        AgentEnvironment agentEnvironment = executableJob.getPrivateAgentEnvironment();
        AgentEnvironment agentEnvironment2 = executableJob.getSharedAgentEnvironment();
        if (agentEnvironment2 != null) {
            return agentEnvironment2.getRunType();
        }
        return agentEnvironment.getRunType();
    }

    static String resolveUser(ExecutableJob executableJob) {
        String string;
        AgentEnvironment agentEnvironment = executableJob.getPrivateAgentEnvironment();
        AgentEnvironment agentEnvironment2 = executableJob.getSharedAgentEnvironment();
        String string2 = null;
        if (agentEnvironment2 != null) {
            string2 = agentEnvironment2.getUserProfile();
        }
        if (agentEnvironment != null && (string = agentEnvironment.getUserProfile()) != null && !string.equals("*SHARED")) {
            string2 = string;
        }
        return string2;
    }

    static String resolvePassword(ExecutableJob executableJob) {
        String string;
        AgentEnvironment agentEnvironment = executableJob.getPrivateAgentEnvironment();
        AgentEnvironment agentEnvironment2 = executableJob.getSharedAgentEnvironment();
        String string2 = null;
        if (agentEnvironment2 != null) {
            string2 = agentEnvironment2.getPassword();
        }
        if (agentEnvironment != null && (string = agentEnvironment.getUserProfile()) != null && !string.equals("*SHARED")) {
            string2 = agentEnvironment.getPassword();
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    static String resolveShell(ExecutableJob executableJob) {
        Agent agent = executableJob.getAgent();
        String[] stringArray = new String[]{ProcessUtil.getShellVar(executableJob.getPrivateAgentEnvironment()), ProcessUtil.getShellVar(executableJob.getSharedAgentEnvironment()), agent.getJobShell()};
        String string = null;
        for (String string2 : stringArray) {
            if (string2 == null || string2.length() <= 0) continue;
            string = string2;
            break;
        }
        return string;
    }

    static String getShellVar(AgentEnvironment agentEnvironment) {
        if (agentEnvironment == null) {
            return null;
        }
        return agentEnvironment.getMap().get("PROCESS_SHELL");
    }

    public static String toString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static void convertBIFS(Platform platform, ArrayList<ProcessCommand> arrayList, String string, String string2) {
        ProcessCommand processCommand;
        for (int i = 0; i < arrayList.size() && (processCommand = arrayList.get(i)) != null; ++i) {
            Object object;
            CharSequence charSequence;
            CommandSetCommand commandSetCommand = processCommand.getCommand();
            if (commandSetCommand != null && processCommand.getCommand().get_sqlServerJob() != null) {
                try {
                    charSequence = SqlServerJobUtil.buildSqlCommandLine(processCommand.getCommand(), processCommand.getCommand().get_sqlServerJob());
                    processCommand.getCommand().setCommandString((String)charSequence);
                }
                catch (Throwable throwable) {
                    System.out.println("Error building SQL Job Commandline: " + throwable.getMessage());
                }
                continue;
            }
            if (processCommand.getCommand() == null || processCommand.getCommand().getCommandString() == null) continue;
            charSequence = new StringBuffer(System.getProperty("user.dir"));
            String string3 = System.getProperty("file.separator");
            String string4 = processCommand.getCommand().getCommandString();
            String string5 = platform.getCommandExtension();
            String string6 = null;
            String[] stringArray = string4.trim().split(" ");
            String string7 = stringArray[0];
            boolean bl = false;
            if (string4.startsWith(FTU_MARKER)) {
                if (!(platform instanceof WindowsPlatform)) {
                    throw new IllegalArgumentException("FTU is not supported on non-Windows Operating Systems.");
                }
                ((StringBuffer)charSequence).append(string3);
                ((StringBuffer)charSequence).append(string4);
                object = "\"" + ((StringBuffer)charSequence).toString();
                string6 = ((String)object).replace(FTU_MARKER, "Automate Schedule Agent FTU.exe\"");
            } else if (string7.toUpperCase().contains(BIF_MARKER) && !platform.isCommentCommand(string4)) {
                Object object2;
                String string8 = ProcessUtil.getPwdParm(stringArray);
                if (string8 != null) {
                    object2 = string8.split(":");
                    if (((String[])object2).length < 2) {
                        throw new IllegalArgumentException("The password parameter is not formatted properly.");
                    }
                    String string9 = object2[1];
                    ProcessCommand processCommand2 = ProcessUtil.getCommandSetEnvVariable(platform, "AGT_ENV_PWD", string9, string2);
                    if (processCommand2 != null) {
                        arrayList.add(i++, processCommand2);
                        string4 = string4.replace(string8, "");
                        bl = true;
                    }
                }
                if (!(string4 = string4.replace("FTP.B_I_F", "ftp.B_I_F")).toUpperCase().contains(((StringBuffer)charSequence).toString().toUpperCase())) {
                    ((StringBuffer)charSequence).append(string3);
                    ((StringBuffer)charSequence).append(string4);
                    object = "\"" + ((StringBuffer)charSequence).toString();
                    string6 = ((String)object).replace(BIF_MARKER, string5 + "\"" + " C_F_G");
                } else {
                    string6 = string4.replace(BIF_MARKER, string5 + " C_F_G");
                }
                object2 = new StringBuffer("");
                if (!string6.toUpperCase().contains(" -F ") && string != null) {
                    ((StringBuffer)object2).append(" -f ");
                    ((StringBuffer)object2).append("\"");
                    ((StringBuffer)object2).append(string);
                    ((StringBuffer)object2).append("\"");
                }
                string6 = string6.replace("C_F_G", ((StringBuffer)object2).toString());
            }
            if (string6 == null) continue;
            arrayList.get(i).getCommand().setCommandString(string6);
            if (!bl) continue;
            object = ProcessUtil.getCommandSetEnvVariable(platform, "AGT_ENV_PWD", "", string2);
            if (object != null) {
                arrayList.add(++i, (ProcessCommand)object);
            }
            bl = false;
        }
    }

    public static ProcessCommand getCommandSetEnvVariable(Platform platform, String string, String string2, String string3) {
        String string4 = platform.getSetEnvironment(string, string2, string3);
        if (string4 != null) {
            CommandSetCommand commandSetCommand = new CommandSetCommand();
            commandSetCommand.setReturnCode(AgentReturnCode.getInstanceStandard());
            commandSetCommand.setCancelOnError(false);
            commandSetCommand.setCommandString(string4);
            ProcessCommand processCommand = new ProcessCommand(-10, commandSetCommand, 0);
            return processCommand;
        }
        return null;
    }

    public static ProcessCommand getCommandResetErrorLevel() {
        CommandSetCommand commandSetCommand = new CommandSetCommand();
        commandSetCommand.setReturnCode(AgentReturnCode.getInstanceStandard());
        commandSetCommand.setCancelOnError(false);
        commandSetCommand.setCommandString("ver > nul");
        return new ProcessCommand(-10, commandSetCommand, 0);
    }

    private static String getPwdParm(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toUpperCase().trim().startsWith("-P:")) continue;
            return stringArray[i];
        }
        return null;
    }

    public static void testDisplayEnvMap(Map<String, String> map) {
        logger.debug((Object)("envMap size = " + map.size()));
        Set<String> set = map.keySet();
        for (String string : set) {
            String string2 = map.get(string);
            logger.debug((Object)("Key(" + string + ") String(" + string2 + ")"));
        }
    }
}

