/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.AgentCopyFileDefinition;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.FileTransfer;
import com.helpsystems.enterprise.core.busobj.FileTransferSystem;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobConditionType;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobLogHeader;
import com.helpsystems.enterprise.core.busobj.OutputDistribution;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPARequestComposite;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskRequestComposite;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudCommand;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaCloudServer;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaRepository;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.Parameter;
import com.helpsystems.enterprise.core.busobj.oracle.OracleCommand;
import com.helpsystems.enterprise.core.busobj.oracle.OracleConcurrentRequest;
import com.helpsystems.enterprise.core.busobj.oracle.OracleExecutable;
import com.helpsystems.enterprise.core.busobj.oracle.OracleParameter;
import com.helpsystems.enterprise.core.busobj.oracle.OracleSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPXMIAuditLevel;
import com.helpsystems.enterprise.core.cmdlineobj.InfaCloudParamMarker;
import com.helpsystems.enterprise.core.cmdlineobj.InfaCmdParamMarker;
import com.helpsystems.enterprise.core.dm.FilePeerControlAM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;
import com.helpsystems.enterprise.module.exec.BifPlatformValidator;
import com.helpsystems.enterprise.module.exec.JobExecDMImpl;
import com.helpsystems.enterprise.module.exec.LogFileWrapper;
import com.helpsystems.enterprise.module.exec.Platform;
import com.helpsystems.enterprise.module.exec.ProcessCommand;
import com.helpsystems.enterprise.module.exec.ProcessMonitor;
import com.helpsystems.enterprise.module.exec.ProcessUtil;
import com.helpsystems.enterprise.module.exec.UNIXPlatform;
import com.helpsystems.enterprise.module.exec.WindowsPlatform;
import com.helpsystems.enterprise.module.windows.WindowsProcessLauncher;
import com.helpsystems.enterprise.peer.AgentControl;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.peer.preconditions.JobConditionsComparator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

class JobProcess
extends EnterpriseVersionedObject {
    public static final char COMPLETION_CODE_FAIL = 'F';
    public static final char COMPLETION_CODE_CANCELED = 'A';
    public static final char COMPLETION_CODE_SUCCESS = 'C';
    public static final char COMPLETION_CODE_ERROR = 'E';
    public static final String SINGLE_QUOTE = "'";
    public static final String ESCAPED_DOUBLE_QUOTE = "\\\"";
    private static final long serialVersionUID = 7675462027973247618L;
    public static final String PROCESS_LOGIN_KEY = "__PROCESS_LOGIN";
    private static final Logger logger = Logger.getLogger(JobProcess.class);
    public static final String WIN_2003_OS = "Windows 2003";
    public static final String WIN_XP_OS = "Windows XP";
    private static final String AUTOMATE_SCRIPT_FILE = "automatetaskrunner";
    private static final String AUTOMATE_BPA_SCRIPT_FILE = "automatebpacommandrunner";
    private static final AgentReturnCode JOB_SETUP_RETURN_CODE = new AgentReturnCode();
    private File outLogFile;
    private ExecutableJob ej;
    private long whenStarted;
    private String terminationData;
    private char completionCode;
    private JobEndedReasonCode jobEndedReasonCode;
    private String terminationReason;
    private int failedAtCommandSequence = -1;
    private boolean wasTerminatedByServer;
    private Map<Long, List<String>> agentOutputFileMap;
    private PeerID filePeerID;
    private ArrayList<Long> startedSAPInterceptedJobIDs = new ArrayList();
    private transient Platform platform;
    private transient JobExecDMImpl mgr;
    private transient Process process;
    private transient ProcessMonitor processMonitor;
    private transient LogFileWrapper logFileWrapper;
    private transient Map<Long, String> agentOutputPrefixMap;
    private boolean sentCompletion;
    private List<AgentCopyFileDefinition> agentCopyFileDefinitions;
    private OutputDistribution[] outputDistributionArray;
    private HashMap<Long, String> deletedFileArray = new HashMap();
    private String subShell = null;
    private Map<String, String> envMap;

    @Deprecated
    public JobProcess() {
        this.completionCode = (char)32;
        this.agentOutputPrefixMap = new HashMap<Long, String>();
        this.agentOutputFileMap = new HashMap<Long, List<String>>();
        this.agentCopyFileDefinitions = new ArrayList<AgentCopyFileDefinition>();
    }

    JobProcess(ExecutableJob executableJob, Platform platform, JobExecDMImpl jobExecDMImpl) throws SubmitFailedException {
        this.ej = executableJob;
        this.whenStarted = executableJob.getAgentStartedTime();
        this.platform = platform;
        this.mgr = jobExecDMImpl;
        this.completionCode = (char)32;
        this.agentOutputPrefixMap = new HashMap<Long, String>();
        this.agentOutputFileMap = new HashMap<Long, List<String>>();
        this.agentCopyFileDefinitions = new ArrayList<AgentCopyFileDefinition>();
        this.envMap = ProcessUtil.resolveEnvironment(executableJob);
        this.initLogFile();
        this.startProcess();
    }

    public ExecutableJob getExecutableJob() {
        return this.ej;
    }

    public long getWhenStarted() {
        return this.whenStarted;
    }

    public boolean wasTerminatedByServer() {
        return this.wasTerminatedByServer;
    }

    public String getTerminationReason() {
        return this.terminationReason;
    }

    public void setTerminationReason(String string) {
        this.terminationReason = string;
    }

    public char getCompletionCode() {
        return this.completionCode;
    }

    void setCompletionCode(char c) {
        this.completionCode = c;
    }

    public void setJobEndedReasonCode(JobEndedReasonCode jobEndedReasonCode) {
        this.jobEndedReasonCode = jobEndedReasonCode;
    }

    public JobEndedReasonCode getJobEndedReasonCode() {
        return this.jobEndedReasonCode;
    }

    public File getOutputLogFile() {
        return this.outLogFile;
    }

    public Map<Long, String> getAgentOutputPrefixMap() {
        return this.agentOutputPrefixMap;
    }

    Map<Long, List<String>> getAgentOutputFileMap() {
        return this.agentOutputFileMap;
    }

    public Process getProcess() {
        return this.process;
    }

    Platform getPlatform() {
        return this.platform;
    }

    LogFileWrapper getLogFileWrapper() {
        return this.logFileWrapper;
    }

    private void initLogFile() throws SubmitFailedException {
        String string = this.ej.getAgent().getName();
        String string2 = "joblogtmp";
        if (AgentControl.isWindows()) {
            string2 = DefaultConfigPath.getDefaultPath() + File.separator + string2;
        }
        this.outLogFile = new File(string2 + "/" + string + "_" + this.ej.getJobHistory().getJobName() + "_" + this.ej.getEventID() + ".log");
        if (this.outLogFile.exists() && !this.outLogFile.delete()) {
            throw new SubmitFailedException("Unable to delete existing log file " + this.outLogFile.getAbsolutePath());
        }
        JobLogHeader jobLogHeader = this.createJobLogHeader();
        this.logFileWrapper = new LogFileWrapper(this.outLogFile);
        this.logFileWrapper.write(jobLogHeader.toStringArray());
    }

    private JobLogHeader createJobLogHeader() {
        ValidationHelper.checkForNull((String)"Executable Job", (Object)((Object)this.ej));
        AgentEnvironment agentEnvironment = this.ej.getSharedAgentEnvironment();
        String string = "<private>";
        if (agentEnvironment != null) {
            string = agentEnvironment.getName();
        }
        JobLogHeader jobLogHeader = new JobLogHeader(this.ej.getAgentStartedTime(), this.ej.getJobHistory().getJobName(), this.ej.getScheduleJob().getSkybotJobNumber(), this.ej.getScheduleJob().getDescription(), this.ej.getJobHistory().getJobParameters(), this.ej.getEventID(), string, this.ej.getAgent().getName(), System.getProperty("user.name"), this.ej.getAgent().getOperatingSystem(), this.ej.getAgent().getVersion(), this.serverName(this.ej.getServerPeerID()));
        return jobLogHeader;
    }

    private void startProcess() throws SubmitFailedException {
        Object object;
        block34: {
            Object object2;
            ProcessCommand[] processCommandArray;
            String[] stringArray;
            String string;
            try {
                if (logger.isDebugEnabled()) {
                    String string2 = this.ej.getScheduleJob().getSkybotJobName();
                    string = this.ej.getEventID();
                    logger.debug((Object)("JobProcess is starting a process for job named " + string2 + " with event id " + string + "."));
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error logging JobProcess started message.", throwable);
            }
            int n = ProcessUtil.resolveRunType(this.ej);
            string = ProcessUtil.resolveUser(this.ej);
            if (n == 2 || n == 4) {
                if (string == null || string.length() == 0) {
                    String string3 = "No user specified in job setup.";
                    this.writeFailureAndClose(string3);
                    throw new SubmitFailedException(string3);
                }
                if (this.platform instanceof UNIXPlatform && "root".equals(System.getProperty("user.name")) && "root".equals(string) && n == 2) {
                    String string4 = "Unable to authenticate password for job user 'root'.  You may not run a agent job as 'root' when the agent itself has been started as 'root'.";
                    this.writeFailureAndClose(string4);
                    throw new SubmitFailedException(string4);
                }
            } else {
                string = "-=-";
            }
            try {
                stringArray = this.platform.getProcessShellCommand(n, string, this.isProcessLogin());
            }
            catch (Exception exception) {
                throw new SubmitFailedException("Unable to build the command to start the agent-job", exception);
            }
            String string5 = ProcessUtil.toString(stringArray);
            if (this.platform instanceof WindowsPlatform) {
                processCommandArray = string;
                object = "";
                object2 = string.split("\\\\");
                if (((String[])object2).length > 1) {
                    object = object2[0];
                    processCommandArray = object2[1];
                }
                processCommandArray = this.platform.quoteString((String)processCommandArray);
                String string6 = Long.toString(this.whenStarted);
                this.logFileWrapper.write("Starting process with command: " + WindowsProcessLauncher.getExecutable() + " " + (String)processCommandArray + " " + (String)object + " " + string6 + " " + string5);
                logger.debug((Object)("About to start a Process for eventID: " + this.ej.getEventID()));
                try {
                    this.process = this.mgr.getWindowsProcessLauncher().start((String)processCommandArray, (String)object, string6 + ':' + this.ej.getEventID(), string5);
                }
                catch (Exception exception) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unable to start Windows process ");
                    stringBuilder.append(string5);
                    stringBuilder.append(" for user ");
                    stringBuilder.append(string);
                    stringBuilder.append(" and eventID ");
                    stringBuilder.append(this.ej.getEventID());
                    if (exception.getLocalizedMessage() != null) {
                        stringBuilder.append(" Cause: ");
                        stringBuilder.append(exception.getLocalizedMessage());
                    }
                    logger.error((Object)stringBuilder.toString(), (Throwable)exception);
                    this.writeFailureAndClose(stringBuilder.toString());
                    throw new SubmitFailedException(stringBuilder.toString(), exception, SubmitFailedException.Reason.CREATE_PROCESS_FAILED);
                }
            }
            this.logFileWrapper.write("Starting process with command: " + string5);
            processCommandArray = new ProcessBuilder(stringArray);
            if (!this.isProcessLogin()) {
                processCommandArray.environment().put("TERM", "robotterm");
                processCommandArray.environment().put("TERMINFO", System.getProperty("user.dir"));
            }
            processCommandArray.redirectErrorStream(true);
            try {
                this.process = processCommandArray.start();
            }
            catch (IOException iOException) {
                SubmitFailedException submitFailedException = new SubmitFailedException("Unable to start the process: " + string5, iOException, SubmitFailedException.Reason.CREATE_PROCESS_FAILED);
                logger.debug((Object)"", (Throwable)submitFailedException);
                this.writeFailureAndClose(submitFailedException.getMessage());
                throw submitFailedException;
            }
            if (this.process == null) {
                processCommandArray = "Unable to start the process: " + string5;
                this.writeFailureAndClose((String)processCommandArray);
                throw new SubmitFailedException((String)processCommandArray);
            }
            processCommandArray = this.buildCommands();
            try {
                BifPlatformValidator.validateBifCommandsAgainstTargetPlatform(this.platform, processCommandArray);
            }
            catch (SubmitFailedException submitFailedException) {
                logger.debug((Object)submitFailedException.getStackTrace(), (Throwable)submitFailedException);
                this.jobEndedReasonCode = JobEndedReasonCode.PLATFORM_COMMAND_MISMATCH;
                this.process.destroy();
                throw submitFailedException;
            }
            try {
                this.processMonitor = new ProcessMonitor(this, processCommandArray);
                this.processMonitor.setDeletedFileArray(this.deletedFileArray);
            }
            catch (Exception exception) {
                object2 = "Unable to monitor the process";
                this.writeFailureAndClose((String)object2);
                this.process.destroy();
                throw new SubmitFailedException((String)object2, exception);
            }
            try {
                object = this.process.getInputStream();
                try {
                    while (((InputStream)object).available() < 1 && System.currentTimeMillis() - this.whenStarted < 120000L) {
                        if (this.process != null) {
                            try {
                                this.process.exitValue();
                                try {
                                    this.process.destroy();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                object2 = "Process exited before job could run.";
                                this.writeFailureAndClose((String)object2);
                                throw new SubmitFailedException((String)object2);
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                // empty catch block
                            }
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (((InputStream)object).available() >= 1) break block34;
                try {
                    this.process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object2 = "Process has not produced any output.";
                this.writeFailureAndClose((String)object2);
                throw new SubmitFailedException((String)object2);
            }
            catch (IOException iOException) {
                object2 = "Unable to read output from the process.";
                this.writeFailureAndClose((String)object2);
                throw new SubmitFailedException((String)object2, iOException);
            }
        }
        object = new Thread(this.processMonitor);
        ((Thread)object).start();
    }

    private boolean isProcessLogin() {
        String string = this.envMap.get(PROCESS_LOGIN_KEY);
        return "true".equalsIgnoreCase(string);
    }

    private void writeFailureAndClose(String string) {
        if (this.logFileWrapper == null || string == null) {
            return;
        }
        this.logFileWrapper.write(string);
        this.logFileWrapper.close();
    }

    private ProcessCommand[] buildCommands() throws SubmitFailedException {
        ProcessCommand[] processCommandArray;
        Object object;
        int n;
        ArrayList<ProcessCommand> arrayList = new ArrayList<ProcessCommand>();
        this.buildInitCommands(arrayList);
        int n2 = n = this.ej.getJobConditions() == null ? 0 : this.ej.getJobConditions().length;
        if (!this.ej.isIgnoreConditions() && this.ej.isConditional() && n > 0) {
            object = this.ej.getJobConditions();
            Arrays.sort(object, new JobConditionsComparator());
            for (int i = 0; i < n; ++i) {
                this.buildJobConditionPeerCommand(arrayList, object[i]);
            }
        }
        this.buildActualJobCommands(arrayList);
        object = null;
        try {
            object = this.mgr.getPeer().getConfigPath();
        }
        catch (Exception exception) {
            logger.debug((Object)"Could not retrieve the agent peer configuration path.", (Throwable)exception);
        }
        this.platform.interpretBIFS(arrayList, (String)object, this.subShell);
        long l = this.ej.getScheduleJob().getSkybotJobNumber();
        try {
            processCommandArray = (ProcessCommand[])ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.ej.getServerPeerID(), (String)"ENTERPRISE.OutputDistributiontDM");
            this.outputDistributionArray = processCommandArray.getByJobId(l);
        }
        catch (Exception exception) {
            String string = "Error while retrieving the output distribution for jobId = " + l;
            logger.debug((Object)string, (Throwable)exception);
        }
        if (this.outputDistributionArray != null) {
            this.buildAgentOutputCommands(arrayList, this.outputDistributionArray, this.ej.getEventID());
        }
        processCommandArray = new ProcessCommand[arrayList.size()];
        arrayList.toArray(processCommandArray);
        return processCommandArray;
    }

    private void buildInitCommands(List<ProcessCommand> list) {
        Object object;
        Object object2;
        Object object3;
        String string = ProcessUtil.resolvePassword(this.ej);
        boolean bl = this.platform.sendUserPassword();
        int n = ProcessUtil.resolveRunType(this.ej);
        if (n != 2) {
            bl = false;
        }
        if (this.platform instanceof UNIXPlatform && !bl && n == 2 && (object3 = this.platform.getSwapUserCommand((String)(object2 = ProcessUtil.resolveUser(this.ej)), this.isProcessLogin())) != null && ((Object)object3).length > 0) {
            list.add(new ProcessCommand(-1, this.makeInitCommand("set -e"), 20));
            list.add(new ProcessCommand(-1, this.makeInitCommand(ProcessUtil.toString((String[])object3)), 14));
            bl = true;
        }
        if (bl && string != null) {
            if (this.platform instanceof WindowsPlatform) {
                string = string + '\u0000';
            }
            object2 = new ProcessCommand(-1, this.makeInitCommand(string), 10);
            ((ProcessCommand)object2).setInputHidden(true);
            list.add((ProcessCommand)object2);
        }
        if ((object2 = ProcessUtil.resolveShell(this.ej)) != null && ((String)object2).length() > 0) {
            if (this.platform instanceof UNIXPlatform) {
                object3 = new CommandSetCommand("echo Process ID=$$");
                ((CommandSetCommand)((Object)object3)).setCancelOnError(false);
                ((CommandSetCommand)((Object)object3)).setReturnCode(JOB_SETUP_RETURN_CODE);
                list.add(new ProcessCommand(-1, (CommandSetCommand)((Object)object3), 0));
            }
            list.add(new ProcessCommand(-1, this.makeInitCommand((String)object2), 0));
            this.subShell = object2;
            if (this.platform instanceof UNIXPlatform) {
                object3 = new CommandSetCommand("echo Process ID=$$");
                ((CommandSetCommand)((Object)object3)).setCancelOnError(true);
                ((CommandSetCommand)((Object)object3)).setReturnCode(JOB_SETUP_RETURN_CODE);
                list.add(new ProcessCommand(-1, (CommandSetCommand)((Object)object3), 40));
            }
        }
        if (this.platform instanceof UNIXPlatform) {
            object3 = this.makeInitCommand("stty cols 10000");
            ((CommandSetCommand)((Object)object3)).setCancelOnError(false);
            list.add(new ProcessCommand(-1, (CommandSetCommand)((Object)object3), 20));
        }
        if ((object3 = ProcessUtil.resolveWorkingDir(this.ej)) != null && ((String)object3).length() > 0 && !((String)object3).equals(".")) {
            if (this.platform instanceof UNIXPlatform) {
                list.add(new ProcessCommand(-1, this.makeInitCommand("cd " + this.platform.quoteString((String)object3)), 20));
            } else if (this.platform instanceof WindowsPlatform) {
                if (((String)object3).indexOf(":") == 1) {
                    list.add(new ProcessCommand(-1, this.makeInitCommand(((String)object3).substring(0, 2)), 20));
                    if (((String)object3).length() > 2) {
                        object = ((String)object3).substring(2);
                        if (!((String)object).startsWith("\\") && !((String)object).startsWith("/")) {
                            object = "\\" + (String)object;
                        }
                        list.add(new ProcessCommand(-1, this.makeInitCommand("cd " + (String)object), 20));
                    }
                } else {
                    list.add(new ProcessCommand(-1, this.makeInitCommand("cd " + (String)object3), 20));
                }
            }
        }
        object = this.platform.getEnvCommands(this.envMap, this.subShell);
        for (String string2 : object) {
            list.add(new ProcessCommand(-1, this.makeInitCommand(string2), 20));
        }
        list.add(ProcessCommand.MARKER_INSTANCE);
    }

    private void buildActualJobCommands(List<ProcessCommand> list) throws SubmitFailedException {
        CommandSet commandSet = this.ej.getScheduleJob().getCommandSet();
        block20: for (CommandSetCommand commandSetCommand : commandSet.getCommands()) {
            switch (commandSetCommand.getCommandType()) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 15: {
                    list.add(new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 0));
                    continue block20;
                }
                case 0: 
                case 2: {
                    list.add(new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20));
                    continue block20;
                }
                case 1: {
                    this.addFileTransferCommand(commandSetCommand, list);
                    continue block20;
                }
                case 3: {
                    this.addWindowsTransponderCommand(commandSetCommand, list);
                    continue block20;
                }
                case 8: {
                    list.add(this.buildInformaticaCommandString(commandSetCommand));
                    continue block20;
                }
                case 9: {
                    try {
                        this.addOracleCommands(commandSetCommand, list);
                        continue block20;
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        throw new SubmitFailedException("Error adding Oracle Command to the job.", resourceUnavailableException);
                    }
                }
                case 10: {
                    try {
                        list.add(this.buildWebServiceCommandString(commandSetCommand));
                        continue block20;
                    }
                    catch (Exception exception) {
                        throw new SubmitFailedException("Error adding Web Service Command to the job.", exception);
                    }
                }
                case 12: {
                    list.add(this.buildInformaticaCloudCommandString(commandSetCommand, this.ej.getEventID(), String.valueOf(this.ej.getAgent().getPort()), this.ej.getScheduleJob().getSkybotJobName()));
                    continue block20;
                }
                case 13: {
                    try {
                        list.add(this.buildAutoMateTaskCommandString(commandSetCommand));
                        continue block20;
                    }
                    catch (IOException iOException) {
                        throw new SubmitFailedException("Error adding AutoMate Task Command to the job.", iOException);
                    }
                }
                case 14: {
                    try {
                        list.add(this.buildAutoMateBPACommandString(commandSetCommand));
                        continue block20;
                    }
                    catch (IOException iOException) {
                        throw new SubmitFailedException("Error adding AutoMate BPA Command to the job.", iOException);
                    }
                }
                default: {
                    throw new SubmitFailedException("Command Type " + commandSetCommand.getCommandType() + " is not supported.", SubmitFailedException.Reason.UNSUPPORTED_COMMAND_TYPE, commandSetCommand);
                }
            }
        }
    }

    private ProcessCommand buildAutoMateBPACommandString(CommandSetCommand commandSetCommand) throws IOException {
        String string = AUTOMATE_BPA_SCRIPT_FILE + this.platform.getCommandExtension();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(new File(string).getAbsolutePath());
        stringBuilder.append("\" ");
        String string2 = this.buildAutoMateCommandFile(commandSetCommand);
        if (string2 == null) {
            throw new IOException("Could not find AutoMate BPA Command file");
        }
        boolean bl = true;
        if (string.toLowerCase().endsWith(".sh")) {
            bl = false;
        }
        boolean bl2 = this.platform.isCSHShell(this.getSubShell());
        if (!bl && !bl2) {
            string2 = string2.replaceAll("\\$", "\\\\\\$");
        }
        stringBuilder.append(string2);
        commandSetCommand.setCommandString(stringBuilder.toString());
        return new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20);
    }

    private void addOracleCommands(CommandSetCommand commandSetCommand, List<ProcessCommand> list) throws ResourceUnavailableException {
        Object object;
        OracleExecutable oracleExecutable = commandSetCommand.getOracleExecutable();
        OracleSystemDefinition oracleSystemDefinition = oracleExecutable.getOracleSystemDefinition();
        String string = "";
        if (this.platform instanceof UNIXPlatform) {
            string = ". ";
        }
        string = string + oracleSystemDefinition.getEnvironmentFilePath();
        CommandSetCommand commandSetCommand2 = new CommandSetCommand(string);
        commandSetCommand2.setLineNumber(commandSetCommand.getLineNumber());
        commandSetCommand2.setCancelOnError(commandSetCommand.isCancelOnError());
        commandSetCommand2.setReturnCode(AgentReturnCode.getInstanceStandard());
        ProcessCommand processCommand = new ProcessCommand(commandSetCommand2.getLineNumber(), commandSetCommand2, 20);
        list.add(processCommand);
        String string2 = "";
        if (this.platform instanceof UNIXPlatform) {
            string2 = "$FND_TOP/bin/CONCSUB";
        } else if (this.platform instanceof WindowsPlatform) {
            string2 = "%FND_TOP%\\bin\\CONCSUB";
        } else {
            logger.error((Object)("Unsupported platform(" + this.platform.getName() + ") for Oracle commands."));
            return;
        }
        string2 = string2 + " " + oracleSystemDefinition.getOracleUserName() + "/" + oracleSystemDefinition.getDecryptedPassword();
        string2 = string2 + " " + oracleSystemDefinition.getResponsibilityAppShortname();
        String string3 = SINGLE_QUOTE;
        if (this.platform instanceof WindowsPlatform) {
            string3 = ESCAPED_DOUBLE_QUOTE;
        }
        string2 = string2 + " " + string3 + oracleSystemDefinition.getResponsibilityName() + string3;
        string2 = string2 + " " + oracleSystemDefinition.getApplicationUsername();
        OracleCommand oracleCommand = oracleExecutable.getOracleCommand();
        if (oracleCommand instanceof OracleConcurrentRequest) {
            Object object2;
            object = (OracleConcurrentRequest)oracleCommand;
            string2 = string2 + " WAIT=" + ((OracleConcurrentRequest)object).getWaitOption().name();
            string2 = string2 + " CONCURRENT " + ((OracleConcurrentRequest)object).getProgramApplicationShortname();
            string2 = string2 + " " + ((OracleConcurrentRequest)object).getConcurrentProgram();
            String string4 = "PROGRAM_NAME=";
            string4 = string4 + ESCAPED_DOUBLE_QUOTE;
            if (((OracleConcurrentRequest)object).getProgramName().length() > 0) {
                string4 = string4 + ((OracleConcurrentRequest)object).getProgramName();
            } else {
                object2 = this.ej.getJobHistory().getJobName();
                object2 = this.platform instanceof UNIXPlatform ? (String)object2 + "\\(" + this.ej.getEventID() + "\\)" : (String)object2 + "(" + this.ej.getEventID() + ")";
                string4 = string4 + (String)object2;
            }
            string4 = string4 + ESCAPED_DOUBLE_QUOTE;
            string2 = string2 + " " + string4;
            object2 = ((OracleConcurrentRequest)object).getParameterList();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                OracleParameter oracleParameter = (OracleParameter)((Object)iterator.next());
                string2 = string2 + " " + this.getOracleFormattedParameter(oracleParameter.getValue());
            }
            String string5 = ((OracleConcurrentRequest)object).getPrinterName();
            if (string5 != null && string5.length() > 0) {
                String string6;
                string2 = string2 + " PRINTER=" + string5;
                int n = ((OracleConcurrentRequest)object).getNumberOfCopies();
                string2 = string2 + " NUMBER_OF_COPIES=" + n;
                String string7 = ((OracleConcurrentRequest)object).getPrintStyle();
                if (string7 != null && string7.length() > 0) {
                    string2 = string2 + " PRINT_STYLE=" + string7;
                }
                if ((string6 = ((OracleConcurrentRequest)object).getLanguage()) != null && string6.length() > 0) {
                    string2 = string2 + " LANGUAGE=" + string6;
                }
            }
        }
        commandSetCommand.setCommandString(string2);
        object = new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20);
        list.add((ProcessCommand)object);
    }

    private String getOracleFormattedParameter(String string) {
        String string2 = string;
        if (string.contains(" ")) {
            string2 = "";
            string2 = string2 + ESCAPED_DOUBLE_QUOTE;
            string2 = string2 + string;
            string2 = string2 + ESCAPED_DOUBLE_QUOTE;
        }
        return string2;
    }

    private void addWindowsTransponderCommand(CommandSetCommand commandSetCommand, List<ProcessCommand> list) {
        StringBuilder stringBuilder = new StringBuilder(255);
        String string = "bin\\Win32\\vlaunch.exe";
        stringBuilder.append('\"');
        stringBuilder.append(new File(string).getAbsolutePath());
        stringBuilder.append('\"');
        stringBuilder.append(' ');
        if (commandSetCommand.isWaitOnGui()) {
            stringBuilder.append('\"');
            stringBuilder.append('/');
            stringBuilder.append('w');
            stringBuilder.append('\"');
            stringBuilder.append(' ');
        }
        stringBuilder.append('\"');
        String string2 = this.getDoubleQuotedCommandString(commandSetCommand.getCommandString());
        stringBuilder.append(string2);
        stringBuilder.append('\"');
        commandSetCommand.setCommandString(stringBuilder.toString());
        list.add(new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20));
    }

    private String getDoubleQuotedCommandString(String string) {
        String string2 = string;
        logger.debug((Object)("*** commandString = " + string));
        if (string.contains("\"")) {
            logger.debug((Object)"*** Found double quotes in the commandString");
            string2 = string.replaceAll("\"", "\"\"");
        }
        logger.debug((Object)("*** doubleQuotedCommandString = " + string2));
        return string2;
    }

    private void addFileTransferCommand(CommandSetCommand commandSetCommand, List<ProcessCommand> list) {
        ProcessCommand[] processCommandArray = null;
        processCommandArray = this.buildFileTransferCommandString(commandSetCommand);
        if (commandSetCommand.getCommandString().trim().length() > 0) {
            if (processCommandArray.length > 0) {
                list.add(processCommandArray[0]);
                list.add(processCommandArray[1]);
            }
            list.add(new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20));
            if (processCommandArray.length > 0) {
                list.add(processCommandArray[2]);
                list.add(processCommandArray[3]);
                if (processCommandArray[4] != null) {
                    list.add(processCommandArray[4]);
                }
            }
        }
    }

    private String encode(String string, String string2) {
        String string3 = string;
        try {
            string3 = UnacodeMash.unMash(string);
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string3);
            return UnacodeMash.mash(stringBuffer.toString());
        }
        catch (Exception exception) {
            return string;
        }
    }

    private ProcessCommand[] getEnvAdds(FileTransferSystem fileTransferSystem, String string) {
        ProcessCommand[] processCommandArray = new ProcessCommand[5];
        String string2 = fileTransferSystem.getEncryptedPassword();
        string2 = string2 == null ? "" : this.encode(string2, string);
        String string3 = fileTransferSystem.getPasswordSalt();
        if (string3 == null) {
            string3 = "";
        }
        processCommandArray[0] = ProcessUtil.getCommandSetEnvVariable(this.platform, "AGT_ENV_PWD", this.platform.quoteEnvVarValue(string2, this.subShell), this.subShell);
        processCommandArray[1] = ProcessUtil.getCommandSetEnvVariable(this.platform, "AGT_ENV_SALT", this.platform.quoteEnvVarValue(string3, this.subShell), this.subShell);
        processCommandArray[2] = ProcessUtil.getCommandSetEnvVariable(this.platform, "AGT_ENV_PWD", "", this.subShell);
        processCommandArray[3] = ProcessUtil.getCommandSetEnvVariable(this.platform, "AGT_ENV_SALT", "", this.subShell);
        String string4 = System.getProperty("os.name").trim();
        if (string4.equalsIgnoreCase(WIN_2003_OS.trim()) || string4.equalsIgnoreCase(WIN_XP_OS.trim())) {
            processCommandArray[4] = ProcessUtil.getCommandResetErrorLevel();
        }
        return processCommandArray;
    }

    private ProcessCommand[] buildFileTransferCommandString(CommandSetCommand commandSetCommand) {
        if (commandSetCommand == null) {
            return new ProcessCommand[0];
        }
        if (commandSetCommand.getCommandType() != 1) {
            return new ProcessCommand[0];
        }
        String string = "filetransfer" + this.platform.getCommandExtension();
        String string2 = '\"' + new File(string).getAbsolutePath() + "\" ";
        string2 = string2 + this.buildFlagsAndValuesArgs(commandSetCommand.getFileTransfer());
        commandSetCommand.setCommandString(string2);
        return this.getEnvAdds(commandSetCommand.getFileTransfer().getFileTransferSystem(), commandSetCommand.getFileTransfer().getCommandHash());
    }

    private String buildFlagsAndValuesArgs(FileTransfer fileTransfer) {
        FileTransferSystem fileTransferSystem = fileTransfer.getFileTransferSystem();
        StringBuilder stringBuilder = new StringBuilder();
        this.addFlagAndValue(stringBuilder, this.createTransferDirectionString(fileTransfer), "d", true);
        this.addFlagAndValue(stringBuilder, fileTransfer.getRemoteFileName(), "r", true);
        this.addFlagAndValue(stringBuilder, fileTransfer.getAgentFileName(), "a", true);
        this.addFlagAndValue(stringBuilder, fileTransfer.isReplaceExistingTargetFile() ? "yes" : "no", "e");
        this.addFlagAndValue(stringBuilder, this.createTransferTypeString(fileTransfer), "t");
        this.addFlagAndValue(stringBuilder, this.createTransferModeString(fileTransferSystem), "m");
        this.addFlagAndValue(stringBuilder, fileTransferSystem.getSystemName(), "y");
        this.addFlagAndValue(stringBuilder, fileTransferSystem.getUser(), "u", true);
        this.addFlagAndValue(stringBuilder, fileTransferSystem.getPort() + "", "p");
        this.addFlagAndValue(stringBuilder, this.createAythenticationTypeString(fileTransferSystem), "b");
        this.addFlagAndValue(stringBuilder, fileTransferSystem.getPrivateKeyPath(), "k");
        if (fileTransfer.getSiteCommand() != null && !fileTransfer.getSiteCommand().equals("")) {
            this.addFlagAndValue(stringBuilder, fileTransfer.getSiteCommand(), "g", true);
        }
        this.addFlagAndValue(stringBuilder, fileTransferSystem.isUnknownHostChallenge() ? "yes" : "no", "c");
        this.addFlagAndValue(stringBuilder, fileTransferSystem.isUseImplicitFtps() ? "yes" : "no", "i");
        this.addFlagAndValue(stringBuilder, fileTransfer.isDeleteAfterTransfer() ? "yes" : "no", "l");
        return stringBuilder.toString();
    }

    private String createTransferTypeString(FileTransfer fileTransfer) {
        String string = "binary";
        if (fileTransfer.getTransferType() == 1) {
            string = "binary";
        } else if (fileTransfer.getTransferType() == 0) {
            string = "text";
        } else {
            throw new InvalidParameterException("No such Transfer Type supported!");
        }
        return string;
    }

    private String createAythenticationTypeString(FileTransferSystem fileTransferSystem) {
        String string = "username";
        int n = fileTransferSystem.getAuthenticationType();
        if (n == 2) {
            string = "key";
        } else if (n != 1) {
            throw new InvalidParameterException("No such Authentication Type supported!");
        }
        return string;
    }

    private String createTransferDirectionString(FileTransfer fileTransfer) {
        String string = "put";
        if (fileTransfer.getDirection() == 1) {
            string = "put";
        } else if (fileTransfer.getDirection() == 0) {
            string = "get";
        } else {
            throw new InvalidParameterException("No such Transfer Direction supported!");
        }
        return string;
    }

    private String createTransferModeString(FileTransferSystem fileTransferSystem) {
        String string = "ftp";
        switch (fileTransferSystem.getTransferType()) {
            case 0: {
                string = "ftp";
                break;
            }
            case 2: {
                string = "ftps";
                break;
            }
            case 1: {
                string = "sftp";
                break;
            }
            default: {
                throw new InvalidParameterException("No such Transfer Mode supported!");
            }
        }
        return string;
    }

    private void addFlagAndValue(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('\"');
        stringBuilder.append("-" + string2 + ":");
        if (string != null && string.endsWith("\\")) {
            String string3 = string.replaceAll("\\\\+$", "\\\\\\\\");
            stringBuilder.append(string3);
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append('\"');
        stringBuilder.append(' ');
    }

    private void addFlagAndValue(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        this.addFlagAndValue(stringBuilder, string, string2);
        if (bl && this.platform instanceof UNIXPlatform) {
            stringBuilder.append("\\\n");
        }
    }

    private void buildAgentOutputCommands(List<ProcessCommand> list, OutputDistribution[] outputDistributionArray, String string) {
        if (outputDistributionArray == null || outputDistributionArray.length < 1) {
            logger.debug((Object)("No output distributions to build for event ID " + string + "."));
            return;
        }
        logger.debug((Object)("Output distributions to build for event ID " + string + ": " + outputDistributionArray.length));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ProcessUtil.findInLibraryPath("fileread");
        if (string2 == null) {
            string2 = ProcessUtil.findInLibraryPath("fileread.exe");
        }
        if (string2 == null) {
            String string3 = "Unable to process Agent Output because the 'fileread' utility could not be found.";
            CommandSetCommand commandSetCommand = new CommandSetCommand(this.platform.makeRemarkCommand(string3, this.subShell));
            commandSetCommand.setCancelOnError(false);
            commandSetCommand.setErrorHandlingRetry(false);
            commandSetCommand.setReturnCode(JOB_SETUP_RETURN_CODE);
            list.add(new ProcessCommand(-2, commandSetCommand, 20));
            logger.debug((Object)string3);
            return;
        }
        for (int i = 0; i < outputDistributionArray.length; ++i) {
            AgentCopyFileDefinition agentCopyFileDefinition = new AgentCopyFileDefinition();
            agentCopyFileDefinition.setAgentFilePath(outputDistributionArray[i].getFileFilter());
            agentCopyFileDefinition.setOid(outputDistributionArray[i].getOid());
            this.agentCopyFileDefinitions.add(agentCopyFileDefinition);
        }
        if (!this.agentCopyFileDefinitions.isEmpty()) {
            stringBuffer.append("\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
            if (this.platform instanceof UNIXPlatform) {
                stringBuffer.append("\\\n");
            }
            if (logger.isTraceEnabled() || logger.isDebugEnabled()) {
                stringBuffer.append(" -v");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (AgentCopyFileDefinition agentCopyFileDefinition : this.agentCopyFileDefinitions) {
                StringBuffer stringBuffer3 = new StringBuffer("_@_PREFIX_@_");
                long l = agentCopyFileDefinition.getOid();
                stringBuffer3.append(l);
                stringBuffer3.append("_");
                stringBuffer2.setLength(0);
                stringBuffer2.append(" -r -p ");
                stringBuffer2.append(stringBuffer3.toString());
                stringBuffer2.append(" -- ");
                stringBuffer2.append(this.platform.quoteString(agentCopyFileDefinition.getAgentFilePath()));
                this.agentOutputPrefixMap.put(l, stringBuffer3.toString());
                CommandSetCommand commandSetCommand = new CommandSetCommand(stringBuffer.toString() + stringBuffer2.toString());
                commandSetCommand.setCancelOnError(false);
                commandSetCommand.setErrorHandlingRetry(false);
                commandSetCommand.setReturnCode(JOB_SETUP_RETURN_CODE);
                ProcessCommand processCommand = new ProcessCommand(-2, commandSetCommand, 20);
                processCommand.setAgentCopyFileDefinition(agentCopyFileDefinition);
                list.add(processCommand);
            }
        }
    }

    public String getSubShell() {
        return this.subShell;
    }

    public void setSubShell(String string) {
        this.subShell = string;
    }

    private CommandSetCommand makeInitCommand(String string) {
        CommandSetCommand commandSetCommand = new CommandSetCommand(string);
        commandSetCommand.setCancelOnError(true);
        commandSetCommand.setReturnCode(JOB_SETUP_RETURN_CODE);
        return commandSetCommand;
    }

    public void terminate(String string) {
        this.completionCode = (char)65;
        this.wasTerminatedByServer = true;
        String string2 = "";
        if (string != null) {
            string2 = !string.contains("by user") && !string.contains("Job Monitor") ? string2 + "by user " + string : (string.contains("Job Monitor") ? string2 + "by the " + string : string2 + string);
        }
        String string3 = "Job termination requested for Job " + this.ej.getScheduleJob().getName() + " event ID " + this.ej.getEventID() + " " + string2;
        logger.debug((Object)string3);
        if (this.filePeerID != null) {
            this.mgr.getPeer().disconnectFromPeer(this.filePeerID);
        }
        if (this.processMonitor != null) {
            this.processMonitor.terminate(string2);
        }
    }

    public PeerID getFilePeerID() {
        return this.filePeerID;
    }

    void filePeerConnected(PeerID peerID) {
        logger.debug((Object)"*** Inside JobProcess.filePeerConnected");
        if (this.completionCode == 'F') {
            logger.trace((Object)("Disconnecting from unneeded File Peer " + peerID));
            this.mgr.getPeer().disconnectFromPeer(peerID);
            return;
        }
        if (this.completionCode == ' ') {
            this.completionCode = (char)67;
        }
        this.filePeerID = peerID;
        try {
            this.processMonitor.readOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendCompletion();
    }

    void finishJob() {
        this.processMonitor.finish();
        if (this.filePeerID != null) {
            try {
                FilePeerControlAM filePeerControlAM = (FilePeerControlAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.filePeerID, (String)"ENTERPRISE.FilePeerControlAM");
                filePeerControlAM.finished();
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to tell the FilePeer " + this.filePeerID + " that this agent is finished with it."), (Throwable)exception);
                this.mgr.getPeer().disconnectFromPeer(this.filePeerID);
            }
        }
        while (this.processMonitor.isAlive()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseAgentOutputLog(long l) {
        if (this.completionCode != ' ') {
            return;
        }
        if (this.outputDistributionArray == null || this.outputDistributionArray.length == 0) {
            return;
        }
        Map<Long, String> map = this.getAgentOutputPrefixMap();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            List<String> list;
            int n;
            long l2;
            fileInputStream = new FileInputStream(this.getOutputLogFile());
            for (long i = l; i > 0L; i -= l2) {
                l2 = fileInputStream.skip(i);
                if (l2 >= 0L) continue;
                throw new EOFException("Unable to parse Agent Output, log file truncated.");
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf8"));
            Set<Long> set = map.keySet();
            String string = bufferedReader.readLine();
            while (string != null) {
                n = 0;
                Iterator<Long> iterator = set.iterator();
                while (iterator.hasNext() && n == 0) {
                    Long l3 = iterator.next();
                    list = map.get(l3);
                    int n2 = this.searchForFilereadPrefix(string, (String)((Object)list));
                    if (n2 <= -1) continue;
                    this.saveToMap(l3, string.substring(n2));
                }
                string = bufferedReader.readLine();
            }
            int n3 = this.outputDistributionArray.length;
            boolean bl = false;
            for (n = 0; n < n3 && !bl; ++n) {
                CharSequence charSequence;
                list = this.agentOutputFileMap.get(this.outputDistributionArray[n].getOid());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    charSequence = "No files match the output distribution's file filter: " + this.outputDistributionArray[n].getFileFilter();
                    if (this.outputDistributionArray[n].isFailOnMissingFiles()) {
                        this.logFileWrapper.write((String)charSequence);
                        this.setCompletionCode('F');
                        this.setJobEndedReasonCode(JobEndedReasonCode.OUTPUT_DISTRIBUTION);
                        bl = true;
                        continue;
                    }
                    if (this.logFileWrapper == null) continue;
                    this.logFileWrapper.write((String)charSequence);
                    continue;
                }
                if (this.outputDistributionArray[n].getCopyDuplicate() != 2 || !FileHandler.containsDublicateNames(list)) continue;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("List of files matching to filefilter:");
                ((StringBuilder)charSequence).append(this.outputDistributionArray[n].getFileFilter());
                ((StringBuilder)charSequence).append(" has duplications");
                this.writeFailureAndClose(((StringBuilder)charSequence).toString());
                this.setCompletionCode('F');
                this.setJobEndedReasonCode(JobEndedReasonCode.OUTPUT_DISTRIBUTION);
                bl = true;
            }
            if (bl) {
                this.agentOutputFileMap.clear();
            }
        }
        catch (Exception exception) {
            String string = "Unable to parse the Agent Output from the job log.";
            logger.debug((Object)string, (Throwable)exception);
            this.completionCode = (char)70;
            this.terminationReason = string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {}
            System.gc();
        }
    }

    private int searchForFilereadPrefix(String string, String string2) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return n;
        }
        if (n == 0) {
            return string2.length();
        }
        int n2 = string2.length() + n;
        if (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ' ') {
                return -1;
            }
            return n2;
        }
        return -1;
    }

    private void saveToMap(long l, String string) {
        List<String> list = this.agentOutputFileMap.get(l);
        if (list == null) {
            list = new ArrayList<String>();
            this.agentOutputFileMap.put(l, list);
        }
        list.add(string);
    }

    void sendCompletion() {
        if (!this.sentCompletion) {
            try {
                this.mgr.sendCompletionForProcess(this);
                this.sentCompletion = true;
            }
            catch (Throwable throwable) {
                logger.info((Object)"Job completion was not sent.", throwable);
            }
        }
    }

    public boolean isJobCompletionSent() {
        return this.sentCompletion;
    }

    void processFinished() {
        this.sendCompletion();
        this.mgr.processEnded(this);
    }

    ProcessCommand buildFilePeerCommand() {
        String string = System.getProperty("user.dir") + File.separatorChar + "filepeer";
        string = this.platform instanceof UNIXPlatform ? string + ".sh" : this.platform.quoteString(string);
        CommandSetCommand commandSetCommand = new CommandSetCommand(string + " " + this.mgr.getPeer().getRemotePeerID().getPeerDescriptor().getPort() + " " + this.whenStarted);
        commandSetCommand.setCancelOnError(false);
        commandSetCommand.setReturnCode(JOB_SETUP_RETURN_CODE);
        ProcessCommand processCommand = new ProcessCommand(-2, commandSetCommand, 20);
        return processCommand;
    }

    private void buildJobConditionPeerCommand(List<ProcessCommand> list, JobCondition jobCondition) {
        String string = System.getProperty("user.dir") + File.separatorChar + "jcpeer";
        string = this.platform instanceof UNIXPlatform ? string + ".sh" : this.platform.quoteString(string);
        String string2 = "ENTERPRISE.AgentConditionsAM" + this.whenStarted;
        String string3 = String.valueOf(this.mgr.getPeer().getRemotePeerID().getPeerDescriptor().getPort());
        String string4 = string + " ";
        string4 = string4 + this.buildConditionCheckCommandString(string3, string2, jobCondition);
        CommandSetCommand commandSetCommand = new CommandSetCommand(string4);
        commandSetCommand.setReturnCode(JOB_SETUP_RETURN_CODE);
        ProcessCommand processCommand = new ProcessCommand(-3, commandSetCommand, 20);
        list.add(processCommand);
    }

    boolean isConnectedToServer() {
        return this.mgr.getPeer().getConnectedAgentServer() != null;
    }

    public void setFailedAtCommandSequence(int n) {
        this.failedAtCommandSequence = n;
    }

    public int getFailedAtCommandSequence() {
        return this.failedAtCommandSequence;
    }

    public void jobConditionsPeerConnected(PeerID peerID) {
    }

    private String buildConditionCheckCommandString(String string, String string2, JobCondition jobCondition) {
        String string3 = null;
        JobCondition[] jobConditionArray = this.ej.getJobConditions();
        if (jobConditionArray != null && jobConditionArray.length > 0) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(255);
            this.addFlagAndValue(stringBuilder, string, "u", true);
            this.addFlagAndValue(stringBuilder, string2, "q", true);
            this.addFlagAndValue(stringBuilder, String.valueOf(jobCondition.getOid()), "i", true);
            this.addFlagAndValue(stringBuilder, String.valueOf(jobCondition.getJobId()), "j", true);
            this.addFlagAndValue(stringBuilder, String.valueOf(jobCondition.getSequenceNumber()), "s", true);
            this.addFlagAndValue(stringBuilder, String.valueOf(jobCondition.getConditionType().persistanceCode()), "t", true);
            String string4 = jobCondition.getConditionData();
            if (jobCondition.getConditionType() == JobConditionType.PROCESS && string4 != null && !"".equals(string4)) {
                object = new BASE64Encoder();
                string4 = object.encode(string4.getBytes());
            } else if (string4.endsWith("\\")) {
                string4 = string4 + "\\";
            } else if (jobCondition.getConditionType() == JobConditionType.DRIVE_SPACE && string4.endsWith(":")) {
                string4 = string4 + "\\\\";
            }
            this.addFlagAndValue(stringBuilder, string4, "d", true);
            this.addFlagAndValue(stringBuilder, String.valueOf(jobCondition.getConditionVar1()), "n", true);
            this.addFlagAndValue(stringBuilder, String.valueOf(jobCondition.getConditionVar2()), "m", true);
            object = null;
            object = jobCondition.isConditionChoice() ? "yes" : "no";
            this.addFlagAndValue(stringBuilder, (String)object, "c", true);
            this.addFlagAndValue(stringBuilder, jobCondition.getConjunction(), "o", true);
            String string5 = jobCondition.getConditionData1();
            if (jobCondition.getConditionType() == JobConditionType.PROCESS && string5 != null && !"".equals(string5)) {
                this.addFlagAndValue(stringBuilder, string5, "y", false);
            }
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    public void bypassConditions() {
        logger.debug((Object)"Received notice to bypass conditions for this job.");
        this.processMonitor.bypassConditions();
    }

    public String getTerminationData() {
        return this.terminationData;
    }

    public void setTerminationData(String string) {
        this.terminationData = string;
    }

    public ArrayList<Long> getStartedSAPInterceptedJobIDs() {
        return this.startedSAPInterceptedJobIDs;
    }

    public void addStartedSAPInterceptedJobID(long l) {
        this.startedSAPInterceptedJobIDs.add(l);
    }

    public void addStartedSAPInterceptedJobIDs(ArrayList<Long> arrayList) {
        this.startedSAPInterceptedJobIDs.addAll(arrayList);
    }

    public void notifySAPXMIAuditLevelChange(long l, SAPXMIAuditLevel sAPXMIAuditLevel) {
        if (this.processMonitor != null) {
            this.processMonitor.updateSAPXMIAuditLevel(l, sAPXMIAuditLevel);
        }
    }

    private ProcessCommand buildAutoMateTaskCommandString(CommandSetCommand commandSetCommand) throws IOException {
        String string = AUTOMATE_SCRIPT_FILE + this.platform.getCommandExtension();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(new File(string).getAbsolutePath());
        stringBuilder.append("\" ");
        String string2 = this.buildAutoMateCommandFile(commandSetCommand);
        if (string2 == null) {
            throw new IOException("Could not find AutoMate Task Command file");
        }
        boolean bl = true;
        if (string.toLowerCase().endsWith(".sh")) {
            bl = false;
        }
        boolean bl2 = this.platform.isCSHShell(this.getSubShell());
        if (!bl && !bl2) {
            string2 = string2.replaceAll("\\$", "\\\\\\$");
        }
        stringBuilder.append(string2);
        commandSetCommand.setCommandString(stringBuilder.toString());
        return new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20);
    }

    private String buildAutoMateCommandFile(CommandSetCommand commandSetCommand) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (com.sun.jna.Platform.isMac()) {
            bl = false;
        }
        ScheduleJob scheduleJob = this.ej.getScheduleJob();
        String string = scheduleJob.getSkybotJobName();
        long l = this.ej.getJobHistory().getId();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (AgentControl.isWindows()) {
            stringBuilder2.append(DefaultConfigPath.getDefaultPath());
            stringBuilder2.append(File.separator);
            stringBuilder2.append("webservice");
        } else {
            object = System.getProperty("user.dir");
            stringBuilder2.append((String)object);
            stringBuilder2.append(File.separator);
            stringBuilder2.append("webservice");
            stringBuilder2.append(File.separator);
            stringBuilder2.append("requests");
        }
        object = new File(stringBuilder2.toString());
        if (!((File)object).exists()) {
            ((File)object).mkdir();
            if (!AgentControl.isWindows()) {
                try {
                    Runtime.getRuntime().exec("chmod 711 " + stringBuilder2.toString());
                }
                catch (IOException iOException) {
                    logger.error((Object)("Error setting permission on: " + stringBuilder2.toString()), (Throwable)iOException);
                }
            }
        }
        stringBuilder2.append(File.separator);
        stringBuilder2.append(this.ej.getAgent().getOid());
        stringBuilder2.append("_");
        stringBuilder2.append(l);
        stringBuilder2.append("_");
        stringBuilder2.append(commandSetCommand.getOid());
        stringBuilder2.append("_");
        stringBuilder2.append(string);
        stringBuilder2.append(".xml");
        this.deletedFileArray.put(commandSetCommand.getOid(), stringBuilder2.toString());
        try {
            switch (commandSetCommand.getCommandType()) {
                case 13: {
                    AutoMateTaskRequestComposite autoMateTaskRequestComposite = commandSetCommand.getAutoMateTaskRequest();
                    autoMateTaskRequestComposite.setSkybotJobName(string);
                    autoMateTaskRequestComposite.setSkybotJobHistoryID(l);
                    AutoMateTaskRequestComposite.saveToDisk(autoMateTaskRequestComposite, stringBuilder2.toString());
                    break;
                }
                case 14: {
                    AutoMateBPARequestComposite autoMateBPARequestComposite = commandSetCommand.getAutoMateBPARequest();
                    autoMateBPARequestComposite.setSkybotJobName(string);
                    autoMateBPARequestComposite.setSkybotJobHistoryID(l);
                    AutoMateBPARequestComposite.saveToDisk(autoMateBPARequestComposite, stringBuilder2.toString());
                    break;
                }
            }
            this.addFlagAndValue(stringBuilder, stringBuilder2.toString(), "xml", bl);
        }
        catch (IOException iOException) {
            logger.error((Object)("Error saving AutoMateTask file: " + stringBuilder2.toString()), (Throwable)iOException);
            return null;
        }
        return stringBuilder.toString();
    }

    private ProcessCommand buildInformaticaCommandString(CommandSetCommand commandSetCommand) {
        String string = "informatica" + this.platform.getCommandExtension();
        boolean bl = true;
        if (string.toLowerCase().endsWith(".sh")) {
            bl = false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(new File(string).getAbsolutePath());
        stringBuilder.append("\" ");
        stringBuilder.append(this.buildInformaticaKeyValuesPairs(commandSetCommand.getInfaWorkflowCmd(), bl));
        commandSetCommand.setCommandString(stringBuilder.toString());
        return new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20);
    }

    private String buildInformaticaKeyValuesPairs(InformaticaWorkflowCommand informaticaWorkflowCommand, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        InformaticaRepository informaticaRepository = informaticaWorkflowCommand.getInfaRepo();
        boolean bl2 = true;
        if (com.sun.jna.Platform.isMac()) {
            bl2 = false;
        }
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getDomain(), InfaCmdParamMarker.DOMAIN, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getRepoName(), InfaCmdParamMarker.REPO_NAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getInfaUserName(), InfaCmdParamMarker.USERNAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getEncryptedPassword(), InfaCmdParamMarker.PASSWORD, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getPasswordSalt(), InfaCmdParamMarker.PASSWORD_SALT, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, Integer.toString(informaticaRepository.getPort()), InfaCmdParamMarker.PORT, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getSystemName(), InfaCmdParamMarker.SYSTEM_NAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaRepository.getSecurityDomain(), InfaCmdParamMarker.SECURITY_DOMAIN, bl2);
        if (informaticaRepository.isUseHTTPS()) {
            this.addInformaticaFlagAndValue(stringBuilder, "yes", InfaCmdParamMarker.USE_HTTPS, bl2);
        } else {
            this.addInformaticaFlagAndValue(stringBuilder, "no", InfaCmdParamMarker.USE_HTTPS, bl2);
        }
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getFolderName(), InfaCmdParamMarker.FOLDER_NAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getWorkflowName(), InfaCmdParamMarker.WF_NAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getRunInstanceName(), InfaCmdParamMarker.RUN_INSTANCE_NAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getIntegrationSvcName(), InfaCmdParamMarker.INT_SVC_NAME, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getTaskInstancePath(), InfaCmdParamMarker.TASK_INSTANCE_PATH, bl2);
        if (informaticaWorkflowCommand.isRunTask()) {
            this.addInformaticaFlagAndValue(stringBuilder, "yes", InfaCmdParamMarker.RUN_ONLY, bl2);
        } else {
            this.addInformaticaFlagAndValue(stringBuilder, "no", InfaCmdParamMarker.RUN_ONLY, bl2);
        }
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getOsUser(), InfaCmdParamMarker.OS_USER, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getParameterFile(), InfaCmdParamMarker.PARAM_FILE, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, informaticaWorkflowCommand.getRequestMode().toString(), InfaCmdParamMarker.REQUEST_MODE, bl2);
        if (informaticaWorkflowCommand.isAbort()) {
            this.addInformaticaFlagAndValue(stringBuilder, "yes", InfaCmdParamMarker.ABORT, bl2);
        } else {
            this.addInformaticaFlagAndValue(stringBuilder, "no", InfaCmdParamMarker.ABORT, bl2);
        }
        if (informaticaWorkflowCommand.isRetrieveLog()) {
            this.addInformaticaFlagAndValue(stringBuilder, "yes", InfaCmdParamMarker.RETRIEVE_LOG, bl2);
        } else {
            this.addInformaticaFlagAndValue(stringBuilder, "no", InfaCmdParamMarker.RETRIEVE_LOG, bl2);
        }
        List<Parameter> list = informaticaWorkflowCommand.getParameterList();
        String string2 = string = "\"";
        boolean bl3 = this.platform.isCSHShell(this.getSubShell());
        if (bl3) {
            string2 = SINGLE_QUOTE;
        }
        for (Parameter parameter : list) {
            String string3 = parameter.getName();
            String string4 = parameter.getValue();
            String string5 = parameter.getScope();
            if (!bl && !bl3) {
                string3 = string3.replaceAll("\\$", "\\\\\\$");
            }
            stringBuilder.append(InfaCmdParamMarker.PARAM.persistanceCode());
            stringBuilder.append(" ");
            this.addInfaParameterFlagAndValue(stringBuilder, string3, bl2, string2);
            this.addInfaParameterFlagAndValue(stringBuilder, string4, bl2, string);
            this.addInfaParameterFlagAndValue(stringBuilder, string5, bl2, string);
        }
        ScheduleJob scheduleJob = this.ej.getScheduleJob();
        this.addInformaticaFlagAndValue(stringBuilder, Long.toString(scheduleJob.getSkybotJobNumber()), InfaCmdParamMarker.JOB_NUMBER, bl2);
        this.addInformaticaFlagAndValue(stringBuilder, scheduleJob.getName(), InfaCmdParamMarker.JOB_NAME, bl2);
        return stringBuilder.toString();
    }

    private void addInformaticaFlagAndValue(StringBuilder stringBuilder, InfaCmdParamMarker infaCmdParamMarker, String string) {
        String string2 = infaCmdParamMarker.persistanceCode();
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append('\"');
        if (string != null && string.endsWith("\\")) {
            String string3 = string.replaceAll("\\\\+$", "\\\\\\\\");
            stringBuilder.append(string3);
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append('\"');
        stringBuilder.append(' ');
    }

    private void addInformaticaFlagAndValue(StringBuilder stringBuilder, String string, InfaCmdParamMarker infaCmdParamMarker, boolean bl) {
        this.addInformaticaFlagAndValue(stringBuilder, infaCmdParamMarker, string);
        if (bl && this.platform instanceof UNIXPlatform) {
            stringBuilder.append("\\\n");
        }
    }

    private void addInfaParameterFlagAndValue(StringBuilder stringBuilder, String string, boolean bl, String string2) {
        stringBuilder.append(string2);
        if (string != null && string.endsWith("\\")) {
            String string3 = string.replaceAll("\\\\+$", "\\\\\\\\");
            stringBuilder.append(string3);
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(string2);
        stringBuilder.append(' ');
        if (bl && this.platform instanceof UNIXPlatform) {
            stringBuilder.append("\\\n");
        }
    }

    private ProcessCommand buildWebServiceCommandString(CommandSetCommand commandSetCommand) throws IOException {
        String string = "runwebservicereq" + this.platform.getCommandExtension();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(new File(string).getAbsolutePath());
        stringBuilder.append("\" ");
        String string2 = this.buildWebServiceKeyValuesPairs(commandSetCommand);
        if (string2 == null) {
            throw new IOException("Could not find Web Service Command file");
        }
        stringBuilder.append(string2);
        commandSetCommand.setCommandString(stringBuilder.toString());
        return new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20);
    }

    private String buildWebServiceKeyValuesPairs(CommandSetCommand commandSetCommand) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (com.sun.jna.Platform.isMac()) {
            bl = false;
        }
        ScheduleJob scheduleJob = this.ej.getScheduleJob();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (AgentControl.isWindows()) {
            stringBuilder2.append(DefaultConfigPath.getDefaultPath());
            stringBuilder2.append(File.separator);
            stringBuilder2.append("webservice");
        } else {
            object = System.getProperty("user.dir");
            stringBuilder2.append((String)object);
            stringBuilder2.append(File.separator);
            stringBuilder2.append("webservice");
            stringBuilder2.append(File.separator);
            stringBuilder2.append("requests");
        }
        object = new File(stringBuilder2.toString());
        if (!((File)object).exists()) {
            ((File)object).mkdir();
            if (!AgentControl.isWindows()) {
                try {
                    Runtime.getRuntime().exec("chmod 711 " + stringBuilder2.toString());
                }
                catch (IOException iOException) {
                    logger.error((Object)("Error setting permission on: " + stringBuilder2.toString()), (Throwable)iOException);
                }
            }
        }
        stringBuilder2.append(File.separator);
        stringBuilder2.append(this.ej.getAgent().getOid());
        stringBuilder2.append("_");
        stringBuilder2.append(this.ej.getJobHistory().getId());
        stringBuilder2.append("_");
        stringBuilder2.append(commandSetCommand.getOid());
        stringBuilder2.append("_");
        stringBuilder2.append(scheduleJob.getSkybotJobName());
        stringBuilder2.append(".xml");
        this.deletedFileArray.put(commandSetCommand.getOid(), stringBuilder2.toString());
        try {
            WebServiceRequestComposite.saveToDisk(commandSetCommand.getWebServiceCommand(), stringBuilder2.toString());
            this.addFlagAndValue(stringBuilder, stringBuilder2.toString(), "xml", bl);
        }
        catch (IOException iOException) {
            logger.error((Object)("Error saving Web Service file: " + stringBuilder2.toString()), (Throwable)iOException);
            return null;
        }
        return stringBuilder.toString();
    }

    private ProcessCommand buildInformaticaCloudCommandString(CommandSetCommand commandSetCommand, String string, String string2, String string3) {
        String string4 = "icjobrunner" + this.platform.getCommandExtension();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(new File(string4).getAbsolutePath());
        stringBuilder.append("\" ");
        stringBuilder.append(this.buildInformaticaCloudKeyValuesPairs(commandSetCommand.getInfaCloudCommand(), string, string2, string3));
        commandSetCommand.setCommandString(stringBuilder.toString());
        return new ProcessCommand(commandSetCommand.getLineNumber(), commandSetCommand, 20);
    }

    private String buildInformaticaCloudKeyValuesPairs(InformaticaCloudCommand informaticaCloudCommand, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        InformaticaCloudServer informaticaCloudServer = informaticaCloudCommand.getInfaCloudserver();
        boolean bl = true;
        if (com.sun.jna.Platform.isMac()) {
            bl = false;
        }
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudServer.getUserEmail(), InfaCloudParamMarker.USER_EMAIL, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudServer.getEncryptedPassword(), InfaCloudParamMarker.PASSWORD, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudServer.getPasswordSalt(), InfaCloudParamMarker.PASSWORD_SALT, bl);
        if (informaticaCloudServer.isVerboseLogging()) {
            this.addInformaticaCloudFlagAndValue(stringBuilder, "yes", InfaCloudParamMarker.VERBOSE, bl);
        } else {
            this.addInformaticaCloudFlagAndValue(stringBuilder, "no", InfaCloudParamMarker.VERBOSE, bl);
        }
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudServer.getBaseURL(), InfaCloudParamMarker.BASE_URL, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, String.valueOf(informaticaCloudServer.getInitialPollingInterval()), InfaCloudParamMarker.FIND_JOB_INTERVAL, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, String.valueOf(informaticaCloudServer.getInitialPollingAttempts()), InfaCloudParamMarker.FIND_JOB_MAX_TRIES, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, String.valueOf(informaticaCloudServer.getStatusPollingInterval()), InfaCloudParamMarker.STATUS_INTERVAL, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudServer.getName(), InfaCloudParamMarker.SERVER_NAME, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, String.valueOf(informaticaCloudServer.getOID()), InfaCloudParamMarker.SERVER_OID, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudCommand.getTaskName(), InfaCloudParamMarker.TASK_NAME, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, informaticaCloudCommand.getTaskType(), InfaCloudParamMarker.TASK_TYPE, bl);
        if (informaticaCloudCommand.isContinueImmediately()) {
            this.addInformaticaCloudFlagAndValue(stringBuilder, "yes", InfaCloudParamMarker.CONTINUE_IMMIDEATELY, bl);
        } else {
            this.addInformaticaCloudFlagAndValue(stringBuilder, "no", InfaCloudParamMarker.CONTINUE_IMMIDEATELY, bl);
        }
        this.addInformaticaCloudFlagAndValue(stringBuilder, string3, InfaCloudParamMarker.SKYBOT_JOB_NAME, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, string, InfaCloudParamMarker.RUN_NUMBER, bl);
        this.addInformaticaCloudFlagAndValue(stringBuilder, string2, InfaCloudParamMarker.AGENT_PORT_NUMBER, bl);
        return stringBuilder.toString();
    }

    private void addInformaticaCloudFlagAndValue(StringBuilder stringBuilder, InfaCloudParamMarker infaCloudParamMarker, String string) {
        String string2 = infaCloudParamMarker.persistanceCode();
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append('\"');
        if (string != null && string.endsWith("\\")) {
            String string3 = string.replaceAll("\\\\+$", "\\\\\\\\");
            stringBuilder.append(string3);
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append('\"');
        stringBuilder.append(' ');
    }

    private void addInformaticaCloudFlagAndValue(StringBuilder stringBuilder, String string, InfaCloudParamMarker infaCloudParamMarker, boolean bl) {
        this.addInformaticaCloudFlagAndValue(stringBuilder, infaCloudParamMarker, string);
        if (bl && this.platform instanceof UNIXPlatform) {
            stringBuilder.append("\\\n");
        }
    }

    private String serverName(PeerID peerID) {
        PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
        if (peerDescriptor != null) {
            return peerDescriptor.getPeerName();
        }
        return peerID.toString();
    }

    static {
        JOB_SETUP_RETURN_CODE.addActionCode("0");
        JOB_SETUP_RETURN_CODE.setSuccessTypeList(true);
    }
}

