/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.PostJobLogEntryHelperAM;
import com.helpsystems.enterprise.core.dm.SubmitFailedException;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.module.exec.JobProcess;
import com.helpsystems.enterprise.peer.preconditions.JobConditionHelper;
import org.apache.log4j.Logger;

public class JobConditionController {
    private static Logger logger = Logger.getLogger(JobConditionController.class);
    public static int FAILED = 0;
    public static int CANCELED = 1;
    public static int RUN_ANYWAY = 2;
    private JobTrackerAM jobTrackerAM;
    private PostJobLogEntryHelperAM postJobLogEntryHelperAM;
    private JobHistory localJobHistory = new JobHistory();

    public JobConditionController(PeerID peerID) {
        try {
            this.jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.JobTrackerAM");
        }
        catch (Exception exception) {
            logger.info((Object)"Can not get data manager for JobTrackerAM.", (Throwable)exception);
        }
        try {
            this.postJobLogEntryHelperAM = (PostJobLogEntryHelperAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.PostJobLogEntryHelperAM");
        }
        catch (Exception exception) {
            logger.info((Object)"Can not get data manager for PostJobLogEntryHelperAM.", (Throwable)exception);
        }
    }

    public synchronized void wakeUpRetryWaitJobs() {
        this.notifyAll();
    }

    public synchronized void openWayForNewThread() {
        this.notify();
    }

    public synchronized boolean controlNotMetJobCondition(JobCondition jobCondition, ExecutableJob executableJob, JobHistory jobHistory, JobProcess jobProcess) throws SubmitFailedException, ActionFailedException {
        String string = executableJob.getScheduleJob().getName();
        String string2 = executableJob.getEventID();
        if (executableJob.isCondRetry() && !executableJob.isIgnoreConditions()) {
            if (this.localJobHistory.getRetryNumber() >= executableJob.getCondRetryCount()) {
                this.conditionFailAction(jobCondition, executableJob, jobHistory, jobProcess);
                return false;
            }
            logger.trace((Object)("Setting run number " + string2 + " of job '" + string + "' status to " + "Condition Retry-Wait and saving " + "job history."));
            this.localJobHistory.setTerminationData(JobConditionHelper.getTerminationData((JobCondition)jobCondition));
            this.localJobHistory.setStatusCode(JobStatusCode.CONDITION_RETRY_WAIT);
            this.localJobHistory.setRetryNumber(this.localJobHistory.getRetryNumber() + 1);
            long l = executableJob.getCondRetryDelay() * 1000;
            long l2 = System.currentTimeMillis() + l;
            this.localJobHistory.setRetryNextTime(l2);
            if (jobHistory != null) {
                jobHistory.setTerminationData(this.localJobHistory.getTerminationData());
                jobHistory.setStatusCode(this.localJobHistory.getStatusCode());
                jobHistory.setRetryNumber(this.localJobHistory.getRetryNumber());
                jobHistory.setRetryNextTime(this.localJobHistory.getRetryNextTime());
                if (this.jobTrackerAM != null) {
                    try {
                        this.jobTrackerAM.jobRequeuedForRetry(jobHistory);
                    }
                    catch (Exception exception) {
                        logger.info((Object)exception);
                    }
                }
                if (jobHistory.getRetryNumber() == 1 && this.postJobLogEntryHelperAM != null) {
                    try {
                        this.postJobLogEntryHelperAM.postSLogEnterRetryWait(jobHistory, jobCondition);
                    }
                    catch (Exception exception) {
                        logger.info((Object)exception);
                    }
                }
            }
            if (l > 0L) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    logger.info((Object)interruptedException);
                }
            }
        } else {
            this.conditionFailAction(jobCondition, executableJob, jobHistory, jobProcess);
            return false;
        }
        return true;
    }

    private void conditionFailAction(JobCondition jobCondition, ExecutableJob executableJob, JobHistory jobHistory, JobProcess jobProcess) throws SubmitFailedException, ActionFailedException {
        String string = executableJob.getScheduleJob().getName();
        String string2 = executableJob.getEventID();
        String string3 = "Conditions were not met for Job '" + string + "' with run number " + string2;
        if (executableJob.getConditionFailStatus() == RUN_ANYWAY) {
            logger.debug((Object)(string3 + ".  Updating job history."));
            this.localJobHistory.setTerminationData(JobConditionHelper.getTerminationData((JobCondition)jobCondition));
            this.localJobHistory.setBypassConditions(true);
            long l = System.currentTimeMillis();
            this.localJobHistory.setRetryNextTime(l);
            if (jobHistory != null) {
                jobHistory.setTerminationData(this.localJobHistory.getTerminationData());
                jobHistory.setBypassConditions(this.localJobHistory.isBypassConditions());
                jobHistory.setRetryNextTime(this.localJobHistory.getRetryNextTime());
                if (this.postJobLogEntryHelperAM != null) {
                    try {
                        this.postJobLogEntryHelperAM.postSLogRunAnyway(jobHistory, jobCondition);
                    }
                    catch (Exception exception) {
                        logger.info((Object)exception);
                    }
                }
                if (this.jobTrackerAM != null) {
                    try {
                        this.jobTrackerAM.saveJobHistory(jobHistory);
                    }
                    catch (Exception exception) {
                        logger.info((Object)exception);
                    }
                }
            }
            executableJob.setIgnoreConditions(true);
            String string4 = "About to run job '" + string + "' run number " + string2 + " without " + "checking conditions.";
            logger.debug((Object)string4);
        } else {
            logger.debug((Object)(string3 + ".  Terminating job."));
            this.terminateJobEnd(jobCondition, executableJob, jobHistory, jobProcess);
        }
    }

    private void terminateJobEnd(JobCondition jobCondition, ExecutableJob executableJob, JobHistory jobHistory, JobProcess jobProcess) {
        String string = executableJob.getScheduleJob().getName();
        String string2 = executableJob.getAgent().getName();
        String string3 = executableJob.getEventID();
        JobStatusCode jobStatusCode = executableJob.getConditionFailStatus() == FAILED ? JobStatusCode.FAILED : JobStatusCode.CANCELED;
        this.localJobHistory.setStatusCode(jobStatusCode);
        this.localJobHistory.setJobEndedReasonCode(JobEndedReasonCode.CONDITION_NOT_MET);
        this.localJobHistory.setTerminationData(JobConditionHelper.getTerminationData((JobCondition)jobCondition));
        if (jobHistory != null) {
            jobHistory.setStatusCode(this.localJobHistory.getStatusCode());
            jobHistory.setJobEndedReasonCode(this.localJobHistory.getJobEndedReasonCode());
            jobHistory.setTerminationData(this.localJobHistory.getTerminationData());
        }
        logger.trace((Object)("A condition was not satisfied for job '" + string + "' with run number " + string3 + " on agent " + string2 + ".  Posting entry to schedule log."));
        char c = executableJob.getConditionFailStatus() == FAILED ? (char)'F' : 'A';
        jobProcess.setCompletionCode(c);
        jobProcess.setJobEndedReasonCode(JobEndedReasonCode.CONDITION_NOT_MET);
        jobProcess.setTerminationData(JobConditionHelper.getTerminationData((JobCondition)jobCondition));
        jobProcess.setTerminationReason("Job condition not met.");
        logger.trace((Object)("Terminating job '" + string + "' with run number " + string3 + " due to condition not satisfied on agent " + string2 + "."));
    }
}

