/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.DurableMap;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.RunnableThrottle;
import com.helpsystems.common.core.util.RunnableThrottleObject;
import com.helpsystems.common.core.util.RunnableThrottleRunner;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.OutputDistribution;
import com.helpsystems.enterprise.core.busobj.oracle.OracleCommand;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.JobCompletionDM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.OutputDistributionDM;
import com.helpsystems.enterprise.core.dm.OutputDistributionHistoryDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobsDM;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobCompletionInfo;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.module.exec.AgentOutputWorker;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobCompletionDMImpl
extends AbstractManager
implements JobCompletionDM {
    private static final Logger logger = Logger.getLogger(JobCompletionDMImpl.class);
    private static final RunnableThrottleRunner jcRunnableThrottleRunner = new JobCompletionThrottleRunner();
    private static final RunnableThrottle jcRunnableThrottle = new RunnableThrottle(20, "JobCompletion", "jobcompletion", jcRunnableThrottleRunner);
    private HashMap<String, ExecutableJob> socketMap;
    private HashMap<String, AgentOutputWorker> workerMap;
    private AgentPeer agentServer;
    private DurableMap durableMap;
    private HashMap<String, Integer> infoStateMap;
    private Object persistenceLock;

    public JobCompletionDMImpl(AgentPeer agentPeer) throws IOException {
        super.setName("ENTERPRISE.JobCompletionDM");
        this.agentServer = agentPeer;
        this.persistenceLock = new Object();
        this.socketMap = new HashMap();
        this.workerMap = new HashMap();
        this.infoStateMap = new HashMap();
        String string = System.getProperty("user.dir") + "/tmp";
        this.durableMap = new DurableMap(string, agentPeer.getRemotePeerID().getInstanceIdentifier().toString());
        if (this.durableMap.size() > 0) {
            Object object;
            Object object2;
            int n = 0;
            for (String string2 : this.durableMap.keySet()) {
                try {
                    Serializable serializable = this.durableMap.get(string2);
                    if (serializable instanceof JobCompletionInfo) {
                        object2 = ((JobCompletionInfo)((Object)serializable)).getExecutableJob().getEventID();
                        logger.debug((Object)("Adding eventID to backlog: " + (String)object2 + " complcode: " + ((JobCompletionInfo)((Object)serializable)).getCompletionCode()));
                        this.infoStateMap.put((String)object2, 0);
                        continue;
                    }
                    logger.debug((Object)("Ignoring non-JobInfo object: " + serializable.getClass().getName() + ":" + serializable));
                }
                catch (Exception exception) {
                    if (++n <= 5) {
                        logger.warn((Object)("Unable to restore off-line job completion information from " + string + "/" + string2), (Throwable)exception);
                    }
                    try {
                        this.durableMap.remove(string2);
                    }
                    catch (Exception exception2) {
                        logger.debug((Object)("Unable to delete file " + string + "/" + string2), (Throwable)exception2);
                    }
                }
            }
            if (n > 0) {
                object = "";
                object = n == 1 ? "a job" : n + " jobs";
                logger.warn((Object)("Unable to restore off-line job completion info for " + (String)object + ". If a job is still active, it will need to be ended manually."));
            }
            object = null;
            long l = SkybotStackSize.getStackSize();
            object2 = new BacklogProcessor();
            object = l != 0L ? new Thread(null, (Runnable)object2, "BacklogProcessor", l) : new Thread((Runnable)object2);
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(JobCompletionInfo jobCompletionInfo, int n) {
        String string = jobCompletionInfo.getExecutableJob().getEventID();
        Object object = this.persistenceLock;
        synchronized (object) {
            try {
                this.durableMap.put(string, (Serializable)((Object)jobCompletionInfo));
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to persist job completion history.", (Throwable)exception);
                return;
            }
            this.infoStateMap.put(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasJob(String string) {
        Object object = this.persistenceLock;
        synchronized (object) {
            try {
                Serializable serializable = this.durableMap.get(string);
                return serializable != null;
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to check for persisted job info.", (Throwable)exception);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpersist(String string) {
        Object object = this.persistenceLock;
        synchronized (object) {
            try {
                this.durableMap.remove(string);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to un-persist job completion history.", (Throwable)exception);
            }
            logger.debug((Object)("Removing eventID from backlog: " + string));
            this.infoStateMap.remove(string);
        }
    }

    @Override
    @Deprecated
    public void jobCompleted(JobCompletionInfo jobCompletionInfo, boolean bl) {
        jobCompletionInfo.setTerminatedByServer(bl);
        this.jobCompleted(jobCompletionInfo);
    }

    @Override
    public void jobCompleted(long l, long l2, long l3, JobCompletionInfo jobCompletionInfo) {
        ValidationHelper.checkForNull((String)"Job Completion Info", (Object)((Object)jobCompletionInfo));
        ExecutableJob executableJob = jobCompletionInfo.getExecutableJob();
        try {
            JobHistory jobHistory = this.getJobHistoryDM().get(l);
            if (jobHistory.getServerInitiatedTime() != l2) {
                jobHistory = new JobHistory();
                jobHistory.setId(l);
                jobHistory.setServerInitiatedTime(l2);
                Agent agent = new Agent();
                agent.setName("Unknown");
                executableJob.setAgent(agent);
            } else {
                jobHistory.setQueueEndedTime(l3);
                ScheduleJob scheduleJob = this.getScheduleJobDM().get(jobHistory.getJobID());
                executableJob.setScheduleJob(scheduleJob);
                Agent agent = this.getAgentDM().get(jobHistory.getAgentID());
                executableJob.setAgent(agent);
            }
            executableJob.setJobHistory(jobHistory);
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to mark the job history with run ID {0} as completed.", (Object[])new Object[]{l}), (Throwable)exception);
            return;
        }
        this.jobCompleted(jobCompletionInfo);
    }

    @Override
    public void jobCompleted(JobCompletionInfo jobCompletionInfo) {
        this.jobCompleted(jobCompletionInfo, 2);
    }

    private void jobCompleted(JobCompletionInfo jobCompletionInfo, int n) {
        this.persist(jobCompletionInfo, n);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Queuing Job Completion RunnableThrottle entry...");
        }
        jcRunnableThrottle.queue(new RunnableThrottleObject("JobCompletion", (Object)new JobCompletionInfoBucket(this, jobCompletionInfo, n)));
    }

    protected void startJobCompletedRunner(JobCompletionInfo jobCompletionInfo, int n, RunnableThrottle runnableThrottle) {
        Thread thread = null;
        JobCompletionRunner jobCompletionRunner = new JobCompletionRunner(jobCompletionInfo, n, runnableThrottle);
        long l = SkybotStackSize.getStackSize();
        thread = l != 0L ? new Thread(null, jobCompletionRunner, "JobCompletionRunner", l) : new Thread(jobCompletionRunner);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutableJob endJob(String string) {
        HashMap<String, AgentOutputWorker> hashMap = this.workerMap;
        synchronized (hashMap) {
            AgentOutputWorker agentOutputWorker = this.workerMap.remove(string);
            if (agentOutputWorker != null) {
                agentOutputWorker.terminate();
            }
        }
        this.unpersist(string);
        return this.removeSocket(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSocket(String string, ExecutableJob executableJob) {
        HashMap<String, ExecutableJob> hashMap = this.socketMap;
        synchronized (hashMap) {
            this.socketMap.put(string, executableJob);
        }
        this.checkForBackloggedInfo(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutableJob removeSocket(String string) {
        HashMap<String, ExecutableJob> hashMap = this.socketMap;
        synchronized (hashMap) {
            ExecutableJob executableJob = this.socketMap.remove(string);
            logger.debug((Object)("Removing socket for eventID: " + string));
            return executableJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyCompletion(String string, char c, boolean bl, boolean bl2) {
        Object object = this.persistenceLock;
        synchronized (object) {
            if (this.infoStateMap.get(string) != null && this.infoStateMap.get(string) != 0) {
                this.infoStateMap.put(string, 1);
            }
        }
        object = this.removeSocket(string);
        if (object == null && !bl) {
            if (!bl2) {
                logger.debug((Object)("Unable to notify the scheduler that a job completed. Event ID: " + string));
                return;
            }
            logger.warn((Object)("No Job History record exists to update for Event ID: " + string));
        }
        try {
            this.unpersist(string);
        }
        catch (Exception exception) {
            logger.error((Object)("Error communicating with the scheduler, Job Event ID: " + string), (Throwable)exception);
        }
    }

    @Override
    public int countWaitingSockets(String string, String string2) {
        return this.getWaitingSockets(string, string2).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutableJob[] getWaitingSockets(String string, String string2) {
        ArrayList<ExecutableJob> arrayList = new ArrayList<ExecutableJob>();
        ExecutableJob[] executableJobArray = this.socketMap;
        synchronized (this.socketMap) {
            for (ExecutableJob executableJob : this.socketMap.values()) {
                Agent agent = executableJob.getAgent();
                boolean bl = true;
                if (string != null && !Equal.isEqual((Object)string, (Object)agent.getHardwareHash())) {
                    bl = false;
                }
                if (string2 != null && !Equal.isEqual((Object)string2, (Object)agent.getInstanceIdentifier())) {
                    bl = false;
                }
                if (!bl) continue;
                arrayList.add(executableJob);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            executableJobArray = new ExecutableJob[arrayList.size()];
            arrayList.toArray(executableJobArray);
            return executableJobArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForBackloggedInfo(String string, boolean bl) {
        JobCompletionInfo jobCompletionInfo = null;
        HashMap<String, ExecutableJob> hashMap = this.persistenceLock;
        synchronized (hashMap) {
            if (!this.infoStateMap.containsKey(string)) {
                return;
            }
            int n = this.infoStateMap.get(string);
            if (n != 1 && n != 0) {
                return;
            }
            try {
                jobCompletionInfo = (JobCompletionInfo)((Object)this.durableMap.get(string));
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to restore off-line job info for event " + string + ".  The event will be removed."), (Throwable)exception);
                try {
                    this.durableMap.remove(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return;
            }
        }
        if (jobCompletionInfo != null && !this.isTerminalState(jobCompletionInfo.getCompletionCode())) {
            hashMap = this.socketMap;
            synchronized (hashMap) {
                if (this.socketMap.get(string) == null) {
                    logger.debug((Object)("Socket for eventID " + string + " is not present"));
                    return;
                }
            }
        }
        if (!jobCompletionInfo.isJobLogProcessFinished() && this.agentServer.getPeerFromRoutingTable(jobCompletionInfo.getPeerID()) == null && bl) {
            logger.debug((Object)"The Joblog has not been processed, but the Agent is not ready.");
            return;
        }
        if (jobCompletionInfo.getCompletionCode() == 'C') {
            this.checkAgentOutput(jobCompletionInfo);
        }
        jobCompletionInfo.setFileTransferFinished(true);
        this.jobCompleted(jobCompletionInfo, 0);
    }

    private int failPendingOPDHRecord(long l) {
        int n = 0;
        if (l > 0L) {
            OutputDistributionHistoryDM outputDistributionHistoryDM = (OutputDistributionHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.OutputDistributionHistoryDM");
            n = outputDistributionHistoryDM.markPendingFailed(l, 0);
        }
        return n;
    }

    private AgentDM getAgentDM() {
        return (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
    }

    private JobHistoryDM getJobHistoryDM() {
        return (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
    }

    private ScheduleJobDM getScheduleJobDM() {
        return (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
    }

    private void checkAgentOutput(JobCompletionInfo jobCompletionInfo) {
        this.checkAgentOutput(jobCompletionInfo, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAgentOutput(JobCompletionInfo jobCompletionInfo, boolean bl, OutputDistribution[] outputDistributionArray) {
        if (jobCompletionInfo.getExecutableJob() == null) {
            logger.debug((Object)"Executable Job info missing for the current job");
            return;
        }
        ScheduleJob scheduleJob = jobCompletionInfo.getExecutableJob().getScheduleJob();
        if (scheduleJob == null) {
            logger.debug((Object)"Schedule Job info missing for the current job.");
            return;
        }
        String string = scheduleJob.getName();
        if (jobCompletionInfo.isFileTransferFinished()) {
            logger.debug((Object)("File Transfer marked as already completed for Job " + string));
            return;
        }
        long l = Long.parseLong(jobCompletionInfo.getExecutableJob().getEventID());
        OutputDistribution[] outputDistributionArray2 = null;
        if (bl) {
            Class<JobCompletionDMImpl> clazz = JobCompletionDMImpl.class;
            synchronized (JobCompletionDMImpl.class) {
                long l2 = jobCompletionInfo.getExecutableJob().getScheduleJob().getSkybotJobNumber();
                OutputDistributionDM outputDistributionDM = null;
                try {
                    outputDistributionDM = MRHelper.getOutputDistributionDM();
                    outputDistributionArray2 = outputDistributionDM.getByJobId(l2);
                }
                catch (Exception exception) {
                    String string2 = "Error while retrieving the output distribution for job " + string;
                    logger.debug((Object)string2, (Throwable)exception);
                    this.failPendingOPDHRecord(l);
                    // ** MonitorExit[var9_8] (shouldn't be in output)
                    return;
                }
            }
        }
        outputDistributionArray2 = outputDistributionArray;
        {
            if (outputDistributionArray2 == null || outputDistributionArray2.length < 1) {
                if (jobCompletionInfo.isSupportingOutputDistribution()) {
                    logger.debug((Object)("No Agent Output Distribution info found for job " + string));
                } else {
                    logger.debug((Object)"Any File Distributions were not loaded.");
                }
                this.failPendingOPDHRecord(l);
                return;
            }
            for (int i = 0; i < outputDistributionArray2.length; ++i) {
                if (!outputDistributionArray2[i].isFailOnMissingFiles()) continue;
                if (this.failPendingOPDHRecord(l) > 0) {
                    jobCompletionInfo.setCompletionCode('F');
                    jobCompletionInfo.setJobEndedReasonCode(JobEndedReasonCode.OUTPUT_DISTRIBUTION);
                }
                return;
            }
            return;
        }
    }

    private boolean isTerminalState(char c) {
        JobStatusCode jobStatusCode = JobStatusCode.persistanceCodeToEnum(String.valueOf(c));
        return JobStatusCode.TERMINAL_STATES.contains(jobStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobCompletionInfo getJobCompletionInfo(String string) {
        JobCompletionInfo jobCompletionInfo = null;
        Object object = this.persistenceLock;
        synchronized (object) {
            try {
                jobCompletionInfo = (JobCompletionInfo)((Object)this.durableMap.get(string));
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to choose for persisted job info.", (Throwable)exception);
            }
        }
        return jobCompletionInfo;
    }

    public void processDiscrepancyLogEntries(String string, JobHistory jobHistory, JobCompletionInfo jobCompletionInfo) {
        boolean bl = false;
        switch (jobHistory.getStatusCode()) {
            case COMPLETED: {
                switch (jobCompletionInfo.getCompletionCode()) {
                    case 'A': 
                    case 'E': 
                    case 'F': {
                        bl = true;
                    }
                }
                break;
            }
            case CANCELED: {
                switch (jobCompletionInfo.getCompletionCode()) {
                    case 'C': 
                    case 'E': 
                    case 'F': {
                        bl = true;
                    }
                }
                break;
            }
            case FAILED: {
                switch (jobCompletionInfo.getCompletionCode()) {
                    case 'A': 
                    case 'C': 
                    case 'E': {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            String string2 = "";
            if (jobHistory.getJobEndedReasonCode() != null) {
                string2 = jobHistory.getJobEndedReasonCode().name();
            }
            JobStatusCode jobStatusCode = JobStatusCode.persistanceCodeToEnum(String.valueOf(jobCompletionInfo.getCompletionCode()));
            String string3 = null;
            if (jobCompletionInfo.getJobEndedReasonCode() != null) {
                string3 = jobCompletionInfo.getJobEndedReasonCode().name();
            }
            String string4 = String.valueOf(jobCompletionInfo.getFailedAtCommandSequence());
            String[] stringArray = new String[]{jobHistory.getAgentName(), jobHistory.getJobName(), string, jobStatusCode.name(), string3, string4, jobHistory.getStatusCode_asText(), string2};
            ScheduleLogEntry scheduleLogEntry = string3 != null ? (jobCompletionInfo.getFailedAtCommandSequence() > 0 ? RosettaMsg.JOB_DELAYED_COMMAND_FAILURE_WITH_PRIOR_INFO.newLogEntry(stringArray) : RosettaMsg.JOB_DELAYED_COMPLETION_WITH_REASON_AND_PRIOR_INFO.newLogEntry(stringArray)) : RosettaMsg.JOB_DELAYED_COMPLETION_WITH_PRIOR_INFO.newLogEntry(stringArray);
            scheduleLogEntry.setAgentID(jobHistory.getAgentID());
            scheduleLogEntry.setJobID(jobHistory.getJobID());
            scheduleLogEntry.setJobHistoryID(jobHistory.getId());
            ScheduleLogger.write(scheduleLogEntry);
        }
    }

    private void postDelayedCompletionMessage(JobCompletionInfo jobCompletionInfo, boolean bl) {
        try {
            ExecutableJob executableJob = jobCompletionInfo.getExecutableJob();
            JobStatusCode jobStatusCode = JobStatusCode.persistanceCodeToEnum(String.valueOf(jobCompletionInfo.getCompletionCode()));
            String string = "";
            if (jobCompletionInfo.getJobEndedReasonCode() != null) {
                string = jobCompletionInfo.getJobEndedReasonCode().name();
            }
            String[] stringArray = new String[]{executableJob.getAgent().getName(), executableJob.getScheduleJob().getName(), executableJob.getEventID(), jobStatusCode.name(), string, String.valueOf(jobCompletionInfo.getFailedAtCommandSequence())};
            ScheduleLogEntry scheduleLogEntry = bl ? RosettaMsg.JOB_HISTORY_RECORD_MISMATCH.newLogEntry(stringArray) : (jobStatusCode.equals(JobStatusCode.COMPLETED) ? RosettaMsg.JOB_DELAYED_COMPLETION_INFO.newLogEntry(stringArray) : (jobCompletionInfo.getFailedAtCommandSequence() > 0 ? RosettaMsg.JOB_DELAYED_COMMAND_FAILURE_INFO.newLogEntry(stringArray) : RosettaMsg.JOB_DELAYED_FAILURE_INFO.newLogEntry(stringArray)));
            scheduleLogEntry.setAgentID(executableJob.getAgent().getOid());
            scheduleLogEntry.setJobID(executableJob.getScheduleJob().getSkybotJobNumber());
            scheduleLogEntry.setJobHistoryID(Long.valueOf(executableJob.getEventID()));
            ScheduleLogger.write(scheduleLogEntry);
        }
        catch (Exception exception) {
            logger.error((Object)"Error posting Schedule Log Entry.", (Throwable)exception);
        }
    }

    static {
        Thread thread = new Thread((Runnable)jcRunnableThrottle);
        thread.start();
    }

    protected static class JobCompletionThrottleRunner
    implements RunnableThrottleRunner {
        protected JobCompletionThrottleRunner() {
        }

        public void startThread(RunnableThrottleObject runnableThrottleObject, RunnableThrottle runnableThrottle) {
            JobCompletionInfoBucket jobCompletionInfoBucket = (JobCompletionInfoBucket)runnableThrottleObject.getRequest();
            jobCompletionInfoBucket.jobCompletionDMImpl.startJobCompletedRunner(jobCompletionInfoBucket.info, jobCompletionInfoBucket.state, runnableThrottle);
        }
    }

    private class JobCompletionInfoBucket {
        JobCompletionInfo info;
        int state;
        JobCompletionDMImpl jobCompletionDMImpl;

        public JobCompletionInfoBucket(JobCompletionDMImpl jobCompletionDMImpl2, JobCompletionInfo jobCompletionInfo, int n) {
            this.info = jobCompletionInfo;
            this.state = n;
            this.jobCompletionDMImpl = jobCompletionDMImpl2;
        }
    }

    class BacklogProcessor
    implements Runnable {
        private HashSet<String> oldInfoSet = new HashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BacklogProcessor() {
            Object object = JobCompletionDMImpl.this.persistenceLock;
            synchronized (object) {
                for (Map.Entry entry : JobCompletionDMImpl.this.infoStateMap.entrySet()) {
                    if ((Integer)entry.getValue() != 0) continue;
                    this.oldInfoSet.add((String)entry.getKey());
                }
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Backlog Processor");
            long l = System.currentTimeMillis();
            while (this.oldInfoSet.size() > 0) {
                this.processBackloggedEntries(true);
                long l2 = System.currentTimeMillis();
                if (l2 - l > 300000L) {
                    this.processBackloggedEntries(false);
                    this.abandonMap();
                    for (String string : this.oldInfoSet) {
                        JobCompletionDMImpl.this.unpersist(string);
                    }
                    return;
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void processBackloggedEntries(boolean bl) {
            for (String string : this.oldInfoSet) {
                JobCompletionDMImpl.this.checkForBackloggedInfo(string, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void abandonMap() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Abandoning the following old job completion info:");
            Object object = JobCompletionDMImpl.this.persistenceLock;
            synchronized (object) {
                HashSet hashSet = new HashSet(JobCompletionDMImpl.this.infoStateMap.keySet());
                for (String string : hashSet) {
                    JobCompletionInfo jobCompletionInfo = null;
                    try {
                        jobCompletionInfo = (JobCompletionInfo)((Object)JobCompletionDMImpl.this.durableMap.get(string));
                    }
                    catch (Exception exception) {
                        logger.debug((Object)("Unable to restore off-line job info for event " + string), (Throwable)exception);
                        continue;
                    }
                    ExecutableJob executableJob = jobCompletionInfo.getExecutableJob();
                    String string2 = jobCompletionInfo.getPeerID().getPeerDescriptor().getComputerName();
                    if (executableJob != null && executableJob.getAgent() != null && executableJob.getAgent().getName() != null) {
                        string2 = executableJob.getAgent().getName();
                    }
                    String string3 = "Unknown";
                    if (executableJob != null && executableJob.getScheduleJob() != null && executableJob.getScheduleJob().getName() != null) {
                        string3 = executableJob.getScheduleJob().getName();
                    }
                    long l = jobCompletionInfo.getWhenStarted();
                    String string4 = "Unknown";
                    if (l > 0L) {
                        string4 = DateTranslator.formatDateTime((Date)new Date(l));
                    }
                    stringBuilder.append("\nJob= " + string3 + ", EventID= " + string);
                    stringBuilder.append(", Agent= " + string2 + ", Date Started= ");
                    stringBuilder.append(string4);
                }
                logger.debug((Object)stringBuilder);
            }
        }
    }

    class JobCompletionRunner
    implements Runnable {
        JobCompletionInfo info;
        int state;
        String mainThreadName;
        RunnableThrottle throttle = null;

        JobCompletionRunner(JobCompletionInfo jobCompletionInfo, int n, RunnableThrottle runnableThrottle) {
            this.info = jobCompletionInfo;
            this.state = n;
            this.throttle = runnableThrottle;
            this.mainThreadName = "Job Completion Runner for " + jobCompletionInfo.getExecutableJob().getScheduleJob().getSkybotJobName() + ":" + jobCompletionInfo.getExecutableJob().getEventID();
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName(this.mainThreadName);
                this.runJCR();
            }
            finally {
                if (this.throttle != null) {
                    this.throttle.releaseSemaphore();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJCR() {
            Object object;
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string = this.info.getExecutableJob().getEventID();
            char c = this.info.getCompletionCode();
            int n = this.info.getFailedAtCommandSequence();
            logger.debug((Object)("Job completed - name: " + this.info.getExecutableJob().getJobHistory().getJobName() + " eventID: " + string + " Code: " + c + " CMD Seq#: " + n), this.info.getCause());
            this.processOracleRequestResults(string);
            if (this.info.getStartedSAPInterceptedJobIDs().size() > 0) {
                object2 = (SAPInterceptedJobsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPInterceptedJobsDM");
                try {
                    object2.update(this.info.getStartedSAPInterceptedJobIDs(), SAPInterceptedJob.InterceptedJobStatus.COMPLETED);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)("Error updating intercepted jobs with the status of " + SAPInterceptedJob.InterceptedJobStatus.COMPLETED));
                }
            }
            object2 = (JobHistoryDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobHistoryDM");
            JobHistory jobHistory = null;
            try {
                jobHistory = object2.get(new Long(string));
                if (jobHistory != null && jobHistory.getServerInitiatedTime() != this.info.getExecutableJob().getJobHistory().getServerInitiatedTime()) {
                    bl2 = true;
                    bl3 = true;
                    jobHistory = null;
                }
            }
            catch (NoDataException noDataException) {
                bl2 = true;
            }
            catch (Exception exception) {
                logger.error((Object)"Error obtaining Job History record for completed job.", (Throwable)exception);
            }
            if (jobHistory != null) {
                if (jobHistory.getQueueEndedTime() == 0L) {
                    try {
                        object = this.info.getExecutableJob().getJobHistory();
                        jobHistory.setQueueEndedTime(((JobHistory)((Object)object)).getQueueEndedTime());
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"*** Potential backlevel Agent.  Unable to get Queue Ended Time from JobCompletionInfo.", (Throwable)exception);
                    }
                }
                if (!((String)(object = this.info.getExecutableJob().getAgent().getName())).equals(jobHistory.getAgentName())) {
                    logger.debug((Object)("An agent name change was detected: The starting agent name was " + jobHistory.getAgentName() + " the agent the job finished is " + (String)object));
                    jobHistory.setAgentName((String)object);
                }
                jobHistory.setAgentEndedTime(this.info.getWhenEnded());
                if (jobHistory.getStatusCode().isTerminalState()) {
                    this.info.setTerminatedByServer(true);
                    JobCompletionDMImpl.this.processDiscrepancyLogEntries(string, jobHistory, this.info);
                } else {
                    jobHistory.setStatusCode_asStr(String.valueOf(c));
                    if (jobHistory.getStatusCode().equals(JobStatusCode.FAILED) || jobHistory.getStatusCode().equals(JobStatusCode.CANCELED) || jobHistory.getStatusCode().equals(JobStatusCode.ERROR)) {
                        if (this.info.getJobEndedReasonCode() != null) {
                            jobHistory.setJobEndedReasonCode(this.info.getJobEndedReasonCode());
                            if (jobHistory.getJobEndedReasonCode().equals(JobEndedReasonCode.COMMAND_FAILURE)) {
                                jobHistory.setFailedAtCommandSequence(n);
                            }
                        } else if (n >= 0) {
                            jobHistory.setFailedAtCommandSequence(n);
                            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_FAILURE);
                        } else {
                            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.INITIALIZATION_FAILURE);
                        }
                    }
                }
                if (!this.info.isJobLogProcessFinished()) {
                    this.doAgentOutput();
                    if (jobHistory.getStatusCode().equals(JobStatusCode.COMPLETED) && jobHistory.getJobEndedReasonCode() == null && c == 'F') {
                        jobHistory.setStatusCode_asStr(String.valueOf(c));
                        jobHistory.setJobEndedReasonCode(this.info.getJobEndedReasonCode());
                    }
                }
                Thread.currentThread().setName(this.mainThreadName + "-" + " Finalizing Completion");
                jobHistory.setCopiedJobLogToServer(this.info.isJobExecLogTransferred());
                jobHistory.setTerminationData(this.info.getTerminationData());
                PeerID peerID = this.info.getFilePeerID();
                if (peerID != null) {
                    JobCompletionDMImpl.this.agentServer.disconnectFromPeer(peerID);
                }
                if (jobHistory.getAgentStartedTime() == 0L) {
                    jobHistory.setAgentStartedTime(this.info.getWhenStarted());
                }
                JobTrackerAM jobTrackerAM = (JobTrackerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobTrackerAM");
                try {
                    jobTrackerAM.jobCompletedByAgent(jobHistory, this.info.wasTerminatedByServer());
                    bl = true;
                }
                catch (ActionFailedException actionFailedException) {
                    if (actionFailedException.getCause() instanceof InvalidStateException) {
                        logger.debug((Object)actionFailedException.getCause().getMessage());
                    }
                    try {
                        if (this.info.wasTerminatedByServer()) {
                            object2.updateAgentInfo(jobHistory.getId(), this.info.getWhenEnded());
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error updating Job History for completed job.", (Throwable)exception);
                    }
                }
            } else if (this.state != 0) {
                JobCompletionDMImpl.this.postDelayedCompletionMessage(this.info, bl3);
            }
            object = JobCompletionDMImpl.this.workerMap;
            synchronized (object) {
                JobCompletionDMImpl.this.workerMap.remove(string);
            }
            JobCompletionDMImpl.this.replyCompletion(string, c, bl, bl2);
        }

        private void processOracleRequestResults(String string) {
            try {
                HashMap<Integer, OracleCommand> hashMap = this.info.getExecutableJob().getOracleRequestsHM();
                for (Integer n : hashMap.keySet()) {
                    OracleCommand oracleCommand = hashMap.get(n);
                    logger.debug((Object)("Oracle Command " + oracleCommand.getOID() + " of type " + (Object)((Object)oracleCommand.getOracleCommandType()) + " in eventID " + string + " has Oracle Request ID: " + n + " and status " + oracleCommand.getOracleStatusCode().getDescription()));
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error processing Oracle request results.", (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAgentOutput() {
            Object object;
            String string = this.info.getExecutableJob().getScheduleJob().getName();
            String string2 = this.info.getExecutableJob().getEventID();
            String string3 = "";
            string3 = this.state == 0 ? "- Transferring Backlog Files" : "- Transferring Files";
            Thread.currentThread().setName(this.mainThreadName + string3);
            OutputDistribution[] outputDistributionArray = null;
            try {
                AgentOutputWorker agentOutputWorker = new AgentOutputWorker(this.info, JobCompletionDMImpl.this.agentServer);
                outputDistributionArray = agentOutputWorker.getOutputDistributions();
                object = JobCompletionDMImpl.this.workerMap;
                synchronized (object) {
                    JobCompletionDMImpl.this.workerMap.put(string2, agentOutputWorker);
                }
                agentOutputWorker.run();
            }
            catch (Throwable throwable) {
                object = "Unable to process agent output for job " + string;
                logger.error(object, throwable);
                this.info.setTerminationReason((String)object);
            }
            JobCompletionDMImpl.this.checkAgentOutput(this.info, false, outputDistributionArray);
            this.info.setJobLogProcessingFinished(true);
            int n = 1;
            object = JobCompletionDMImpl.this.persistenceLock;
            synchronized (object) {
                if (JobCompletionDMImpl.this.infoStateMap.get(string2) != null && (Integer)JobCompletionDMImpl.this.infoStateMap.get(string2) == 0) {
                    n = 0;
                }
            }
            logger.debug((Object)("Persisting EventID: " + string2 + " as State: " + n));
            JobCompletionDMImpl.this.persist(this.info, n);
        }
    }
}

