/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.informatica.ConsoleLogger;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaRepository;
import com.helpsystems.enterprise.core.busobj.informatica.InformaticaWorkflowCommand;
import com.helpsystems.enterprise.core.busobj.informatica.SkybotParam;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.DIServiceInfo;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.DataIntegrationServiceLocator;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TaskDetails;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.TaskRequest;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.WorkflowDetails;
import com.helpsystems.enterprise.core.busobj.informatica.dataintegration.WorkflowRequest;
import com.helpsystems.enterprise.core.cmdlineobj.InformaticaCommand;
import com.helpsystems.enterprise.core.cmdlineobj.InformaticaDetails;
import com.helpsystems.enterprise.module.informatica.ConnectionTracker;
import com.helpsystems.enterprise.module.informatica.DataIntegrationSupport;
import com.helpsystems.enterprise.module.informatica.InformaticaConnectionProvider;
import com.helpsystems.enterprise.module.informatica.RunningResult;

public class InformaticaController
extends DataIntegrationSupport {
    public static final String ENVVAR_INFO_LOGIN_ATTEMPTS = "INFO_LOGIN_ATTEMPTS";
    public static final String ENVVAR_INFO_LOGIN_INTERVAL = "INFO_LOGIN_INTERVAL";
    public static final String ENVVAR_INFO_STATUS_POLLING = "INFO_STATUS_POLL";
    public static final String ENVVAR_INFO_STATUS_POLLING_INTERVAL = "INFO_STATUS_POLL_INTERVAL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningResult execute(InformaticaCommand informaticaCommand) throws Exception {
        ConnectionTracker connectionTracker;
        RunningResult runningResult;
        block25: {
            InformaticaDetails informaticaDetails = informaticaCommand.getInformaticaDetails();
            InformaticaConnectionProvider informaticaConnectionProvider = new InformaticaConnectionProvider();
            InformaticaRepository informaticaRepository = informaticaDetails.getRepo();
            InformaticaWorkflowCommand informaticaWorkflowCommand = informaticaDetails.getWfCmd();
            SkybotParam skybotParam = informaticaDetails.getSkybotParam();
            runningResult = new RunningResult();
            InformaticaController.validate(informaticaDetails);
            connectionTracker = null;
            try {
                Object object;
                Object object2;
                block24: {
                    DataIntegrationServiceLocator dataIntegrationServiceLocator = new DataIntegrationServiceLocator();
                    String string = informaticaRepository.getDIWSHUrl();
                    dataIntegrationServiceLocator.setDataIntegrationEndpointAddress(string);
                    long l = 30L;
                    long l2 = 10L;
                    try {
                        object2 = System.getenv(ENVVAR_INFO_LOGIN_ATTEMPTS);
                        if (object2 != null && ((String)object2).trim().length() > 0) {
                            l = Long.valueOf(((String)object2).trim());
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Error loading environment variable: INFO_LOGIN_ATTEMPTS");
                    }
                    try {
                        object2 = System.getenv(ENVVAR_INFO_LOGIN_INTERVAL);
                        if (object2 != null && ((String)object2).trim().length() > 0) {
                            l2 = Long.valueOf(((String)object2).trim());
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Error loading environment variable: INFO_LOGIN_INTERVAL");
                    }
                    connectionTracker = new ConnectionTracker(dataIntegrationServiceLocator, informaticaConnectionProvider, informaticaRepository, l, l2);
                    try {
                        object2 = System.getenv(ENVVAR_INFO_STATUS_POLLING);
                        if (object2 != null && ((String)object2).trim().equalsIgnoreCase("true")) {
                            connectionTracker.setUseStatusPolling(true);
                            System.out.println("Status polling will be used for monitoring workflow/task completion.");
                        }
                        if ((object = System.getenv(ENVVAR_INFO_STATUS_POLLING_INTERVAL)) == null || ((String)object).trim().length() <= 0) break block24;
                        long l3 = 0L;
                        try {
                            l3 = Long.valueOf(((String)object).trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Error parsing polling interval parameter: " + (String)object);
                        }
                        if (l3 > 1L) {
                            connectionTracker.setUseStatusPollingInterval(l3);
                            System.out.println("Workflow/task polling interval has been specified (milliseconds): " + l3);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Error loading polling parameters: " + exception.getMessage());
                    }
                }
                this.logIn(connectionTracker);
                object2 = new DIServiceInfo();
                ((DIServiceInfo)object2).setDomainName(informaticaRepository.getDomain());
                ((DIServiceInfo)object2).setServiceName(informaticaWorkflowCommand.getIntegrationSvcName());
                if (!informaticaWorkflowCommand.isRunTask()) {
                    object = this.startWorkflow(connectionTracker.getDiInterface(), (DIServiceInfo)object2, informaticaWorkflowCommand, skybotParam);
                    ((WorkflowRequest)object).setKey(null);
                    ((WorkflowRequest)object).setAttribute(null);
                    WorkflowDetails workflowDetails = null;
                    if (connectionTracker.isUseStatusPolling()) {
                        workflowDetails = this.pollStatusForWorkflowCompletion((WorkflowRequest)object, (DIServiceInfo)object2, connectionTracker);
                    } else {
                        this.waitForWorkflow(connectionTracker.getDiInterface(), (WorkflowRequest)object);
                        workflowDetails = this.getWorkflowDetails(connectionTracker.getDiInterface(), (WorkflowRequest)object, (DIServiceInfo)object2, false);
                    }
                    if (workflowDetails != null) {
                        this.logWorkflowDetails(workflowDetails);
                        runningResult.setErrCode(workflowDetails.getRunErrorCode());
                        runningResult.setRunStatus(workflowDetails.getWorkflowRunStatus().toString());
                    }
                    if (informaticaWorkflowCommand.isRetrieveLog()) {
                        this.getWorkflowLog(connectionTracker.getDiInterface(), (WorkflowRequest)object);
                    } else {
                        ConsoleLogger.println("Workflow log will not be retrieved.");
                    }
                    break block25;
                }
                object = this.startTask(connectionTracker.getDiInterface(), (DIServiceInfo)object2, informaticaWorkflowCommand, skybotParam);
                TaskDetails taskDetails = null;
                if (connectionTracker.isUseStatusPolling()) {
                    taskDetails = this.pollStatusForTaskCompletion((TaskRequest)object, (DIServiceInfo)object2, connectionTracker);
                } else {
                    this.waitForTask(connectionTracker.getDiInterface(), (TaskRequest)object);
                    taskDetails = this.getTaskDetails(connectionTracker.getDiInterface(), (TaskRequest)object, false);
                }
                if (taskDetails != null) {
                    this.logTaskDetails(taskDetails);
                    runningResult.setErrCode(taskDetails.getRunErrorCode());
                    runningResult.setRunStatus(taskDetails.getTaskRunStatus().toString());
                }
                if (informaticaWorkflowCommand.isRetrieveLog()) {
                    this.getTaskLog(connectionTracker.getDiInterface(), (TaskRequest)object);
                    break block25;
                }
                ConsoleLogger.println("Task log will not be retrieved.");
            }
            catch (Throwable throwable) {
                this.logout(connectionTracker);
                throw throwable;
            }
        }
        this.logout(connectionTracker);
        return runningResult;
    }

    private static void validate(InformaticaDetails informaticaDetails) {
        InformaticaRepository informaticaRepository = informaticaDetails.getRepo();
        InformaticaWorkflowCommand informaticaWorkflowCommand = informaticaDetails.getWfCmd();
        SkybotParam skybotParam = informaticaDetails.getSkybotParam();
        ValidationHelper.validateReqFieldForNullAndBlank((String)"User name", (String)informaticaRepository.getInfaUserName());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Password", (String)informaticaRepository.getEncryptedPassword());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Domain", (String)informaticaRepository.getDomain());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"System Name", (String)informaticaRepository.getSystemName());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Repository Name", (String)informaticaRepository.getRepoName());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Folder Name", (String)informaticaWorkflowCommand.getFolderName());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Workflow Name", (String)informaticaWorkflowCommand.getWorkflowName());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Integration Service Name", (String)informaticaWorkflowCommand.getIntegrationSvcName());
        ValidationHelper.validateReqFieldForNullAndBlank((String)"Automate Schedule Job Name", (String)skybotParam.getSkybotJobName());
        ValidationHelper.checkForNull((String)"Automate Schedule Job Number", (Object)skybotParam.getSkybotJobNumber());
        if (informaticaRepository.getPort() <= 0) {
            throw new IllegalArgumentException("Port argument is not valid");
        }
    }
}

