/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.exec;

import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConditionCheckLocker {
    private static final Logger logger = Logger.getLogger(ConditionCheckLocker.class);
    private static Object locker = new Object();
    private static HashMap<String, Long> lockHash = new HashMap();
    private static final long MAX_WAIT = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void startConditionCheckForJob(String string, long l) {
        logger.debug((Object)("ConditionCheckLocker is locking user: " + string + " with job history id: " + l));
        Object object = locker;
        // MONITORENTER : object
        long l2 = System.currentTimeMillis();
        while (true) {
            HashMap<String, Long> hashMap = lockHash;
            // MONITORENTER : hashMap
            if (!lockHash.containsKey(string)) {
                lockHash.put(string, l);
                // MONITOREXIT : hashMap
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : hashMap
            if (System.currentTimeMillis() - l2 > 300000L) {
                logger.warn((Object)("Process to lock user: " + string + " with job history ID: " + l + " timed out and the lock was not added."));
                ConditionCheckLocker.logLockHashContents();
                // MONITOREXIT : object
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                logger.warn((Object)("Process to lock user: " + string + " with job history ID: " + l + " was interrupted."), (Throwable)interruptedException);
                ConditionCheckLocker.logLockHashContents();
                // MONITOREXIT : object
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endConditionCheckForJob(String string, long l) {
        HashMap<String, Long> hashMap = lockHash;
        synchronized (hashMap) {
            Long l2 = lockHash.remove(string);
            if (l2 == null) {
                logger.error((Object)("ConditionCheckLocker did not find a lock item for job user: " + string));
                ConditionCheckLocker.logLockHashContents();
                return;
            }
            if (l2 != l) {
                logger.error((Object)("ConditionCheckLocker unlocked user: " + string + " with job history ID: " + l2 + " while processing job history ID: " + l));
                ConditionCheckLocker.logLockHashContents();
                return;
            }
            logger.debug((Object)("ConditionCheckLocker unlocked user: " + string + " with job history ID: " + l2));
        }
    }

    private static void logLockHashContents() {
        logger.debug((Object)("lockHash contains " + lockHash.size() + " entries."));
        Set<String> set = lockHash.keySet();
        for (String string : set) {
            Long l = lockHash.get(string);
            logger.debug((Object)("User(" + string + "); JobHistoryID(" + l + ")"));
        }
    }
}

