/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.JobQueueProxy;
import com.helpsystems.enterprise.core.busobj.JobQueueScheduleEntry;
import com.helpsystems.enterprise.core.busobj.JobQueueType;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.JobQueuesDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.SkybotCronExpression;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class JobQueueScheduleHelper {
    private static Logger logger = Logger.getLogger(JobQueueScheduleHelper.class);

    public static void calculateJobQueueSchedule(JobQueueProxy jobQueueProxy, JobQueueScheduleEntry[] jobQueueScheduleEntryArray, long l) {
        if (jobQueueProxy == null) {
            throw new NullPointerException("Job Queue is null.");
        }
        if (jobQueueScheduleEntryArray == null) {
            throw new NullPointerException("Job Queue Schedule Entry array is null.");
        }
        switch (jobQueueProxy.getJobQueueType()) {
            case AGENT: {
                logger.debug((Object)("Calculating Job Queue Schedule for Agent Job Queue '" + jobQueueProxy.getName() + "' with Target ID " + jobQueueProxy.getTargetID() + "."));
                break;
            }
            case CROSS_AGENT: {
                logger.debug((Object)("Calculating Job Queue Schedule for Cross-Agent Job Queue '" + jobQueueProxy.getName() + "."));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Job Queue Type: " + jobQueueProxy.getJobQueueType());
            }
        }
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(l);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
        calendar2.add(6, -7);
        Calendar calendar3 = Calendar.getInstance(timeZone);
        calendar3.setTimeInMillis(calendar.getTimeInMillis());
        calendar3.add(6, 7);
        JobQueueScheduleHelper.calcSchedule(jobQueueProxy, calendar2, calendar3, calendar, timeZone, jobQueueScheduleEntryArray);
    }

    private static void calcSchedule(JobQueueProxy jobQueueProxy, Calendar calendar, Calendar calendar2, Calendar calendar3, TimeZone timeZone, JobQueueScheduleEntry[] jobQueueScheduleEntryArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        JobQueueScheduleHelper.logger_trace("=====================================================================================================");
        JobQueueScheduleHelper.logger_trace("Calculating schedule for: " + ScheduleLogger.formatTimeStamp(calendar) + " - " + ScheduleLogger.formatTimeStamp(calendar2));
        JobQueueScheduleHelper.logger_trace("=====================================================================================================");
        Agent agent = null;
        String string = "";
        String string2 = jobQueueProxy.getName();
        try {
            if (jobQueueProxy.getJobQueueType() == JobQueueType.AGENT && jobQueueProxy.getTargetID() != 0L && (agent = (object4 = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM")).get(jobQueueProxy.getTargetID())) != null) {
                string = agent.getName();
                string2 = string + "/" + string2;
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error loading Agent for Job Queue: " + jobQueueProxy.getOID() + " - " + string2 + " - " + jobQueueProxy.getTargetID()), throwable);
        }
        object4 = new HashMap();
        for (int i = 0; i < jobQueueScheduleEntryArray.length; ++i) {
            if (jobQueueScheduleEntryArray[i] == null || !jobQueueScheduleEntryArray[i].isEnabled()) continue;
            object3 = jobQueueScheduleEntryArray[i].buildCRONString();
            logger.debug((Object)("Processing: [" + (Object)((Object)jobQueueScheduleEntryArray[i]) + "] as CRON expression: [" + (String)object3 + "]"));
            object2 = new SkybotCronExpression((String)object3, timeZone);
            object = ((SkybotCronExpression)object2).getNextScheduledTime(calendar);
            while (calendar2.getTimeInMillis() > ((Calendar)object).getTimeInMillis()) {
                ((HashMap)object4).put(String.valueOf(((Calendar)object).getTimeInMillis()), new EffectiveSchedule((Calendar)object, jobQueueScheduleEntryArray[i]));
                object = ((SkybotCronExpression)object2).getNextScheduledTime((Calendar)object);
            }
        }
        JobQueueScheduleHelper.logger_trace("Schedule:");
        JobQueueScheduleHelper.logger_trace("=====================================================================================================");
        EffectiveSchedule effectiveSchedule = null;
        object3 = null;
        object2 = new TreeSet(((HashMap)object4).keySet());
        object = object2.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            EffectiveSchedule effectiveSchedule2 = (EffectiveSchedule)((HashMap)object4).get(string3);
            JobQueueScheduleHelper.logger_trace("\tStart Time: " + ScheduleLogger.formatTimeStamp(effectiveSchedule2.startTime) + " Max Active: " + effectiveSchedule2.jobQueueScheduleEntry.getMaxActiveJobs() + " Schedule Name: " + effectiveSchedule2.jobQueueScheduleEntry.getName());
            if (calendar3.getTimeInMillis() >= effectiveSchedule2.startTime.getTimeInMillis()) {
                effectiveSchedule = effectiveSchedule2;
                continue;
            }
            if (object3 != null) continue;
            object3 = effectiveSchedule2;
        }
        logger.debug((Object)("Current Schedule: Name: " + effectiveSchedule.jobQueueScheduleEntry.getName() + " Start Time: " + ScheduleLogger.formatTimeStamp(effectiveSchedule.startTime) + " Max Active: " + effectiveSchedule.jobQueueScheduleEntry.getMaxActiveJobs()));
        logger.debug((Object)("Next Schedule: Name: " + ((EffectiveSchedule)object3).jobQueueScheduleEntry.getName() + " Start Time: " + ScheduleLogger.formatTimeStamp(((EffectiveSchedule)object3).startTime) + " Max Active: " + ((EffectiveSchedule)object3).jobQueueScheduleEntry.getMaxActiveJobs()));
        if (effectiveSchedule != null) {
            object = effectiveSchedule.jobQueueScheduleEntry.getName();
            long l = effectiveSchedule.startTime.getTimeInMillis();
            long l2 = ((EffectiveSchedule)object3).startTime.getTimeInMillis();
            if (jobQueueProxy.getLastUpdatedUTC() < l) {
                try {
                    logger.debug((Object)("Updating Job Queue '" + string2 + "' with schedule '" + (String)object + "'."));
                    JobQueuesDM jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
                    jobQueuesDM.updateJobQueueFromScheduleEntry(effectiveSchedule.jobQueueScheduleEntry, l, l2);
                    EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseServerAM");
                    enterpriseServerAM.jobQueueChanged(jobQueueProxy.getOID());
                    try {
                        ScheduleLogEntry scheduleLogEntry = null;
                        if (jobQueueProxy.getJobQueueType() == JobQueueType.AGENT) {
                            String[] stringArray = new String[]{jobQueueProxy.getName(), object, string};
                            scheduleLogEntry = new ScheduleLogEntry(RosettaMsg.JOB_QUEUE_UPDATED, stringArray, jobQueueProxy.getTargetID(), 0L, 0L);
                        } else {
                            String[] stringArray = new String[]{jobQueueProxy.getName(), object};
                            scheduleLogEntry = new ScheduleLogEntry(RosettaMsg.JOB_QUEUE_UPDATED_XAGENT, stringArray, jobQueueProxy.getTargetID(), 0L, 0L);
                        }
                        ScheduleLogger.write(scheduleLogEntry);
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"Error logging job queue update.", (Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error updating Job Queue '" + string2 + "' with Job Queue Schedule '" + (String)object + "'."), throwable);
                }
            } else {
                logger.debug((Object)("Job queue schedule is already current for Job Queue: " + string2));
                try {
                    JobQueuesDM jobQueuesDM = (JobQueuesDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobQueuesDM");
                    jobQueuesDM.updateJobQueueNextScheduleTime(jobQueueProxy.getOID(), l2);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error updating Job Queue '" + string2 + "' with Job Queue Schedule '" + (String)object + "'."), throwable);
                }
            }
        }
    }

    private static void logger_trace(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string);
        }
    }

    public static class EffectiveSchedule {
        public Calendar startTime;
        public JobQueueScheduleEntry jobQueueScheduleEntry;

        protected EffectiveSchedule(Calendar calendar, JobQueueScheduleEntry jobQueueScheduleEntry) {
            this.startTime = calendar;
            this.jobQueueScheduleEntry = jobQueueScheduleEntry;
        }
    }
}

