/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.dm.ActiveProcessAM;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.enterprise.core.busobj.AgentEventHistory;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.module.AgentEventMonitorAMImpl;
import java.util.ArrayList;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

class AgentEventMonitorExecutor
implements Runnable {
    private static final Logger logger = Logger.getLogger(AgentEventMonitorExecutor.class);
    protected AgentEventMonitor aem;
    private long agentOID;
    private AgentEventMonitorAMImpl mgr;
    boolean firstPoll;
    FutureTask placeholder;
    private boolean isPolling;
    private Object pollLock;
    private ArrayList<AgentEventHistory> historyCache;
    private JobExecDM jobExecDM;

    AgentEventMonitorExecutor(AgentEventMonitor agentEventMonitor, AgentEventMonitorAMImpl agentEventMonitorAMImpl, long l, JobExecDM jobExecDM) {
        ValidationHelper.checkForNull((String)"AgentEventMonitor", (Object)((Object)agentEventMonitor));
        this.aem = agentEventMonitor;
        ValidationHelper.checkForNull((String)"AgentEventMonitorAMImpl", (Object)agentEventMonitorAMImpl);
        this.mgr = agentEventMonitorAMImpl;
        this.agentOID = l;
        this.jobExecDM = jobExecDM;
        this.firstPoll = true;
        this.pollLock = new Object();
        this.historyCache = new ArrayList();
    }

    void fireEvent(String string, String string2) {
        this.historyCache.add(this.mgr.createHistoryRecord(this.aem, '*', string, string2, this.agentOID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        int n;
        String string = Thread.currentThread().getName();
        Thread.currentThread().setName("EventMonitor_" + this.aem.getName());
        if (!this.mgr.containsExecutor(this)) {
            this.removeSelf();
            return;
        }
        if (this.mgr.isShutdownRequested() && (n = this.jobExecDM.activeJobCount()) == 0) {
            return;
        }
        if (this.aem.getDisabled()) {
            this.firstPoll = true;
            return;
        }
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isPolling) {
                return;
            }
            this.isPolling = true;
        }
        long l = System.currentTimeMillis();
        try {
            logger.trace((Object)("Polling " + this.aem.getName()));
            this.runPoll();
            if (!this.historyCache.isEmpty()) {
                if (!this.mgr.containsExecutor(this)) {
                    this.removeSelf();
                    return;
                }
                AgentEventHistory[] agentEventHistoryArray = new AgentEventHistory[this.historyCache.size()];
                this.historyCache.toArray(agentEventHistoryArray);
                this.mgr.enqueueAll(agentEventHistoryArray);
            }
        }
        finally {
            logger.trace((Object)("Finished Polling " + this.aem.getName() + ", time = " + DateTranslator.formatElapsedTime((long)(System.currentTimeMillis() - l))));
            this.isPolling = false;
            this.historyCache.clear();
            Thread.currentThread().setName(string);
        }
    }

    void runPoll() {
    }

    void removeSelf() {
        this.mgr.removeExecutor(this);
    }

    RemoteFileAM getLocalFileAM() {
        return this.mgr.getLocalFileAM();
    }

    ActiveProcessAM getProcessAM() {
        return this.mgr.getProcessAM();
    }

    public long getAgentOID() {
        return this.agentOID;
    }

    public int hashcode() {
        return (int)this.aem.getOID();
    }

    public boolean equals(Object object) {
        AgentEventMonitorExecutor agentEventMonitorExecutor = (AgentEventMonitorExecutor)object;
        return this.aem.getOID() == agentEventMonitorExecutor.aem.getOID();
    }
}

