/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.DurableQueue;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.dm.ActiveProcessAM;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEventHistory;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.FileEvent;
import com.helpsystems.enterprise.core.busobj.ProcessEvent;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryAM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorAM;
import com.helpsystems.enterprise.core.dm.JobExecDM;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.module.AgentEventMonitorExecutor;
import com.helpsystems.enterprise.module.FileEventMonitorExecutor;
import com.helpsystems.enterprise.module.ProcessEventMonitorExecutor;
import com.helpsystems.enterprise.peer.AgentControl;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class AgentEventMonitorAMImpl
extends AbstractManager
implements AgentEventMonitorAM {
    private static final Logger logger = Logger.getLogger(AgentEventMonitorAMImpl.class);
    private AgentPeer peer;
    private Map<Long, AgentEventMonitorExecutor> eventMap;
    boolean haveReceivedMonitors;
    private ScheduledThreadPoolExecutor executor;
    private RemoteFileAM localFileAM;
    private ActiveProcessAM processAM;
    private DurableQueue dq;
    private PeerID startingServerID;
    private AgentEventHistoryAM historyAM;
    private long lastTimestamp;
    private Object timestamplock;
    private boolean transferringData;

    AgentEventMonitorAMImpl(AgentPeer agentPeer, RemoteFileAM remoteFileAM, ActiveProcessAM activeProcessAM) throws IOException {
        File file;
        ValidationHelper.checkForNull((String)"Peer", (Object)agentPeer);
        this.peer = agentPeer;
        ValidationHelper.checkForNull((String)"BasicFileAM", (Object)remoteFileAM);
        this.localFileAM = remoteFileAM;
        ValidationHelper.checkForNull((String)"ActiveProcessAM", (Object)activeProcessAM);
        this.processAM = activeProcessAM;
        this.setName("ENTERPRISE.AgentEventMonitorAM");
        this.eventMap = new HashMap<Long, AgentEventMonitorExecutor>();
        this.executor = new ScheduledThreadPoolExecutor(5);
        this.timestamplock = new Object();
        String string = "joblogtmp";
        if (AgentControl.isWindows()) {
            string = DefaultConfigPath.getDefaultPath() + File.separator + string;
        }
        if (!(file = new File(string)).exists()) {
            file.mkdir();
        }
        String string2 = string + "/" + agentPeer.getRemotePeerID().getInstanceIdentifier().toString() + "_eventData.dq";
        this.dq = new DurableQueue(string2);
        if (agentPeer.getAgentConfig().getOfflineEventHandling() == 0) {
            this.clearDataQueue();
        }
        Thread thread = new Thread(new DecacheRunner());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentEventMonitor[] getMonitors() {
        Map<Long, AgentEventMonitorExecutor> map = this.eventMap;
        synchronized (map) {
            AgentEventMonitor[] agentEventMonitorArray = new AgentEventMonitor[this.eventMap.size()];
            int n = 0;
            for (AgentEventMonitorExecutor agentEventMonitorExecutor : this.eventMap.values()) {
                agentEventMonitorArray[n] = agentEventMonitorExecutor.aem;
                ++n;
            }
            return agentEventMonitorArray;
        }
    }

    boolean isShutdownRequested() {
        return this.peer.isShutdownRequested();
    }

    @Override
    public boolean isTransferringData() {
        return this.transferringData;
    }

    private AgentEventMonitorExecutor generateExecutor(AgentEventMonitor agentEventMonitor, long l) {
        JobExecDM jobExecDM = (JobExecDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobExecDM");
        if (agentEventMonitor instanceof FileEvent) {
            return new FileEventMonitorExecutor(agentEventMonitor, this, l, jobExecDM);
        }
        if (agentEventMonitor instanceof ProcessEvent) {
            return new ProcessEventMonitorExecutor(agentEventMonitor, this, l, jobExecDM);
        }
        return new AgentEventMonitorExecutor(agentEventMonitor, this, l, jobExecDM);
    }

    @Override
    public void setMonitors(AgentEventMonitor[] agentEventMonitorArray) {
        try {
            this.setMonitors(agentEventMonitorArray, this.getAgentID());
        }
        catch (Exception exception) {
            logger.error((Object)"Error setting Agent Event Monitors.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMonitors(AgentEventMonitor[] agentEventMonitorArray, long l) {
        if (this.peer.isShutdownRequested()) {
            return;
        }
        Map<Long, AgentEventMonitorExecutor> map = this.eventMap;
        synchronized (map) {
            HashMap<String, AgentEventMonitorExecutor> hashMap = new HashMap<String, AgentEventMonitorExecutor>();
            for (AgentEventMonitorExecutor agentEventMonitorExecutor : this.eventMap.values()) {
                hashMap.put(String.valueOf(agentEventMonitorExecutor.aem.getOID()), agentEventMonitorExecutor);
            }
            for (AgentEventMonitor agentEventMonitor : agentEventMonitorArray) {
                AgentEventMonitorExecutor agentEventMonitorExecutor;
                if ((agentEventMonitor.getType() == 301 || agentEventMonitor.getType() == 301) && IBMiAgent.isIBMiOS()) {
                    logger.warn((Object)("IBM i Agent is ignoring invalid Process type Agent Event Monitor: " + agentEventMonitor.getName()));
                    continue;
                }
                AgentEventMonitorExecutor agentEventMonitorExecutor2 = null;
                String string = String.valueOf(agentEventMonitor.getOID());
                if (hashMap.containsKey(string)) {
                    agentEventMonitorExecutor = (AgentEventMonitorExecutor)hashMap.get(string);
                    String string2 = agentEventMonitorExecutor.aem.getName();
                    if (agentEventMonitorExecutor.aem.isDifferentThan(agentEventMonitor)) {
                        logger.trace((Object)("Replacing updated active monitor: " + string2));
                        agentEventMonitorExecutor2 = this.generateExecutor(agentEventMonitor, l);
                    } else {
                        logger.trace((Object)("Leaving unchanged active monitor: " + string2));
                    }
                    hashMap.remove(string);
                } else {
                    logger.trace((Object)("Initiating inactive monitor: " + agentEventMonitor.getName()));
                    agentEventMonitorExecutor2 = this.generateExecutor(agentEventMonitor, l);
                }
                if (agentEventMonitorExecutor2 == null) continue;
                agentEventMonitorExecutor = this.eventMap.remove(agentEventMonitor.getOID());
                if (agentEventMonitorExecutor != null && agentEventMonitorExecutor.placeholder != null) {
                    logger.trace((Object)("Stopping executor for active monitor: " + agentEventMonitorExecutor.aem.getName()));
                    this.executor.remove(agentEventMonitorExecutor.placeholder);
                }
                this.eventMap.put(agentEventMonitor.getOID(), agentEventMonitorExecutor2);
                if (agentEventMonitor.getType() == 0 || agentEventMonitor.getDisabled()) continue;
                logger.trace((Object)("Starting executor for monitor: " + agentEventMonitor.getName()));
                agentEventMonitorExecutor2.placeholder = (FutureTask)((Object)this.executor.scheduleWithFixedDelay(agentEventMonitorExecutor2, 0L, agentEventMonitor.getCycle(), TimeUnit.SECONDS));
            }
            for (AgentEventMonitorExecutor agentEventMonitorExecutor : hashMap.values()) {
                logger.trace((Object)("Stopping a removed monitor: " + agentEventMonitorExecutor.aem.getName()));
                AgentEventMonitorExecutor agentEventMonitorExecutor3 = this.eventMap.remove(agentEventMonitorExecutor.aem.getOID());
                if (agentEventMonitorExecutor3 == null || agentEventMonitorExecutor3.placeholder == null) continue;
                logger.trace((Object)("Stopping executor for removed monitor: " + agentEventMonitorExecutor3.aem.getName()));
                this.executor.remove(agentEventMonitorExecutor3.placeholder);
            }
            this.haveReceivedMonitors = true;
        }
    }

    @Override
    public void fireEvent(AgentEventMonitor agentEventMonitor, char c, String string) {
        try {
            long l = 0L;
            try {
                l = this.getAgentID();
            }
            catch (ManagerNotFoundException managerNotFoundException) {
                // empty catch block
            }
            AgentEventHistory agentEventHistory = this.createHistoryRecord(agentEventMonitor, c, string, null, l);
            this.enqueueAll(new AgentEventHistory[]{agentEventHistory});
        }
        catch (DataException dataException) {
            logger.error((Object)"Lookup for agent is failed", (Throwable)dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Lookup for agent is failed", (Throwable)resourceUnavailableException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentEventHistory createHistoryRecord(AgentEventMonitor agentEventMonitor, char c, String string, String string2, long l) {
        long l2 = 0L;
        Object object = this.timestamplock;
        synchronized (object) {
            l2 = System.currentTimeMillis();
            if (l2 <= this.lastTimestamp) {
                l2 = this.lastTimestamp + 1L;
            }
            this.lastTimestamp = l2;
        }
        if (logger.isTraceEnabled()) {
            object = "Creating history record: " + agentEventMonitor.getName() + ", data: " + string;
            if (string2 != null) {
                object = (String)object + ", details: " + string2;
            }
            logger.trace(object);
        }
        object = null;
        try {
            object = new AgentEventHistory(agentEventMonitor.getOID(), l, l2, c, string);
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to look up agent", (Throwable)exception);
        }
        return object;
    }

    private long getAgentID() throws DataException, ResourceUnavailableException {
        PeerID peerID = this.peer.getRemotePeerID();
        AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.AgentDM");
        Agent agent = agentDM.getByHardwareHashAndInstanceIdentifier(peerID.getHardwareHash(), (String)((Object)peerID.getInstanceIdentifier()));
        return agent.getOid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBackloggedEvents() throws IOException {
        if (!this.dataQueueHasData()) {
            return;
        }
        PeerID peerID = this.peer.getConnectedAgentServer();
        Map<Long, AgentEventMonitorExecutor> map = this.eventMap;
        synchronized (map) {
            if (!this.haveReceivedMonitors) {
                return;
            }
            if (peerID == null) {
                this.haveReceivedMonitors = false;
                return;
            }
            if (this.eventMap.size() == 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Clearing event history durable queue.");
                }
                this.clearDataQueue();
                return;
            }
        }
        this.transferringData = true;
        while (this.dataQueueHasData()) {
            Object object;
            AgentEventHistory[] agentEventHistoryArray;
            if (!peerID.equals((Object)this.peer.getConnectedAgentServer())) {
                return;
            }
            map = new HashMap<Long, AgentEventMonitorExecutor>();
            while (((HashMap)map).size() <= 100 && this.dataQueueHasData()) {
                agentEventHistoryArray = this.getAgentEventHistory();
                if (agentEventHistoryArray == null) {
                    object = "popped a null aeh.";
                    logger.error(object);
                    continue;
                }
                object = null;
                object = this.getAgentEventMonitorExecutor(agentEventHistoryArray.getEventOID());
                if (object == null || ((AgentEventMonitorExecutor)object).aem.isDisabled()) continue;
                if (agentEventHistoryArray.getAgentOID() == 0L) {
                    agentEventHistoryArray.setAgentOID(((AgentEventMonitorExecutor)object).getAgentOID());
                }
                ((HashMap)map).put(agentEventHistoryArray.getAgentTimeStamp(), (AgentEventMonitorExecutor)agentEventHistoryArray);
            }
            if (((HashMap)map).isEmpty()) continue;
            agentEventHistoryArray = new AgentEventHistory[((HashMap)map).size()];
            ((HashMap)map).values().toArray(agentEventHistoryArray);
            object = this.sendEventsToServer(agentEventHistoryArray);
            if (object == null) {
                throw new NullPointerException("sentEvents is null");
            }
            if (((Object)object).length == agentEventHistoryArray.length) {
                for (AgentEventHistory agentEventHistory : agentEventHistoryArray) {
                    if (agentEventHistory == null) {
                        throw new NullPointerException("event history from array is null.");
                    }
                    ((HashMap)map).remove(agentEventHistory.getAgentTimeStamp());
                }
            } else {
                for (AgentEventHistory agentEventHistory : object) {
                    AgentEventHistory agentEventHistory2 = (AgentEventHistory)((Object)((HashMap)map).remove((long)agentEventHistory));
                    if (agentEventHistory2 != null) continue;
                    logger.warn((Object)("No history match for agent timestamp: " + (long)agentEventHistory));
                }
            }
            for (AgentEventHistory agentEventHistory : ((HashMap)map).values()) {
                if (agentEventHistory == null) {
                    throw new NullPointerException("event history for re-enquing is null.");
                }
                logger.debug((Object)("Re-enqueing agent event history record (" + agentEventHistory.getEventOID() + "/" + agentEventHistory.getAgentTimeStamp() + "): " + agentEventHistory.getEventData()));
                this.putAgentEventHistory(agentEventHistory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentEventHistory getAgentEventHistory() throws IOException {
        DurableQueue durableQueue = this.dq;
        synchronized (durableQueue) {
            return (AgentEventHistory)((Object)this.dq.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAgentEventHistory(AgentEventHistory agentEventHistory) throws IOException {
        if (agentEventHistory == null) {
            logger.debug((Object)"AgentEventMonitorAM is attempting to push a null AgentEventHistory");
            return;
        }
        DurableQueue durableQueue = this.dq;
        synchronized (durableQueue) {
            this.dq.push((Serializable)((Object)agentEventHistory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dataQueueHasData() {
        DurableQueue durableQueue = this.dq;
        synchronized (durableQueue) {
            return !this.dq.isEmpty();
        }
    }

    private synchronized long[] sendEventsToServer(AgentEventHistory[] agentEventHistoryArray) {
        if (agentEventHistoryArray == null || agentEventHistoryArray.length == 0) {
            return new long[0];
        }
        PeerID peerID = this.peer.getConnectedAgentServer();
        if (peerID == null) {
            this.startingServerID = null;
            this.historyAM = null;
            return new long[0];
        }
        if (!peerID.equals((Object)this.startingServerID)) {
            this.historyAM = null;
        }
        if (this.historyAM == null) {
            try {
                this.historyAM = (AgentEventHistoryAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.AgentEventHistoryAM");
                this.startingServerID = peerID;
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to access the AgentEventHistoryAM on " + peerID), (Throwable)exception);
                return new long[0];
            }
        }
        try {
            return this.historyAM.sendEvents(agentEventHistoryArray);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to send events to AgentEventHistoryAM on " + peerID), (Throwable)exception);
            return new long[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAll(AgentEventHistory[] agentEventHistoryArray) {
        try {
            DurableQueue durableQueue = this.dq;
            synchronized (durableQueue) {
                for (int i = 0; i < agentEventHistoryArray.length; ++i) {
                    AgentEventHistory agentEventHistory = agentEventHistoryArray[i];
                    this.putAgentEventHistory(agentEventHistory);
                    agentEventHistoryArray[i] = null;
                }
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Unable to persist event history data.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExecutor(AgentEventMonitorExecutor agentEventMonitorExecutor) {
        Map<Long, AgentEventMonitorExecutor> map = this.eventMap;
        synchronized (map) {
            AgentEventMonitorExecutor agentEventMonitorExecutor2 = this.eventMap.remove(agentEventMonitorExecutor.aem.getOID());
            if (agentEventMonitorExecutor2 == agentEventMonitorExecutor) {
                this.executor.remove(agentEventMonitorExecutor.placeholder);
            } else if (agentEventMonitorExecutor2 != null) {
                this.eventMap.put(agentEventMonitorExecutor.aem.getOID(), agentEventMonitorExecutor2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentEventMonitorExecutor getAgentEventMonitorExecutor(long l) {
        Map<Long, AgentEventMonitorExecutor> map = this.eventMap;
        synchronized (map) {
            return this.eventMap.get(l);
        }
    }

    boolean containsExecutor(AgentEventMonitorExecutor agentEventMonitorExecutor) {
        if (agentEventMonitorExecutor == null) {
            return false;
        }
        return this.getAgentEventMonitorExecutor(agentEventMonitorExecutor.aem.getOID()) == agentEventMonitorExecutor;
    }

    public RemoteFileAM getLocalFileAM() {
        return this.localFileAM;
    }

    public ActiveProcessAM getProcessAM() {
        return this.processAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDataQueue() throws IOException {
        DurableQueue durableQueue = this.dq;
        synchronized (durableQueue) {
            this.dq.clear();
        }
    }

    static /* synthetic */ void access$000(AgentEventMonitorAMImpl agentEventMonitorAMImpl) throws IOException {
        agentEventMonitorAMImpl.processBackloggedEvents();
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ void access$200(AgentEventMonitorAMImpl agentEventMonitorAMImpl) throws IOException {
        agentEventMonitorAMImpl.clearDataQueue();
    }

    static /* synthetic */ boolean access$302(AgentEventMonitorAMImpl agentEventMonitorAMImpl, boolean bl) {
        agentEventMonitorAMImpl.transferringData = bl;
        return agentEventMonitorAMImpl.transferringData;
    }

    class DecacheRunner
    implements Runnable {
        DecacheRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                try {
                    Thread.currentThread().setName("Event History decache");
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException var1_2) {
                            // empty catch block
                        }
                        try {
                            AgentEventMonitorAMImpl.access$000(AgentEventMonitorAMImpl.this);
                        }
                        catch (IOException var1_3) {
                            AgentEventMonitorAMImpl.access$100().warn((Object)"This agent was unable to process the persisted event history information.", (Throwable)var1_3);
                            try {
                                AgentEventMonitorAMImpl.access$200(AgentEventMonitorAMImpl.this);
                            }
                            catch (Exception var2_6) {
                                AgentEventMonitorAMImpl.access$100().debug((Object)"Unable to clear the off-line event history queue for this agent.", (Throwable)var2_6);
                            }
                        }
                        finally {
                            AgentEventMonitorAMImpl.access$302(AgentEventMonitorAMImpl.this, false);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var1_4) {
                    AgentEventMonitorAMImpl.access$100().error((Object)"An error occurred in the Event History DecacheRunner.", var1_4);
                    try {
                        AgentEventMonitorAMImpl.access$100().trace((Object)"The Event History DecacheRunner is ending.");
                    }
                    catch (Throwable var1_5) {}
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var4_8) {
                try {
                    AgentEventMonitorAMImpl.access$100().trace((Object)"The Event History DecacheRunner is ending.");
                }
                catch (Throwable var5_9) {
                    // empty catch block
                }
                throw var4_8;
            }
        }
    }
}

