/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.ImportCronException;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.busobj.traps.EnterpriseAgentSNMPTrap;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommand;
import com.helpsystems.enterprise.core.cmdlineobj.AgentCommandReply;
import com.helpsystems.enterprise.core.cmdlineobj.AgentEndingCommand;
import com.helpsystems.enterprise.core.cmdlineobj.ImportCronCommand;
import com.helpsystems.enterprise.core.cmdlineobj.ReportCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SendMessageCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableCommand;
import com.helpsystems.enterprise.core.cmdlineobj.SkybotVariableValue;
import com.helpsystems.enterprise.core.dm.AgentCommandAM;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.ImportCronAM;
import com.helpsystems.enterprise.core.dm.MRHelper;
import com.helpsystems.enterprise.core.dm.ReportSubmitterAM;
import com.helpsystems.enterprise.core.dm.SkybotVariableDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class AgentCommandAMImpl
extends AbstractManager
implements AgentCommandAM {
    private static final Logger logger = Logger.getLogger(AgentCommandAMImpl.class);
    private AgentPeer agentServer;

    public AgentCommandAMImpl(AgentPeer agentPeer) {
        super.setName("ENTERPRISE.AgentCommandAM");
        this.agentServer = agentPeer;
    }

    @Override
    public AgentCommandReply executeCommand(AgentCommand agentCommand, PeerID peerID) throws ActionFailedException {
        if (agentCommand == null) {
            throw new NullPointerException("The Agent Command is null.");
        }
        if (peerID == null) {
            throw new NullPointerException("The Agent Peer ID is null.");
        }
        logger.debug((Object)("Executing agent command: " + agentCommand.getLogDescription()));
        ProductIID productIID = ProductIID.DIRECT_CONNECT;
        if (agentCommand instanceof AgentEndingCommand) {
            try {
                this.agentServer.updateEndingAgents(peerID);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Error tracking ending agent.", throwable);
            }
            return new AgentCommandReply(false, "Agent Ending Confirmed.");
        }
        if (!this.agentServer.isLicensedAndOnline(peerID)) {
            throw new ActionFailedException("The agent is not licensed.");
        }
        try {
            if (agentCommand instanceof SendMessageCommand) {
                SendMessageCommand sendMessageCommand = (SendMessageCommand)agentCommand;
                return this.executeSendmsg((BasicIdentifier)productIID, sendMessageCommand);
            }
            if (agentCommand instanceof SkybotVariableCommand) {
                return this.executeRvCmd((SkybotVariableCommand)agentCommand);
            }
            if (agentCommand instanceof ReportCommand) {
                return this.executeReportCommand((ReportCommand)agentCommand);
            }
            if (agentCommand instanceof ImportCronCommand) {
                return this.executeImportCronInfo((BasicIdentifier)productIID, (ImportCronCommand)agentCommand, peerID);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ActionFailedException) {
                throw (ActionFailedException)((Object)exception);
            }
            return new AgentCommandReply(exception);
        }
        throw new ActionFailedException("The agent command is not supported: " + agentCommand.getLogDescription());
    }

    @Override
    public void notifyServerOfAgentError(String string) {
        if (string == null || string.isEmpty()) {
            string = "?";
        }
        SystemMessage systemMessage = RosettaMsg.ERROR_ON_AGENT.newSystemMessage(string);
        SystemMessageQueue.write(systemMessage);
    }

    private AgentCommandReply executeImportCronInfo(BasicIdentifier basicIdentifier, ImportCronCommand importCronCommand, PeerID peerID) {
        AgentCommandReply agentCommandReply = new AgentCommandReply(false, "IMPORTCRON completed normally.");
        ImportCronAM importCronAM = (ImportCronAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.ImportCronAM");
        try {
            importCronAM.importCronFile(basicIdentifier, peerID, importCronCommand.getFilePath(), importCronCommand.getFileContent());
        }
        catch (ImportCronException importCronException) {
            agentCommandReply.setFailed(true);
            agentCommandReply.setException(importCronException);
            agentCommandReply.setReplyText(importCronException.getMessage());
            logger.error((Object)"Error importing cron information.", (Throwable)importCronException);
        }
        return agentCommandReply;
    }

    private AgentCommandReply executeReportCommand(ReportCommand reportCommand) {
        ReportSubmitterAM reportSubmitterAM = (ReportSubmitterAM)ManagerRegistry.getManager((String)"ENTERPRISE.ReportSubmitterAM");
        try {
            reportSubmitterAM.putReport(reportCommand);
            return new AgentCommandReply(false, "The report is submitted.");
        }
        catch (Exception exception) {
            System.out.println("Command Failed: ");
            exception.printStackTrace(System.out);
            return new AgentCommandReply(true, "Problem occured while submitting report.");
        }
    }

    AgentCommandReply executeRvCmd(SkybotVariableCommand skybotVariableCommand) {
        if (skybotVariableCommand.isGetMode()) {
            return this.executeRvCmdGet(skybotVariableCommand);
        }
        if (skybotVariableCommand.isSetMode()) {
            return this.executeRvCmdSet(skybotVariableCommand);
        }
        return new AgentCommandReply(true, "Undefined SkybotVariable command mode: " + skybotVariableCommand.getLogDescription());
    }

    private AgentCommandReply executeRvCmdGet(SkybotVariableCommand skybotVariableCommand) {
        Object object;
        boolean bl = false;
        SkybotVariableValue skybotVariableValue = skybotVariableCommand.getSkybotVariableValue();
        SkybotVariableDM skybotVariableDM = MRHelper.getSkybotVariableDM();
        CalendarObjectDM calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
        if (skybotVariableValue.isStatusFailed()) {
            bl = true;
        } else if (skybotVariableValue.isStatusPending()) {
            logger.trace((Object)("Getting value of Automate Schedule Variable '" + skybotVariableValue.getName() + "'"));
            try {
                object = skybotVariableDM.get(skybotVariableValue.getName());
                if (((SkybotVariable)((Object)object)).isStaticValue()) {
                    skybotVariableValue.setValue(((SkybotVariable)((Object)object)).getValue());
                } else {
                    CalendarObject calendarObject = null;
                    Long l = ((SkybotVariable)((Object)object)).getCalendarObjectID();
                    if (l != null) {
                        calendarObject = calendarObjectDM.get(l);
                    }
                    skybotVariableValue.setValue(((SkybotVariable)((Object)object)).getValue(calendarObject, Calendar.getInstance()));
                }
                skybotVariableValue.setStatus(1);
                skybotVariableValue.setReplyMessage("SkybotVariable '" + object.getName() + "' = '" + skybotVariableValue.getValue() + "'.");
            }
            catch (NoDataException noDataException) {
                bl = true;
                skybotVariableValue.setStatus(0);
                skybotVariableValue.setReplyMessage("SkybotVariable '" + skybotVariableValue.getName() + "' does not exist.");
            }
            catch (Exception exception) {
                bl = true;
                skybotVariableValue.setStatus(0);
                skybotVariableValue.setReplyMessage(exception.getMessage());
                logger.error((Object)("Command failed for SkybotVariable '" + skybotVariableValue.getName() + "'."), (Throwable)exception);
            }
        }
        object = null;
        object = bl ? new AgentCommandReply(true, "Automate Schedule Variable was not returned: " + skybotVariableCommand.getLogDescription()) : new AgentCommandReply(false, "Get Automate Schedule Variable completed: " + skybotVariableCommand.getLogDescription());
        object.setReturnObject((Serializable)((Object)skybotVariableValue));
        return object;
    }

    private AgentCommandReply executeRvCmdSet(SkybotVariableCommand skybotVariableCommand) {
        String string;
        Object object;
        boolean bl = false;
        SkybotVariableValue skybotVariableValue = skybotVariableCommand.getSkybotVariableValue();
        SkybotVariableDM skybotVariableDM = MRHelper.getSkybotVariableDM();
        if (skybotVariableValue.isStatusFailed()) {
            bl = true;
        } else if (skybotVariableValue.isStatusPending()) {
            logger.trace((Object)("Setting Automate Schedule Variable: '" + skybotVariableValue.getName() + "' = '" + skybotVariableValue.getValue() + "'"));
            try {
                object = skybotVariableDM.get(skybotVariableValue.getName());
                string = ((SkybotVariable)((Object)object)).getValue();
                ((SkybotVariable)((Object)object)).setValue(skybotVariableValue.getValue());
                SkybotVariable skybotVariable = skybotVariableDM.updateValue((SkybotVariable)((Object)object));
                RosettaMsg rosettaMsg = RosettaMsg.SKYBOT_VARIABLE_SET_BY_API;
                Object[] objectArray = new String[]{object.getName(), string, skybotVariable.getValue()};
                skybotVariableValue.setStatus(1);
                skybotVariableValue.setReplyMessage(RosettaMsg.getMsgText(rosettaMsg, objectArray));
                AgentDM agentDM = (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
                Agent agent = agentDM.getByHardwareKeyAndInstanceIdentifier(skybotVariableCommand.getInitiatingAgent().getHardwareKey(), skybotVariableCommand.getInitiatingAgent().getInstanceIdentifier().toString());
                ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, (String[])objectArray, agent.getOid(), 0L, 0L);
                ScheduleLogger.write(scheduleLogEntry);
            }
            catch (NoDataException noDataException) {
                bl = true;
                skybotVariableValue.setStatus(0);
                skybotVariableValue.setReplyMessage("Automate Schedule Variable '" + skybotVariableValue.getName() + "' does not exist.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
                skybotVariableValue.setStatus(0);
                skybotVariableValue.setReplyMessage(illegalArgumentException.getLocalizedMessage());
            }
            catch (Exception exception) {
                bl = true;
                skybotVariableValue.setStatus(0);
                skybotVariableValue.setReplyMessage(exception.getMessage());
                logger.error((Object)("Command failed for Automate Schedule Variable '" + skybotVariableValue.getName() + "'."), (Throwable)exception);
            }
        }
        object = null;
        if (bl) {
            string = "Automate Schedule Variable was not updated.";
            object = new AgentCommandReply(true, string);
        } else {
            string = "Automate Schedule Variable was updated.";
            object = new AgentCommandReply(false, string);
        }
        ((AgentCommandReply)((Object)object)).setReturnObject((Serializable)((Object)skybotVariableValue));
        return object;
    }

    private AgentCommandReply executeSendmsg(BasicIdentifier basicIdentifier, SendMessageCommand sendMessageCommand) {
        if ("EMAIL".equals(sendMessageCommand.getMode())) {
            return this.sendEmailMessage(basicIdentifier, sendMessageCommand);
        }
        if ("TRAP".equals(sendMessageCommand.getMode())) {
            return this.sendSNMPTrapMessage(basicIdentifier, sendMessageCommand);
        }
        return new AgentCommandReply(true, "Undefined command mode: " + sendMessageCommand.getLogDescription());
    }

    private AgentCommandReply sendEmailMessage(BasicIdentifier basicIdentifier, SendMessageCommand sendMessageCommand) {
        EnterpriseEmailAM enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)basicIdentifier, (String)"ENTERPRISE.EnterpriseEmailAM");
        int n = 0;
        String string = "";
        String string2 = "";
        int n2 = 0;
        String[] stringArray = sendMessageCommand.getR_parm().split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                enterpriseEmailAM.sendMessage(stringArray[i], sendMessageCommand.getS_parm(), sendMessageCommand.getT_parm());
                ++n2;
                continue;
            }
            catch (Exception exception) {
                ++n;
                string = string + string2 + stringArray[i];
                string2 = ", ";
            }
        }
        if (n > 0) {
            return new AgentCommandReply(false, "The Email message was sent to " + n2 + " of " + stringArray.length + " recipients. It was not sent to: " + string);
        }
        return new AgentCommandReply(false, "The Email message was sent to " + n2 + " recipients.");
    }

    private AgentCommandReply sendSNMPTrapMessage(BasicIdentifier basicIdentifier, SendMessageCommand sendMessageCommand) {
        try {
            EnterpriseSNMPTrapAM enterpriseSNMPTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)basicIdentifier, (String)"ENTERPRISE.EnterpriseSNMPTrapAM");
            EnterpriseAgentSNMPTrap enterpriseAgentSNMPTrap = new EnterpriseAgentSNMPTrap();
            enterpriseAgentSNMPTrap.setSeverity(sendMessageCommand.getC_parm());
            enterpriseAgentSNMPTrap.setText(sendMessageCommand.getT_parm());
            enterpriseSNMPTrapAM.sendSNMPTrap(enterpriseAgentSNMPTrap);
            return new AgentCommandReply(false, "The SNMP trap message was sent.");
        }
        catch (Exception exception) {
            return new AgentCommandReply(exception);
        }
    }
}

