/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.install;

import com.helpsystems.common.core.util.NativeSz;
import com.helpsystems.common.core.util.NativeSzInfo;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class JVMTests {
    private static final long BAD_NUMBER = 1231258349442L;
    protected static final String JAVA_VM_STRING = "java.vm.version";
    public static final int BAD_JAVA_VERSION = 1;
    public static final int DATE_FORMAT_PROBLEM = 2;
    public static final int NOT_SUN_JAVA = 3;
    public static final int NATIVE_SZ_FAILURE = 4;
    public static final int BIT_DEPTH_MISMATCH = 5;
    public static final int NATIVE_DB_DRIVER_FAILURE = 6;
    public static final int LONG_JNI_FAILURE = 7;
    public static final int UNKNOWN_FAILURE = 100;

    protected static void exit(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "All tests completed successfully.";
                break;
            }
            case 1: {
                string = "The Java version appears to be older than version 1.4.";
                break;
            }
            case 2: {
                string = "The Java version has the date formatting problem.";
                break;
            }
            case 3: {
                string = "This is not a Sun-certified or Oracle-certified Java environment.";
                break;
            }
            case 4: {
                string = "Unable to load NativeSz native library.";
                break;
            }
            case 5: {
                string = "The selected Java environment is 32-bit, but the Operating System is 64-bit.\nYou must use the 64-bit version of Java on this system.";
                break;
            }
            case 6: {
                string = "Error loading the native database driver.  The JVM requires an update.";
                break;
            }
            case 7: {
                string = "Long number serialization test failed.  The JVM requires an update.";
                break;
            }
            default: {
                string = "Undefined JVMTests error code: " + n;
            }
        }
        if (string != null) {
            System.out.println(string);
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length > 0) {
            String string = stringArray[0];
            String string2 = "-testrc:";
            if (string.toLowerCase().startsWith(string2)) {
                try {
                    int n2 = Integer.parseInt(string.substring(string2.length()).trim());
                    System.out.println("Returning test code: " + n2);
                    JVMTests.exit(n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JVMTests.exit(99);
                }
            }
            if ("-a".equalsIgnoreCase(string) && (n = JVMTests.doAgentTests()) != 0) {
                JVMTests.exit(n);
            }
            if ("-n".equalsIgnoreCase(string)) {
                n = JVMTests.doNativeSzTests();
                if (n == 0) {
                    System.exit(0);
                }
                JVMTests.exit(n);
            }
            if ("-l".equalsIgnoreCase(string)) {
                JVMTests.exit(JVMTests.testLongJNI());
            }
        }
        n = JVMTests.doJVMTests();
        JVMTests.exit(n);
    }

    public static int doJVMTests() {
        int n;
        try {
            "hello world".replaceAll("l", "L");
            new StringBuilder();
        }
        catch (Throwable throwable) {
            return 1;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm");
            simpleDateFormat.format(new Date());
        }
        catch (Throwable throwable) {
            return 2;
        }
        if ("OS/400".equals(System.getProperty("os.name")) && (n = JVMTests.testNativeDB2()) != 0) {
            return n;
        }
        return 0;
    }

    private static int doAgentTests() {
        try {
            Class.forName("sun.tools.jar.Main");
        }
        catch (Exception exception) {
            return 3;
        }
        String string = System.getProperty("java.vendor");
        if (string == null) {
            return 3;
        }
        String string2 = System.getProperty("java.library.path");
        String string3 = System.getProperty("sun.arch.data.model");
        String string4 = System.getProperty("os.arch");
        if ("IA64N".equals(string4)) {
            string3 = "64";
        }
        if (string2.indexOf("64") > -1 && "32".equals(string3)) {
            return 5;
        }
        if (string4 != null && string4.contains("amd")) {
            string4 = "x86";
        }
        if (string.startsWith("Apple")) {
            return 0;
        }
        if (string4.contains("x86") && !string.startsWith("Sun") && !string.startsWith("Oracle")) {
            return 3;
        }
        return 0;
    }

    private static int doNativeSzTests() {
        Properties properties = new Properties();
        properties.put("log4j.rootLogger", "OFF, A1");
        properties.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.put("log4j.appender.A1.Target", "System.err");
        properties.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.put("log4j.appender.A1.layout.ConversionPattern", "%p [%c] %m\n");
        PropertyConfigurator.configure((Properties)properties);
        try {
            NativeSz.getStreamVersion();
            return 0;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            UnsatisfiedLinkError[] unsatisfiedLinkErrorArray;
            for (UnsatisfiedLinkError unsatisfiedLinkError2 : unsatisfiedLinkErrorArray = NativeSzInfo.listFailures()) {
                unsatisfiedLinkError2.printStackTrace();
            }
            return 4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 100;
        }
    }

    private static int testNativeDB2() {
        try {
            Class<?> clazz = Class.forName("com.ibm.db2.jdbc.app.DB2Driver");
            clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return 0;
        }
        catch (Throwable throwable) {
            return 6;
        }
        return 0;
    }

    private static int testLongJNI() {
        int n = JVMTests.doNativeSzTests();
        if (n != 0) {
            return n;
        }
        LongObject longObject = new LongObject();
        try {
            Class<?> clazz = longObject.getClass();
            Field field = clazz.getDeclaredField("value");
            NativeSz.setLongField((Field)field, (Object)longObject, (long)1231258349442L);
            long l = NativeSz.getLongField((Field)field, (Object)longObject);
            if (l == 1231258349442L) {
                return 0;
            }
            return 7;
        }
        catch (Throwable throwable) {
            System.err.println("Unable to run Long JNI Test");
            throwable.printStackTrace();
            return 100;
        }
    }

    static class LongObject {
        long value;

        LongObject() {
        }
    }
}

