/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices;

import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.enterprise.core.webservices.WebServiceExecutorHelper;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import com.helpsystems.enterprise.core.webservices.WebServiceServer;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;

public class WebServiceRequestComposite
implements XMLSerializable,
Serializable {
    private static final long serialVersionUID = 6097325497314078491L;
    WebServiceRequest webServiceRequest = null;
    WebServiceServer webServiceServer = null;

    public WebServiceRequestComposite() {
    }

    public WebServiceRequestComposite(WebServiceRequest webServiceRequest, WebServiceServer webServiceServer) {
        this.webServiceRequest = webServiceRequest;
        this.webServiceServer = webServiceServer;
    }

    public WebServiceRequest getWebServiceRequest() {
        return this.webServiceRequest;
    }

    public void setWebServiceRequest(WebServiceRequest webServiceRequest) {
        this.webServiceRequest = webServiceRequest;
    }

    public WebServiceServer getWebServiceServer() {
        return this.webServiceServer;
    }

    public void setWebServiceServer(WebServiceServer webServiceServer) {
        this.webServiceServer = webServiceServer;
    }

    public String buildUrlString() {
        String string = this.webServiceServer.getUrl() + this.webServiceRequest.getAppUrl();
        System.out.println("Application URL: " + string);
        System.out.println();
        return string;
    }

    public String buildQueryString(HashMap<String, String> hashMap) throws UnsupportedEncodingException {
        Object[] objectArray = this.webServiceRequest.getParameters();
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("&");
            }
            String string = WebServiceExecutorHelper.replaceEnvVars(((WebServiceRequestParameter)objectArray[i]).getName(), hashMap);
            String string2 = WebServiceExecutorHelper.replaceEnvVars(((WebServiceRequestParameter)objectArray[i]).getValue(), hashMap);
            stringBuffer.append(URLEncoder.encode(string, this.webServiceServer.getCharSet()));
            stringBuffer.append("=");
            stringBuffer.append(URLEncoder.encode(string2, this.webServiceServer.getCharSet()));
        }
        return stringBuffer.toString();
    }

    public static void saveToDisk(WebServiceRequestComposite webServiceRequestComposite, String string) throws IOException {
        XMLUtil.writeObjectToFile((XMLSerializable)webServiceRequestComposite, (String)string);
    }

    public static WebServiceRequestComposite restoreFromDisk(String string) throws IOException {
        return (WebServiceRequestComposite)XMLUtil.loadObjectFromFile((String)string);
    }

    public String[] doNotInvoke() {
        return null;
    }

    public String toString() {
        String string = "WebServerDefinition(" + this.webServiceServer.getName() + ") Description(" + this.webServiceRequest.getDescription() + ") RuntimeEnvironmentVariables(" + this.webServiceRequest.getRuntimeEnvironmentVariables() + ") BaseURL(" + this.webServiceServer.getUrl() + ") ApplicationURL(" + this.webServiceRequest.getAppUrl() + ") RequestMethod(" + this.webServiceRequest.getRequestMethodValue() + ")" + " HeaderProperties(" + this.webServiceRequest.getRequestProperties() + ") RequestParameters(" + this.webServiceRequest.getRequestParameters() + ") MessageBodyOverride(" + this.webServiceRequest.getMessageBodyValue() + ")" + (this.webServiceRequest.getMessageBody() == 2 ? " UploadFile(" + this.webServiceRequest.getFileBody() + ")" : "") + " URLEncode(" + (this.webServiceRequest.getUrlEncode() ? "Y" : "N") + ") LogBodytoConsole(" + this.webServiceRequest.getOutputTypeValue() + ") SendBodytoFile(" + (this.webServiceRequest.getOutputToFile() ? this.webServiceRequest.getOutputFileName() : "") + ") SendHeaderstoFile(" + (this.webServiceRequest.getOutputHeadersToFile() ? this.webServiceRequest.getOutputHeadersFilename() : "") + ")";
        return string;
    }
}

