/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.webservices;

import com.helpsystems.enterprise.core.webservices.WebServiceClientWrapper;
import com.helpsystems.enterprise.core.webservices.WebServiceExecutor;
import com.helpsystems.enterprise.core.webservices.WebServiceExecutorHelper;
import com.helpsystems.enterprise.core.webservices.WebServiceRequest;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestComposite;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestParameter;
import com.helpsystems.enterprise.core.webservices.WebServiceRequestProperty;
import com.helpsystems.enterprise.core.webservices.WebServiceServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.encoding.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class WebServiceExecutor_Apache
implements WebServiceExecutor {
    private static final String TILDE = "~";

    public static void main(String[] stringArray) {
        int n;
        Object object;
        if (stringArray.length < 1) {
            WebServiceExecutor_Apache.exit(1, "Command failed: File name containing a web service request definition is required.");
        }
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            object = stringArray[i].split(":");
            n = ((String[])object).length;
            if (n > 0) {
                string = object[0].trim().toLowerCase();
            }
            string2 = null;
            if (n == 2) {
                string2 = object[1];
            } else if (n > 2) {
                String string4;
                string2 = string4 = stringArray[i].substring(object[0].length() + 1);
            }
            try {
                if (string.equals("-xml")) {
                    string3 = string2;
                    continue;
                }
                if (string.equals("-is_unix")) {
                    bl = Boolean.parseBoolean(string2);
                    continue;
                }
                WebServiceExecutor_Apache.exit(1, "Command failed: Invalid option parameter: " + string + " full parm: " + stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WebServiceExecutor_Apache.exit(1, "Command failed:" + illegalArgumentException.getMessage());
            }
        }
        File file = new File(string3);
        System.out.println("Loading Web Service Request Definition from: " + file.getAbsolutePath());
        WebServiceRequestComposite webServiceRequestComposite = null;
        try {
            webServiceRequestComposite = WebServiceRequestComposite.restoreFromDisk(file.getAbsolutePath());
        }
        catch (Exception exception) {
            System.out.println();
            exception.printStackTrace();
            System.out.println();
            WebServiceExecutor_Apache.exit(1, "Command failed: Error loading web service request definition.");
        }
        try {
            if (webServiceRequestComposite != null) {
                object = new WebServiceExecutor_Apache();
                n = ((WebServiceExecutor_Apache)object).processRequest(webServiceRequestComposite);
                System.out.println();
                int n4 = WebServiceExecutor_Apache.getExitCode(bl, n);
                WebServiceExecutor_Apache.exit(n4, "Web Service Command completed with status code: " + n);
            } else {
                WebServiceExecutor_Apache.exit(1, "Command failed: A web service request definition was not loaded.");
            }
        }
        catch (ClientProtocolException clientProtocolException) {
            System.out.println();
            clientProtocolException.printStackTrace();
            System.out.println();
            WebServiceExecutor_Apache.exit(1, "Command failed: Client Protocol Exception");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println();
            unsupportedEncodingException.printStackTrace();
            System.out.println();
            WebServiceExecutor_Apache.exit(1, "Command failed: Unsupported Encoding Exception");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println();
            fileNotFoundException.printStackTrace();
            System.out.println();
            WebServiceExecutor_Apache.exit(1, "Command failed: File Not Found Exception");
        }
        catch (Exception exception) {
            System.out.println("Failed. Cause: " + exception.getMessage());
            if (exception.getCause() != null) {
                System.out.println(exception.getCause().getMessage());
            }
            WebServiceExecutor_Apache.exit(1, "Command failed: " + exception.getLocalizedMessage(), exception);
        }
    }

    private static int getExitCode(boolean bl, int n) {
        if (bl) {
            if (n >= 256 && n <= 300) {
                return 2;
            }
            if (n >= 300 && n <= 400) {
                return 3;
            }
            if (n >= 400 && n <= 500) {
                return 4;
            }
            if (n >= 500 && n <= 600) {
                return 5;
            }
        }
        return n;
    }

    @Override
    public int processRequest(WebServiceRequestComposite webServiceRequestComposite) throws ClientProtocolException, IOException, URISyntaxException, FileNotFoundException {
        System.out.println("Starting command : " + webServiceRequestComposite.getWebServiceRequest().getDescription());
        System.out.println();
        int n = 0;
        HashMap<String, String> hashMap = webServiceRequestComposite.getWebServiceRequest().importEnvVars();
        String string = webServiceRequestComposite.buildUrlString();
        string = WebServiceExecutorHelper.replaceEnvVars(string, hashMap);
        URI uRI = new URI(string);
        string = uRI.toASCIIString();
        System.out.println("URL (encoded): " + string);
        System.out.println();
        switch (webServiceRequestComposite.getWebServiceRequest().getRequestMethod()) {
            case 0: {
                String string2 = webServiceRequestComposite.buildQueryString(hashMap);
                if (string2.length() > 0) {
                    string = string + "?" + string2;
                    System.out.println("URL (with query string): " + string);
                    System.out.println();
                }
                n = this.get(new HttpGet(string), webServiceRequestComposite, hashMap);
                break;
            }
            case 1: {
                n = this.post(new HttpPost(string), webServiceRequestComposite, hashMap);
                break;
            }
            case 2: {
                n = this.put(new HttpPut(string), webServiceRequestComposite, hashMap);
                break;
            }
            case 3: {
                String string3 = webServiceRequestComposite.buildQueryString(hashMap);
                if (string3.length() > 0) {
                    string = string + "?" + string3;
                    System.out.println("URL (with query string): " + string);
                    System.out.println();
                }
                n = this.delete(new HttpDelete(string), webServiceRequestComposite, hashMap);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported request method: " + webServiceRequestComposite.getWebServiceRequest().getRequestMethod());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int get(HttpGet httpGet, WebServiceRequestComposite webServiceRequestComposite, HashMap<String, String> hashMap) throws ClientProtocolException, IOException {
        System.out.println("Request Method: " + httpGet.toString());
        System.out.println();
        WebServiceRequest webServiceRequest = webServiceRequestComposite.getWebServiceRequest();
        WebServiceServer webServiceServer = webServiceRequestComposite.getWebServiceServer();
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (webServiceServer.getTrustAll()) {
            System.out.println("Accepting all SSL Certificates");
            defaultHttpClient = WebServiceClientWrapper.wrapClient((HttpClient)defaultHttpClient);
        }
        this.loadHeaderProperties((AbstractHttpMessage)httpGet, webServiceRequest, hashMap);
        this.loadAuthentication((AbstractHttpMessage)httpGet, webServiceServer);
        this.configureProxyServer((HttpClient)defaultHttpClient);
        try {
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            int n = this.processResponse(webServiceRequest, httpResponse, hashMap);
            return n;
        }
        finally {
            this.releaseConnection((HttpRequestBase)httpGet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int post(HttpPost httpPost, WebServiceRequestComposite webServiceRequestComposite, HashMap<String, String> hashMap) throws ClientProtocolException, IOException, FileNotFoundException {
        System.out.println("Request Method: " + httpPost.toString());
        System.out.println();
        WebServiceRequest webServiceRequest = webServiceRequestComposite.getWebServiceRequest();
        WebServiceServer webServiceServer = webServiceRequestComposite.getWebServiceServer();
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (webServiceServer.getTrustAll()) {
            System.out.println("Accepting all SSL Certificates");
            defaultHttpClient = WebServiceClientWrapper.wrapClient((HttpClient)defaultHttpClient);
        }
        this.loadHeaderProperties((AbstractHttpMessage)httpPost, webServiceRequest, hashMap);
        this.loadAuthentication((AbstractHttpMessage)httpPost, webServiceServer);
        this.configureProxyServer((HttpClient)defaultHttpClient);
        httpPost.setEntity(this.getEntity(webServiceRequest, webServiceServer, hashMap));
        try {
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            int n = this.processResponse(webServiceRequest, httpResponse, hashMap);
            return n;
        }
        finally {
            this.releaseConnection((HttpRequestBase)httpPost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int put(HttpPut httpPut, WebServiceRequestComposite webServiceRequestComposite, HashMap<String, String> hashMap) throws ClientProtocolException, IOException, FileNotFoundException {
        System.out.println("Request Method: " + httpPut.toString());
        System.out.println();
        WebServiceRequest webServiceRequest = webServiceRequestComposite.getWebServiceRequest();
        WebServiceServer webServiceServer = webServiceRequestComposite.getWebServiceServer();
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (webServiceServer.getTrustAll()) {
            System.out.println("Accepting all SSL Certificates");
            defaultHttpClient = WebServiceClientWrapper.wrapClient((HttpClient)defaultHttpClient);
        }
        this.loadHeaderProperties((AbstractHttpMessage)httpPut, webServiceRequest, hashMap);
        this.loadAuthentication((AbstractHttpMessage)httpPut, webServiceServer);
        httpPut.setEntity(this.getEntity(webServiceRequest, webServiceServer, hashMap));
        this.configureProxyServer((HttpClient)defaultHttpClient);
        try {
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPut);
            int n = this.processResponse(webServiceRequest, httpResponse, hashMap);
            return n;
        }
        finally {
            this.releaseConnection((HttpRequestBase)httpPut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int delete(HttpDelete httpDelete, WebServiceRequestComposite webServiceRequestComposite, HashMap<String, String> hashMap) throws ClientProtocolException, IOException {
        System.out.println("Request Method: " + httpDelete.toString());
        System.out.println();
        WebServiceRequest webServiceRequest = webServiceRequestComposite.getWebServiceRequest();
        WebServiceServer webServiceServer = webServiceRequestComposite.getWebServiceServer();
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (webServiceServer.getTrustAll()) {
            System.out.println("Accepting all SSL Certificates");
            defaultHttpClient = WebServiceClientWrapper.wrapClient((HttpClient)defaultHttpClient);
        }
        this.loadHeaderProperties((AbstractHttpMessage)httpDelete, webServiceRequest, hashMap);
        this.loadAuthentication((AbstractHttpMessage)httpDelete, webServiceServer);
        this.configureProxyServer((HttpClient)defaultHttpClient);
        try {
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpDelete);
            int n = this.processResponse(webServiceRequest, httpResponse, hashMap);
            return n;
        }
        finally {
            this.releaseConnection((HttpRequestBase)httpDelete);
        }
    }

    private void releaseConnection(HttpRequestBase httpRequestBase) {
        if (httpRequestBase == null) {
            return;
        }
        try {
            httpRequestBase.releaseConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configureProxyServer(HttpClient httpClient) {
        String string = "SKYBOT_WS_PROXY_URL";
        String string2 = "SKYBOT_WS_PROXY_PORT";
        String string3 = "SKYBOT_WS_PROXY_PROTOCOL";
        try {
            String string4 = System.getenv(string);
            String string5 = System.getenv(string2);
            String string6 = System.getenv(string3);
            if (string4 != null && string5 != null && string6 != null) {
                System.out.println("Configuring Proxy Server: ");
                System.out.println("\tProxy URL: " + string4);
                System.out.println("\tProxy Port: " + string5);
                System.out.println("\tProxy Protocol: " + string6);
                System.out.println();
                int n = Integer.valueOf(string5);
                HttpHost httpHost = new HttpHost(string4, n, string6);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
            } else if (string4 != null || string5 != null || string6 != null) {
                System.out.println("Incomplete settings for configuring Proxy Server: ");
                System.out.println("\t" + string + ": " + string4);
                System.out.println("\t" + string2 + ": " + string5);
                System.out.println("\t" + string3 + ": " + string6);
                System.out.println();
            }
        }
        catch (Exception exception) {
            System.out.println("Error setting Proxy Server: " + exception.getMessage());
        }
    }

    private void loadHeaderProperties(AbstractHttpMessage abstractHttpMessage, WebServiceRequest webServiceRequest, HashMap<String, String> hashMap) {
        System.out.println("Properties:");
        Object[] objectArray = webServiceRequest.getProperties();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = WebServiceExecutorHelper.replaceEnvVars(((WebServiceRequestProperty)objectArray[i]).getName(), hashMap);
            String string2 = WebServiceExecutorHelper.replaceEnvVars(((WebServiceRequestProperty)objectArray[i]).getValue(), hashMap);
            if (string.equalsIgnoreCase("Content-Length")) {
                System.out.println("\t** Ignoring special property: " + string + "=" + string2);
                continue;
            }
            System.out.println("\t" + string + "=" + string2);
            abstractHttpMessage.setHeader(string, string2);
        }
        System.out.println();
    }

    private void loadAuthentication(AbstractHttpMessage abstractHttpMessage, WebServiceServer webServiceServer) {
        String string = "Authorization";
        if (webServiceServer.getAuthType() == 1) {
            System.out.println("Basic Authentication:");
            Header[] headerArray = abstractHttpMessage.getHeaders(string);
            if (headerArray != null && headerArray.length > 0) {
                System.out.println("\tAuthorization is already specified in the headers.  Ignoring Web Service Server Basic Authentication.");
                System.out.println();
                return;
            }
            String string2 = webServiceServer.getAuthUser() + ":" + webServiceServer.authPwd();
            String string3 = Base64.encode((byte[])string2.getBytes());
            String string4 = "Basic " + string3;
            System.out.println("\t" + string + "=" + "{hidden}");
            System.out.println();
            abstractHttpMessage.setHeader(string, string4);
        }
    }

    private int processResponse(WebServiceRequest webServiceRequest, HttpResponse httpResponse, HashMap<String, String> hashMap) throws UnsupportedEncodingException, IllegalStateException, IOException {
        int n = httpResponse.getStatusLine().getStatusCode();
        String string = httpResponse.getStatusLine().getReasonPhrase();
        System.out.println();
        System.out.println("Response Code: " + n);
        System.out.println("Response Message: " + string);
        System.out.println();
        int n2 = 0;
        if (n != 200 && n != 201) {
            n2 = n;
        }
        HttpEntity httpEntity = httpResponse.getAllHeaders();
        System.out.println("Headers: ");
        for (Header header : httpEntity) {
            System.out.println("\t" + header.getName() + "=" + header.getValue());
        }
        System.out.println();
        this.writeResponseHeaderFile(webServiceRequest, hashMap, n, string, (Header[])httpEntity);
        HttpEntity httpEntity2 = httpResponse.getEntity();
        if (webServiceRequest.getOutputToFile() || webServiceRequest.getOutputType() != 0) {
            InputStream inputStream = httpEntity2.getContent();
            if (webServiceRequest.getOutputToFile()) {
                File file = this.processResponseToFile(webServiceRequest, inputStream, hashMap);
                this.close(inputStream);
                inputStream = new FileInputStream(file);
            }
            if (webServiceRequest.getOutputType() != 0) {
                Header header;
                header = httpResponse.getFirstHeader("Content-Type");
                String string2 = null;
                if (header != null) {
                    string2 = header.getValue();
                } else {
                    String string3 = "text/html;charset=UTF-8";
                    System.out.println("Response Header 'Content-Type' was not provided.  Defaulting: " + string3);
                    System.out.println();
                    string2 = string3;
                }
                if (webServiceRequest.getOutputType() == 1) {
                    this.processResponseToConsole(webServiceRequest, "Content-Type", string2, inputStream);
                } else if (n < 200 || n > 299) {
                    this.processResponseToConsole(webServiceRequest, "Content-Type", string2, inputStream);
                }
            }
            this.close(inputStream);
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity2);
        return n2;
    }

    private void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseHeaderFile(WebServiceRequest webServiceRequest, HashMap<String, String> hashMap, int n, String string, Header[] headerArray) {
        if (!webServiceRequest.getOutputHeadersToFile()) {
            return;
        }
        String string2 = WebServiceExecutorHelper.replaceEnvVars(webServiceRequest.getOutputHeadersFilename(), hashMap);
        if (string2 == null || string2.length() == 0) {
            System.out.println("File Path is required for Response Header Output.");
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            string2 = WebServiceExecutor_Apache.replaceTildeInPath(string2);
            File file = new File(string2);
            String string3 = System.getProperty("line.separator");
            System.out.println("Sending response headers to file: " + file.getAbsolutePath());
            System.out.println();
            outputStreamWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("Response Code: " + String.valueOf(n) + string3);
            bufferedWriter.write("Response Text: " + string + string3);
            for (Header header : headerArray) {
                bufferedWriter.write(header.getName() + ": " + header.getValue() + string3);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error writing headers output file.");
            iOException.printStackTrace();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File processResponseToFile(WebServiceRequest webServiceRequest, InputStream inputStream, HashMap<String, String> hashMap) throws UnsupportedEncodingException, IOException {
        int n;
        String string = WebServiceExecutorHelper.replaceEnvVars(webServiceRequest.getOutputFileName(), hashMap);
        string = WebServiceExecutor_Apache.replaceTildeInPath(string);
        File file = new File(string);
        System.out.println("Sending response output to file: " + file.getAbsolutePath());
        System.out.println();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponseToConsole(WebServiceRequest webServiceRequest, String string, String string2, InputStream inputStream) throws UnsupportedEncodingException, IOException {
        String string3 = string;
        String string4 = string2;
        if (string3 == null || string4 == null) {
            System.out.println("Undefined content type. The output will not be sent to the console.");
            return;
        }
        String string5 = null;
        Object object = string4.replace(" ", "").split(";");
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string6 = object[i];
            if (!string6.startsWith("charset=")) continue;
            string5 = string6.split("=", 2)[1];
            break;
        }
        if (string5 == null && (((String)(object = string4.toLowerCase())).startsWith("text/") || ((String)object).startsWith("application/") && (((String)object).contains("json") || ((String)object).contains("xml")))) {
            string5 = "UTF-8";
        }
        if (string5 != null) {
            object = null;
            try {
                String string7;
                object = new BufferedReader(new InputStreamReader(inputStream, string5));
                while ((string7 = ((BufferedReader)object).readLine()) != null) {
                    System.out.println(string7);
                }
                System.out.println();
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        System.out.println("'" + string3 + "=" + string4 + "' header does not contain a charset.  Binary data cannot be written to the console.");
    }

    private HttpEntity getEntity(WebServiceRequest webServiceRequest, WebServiceServer webServiceServer, HashMap<String, String> hashMap) throws FileNotFoundException {
        StringEntity stringEntity = null;
        try {
            Object object;
            Object object2;
            if (webServiceRequest.getFileBody().length() > 0) {
                object2 = WebServiceExecutorHelper.replaceEnvVars(webServiceRequest.getFileBody(), hashMap);
                object2 = WebServiceExecutor_Apache.replaceTildeInPath((String)object2);
                System.out.println("Body (File):");
                System.out.println("\t" + (String)object2);
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    throw new FileNotFoundException("The file was not found: " + ((File)object).getAbsolutePath());
                }
                stringEntity = new FileEntity((File)object);
            } else if (webServiceRequest.getStringBody().length() > 0) {
                object2 = WebServiceExecutorHelper.replaceEnvVars(webServiceRequest.getStringBody(), hashMap);
                if (webServiceRequest.getUrlEncode()) {
                    object2 = URLEncoder.encode((String)object2, webServiceServer.getCharSet());
                }
                System.out.println("Body (String):");
                System.out.println("\t" + (String)object2);
                stringEntity = new StringEntity((String)object2);
            }
            if (stringEntity == null && webServiceRequest.getParameters().length > 0) {
                object2 = new ArrayList();
                object = webServiceRequest.getParameters();
                Arrays.sort((Object[])object);
                System.out.println("Body (Parameters):");
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    String string = WebServiceExecutorHelper.replaceEnvVars(((WebServiceRequestParameter)object[i]).getName(), hashMap);
                    String string2 = WebServiceExecutorHelper.replaceEnvVars(((WebServiceRequestParameter)object[i]).getValue(), hashMap);
                    System.out.println("\t" + string + "=" + string2);
                    ((ArrayList)object2).add(new BasicNameValuePair(string, string2));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((List)object2, webServiceServer.getCharSet());
                stringEntity = urlEncodedFormEntity;
            }
            if (stringEntity == null) {
                System.out.println("No parameters or message body overrides were provided.");
            }
            System.out.println();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringEntity;
    }

    private static void exit(int n, String string) {
        WebServiceExecutor_Apache.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    private static String replaceTildeInPath(String string) {
        if (string == null) {
            return null;
        }
        if (System.getProperty("os.name").indexOf("Win") > -1) {
            return string;
        }
        if (string.startsWith(TILDE)) {
            return System.getProperty("user.home") + string.substring(1);
        }
        return string;
    }
}

