/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WildCardUtils {
    private static final boolean verbose = false;
    public static final char ASTERISK = '*';

    public static String wildcardToRegexp(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (!"*".equals(string)) {
            stringBuffer.append('^');
            int n = string.length();
            block4: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '*': {
                        stringBuffer.append("(.*)");
                        continue block4;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\").append(c);
                        continue block4;
                    }
                    default: {
                        stringBuffer.append('[').append(c).append(']');
                    }
                }
            }
            stringBuffer.append('$');
        } else {
            stringBuffer.append("^[^\\.].*");
        }
        return stringBuffer.toString();
    }

    public static String wildcardToRegexpForFileSystem(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append('^');
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuffer.append("(.*)");
                    continue block4;
                }
                case '\\': {
                    stringBuffer.append("\\\\").append(c);
                    continue block4;
                }
                default: {
                    stringBuffer.append('[').append(c).append(']');
                }
            }
        }
        stringBuffer.append('$');
        return stringBuffer.toString();
    }

    public static List<File> getFileListByRegExp(File file, String string, boolean bl) {
        return WildCardUtils.getFileListByRegExp(file, string, bl, true);
    }

    public static List<File> getFileListByRegExp(File file, String string, boolean bl, boolean bl2) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher("");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (bl || bl2) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!bl && file2.isDirectory() || !bl2 && file2.isFile()) continue;
                String string2 = file2.getName();
                matcher.reset(string2);
                boolean bl3 = matcher.matches();
                if (!bl3) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public static List<File> getFileListByRegExp(File file, String string, boolean bl, boolean bl2, boolean bl3, ArrayList<File> arrayList) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher("");
        if (bl || bl2) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return arrayList;
            }
            for (File file2 : fileArray) {
                if (!bl && file2.isDirectory() || !bl2 && file2.isFile()) continue;
                String string2 = file2.getName();
                matcher.reset(string2);
                boolean bl4 = matcher.matches();
                if (!bl4) continue;
                arrayList.add(file2);
                if (!bl3 || !file2.isDirectory()) continue;
                WildCardUtils.getFileListByRegExp(file2, string, bl, bl2, bl3, arrayList);
            }
        }
        return arrayList;
    }

    public static List<String> getNameListByRegExp(List<String> list, String string) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher("");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            matcher.reset(string2);
            boolean bl = matcher.matches();
            if (!bl) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

