/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.util.TimeZone;

public class SkybotTimeZone {
    private static final int MINUTE_MILLIS = 60000;
    private String id;
    private String displayName;
    private int rawOffset;
    private int dstSavings;

    public SkybotTimeZone(TimeZone timeZone) {
        this.id = timeZone.getID();
        this.displayName = timeZone.getDisplayName();
        this.rawOffset = timeZone.getRawOffset();
        this.dstSavings = timeZone.getDSTSavings();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public int getDstSavings() {
        return this.dstSavings;
    }

    public void setDstSavings(int n) {
        this.dstSavings = n;
    }

    public String getGMTOffsetDesc() {
        int n = this.rawOffset / 60000;
        String string = "GMT+";
        if (n < 0) {
            string = "GMT-";
        }
        int n2 = Math.abs(n / 60);
        int n3 = Math.abs(n % 60);
        String string2 = null;
        string2 = n3 == 0 ? string + n2 : (n3 < 10 ? string + n2 + ":0" + n3 : string + n2 + ":" + n3);
        return string2;
    }

    public String getGmtDstInfo() {
        if (this.dstSavings == 0) {
            return "(" + this.getGMTOffsetDesc() + ")";
        }
        return "(" + this.getGMTOffsetDesc() + " with DST)";
    }

    public String getFullDescription() {
        return this.getGmtDstInfo() + " " + this.getDisplayName();
    }
}

