/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class JobParameterUtil {
    private static Logger logger = Logger.getLogger(JobParameterUtil.class);
    private static final String TAB_DELIM = "\t";
    private static final String MEMBER_DELIM_START = "{";
    private static final String MEMBER_DELIM_END = "}_";
    private static final int MAX_PARAMETER_LENGTH = 8192;

    public static String overrideJobParameters(String string, String string2, String string3, String string4) {
        String string5 = JobParameterUtil.overrideJobParameters(string, string3, string2);
        if ((string5 = JobParameterUtil.overrideJobParameters(string, string5, string4)).length() > 8192) {
            throw new IllegalStateException("Merged parameters object for job " + string + " exceeds maximum combined length of " + 8192 + ". Length=" + string5.length());
        }
        return string5;
    }

    private static String overrideJobParameters(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        Map<String, String> map = JobParameterUtil.removeAnyTargetedParams(JobParameterUtil.parseJobParams(string2));
        Map<String, String> map2 = JobParameterUtil.findTargetedParamsForJob(string, JobParameterUtil.parseJobParams(string2));
        Map<String, String> map3 = JobParameterUtil.removeAnyTargetedParams(JobParameterUtil.parseJobParams(string3));
        Map<String, String> map4 = JobParameterUtil.findTargetedParamsForJob(string, JobParameterUtil.parseJobParams(string3));
        map3.putAll(map4);
        map.putAll(map3);
        map.putAll(map2);
        return JobParameterUtil.formatJobParams(map);
    }

    private static Map<String, String> parseJobParams(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (string == null || string.length() == 0) {
            return treeMap;
        }
        String[] stringArray = string.split(TAB_DELIM);
        for (String string2 : Arrays.asList(stringArray)) {
            int n = string2.indexOf(61);
            if (n < 1) {
                logger.warn((Object)("JobParameter value pair " + string2 + " is not valid and will be ignored."));
                continue;
            }
            treeMap.put(string2.substring(0, n), string2.substring(n + 1));
        }
        return treeMap;
    }

    private static String formatJobParams(Map<String, String> map) {
        String string = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (string.length() > 0) {
                string = string + TAB_DELIM;
            }
            string = string + entry.getKey() + "=" + entry.getValue();
        }
        return string;
    }

    private static Map<String, String> findTargetedParamsForJob(String string, Map<String, String> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string2 = MEMBER_DELIM_START + string.toLowerCase() + MEMBER_DELIM_END;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith(string2)) continue;
            String string3 = entry.getKey().substring(string2.length());
            treeMap.put(string3, entry.getValue());
        }
        return treeMap;
    }

    private static Map<String, String> removeAnyTargetedParams(Map<String, String> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().startsWith(MEMBER_DELIM_START)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }
}

