/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpSyntax;

public class HSSnmpPduPacket
extends SnmpPduPacket {
    private InetAddress sendingAddress;
    private SnmpOctetString community;
    private int port;

    public HSSnmpPduPacket(SnmpPduPacket snmpPduPacket, InetAddress inetAddress, SnmpOctetString snmpOctetString, int n) {
        this.setCommand(snmpPduPacket.getCommand());
        this.setPeer(snmpPduPacket.getPeer());
        this.setRequestId(snmpPduPacket.getRequestId());
        if (snmpPduPacket.getLength() > 0) {
            for (int i = 0; i < snmpPduPacket.getLength(); ++i) {
                this.addVarBind(snmpPduPacket.getVarBindAt(i));
            }
        }
        this.sendingAddress = inetAddress;
        this.community = snmpOctetString;
        this.port = n;
    }

    public String getCommunity() {
        return this.community.toString();
    }

    public void setCommunity(SnmpOctetString snmpOctetString) {
        this.community = snmpOctetString;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getHostName() {
        return this.sendingAddress.toString();
    }

    public InetAddress getSendingAddress() {
        return this.sendingAddress;
    }

    public void setSendingAddress(InetAddress inetAddress) {
        this.sendingAddress = inetAddress;
    }

    public Object clone() {
        return null;
    }

    public SnmpSyntax duplicate() {
        return null;
    }
}

