/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import com.helpsystems.enterprise.core.util.SimpleWildcardFileFinder;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileHandler {
    private static Logger logger = Logger.getLogger(FileHandler.class);

    public static ArrayList<String> getDirFilePathList(String string) {
        SimpleWildcardFileFinder simpleWildcardFileFinder = new SimpleWildcardFileFinder('*');
        File[] fileArray = simpleWildcardFileFinder.getFileList(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    public static boolean deleteDir(File file) {
        boolean bl = false;
        try {
            FileUtils.deleteDirectory((File)file);
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteDirIfEmpty(File file) {
        String string = "Unable to delete directory: ";
        if (!file.isDirectory()) {
            logger.warn((Object)(string + file.getPath() + ". It is not a directory."));
            return false;
        }
        if (file.delete()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Deleted empty directory: " + file.getPath()));
            }
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Probably not empty - not deleted:" + file.getPath()));
        }
        return false;
    }

    public static String getFileExactName(String string) {
        return FilenameUtils.getName((String)string);
    }

    public static String getFileParentPath(String string) {
        return FilenameUtils.getFullPathNoEndSeparator((String)string);
    }

    public static boolean isFileInDirectory(File file, String string) {
        boolean bl = false;
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = fileArray[i].getName();
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String generateIncrementFileName(File file) {
        String string = file.getName();
        String string2 = FilenameUtils.getBaseName((String)string);
        String string3 = FilenameUtils.getExtension((String)string);
        File file2 = file.getParentFile();
        int n = 0;
        while (FileHandler.isFileInDirectory(file2, string)) {
            ++n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append('(');
            stringBuilder.append(n);
            stringBuilder.append(')');
            if (string3 != "") {
                stringBuilder.append('.');
                stringBuilder.append(string3);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static long getFileSizeInBytes(String string) {
        long l = 0L;
        File file = new File(string);
        l = !file.exists() || !file.isFile() ? -1L : FileUtils.sizeOf((File)file);
        return l;
    }

    private static File deleteDirAndGetParent(File file) {
        File file2 = file.getParentFile();
        if (!file.exists()) {
            return file2;
        }
        boolean bl = FileHandler.deleteDirIfEmpty(file);
        if (!bl) {
            file2 = null;
        }
        return file2;
    }

    public static boolean deleteFilesUntilGivenFolder(String string, String string2) {
        File file = new File(string);
        boolean bl = false;
        if (!file.isDirectory()) {
            File file2 = file.getParentFile();
            bl = file.delete();
            if (bl) {
                logger.trace((Object)("Deleted file: " + file.getPath()));
                while (file2 != null && !file2.getName().equals(string2)) {
                    file2 = FileHandler.deleteDirAndGetParent(file2);
                }
            } else {
                logger.warn((Object)("Unable to delete file: " + file.getPath()));
            }
        }
        return bl;
    }

    public static void deleteFileWithParents(String string, int n) {
        File file = new File(string);
        for (int i = 0; i < n && file != null && file.exists(); ++i) {
            file = FileHandler.deleteDirAndGetParent(file);
        }
    }

    public static void deleteEmptyParentFoldersUntilGivenFolder(String string, String string2) {
        File file = new File(string);
        while (file != null && !file.getName().equals(string2)) {
            file = FileHandler.deleteDirAndGetParent(file);
        }
    }

    public static String getFileWithLastDate(List<String> list) {
        String string = "";
        Date date = new Date(-1L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyyyy_HHmmss");
        for (String string2 : list) {
            int n = string2.indexOf(95) + 1;
            int n2 = string2.lastIndexOf(46);
            if (n != -1 && n2 != -1) {
                String string3 = string2.substring(n, n2);
                try {
                    Date date2 = simpleDateFormat.parse(string3);
                    if (!date2.after(date)) continue;
                    date = date2;
                    string = string2;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                continue;
            }
            throw new IllegalArgumentException("Some file paths in the list are incorrect.");
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "c:\\file_testing";
        File file = new File(string);
        boolean bl = file.isDirectory();
        if (!bl) {
            System.out.println("Making directory " + file.getAbsolutePath());
            file.mkdir();
        }
        File file2 = new File("c:\\file_testing\\fixed.txt");
        try {
            System.out.println("Adding new file " + file2.getName());
            file2.createNewFile();
        }
        catch (IOException iOException) {
            System.out.println("Unable to create new file " + file2.getName());
            iOException.printStackTrace();
        }
        for (int i = 0; i < 6; ++i) {
            String string2 = FileHandler.generateIncrementFileName(file2);
            System.out.println(string + "\\" + string2);
            try {
                File file3 = new File(string + "\\" + string2);
                file3.createNewFile();
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Unable to create new file " + string2);
                iOException.printStackTrace();
            }
        }
        if (!bl) {
            FileHandler.deleteDir(file);
        }
    }

    public static boolean containsDublicateNames(List<String> list) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = FileHandler.getFileExactName(string);
            if (!arrayList.contains(string2)) {
                arrayList.add(string2);
                continue;
            }
            bl = true;
            break;
        }
        return bl;
    }
}

