/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;

public class ExtractVariable {
    public static final String SUBSTITUTION_MARKER = "?";
    private static final String REGEX_ESCAPE = "\\";
    private static final String SUBSTITUTION_MARKER_REGEX = "\\?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            String string2;
            File file;
            String string3;
            int n = 4;
            if (stringArray.length != n) {
                string3 = n + " parameters are required. " + stringArray.length + " were specified:";
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = string3 + "\n  Parameter #" + (i + 1) + ": " + stringArray[i];
                }
                ExtractVariable.failTheProcess(string3, 1);
            }
            string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            String string6 = stringArray[3];
            if (string6.indexOf(SUBSTITUTION_MARKER) == -1) {
                ExtractVariable.failTheProcess("The return string does not contain the substitution marker '?': " + string6, 1);
            }
            if (!(file = new File(string3)).exists()) {
                ExtractVariable.failTheProcess("The file to scan does not exist: " + file.getAbsolutePath() + "': " + string6, 1);
            }
            FileReader fileReader = new FileReader(string3);
            bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                string = ExtractVariable.extract(string2, string4, string5);
                if (string == null) continue;
                System.out.println(string6.replaceAll(SUBSTITUTION_MARKER_REGEX, string));
                System.exit(0);
            }
            ExtractVariable.close(bufferedReader);
            string = "The text markers were not found in the file. Begin Marker: " + string4 + " End Marker: " + string5 + "";
            ExtractVariable.failTheProcess(string, 1);
            ExtractVariable.close(bufferedReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ExtractVariable.close(bufferedReader);
            ExtractVariable.failTheProcess(exception.getMessage(), 1);
        }
        finally {
            ExtractVariable.close(bufferedReader);
        }
        System.exit(0);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String extract(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return null;
        }
        n += string2.length();
        if (string3.length() == 0) {
            return string.substring(n);
        }
        int n2 = string.indexOf(string3, n);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n, n2);
    }

    private static void failTheProcess(String string, int n) {
        System.err.println("--- ERROR ---------------------------------------------------------");
        System.err.println(string);
        System.err.println("-------------------------------------------------------------------");
        ExtractVariable.printHelp();
        System.exit(n);
    }

    private static void printHelp() {
        System.err.println("");
        System.err.println("This program will scan for the first file line with text between two text markers.");
        System.err.println("The first matching text found will be substituted into a return string and printed to STDOUT.");
        System.err.println("");
        System.err.println("4 parameters are required: ");
        System.err.println("  - {file}           File to scan for text between markers.");
        System.err.println("  - {begin_marker}   Begining text marker for text scan.");
        System.err.println("  - {end_marker}     Ending text marker for text scan.  Empty string value means End-Of-Line");
        System.err.println("  - {return_string}  String containing Substitution Marker '?' to replace with found text.");
        System.err.println("");
        System.err.println("Example: ");
        System.err.println("");
        System.err.println("    java -cp {classpath} " + ExtractVariable.class.getName() + " {file} {begin_marker} {end_marker} {return_string}");
        System.err.println("");
    }
}

