/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoTest;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayCount;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ScheduleInfo_DayCountTest
extends ScheduleInfoTest {
    private ScheduleInfo_DayCount si;

    public ScheduleInfo_DayCountTest(String string) {
        super(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.si = new ScheduleInfo_DayCount();
    }

    @Override
    protected void tearDown() throws Exception {
        this.si = null;
        super.tearDown();
    }

    @Override
    public void testCreateScheduleInfoOfType() {
        super.testCreateScheduleInfoOfType();
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleJobProxy.ScheduleType.DATE_LIST, (Object)scheduleInfo.getScheduleType());
    }

    public void testValidate() {
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require Calendar");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setName("SomeCalendar");
        this.si.setCalendarObject(calendarObject);
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require Schedule Type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.si.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require Target Type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.si.setTargetType(ScheduleInfo.TargetType.AGENT);
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require TimeZone Type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require Base Date");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.si.setBaseDate(20100401);
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require Day Type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.si.setDayType(CalendarObject.DayType.WORKDAYS);
        try {
            this.si.validate();
            ScheduleInfo_DayCountTest.fail((String)"validate() should require Run Times");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(new LocalHHMM(0, 0));
        runtimes_Basic.addRuntime(new LocalHHMM(8, 15));
        runtimes_Basic.addRuntime(new LocalHHMM(11, 45));
        runtimes_Basic.addRuntime(new LocalHHMM(15, 5));
        this.si.setRuntimes(runtimes_Basic);
        this.si.validate();
    }

    public void testToString() {
        this.calendar.setName("SomeCalendar");
        this.si.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        this.si.setCalendarObject(this.calendar);
        this.si.setBaseDate(20100401);
        this.si.setDayCountInterval(3);
        this.si.setDayType(CalendarObject.DayType.WORKDAYS);
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(new LocalHHMM(0, 0));
        runtimes_Basic.addRuntime(new LocalHHMM(8, 15));
        runtimes_Basic.addRuntime(new LocalHHMM(11, 45));
        runtimes_Basic.addRuntime(new LocalHHMM(15, 5));
        this.si.setRuntimes(runtimes_Basic);
        String string = "Schedule type: DAY_COUNT|Timezone type: SERVER|Calendar: SomeCalendar|Interval: 3|Day type: WORKDAYS|Runtimes: [08:15, 11:45, 15:05]";
        String string2 = this.si.toString();
        ScheduleInfo_DayCountTest.assertEquals((String)string, (String)string2);
    }

    @Override
    public void testCalcNST() {
        this.calendar.setName("SomeCalendar");
        this.si.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        this.si.setCalendarObject(this.calendar);
        this.si.setBaseDate(20100401);
        this.si.setDayCountInterval(3);
        this.si.setDayType(CalendarObject.DayType.ALL_DAYS);
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(new LocalHHMM(0, 0));
        runtimes_Basic.addRuntime(new LocalHHMM(8, 15));
        runtimes_Basic.addRuntime(new LocalHHMM(15, 5));
        this.si.setRuntimes(runtimes_Basic);
        Calendar calendar = new GregorianCalendar();
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 1);
        calendar.set(11, 7);
        calendar.set(12, 43);
        Calendar calendar2 = this.si.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayCountTest.assertEquals((int)1, (int)calendar2.get(5));
        ScheduleInfo_DayCountTest.assertEquals((int)8, (int)calendar2.get(11));
        ScheduleInfo_DayCountTest.assertEquals((int)15, (int)calendar2.get(12));
        calendar = calendar2;
        calendar2 = this.si.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayCountTest.assertEquals((int)1, (int)calendar2.get(5));
        ScheduleInfo_DayCountTest.assertEquals((int)15, (int)calendar2.get(11));
        ScheduleInfo_DayCountTest.assertEquals((int)5, (int)calendar2.get(12));
        calendar = calendar2;
        calendar2 = this.si.calcNST(calendar, this.jobInfo, SERVER_TIME_ZONE);
        ScheduleInfo_DayCountTest.assertEquals((int)4, (int)calendar2.get(5));
        ScheduleInfo_DayCountTest.assertEquals((int)8, (int)calendar2.get(11));
        ScheduleInfo_DayCountTest.assertEquals((int)15, (int)calendar2.get(12));
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        calendar.set(1, 2010);
        calendar.set(2, 3);
        calendar.set(5, 1);
        calendar.set(11, 7);
        calendar.set(12, 43);
        calendar2 = this.si.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayCountTest.assertEquals((int)1, (int)calendar2.get(5));
        ScheduleInfo_DayCountTest.assertEquals((int)8, (int)calendar2.get(11));
        ScheduleInfo_DayCountTest.assertEquals((int)15, (int)calendar2.get(12));
        calendar = calendar2;
        calendar2 = this.si.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayCountTest.assertEquals((int)1, (int)calendar2.get(5));
        ScheduleInfo_DayCountTest.assertEquals((int)15, (int)calendar2.get(11));
        ScheduleInfo_DayCountTest.assertEquals((int)5, (int)calendar2.get(12));
        calendar = calendar2;
        calendar2 = this.si.calcNST(calendar, this.jobInfo, AGENT_TIME_ZONE);
        ScheduleInfo_DayCountTest.assertEquals((int)4, (int)calendar2.get(5));
        ScheduleInfo_DayCountTest.assertEquals((int)8, (int)calendar2.get(11));
        ScheduleInfo_DayCountTest.assertEquals((int)15, (int)calendar2.get(12));
    }

    public void testIsRunDay() {
        this.calendar.setName("SomeCalendar");
        this.si.setScheduleType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        this.si.setCalendarObject(this.calendar);
        this.si.setBaseDate(20100401);
        this.si.setDayCountInterval(3);
        this.si.setDayType(CalendarObject.DayType.WORKDAYS);
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(new LocalHHMM(0, 0));
        runtimes_Basic.addRuntime(new LocalHHMM(8, 15));
        runtimes_Basic.addRuntime(new LocalHHMM(11, 45));
        runtimes_Basic.addRuntime(new LocalHHMM(15, 5));
        this.si.setRuntimes(runtimes_Basic);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 1);
        gregorianCalendar.set(11, 7);
        gregorianCalendar.set(12, 43);
        try {
            this.si.isRunDay(gregorianCalendar, this.jobInfo);
            ScheduleInfo_DayCountTest.fail((String)"isRunDay() should throw IllegalStateException for ScheduleInfo_DayCount");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetBaseDate() {
        this.si.setBaseDate(20100401);
        ScheduleInfo_DayCountTest.assertEquals((int)20100401, (int)this.si.getBaseDate());
    }

    public void testSetDayCountInterval() {
        this.si.setDayCountInterval(3);
        ScheduleInfo_DayCountTest.assertEquals((int)3, (int)this.si.getDayCountInterval());
    }

    public void testSetDayType() {
        this.si.setDayType(CalendarObject.DayType.NON_WORKDAYS);
        ScheduleInfo_DayCountTest.assertEquals((Object)CalendarObject.DayType.NON_WORKDAYS, (Object)this.si.getDayType());
    }

    public void testSetRuntimes() {
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(new LocalHHMM(0, 0));
        this.si.setRuntimes(runtimes_Basic);
        ScheduleInfo_DayCountTest.assertEquals((Object)runtimes_Basic, (Object)this.si.getRuntimes());
    }

    @Override
    public void testGetOmitDates() {
        this.si.setOmitDates(this.omitDates);
        ScheduleInfo_DayCountTest.assertEquals((Object)this.omitDates, (Object)this.si.getOmitDates());
    }

    @Override
    public void testSetLateStartJob() {
        this.si.setLateStartJob(false);
        ScheduleInfo_DayCountTest.assertFalse((boolean)this.si.isLateStartJob());
        this.si.setLateStartJob(true);
        ScheduleInfo_DayCountTest.assertTrue((boolean)this.si.isLateStartJob());
    }

    @Override
    public void testSetNonWorkdayOption() {
        this.si.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.DO_NOT_RUN);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.DO_NOT_RUN, (Object)this.si.getNonWorkdayOption());
        this.si.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.RUN);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.RUN, (Object)this.si.getNonWorkdayOption());
        this.si.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.RUN_ON_NEAREST_PRIOR_WORKDAY);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.RUN_ON_NEAREST_PRIOR_WORKDAY, (Object)this.si.getNonWorkdayOption());
        this.si.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.RUN_ON_NEAREST_SUBSEQUENT_WORKDAY);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.NonWorkdayOption.RUN_ON_NEAREST_SUBSEQUENT_WORKDAY, (Object)this.si.getNonWorkdayOption());
    }

    @Override
    public void testSetTargetID() {
        this.si.setTargetID(12345);
        ScheduleInfo_DayCountTest.assertEquals((int)12345, (int)this.si.getTargetID());
    }

    @Override
    public void testSetTargetType() {
        this.si.setTargetType(ScheduleInfo.TargetType.AGENT);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT, (Object)this.si.getTargetType());
        this.si.setTargetType(ScheduleInfo.TargetType.AGENT_GROUP);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.TargetType.AGENT_GROUP, (Object)this.si.getTargetType());
    }

    @Override
    public void testSetTimeZoneToUse() {
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.AGENT);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.TimeZoneType.AGENT, (Object)this.si.getTimeZoneType());
        this.si.setTimeZoneToUse(ScheduleInfo.TimeZoneType.SERVER);
        ScheduleInfo_DayCountTest.assertEquals((Object)ScheduleInfo.TimeZoneType.SERVER, (Object)this.si.getTimeZoneType());
    }

    @Override
    public void testSetUpdateCounter() {
        this.si.setUpdateCounter(54321);
        ScheduleInfo_DayCountTest.assertEquals((int)54321, (int)this.si.getUpdateCounter());
    }
}

