/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DateList;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayCount;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfPeriod;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo_TimedInterval;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public abstract class ScheduleInfoTest
extends TestCase {
    static TimeZone SERVER_TIME_ZONE = Calendar.getInstance().getTimeZone();
    static TimeZone AGENT_TIME_ZONE = TimeZone.getTimeZone("Europe/Moscow");
    static Calendar MAR15_AGENT_TIME_ZONE = new GregorianCalendar(AGENT_TIME_ZONE);
    static Calendar MAR16_AGENT_TIME_ZONE = new GregorianCalendar(AGENT_TIME_ZONE);
    static Calendar MAR17_AGENT_TIME_ZONE = new GregorianCalendar(AGENT_TIME_ZONE);
    static Calendar MAR18_AGENT_TIME_ZONE = new GregorianCalendar(AGENT_TIME_ZONE);
    static Calendar MAR20_AGENT_TIME_ZONE = new GregorianCalendar(AGENT_TIME_ZONE);
    static Calendar MAR15_SERVER_TIME_ZONE = new GregorianCalendar(SERVER_TIME_ZONE);
    static Calendar MAR16_SERVER_TIME_ZONE = new GregorianCalendar(SERVER_TIME_ZONE);
    static Calendar MAR17_SERVER_TIME_ZONE = new GregorianCalendar(SERVER_TIME_ZONE);
    static Calendar MAR18_SERVER_TIME_ZONE = new GregorianCalendar(SERVER_TIME_ZONE);
    static Calendar MAR20_SERVER_TIME_ZONE = new GregorianCalendar(SERVER_TIME_ZONE);
    protected CalendarObject calendar;
    protected JobInfo jobInfo;
    protected DateObject omitDates;

    public ScheduleInfoTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new CalendarObject();
        this.calendar.setName("MyCalendar");
        this.calendar.setDayStart(new LocalHHMM(0, 0));
        this.calendar.setNonWorkdayByDOW(EnumSet.of(CalendarObject.DayOfWeek.SAT, CalendarObject.DayOfWeek.SUN));
        this.omitDates = new DateObject();
        this.omitDates.setName("OmitDates");
        this.omitDates.setDates(new int[]{20100316, 20100318});
        this.jobInfo = new JobInfo(12, "Job12", 34, "Agent34");
    }

    protected void tearDown() throws Exception {
        this.jobInfo = null;
        this.calendar = null;
        super.tearDown();
    }

    public void testCreateScheduleInfoOfType() {
        ScheduleInfo scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DATE_LIST);
        ScheduleInfoTest.assertTrue((boolean)(scheduleInfo instanceof ScheduleInfo_DateList));
        scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DAY_COUNT);
        ScheduleInfoTest.assertTrue((boolean)(scheduleInfo instanceof ScheduleInfo_DayCount));
        scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DAY_OF_PERIOD);
        ScheduleInfoTest.assertTrue((boolean)(scheduleInfo instanceof ScheduleInfo_DayOfPeriod));
        scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.DAY_OF_WEEK);
        ScheduleInfoTest.assertTrue((boolean)(scheduleInfo instanceof ScheduleInfo_DayOfWeek));
        scheduleInfo = ScheduleInfo.createScheduleInfoOfType(ScheduleJobProxy.ScheduleType.TIMED_INTERVAL);
        ScheduleInfoTest.assertTrue((boolean)(scheduleInfo instanceof ScheduleInfo_TimedInterval));
    }

    public void testMarch15IsAMonday() {
        ScheduleInfoTest.assertEquals((int)2010, (int)MAR15_AGENT_TIME_ZONE.get(1));
        ScheduleInfoTest.assertEquals((int)2, (int)MAR15_AGENT_TIME_ZONE.get(2));
        ScheduleInfoTest.assertEquals((int)15, (int)MAR15_AGENT_TIME_ZONE.get(5));
        ScheduleInfoTest.assertEquals((int)2, (int)MAR15_AGENT_TIME_ZONE.get(7));
    }

    public void testMarch20IsASaturday() {
        ScheduleInfoTest.assertEquals((int)2010, (int)MAR20_AGENT_TIME_ZONE.get(1));
        ScheduleInfoTest.assertEquals((int)2, (int)MAR20_AGENT_TIME_ZONE.get(2));
        ScheduleInfoTest.assertEquals((int)20, (int)MAR20_AGENT_TIME_ZONE.get(5));
        ScheduleInfoTest.assertEquals((int)7, (int)MAR20_AGENT_TIME_ZONE.get(7));
    }

    public abstract void testCalcNST();

    public abstract void testGetOmitDates();

    public abstract void testSetLateStartJob();

    public abstract void testSetNonWorkdayOption();

    public abstract void testSetTargetID();

    public abstract void testSetTargetType();

    public abstract void testSetTimeZoneToUse();

    public abstract void testSetUpdateCounter();

    static {
        MAR15_AGENT_TIME_ZONE.set(1, 2010);
        MAR15_AGENT_TIME_ZONE.set(2, 2);
        MAR15_AGENT_TIME_ZONE.set(5, 15);
        MAR15_AGENT_TIME_ZONE.set(11, 9);
        MAR16_AGENT_TIME_ZONE.set(1, 2010);
        MAR16_AGENT_TIME_ZONE.set(2, 2);
        MAR16_AGENT_TIME_ZONE.set(5, 16);
        MAR16_AGENT_TIME_ZONE.set(11, 9);
        MAR17_AGENT_TIME_ZONE.set(1, 2010);
        MAR17_AGENT_TIME_ZONE.set(2, 2);
        MAR17_AGENT_TIME_ZONE.set(5, 17);
        MAR17_AGENT_TIME_ZONE.set(11, 9);
        MAR18_AGENT_TIME_ZONE.set(1, 2010);
        MAR18_AGENT_TIME_ZONE.set(2, 2);
        MAR18_AGENT_TIME_ZONE.set(5, 18);
        MAR18_AGENT_TIME_ZONE.set(11, 9);
        MAR20_AGENT_TIME_ZONE.set(1, 2010);
        MAR20_AGENT_TIME_ZONE.set(2, 2);
        MAR20_AGENT_TIME_ZONE.set(5, 20);
        MAR20_AGENT_TIME_ZONE.set(11, 9);
        MAR15_SERVER_TIME_ZONE.set(1, 2010);
        MAR15_SERVER_TIME_ZONE.set(2, 2);
        MAR15_SERVER_TIME_ZONE.set(5, 15);
        MAR15_SERVER_TIME_ZONE.set(11, 9);
        MAR16_SERVER_TIME_ZONE.set(1, 2010);
        MAR16_SERVER_TIME_ZONE.set(2, 2);
        MAR16_SERVER_TIME_ZONE.set(5, 16);
        MAR16_SERVER_TIME_ZONE.set(11, 9);
        MAR17_SERVER_TIME_ZONE.set(1, 2010);
        MAR17_SERVER_TIME_ZONE.set(2, 2);
        MAR17_SERVER_TIME_ZONE.set(5, 17);
        MAR17_SERVER_TIME_ZONE.set(11, 9);
        MAR18_SERVER_TIME_ZONE.set(1, 2010);
        MAR18_SERVER_TIME_ZONE.set(2, 2);
        MAR18_SERVER_TIME_ZONE.set(5, 18);
        MAR18_SERVER_TIME_ZONE.set(11, 9);
        MAR20_SERVER_TIME_ZONE.set(1, 2010);
        MAR20_SERVER_TIME_ZONE.set(2, 2);
        MAR20_SERVER_TIME_ZONE.set(5, 20);
        MAR20_SERVER_TIME_ZONE.set(11, 9);
    }
}

