/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfWeek;
import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class Runtimes_DayOfWeekTest
extends TestCase {
    private Runtimes_DayOfWeek runtimes;
    private CalendarObject calendar;
    private JobInfo jobInfo = null;

    public Runtimes_DayOfWeekTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calendar = new CalendarObject();
        this.runtimes = new Runtimes_DayOfWeek(this.calendar);
    }

    protected void tearDown() throws Exception {
        this.calendar = null;
        this.runtimes = null;
        super.tearDown();
    }

    public void testAddRuntime() {
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(7, 0));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK1, new LocalHHMM(8, 15));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.WED, Runtimes_DayOfWeek.RunCode.WEEK2, new LocalHHMM(9, 30));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.THU, Runtimes_DayOfWeek.RunCode.WEEK3, new LocalHHMM(10, 45));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.FRI, Runtimes_DayOfWeek.RunCode.WEEK4, new LocalHHMM(12, 0));
    }

    public void testFirstRuntimeOfDay() {
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(7, 0));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK4, new LocalHHMM(8, 15));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(9, 30));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 26);
        gregorianCalendar.set(11, 12);
        gregorianCalendar.set(12, 34);
        Runtimes_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        Calendar calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)26, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)7, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)0, (int)calendar.get(12));
        gregorianCalendar.set(5, 27);
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)gregorianCalendar.get(7));
        calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)27, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)8, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)15, (int)calendar.get(12));
        gregorianCalendar.set(5, 13);
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)gregorianCalendar.get(7));
        calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)13, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)9, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)30, (int)calendar.get(12));
    }

    public void testNextRuntimeSameDay() {
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(7, 0));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK4, new LocalHHMM(8, 15));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(9, 30));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2010);
        gregorianCalendar.set(2, 3);
        gregorianCalendar.set(5, 26);
        gregorianCalendar.set(11, 6);
        gregorianCalendar.set(12, 0);
        Runtimes_DayOfWeekTest.assertEquals((int)2, (int)gregorianCalendar.get(7));
        Calendar calendar = this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)26, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)7, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)0, (int)calendar.get(12));
        calendar = this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertNull((Object)calendar);
        gregorianCalendar.set(5, 27);
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)gregorianCalendar.get(7));
        calendar = this.runtimes.nextRuntimeSameDay(gregorianCalendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)27, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)8, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)15, (int)calendar.get(12));
        calendar = this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)27, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)9, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)30, (int)calendar.get(12));
        calendar = this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertNull((Object)calendar);
        gregorianCalendar.set(5, 13);
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)gregorianCalendar.get(7));
        calendar = this.runtimes.firstRuntimeOfDay(gregorianCalendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertEquals((int)2010, (int)calendar.get(1));
        Runtimes_DayOfWeekTest.assertEquals((int)3, (int)calendar.get(2));
        Runtimes_DayOfWeekTest.assertEquals((int)13, (int)calendar.get(5));
        Runtimes_DayOfWeekTest.assertEquals((int)9, (int)calendar.get(11));
        Runtimes_DayOfWeekTest.assertEquals((int)30, (int)calendar.get(12));
        calendar = this.runtimes.nextRuntimeSameDay(calendar, this.jobInfo);
        Runtimes_DayOfWeekTest.assertNull((Object)calendar);
    }

    public void testIsEmpty() {
        Runtimes_DayOfWeekTest.assertTrue((boolean)this.runtimes.isEmpty());
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(7, 0));
        Runtimes_DayOfWeekTest.assertFalse((boolean)this.runtimes.isEmpty());
    }

    public void testToString() {
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.MON, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(7, 0));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.WEEK4, new LocalHHMM(8, 15));
        this.runtimes.addRuntime(CalendarObject.DayOfWeek.TUE, Runtimes_DayOfWeek.RunCode.EVERY_WEEK, new LocalHHMM(9, 30));
        String string = "{MON=[07:00], TUE={1=[09:30], 2=[09:30], 3=[09:30], 4=[08:15, 09:30], 5=[09:30]}}";
        String string2 = this.runtimes.toString();
        Runtimes_DayOfWeekTest.assertEquals((String)string, (String)string2);
    }
}

