/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.Runtimes_WeekOfPeriod;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;

public class Runtimes_DayOfWeek
implements Runtimes {
    private CalendarObject calendarObject;
    private Map<CalendarObject.DayOfWeek, Runtimes> map = new EnumMap<CalendarObject.DayOfWeek, Runtimes>(CalendarObject.DayOfWeek.class);

    public Runtimes_DayOfWeek(CalendarObject calendarObject) {
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        this.calendarObject = calendarObject;
    }

    public void addRuntime(CalendarObject.DayOfWeek dayOfWeek, RunCode runCode, LocalHHMM localHHMM) {
        ValidationHelper.checkForNull((String)"Day of week", (Object)((Object)dayOfWeek));
        ValidationHelper.checkForNull((String)"Run code", (Object)runCode);
        ValidationHelper.checkForNull((String)"Runtime", (Object)((Object)localHHMM));
        Runtimes runtimes = this.map.get((Object)dayOfWeek);
        switch (runCode) {
            case NEVER: {
                break;
            }
            case EVERY_WEEK: {
                if (runtimes == null) {
                    runtimes = new Runtimes_Basic(this.calendarObject.getDayStart());
                    this.map.put(dayOfWeek, runtimes);
                }
                if (runtimes instanceof Runtimes_Basic) {
                    ((Runtimes_Basic)runtimes).addRuntime(localHHMM);
                    break;
                }
                ((Runtimes_WeekOfPeriod)runtimes).addRuntimeToEachWeek(localHHMM);
                break;
            }
            case LAST_WEEK: {
                if (runtimes == null) {
                    runtimes = new Runtimes_WeekOfPeriod(this.calendarObject);
                    this.map.put(dayOfWeek, runtimes);
                }
                if (runtimes instanceof Runtimes_WeekOfPeriod) {
                    ((Runtimes_WeekOfPeriod)runtimes).addLastWeekOfPeriodRuntime(localHHMM);
                    break;
                }
                Runtimes_Basic runtimes_Basic = (Runtimes_Basic)runtimes;
                Runtimes_WeekOfPeriod runtimes_WeekOfPeriod = new Runtimes_WeekOfPeriod(this.calendarObject);
                runtimes_WeekOfPeriod.addRuntimesToEachWeek(runtimes_Basic);
                runtimes_WeekOfPeriod.addLastWeekOfPeriodRuntime(localHHMM);
                this.map.put(dayOfWeek, runtimes_WeekOfPeriod);
                break;
            }
            default: {
                if (runtimes == null) {
                    runtimes = new Runtimes_WeekOfPeriod(this.calendarObject);
                    this.map.put(dayOfWeek, runtimes);
                }
                int n = this.extractWeekFromRunCode(runCode);
                if (runtimes instanceof Runtimes_WeekOfPeriod) {
                    ((Runtimes_WeekOfPeriod)runtimes).addRuntime(n, localHHMM);
                    break;
                }
                Runtimes_Basic runtimes_Basic = (Runtimes_Basic)runtimes;
                Runtimes_WeekOfPeriod runtimes_WeekOfPeriod = new Runtimes_WeekOfPeriod(this.calendarObject);
                runtimes_WeekOfPeriod.addRuntimesToEachWeek(runtimes_Basic);
                runtimes_WeekOfPeriod.addRuntime(n, localHHMM);
                this.map.put(dayOfWeek, runtimes_WeekOfPeriod);
            }
        }
    }

    @Override
    public Calendar firstRuntimeOfDay(Calendar calendar, JobInfo jobInfo) {
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        CalendarObject.DayOfWeek dayOfWeek = this.calendarObject.dayOfWeek(calendar);
        Runtimes runtimes = this.map.get((Object)dayOfWeek);
        if (runtimes == null) {
            return null;
        }
        return runtimes.firstRuntimeOfDay(calendar, jobInfo);
    }

    @Override
    public Calendar nextRuntimeSameDay(Calendar calendar, JobInfo jobInfo) {
        ValidationHelper.checkForNull((String)"Considered Scheduled Time", (Object)calendar);
        CalendarObject.DayOfWeek dayOfWeek = this.calendarObject.dayOfWeek(calendar);
        Runtimes runtimes = this.map.get((Object)dayOfWeek);
        if (runtimes == null) {
            return null;
        }
        return runtimes.nextRuntimeSameDay(calendar, jobInfo);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }

    private int extractWeekFromRunCode(RunCode runCode) {
        switch (runCode) {
            case WEEK1: {
                return 1;
            }
            case WEEK2: {
                return 2;
            }
            case WEEK3: {
                return 3;
            }
            case WEEK4: {
                return 4;
            }
            case WEEK5: {
                return 5;
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Unable to extract a week number from RunCode {0}.", (Object[])new Object[]{runCode}));
    }

    public static enum RunCode implements PersistableEnum<String>
    {
        NEVER(""),
        EVERY_WEEK("Y"),
        LAST_WEEK("L"),
        WEEK1("1"),
        WEEK2("2"),
        WEEK3("3"),
        WEEK4("4"),
        WEEK5("5");

        private String persistanceCode;
        private static PersistanceCodeToEnumMap<String, RunCode> map;

        private RunCode(String string2) {
            this.persistanceCode = string2;
        }

        @Override
        public String persistanceCode() {
            return this.persistanceCode;
        }

        public static RunCode persistanceCodeToEnum(String string) {
            RunCode runCode = map.get(string);
            if (runCode == null) {
                String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
                throw new IllegalStateException(string2);
            }
            return runCode;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])RunCode.values());
        }
    }
}

