/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.RuntimeRanges;
import com.helpsystems.enterprise.core.scheduler.TimeRange;
import java.util.Arrays;
import java.util.Calendar;

public class RuntimeRanges_Basic
implements RuntimeRanges {
    private TimeRange[] ranges = new TimeRange[1];
    private int size;

    public RuntimeRanges_Basic() {
    }

    public RuntimeRanges_Basic(TimeRange timeRange) {
        ValidationHelper.checkForNull((String)"Runtime Range", (Object)timeRange);
        this.addRuntimeRange(timeRange);
    }

    public TimeRange[] getRuntimeRanges() {
        Arrays.sort(this.ranges, 0, this.size);
        TimeRange[] timeRangeArray = new TimeRange[this.size];
        for (int i = 0; i < this.size; ++i) {
            timeRangeArray[i] = this.ranges[i];
        }
        return timeRangeArray;
    }

    public void addRuntimeRange(TimeRange timeRange) {
        ValidationHelper.checkForNull((String)"Runtime Range", (Object)timeRange);
        this.ensureCapacityForAdd();
        this.ranges[this.size++] = timeRange;
    }

    @Override
    public boolean contains(Calendar calendar) {
        ValidationHelper.checkForNull((String)"Date/Time", (Object)calendar);
        int n = this.toHHMM(calendar);
        for (int i = 0; i < this.size; ++i) {
            if (!this.ranges[i].contains(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean hasNoRuntimeRangesDefinedForDate(Calendar calendar) {
        return this.isEmpty();
    }

    public String toString() {
        return Arrays.toString(this.getRuntimeRanges());
    }

    private void ensureCapacityForAdd() {
        if (this.size == this.ranges.length) {
            TimeRange[] timeRangeArray = this.ranges;
            int n = this.size * 3 / 2 + 1;
            this.ranges = new TimeRange[n];
            System.arraycopy(timeRangeArray, 0, this.ranges, 0, this.size);
        }
    }

    private int toHHMM(Calendar calendar) {
        return calendar.get(11) * 100 + calendar.get(12);
    }
}

