/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteEntry;
import com.helpsystems.enterprise.core.scheduler.SpecificInstance;
import junit.framework.TestCase;

public class PrerequisiteEntryTest
extends TestCase {
    private PrerequisiteEntry entry;

    protected void setUp() throws Exception {
        super.setUp();
        this.entry = new PrerequisiteEntry();
    }

    protected void tearDown() throws Exception {
        this.entry = null;
        super.tearDown();
    }

    public void testSetOid() {
        this.entry.setOid(12345);
        PrerequisiteEntryTest.assertEquals((int)12345, (int)this.entry.getOid());
    }

    public void testSetDepJobID() {
        this.entry.setDepJobID(55443);
        PrerequisiteEntryTest.assertEquals((int)55443, (int)this.entry.getDepJobID());
    }

    public void testSetDepAgentID() {
        this.entry.setDepAgentID(58476);
        PrerequisiteEntryTest.assertEquals((int)58476, (int)this.entry.getDepAgentID());
    }

    public void testSetSpecificInstance() {
        SpecificInstance specificInstance = new SpecificInstance();
        this.entry.setSpecificInstance(specificInstance);
        PrerequisiteEntryTest.assertEquals((Object)((Object)specificInstance), (Object)((Object)this.entry.getSpecificInstance()));
    }

    public void testIsReactToSpecificInstanceOnly() {
        this.entry.setSpecialInstanceID(0L);
        PrerequisiteEntryTest.assertFalse((boolean)this.entry.isReactToSpecificInstanceOnly());
        this.entry.setSpecialInstanceID(12345L);
        PrerequisiteEntryTest.assertTrue((boolean)this.entry.isReactToSpecificInstanceOnly());
    }

    public void testSetReactToStatus() {
        this.entry.setReactToStatus(PrereqStatusType.FAILED);
        PrerequisiteEntryTest.assertEquals((Object)PrereqStatusType.FAILED, (Object)this.entry.getReactToStatus());
    }

    public void testSetSpecialInstanceID() {
        this.entry.setSpecialInstanceID(1234567L);
        PrerequisiteEntryTest.assertEquals((long)1234567L, (long)this.entry.getSpecialInstanceID());
    }

    public void testIsLatchStatus() {
        this.entry.setLatchStatus(false);
        PrerequisiteEntryTest.assertFalse((boolean)this.entry.isLatchStatus());
        this.entry.setLatchStatus(true);
        PrerequisiteEntryTest.assertTrue((boolean)this.entry.isLatchStatus());
    }

    public void testToString() {
        this.entry.setOid(1234);
        this.entry.setDepJobID(3456);
        this.entry.setDepAgentID(5678);
        this.entry.setSpecialInstanceID(7890L);
        this.entry.setReactToStatus(PrereqStatusType.FAILED);
        this.entry.setLatchStatus(true);
        String string = "PrerequisiteEntry.ID(1234).DEP_JOB_ID(3456).DEP_AGT_ID(5678).SPC_INST_ID(7890).REACT_TO_STS(FAILED).LATCH(true)";
        String string2 = this.entry.toString();
        PrerequisiteEntryTest.assertEquals((String)string, (String)string2);
    }

    public void testValidate() {
        this.entry.validate();
    }
}

