/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.enterprise.core.scheduler.DSTHelper;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class MovedNSTTest
extends TestCase {
    private MovedNST movedNST;
    private Calendar origNST;
    private Calendar adjNST;

    public MovedNSTTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.movedNST = null;
        super.tearDown();
    }

    public void testForward_Normal() {
        this.createCalendars();
        this.origNST.set(2010, 2, 9, 8, 0);
        this.adjNST.set(2010, 2, 12, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)3, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
        this.createCalendars();
        this.origNST.set(2010, 2, 9, 8, 0);
        this.adjNST.set(2010, 2, 9, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_CST_to_CDT() {
        this.createCalendars();
        this.origNST.set(2010, 2, 14, 0, 3);
        this.adjNST.set(2010, 2, 15, 0, 3);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_CDT_to_CST() {
        this.createCalendars();
        this.origNST.set(2010, 10, 5, 8, 0);
        this.adjNST.set(2010, 10, 8, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)3, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_Normal_GMT() {
        this.origNST = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.origNST.clear();
        this.adjNST = (Calendar)this.origNST.clone();
        this.origNST.set(2010, 2, 9, 8, 0);
        this.adjNST.set(2010, 2, 12, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)3, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_CST_to_CDT_Invalid_Date() {
        this.createCalendars();
        this.origNST.set(2010, 2, 13, 2, 10);
        this.adjNST = (Calendar)this.origNST.clone();
        MovedInvalidDateTime movedInvalidDateTime = null;
        try {
            DSTHelper.addDays(this.adjNST, 1);
            MovedNSTTest.fail((String)"Should throw an InvalidDateTimeException.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
        }
        this.movedNST = new MovedNST(movedInvalidDateTime, this.origNST);
        MovedNSTTest.assertEquals((int)1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)50, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_from_Invalid_date() {
        this.createCalendars();
        this.origNST.set(2010, 2, 13, 2, 10);
        MovedInvalidDateTime movedInvalidDateTime = null;
        try {
            DSTHelper.addDays(this.origNST, 1);
            MovedNSTTest.fail((String)"Should throw an InvalidDateTimeException.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
        }
        this.adjNST.set(2010, 2, 15, 2, 10);
        this.movedNST = new MovedNST(this.adjNST, movedInvalidDateTime);
        MovedNSTTest.assertEquals((int)1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)-50, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_Bogus_Date() {
        this.createCalendars();
        this.origNST.set(2010, 2, 9, 12, 0, 0);
        this.adjNST.set(2010, 2, 11, 8, 0, 14);
        try {
            this.movedNST = new MovedNST(this.adjNST, this.origNST);
            MovedNSTTest.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBackward_Normal() {
        this.createCalendars();
        this.origNST.set(2010, 2, 12, 8, 0);
        this.adjNST.set(2010, 2, 8, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)-4, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testBackward_CST_to_CDT() {
        this.createCalendars();
        this.origNST.set(2010, 10, 8, 0, 3);
        this.adjNST.set(2010, 10, 7, 0, 3);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)-1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testBackward_CDT_to_CST() {
        this.createCalendars();
        this.origNST.set(2010, 2, 14, 8, 0);
        this.adjNST.set(2010, 2, 13, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, this.origNST);
        MovedNSTTest.assertEquals((int)-1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)0, (int)this.movedNST.getMinutesMoved());
    }

    public void testBackward_CDT_to_CST_Invalid_Date() {
        this.createCalendars();
        this.origNST.set(2010, 2, 15, 2, 10);
        MovedInvalidDateTime movedInvalidDateTime = null;
        try {
            DSTHelper.addDays(this.origNST, -1);
            MovedNSTTest.fail((String)"Should throw an InvalidDateTimeException.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
        }
        this.adjNST.set(2010, 2, 13, 2, 10);
        this.movedNST = new MovedNST(this.adjNST, movedInvalidDateTime);
        MovedNSTTest.assertEquals((int)-1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)-50, (int)this.movedNST.getMinutesMoved());
    }

    public void testBackward_to_Invalid_date() {
        this.createCalendars();
        this.origNST.set(2010, 2, 15, 2, 10);
        Calendar calendar = (Calendar)this.origNST.clone();
        MovedInvalidDateTime movedInvalidDateTime = null;
        try {
            DSTHelper.addDays(calendar, -1);
            MovedNSTTest.fail((String)"Should throw an InvalidDateTimeException.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
        }
        this.movedNST = new MovedNST(movedInvalidDateTime, this.origNST);
        MovedNSTTest.assertEquals((int)-1, (int)this.movedNST.getDaysMoved());
        MovedNSTTest.assertEquals((int)50, (int)this.movedNST.getMinutesMoved());
    }

    public void testForward_Moved_Normal() {
        this.createCalendars();
        this.origNST.set(2010, 3, 1, 8, 0);
        this.adjNST.set(2010, 3, 4, 8, 0);
        this.movedNST = new MovedNST(this.adjNST, 3, 0);
        MovedNSTTest.assertEquals((long)this.adjNST.getTimeInMillis(), (long)this.movedNST.getTimeInMillis());
        MovedNSTTest.assertEquals((long)this.origNST.getTimeInMillis(), (long)this.movedNST.getOriginalNST().getTimeInMillis());
    }

    public void testForward_Moved_CST_to_CDT() {
        this.createCalendars();
        this.origNST.set(2010, 2, 14, 0, 3);
        this.adjNST.set(2010, 2, 15, 0, 3);
        this.movedNST = new MovedNST(this.adjNST, 1, 0);
        MovedNSTTest.assertEquals((long)this.adjNST.getTimeInMillis(), (long)this.movedNST.getTimeInMillis());
        MovedNSTTest.assertEquals((long)this.origNST.getTimeInMillis(), (long)this.movedNST.getOriginalNST().getTimeInMillis());
    }

    public void test_getOriginalDateTimeYYYYMMDDHHMM() {
        this.createCalendars();
        this.adjNST.set(2010, 3, 4, 9, 15);
        this.movedNST = new MovedNST(this.adjNST, 3, 0);
        MovedNSTTest.assertEquals((long)201004010915L, (long)this.movedNST.getOriginalDateTimeYYYYMMDDHHMM());
    }

    public void test_getOriginalDateTimeYYYYMMDDHHMM_invalid() {
        this.createCalendars();
        this.origNST.set(2010, 2, 15, 2, 10);
        MovedInvalidDateTime movedInvalidDateTime = null;
        try {
            DSTHelper.addDays(this.origNST, -1);
            MovedNSTTest.fail((String)"Should throw an InvalidDateTimeException.");
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            movedInvalidDateTime = invalidDateTimeException.getMovedInvalidDateTime();
        }
        this.adjNST.set(2010, 2, 13, 2, 10);
        this.movedNST = new MovedNST(this.adjNST, movedInvalidDateTime);
        MovedNSTTest.assertEquals((long)201003140210L, (long)this.movedNST.getOriginalDateTimeYYYYMMDDHHMM());
    }

    public void test_dstBoundaryCrossedWithDifferentRules() {
        TimeZone timeZone = TimeZone.getTimeZone("America/Phoenix");
        TimeZone timeZone2 = TimeZone.getTimeZone("America/Denver");
        MovedNSTTest.assertFalse((boolean)timeZone.hasSameRules(timeZone2));
        this.createCalendars();
        this.origNST.setTimeZone(timeZone2);
        this.origNST.set(2010, 2, 15, 2, 10);
        this.adjNST = (Calendar)this.origNST.clone();
        this.adjNST.setTimeZone(timeZone);
        this.adjNST.add(5, -1);
        try {
            this.movedNST = new MovedNST(this.adjNST, this.origNST);
            MovedNSTTest.fail((String)"Should throw a IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_Days_And_Minutes_Moved_Zero() {
        this.createCalendars();
        this.movedNST = new MovedNST(this.adjNST, 0, 0);
        try {
            this.movedNST.getOriginalNST();
            MovedNSTTest.fail((String)"Should throw a IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void createCalendars() {
        this.origNST = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        this.origNST.clear();
        this.adjNST = (Calendar)this.origNST.clone();
    }
}

