/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public class ForecastFilter {
    private ForecastFilterType type;
    private long[] ids;

    public ForecastFilter(ForecastFilterType forecastFilterType, long[] lArray) {
        ValidationHelper.checkForNull((String)"Forecast Filter Type", (Object)forecastFilterType);
    }

    public ForecastFilterType getType() {
        return this.type;
    }

    public long[] getIDs() {
        return this.ids;
    }

    public String toString() {
        return this.type + " " + this.ids;
    }

    public static enum ForecastFilterType implements PersistableEnum<Integer>
    {
        BY_AGENT(0),
        BY_AGENT_GROUP(1);

        private int persistanceCode;
        private static PersistanceCodeToEnumMap<Integer, ForecastFilterType> map;

        private ForecastFilterType(int n2) {
            this.persistanceCode = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.persistanceCode;
        }

        public static ForecastFilterType persistanceCodeToEnum(Integer n) {
            ForecastFilterType forecastFilterType = map.get(n);
            if (forecastFilterType == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return forecastFilterType;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])ForecastFilterType.values());
        }
    }
}

