/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.scheduler;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.MovedInvalidDateTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DSTHelper {
    public static void addDays(Calendar calendar, int n) throws InvalidDateTimeException {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar.add(5, n);
        if (DSTHelper.toHHMM(calendar) != DSTHelper.toHHMM(calendar2)) {
            String string;
            MovedInvalidDateTime movedInvalidDateTime;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            if (DSTHelper.isDueToDST()) {
                movedInvalidDateTime = new MovedInvalidDateTime(DSTHelper.dstBegins(calendar), DSTHelper.toLocalHHMM(calendar2));
                DSTHelper.validateDSTAdjustment(calendar, movedInvalidDateTime);
                string = MessageUtil.formatMsg((String)"An invalid date/time, caused by the switch to Daylight Saving Time, has been detected. Adding {0} day(s) to {1} results in an invalid date/time.", (Object[])new Object[]{n, simpleDateFormat.format(calendar2.getTime())});
            } else {
                movedInvalidDateTime = new MovedInvalidDateTime(calendar, DSTHelper.toLocalHHMM(calendar2));
                string = MessageUtil.formatMsg((String)"An invalid date/time has been detected. Adding {0} day(s) to {1} results in an invalid date/time.", (Object[])new Object[]{n, simpleDateFormat.format(calendar2.getTime())});
            }
            throw new InvalidDateTimeException(string, movedInvalidDateTime, DSTHelper.isDueToDST());
        }
    }

    public static Calendar dstBegins(Calendar calendar) {
        long l;
        long l2;
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        Calendar calendar2 = (Calendar)calendar.clone();
        TimeZone timeZone = calendar2.getTimeZone();
        if (DSTHelper.inDaylightTime(calendar2)) {
            l2 = calendar2.getTimeInMillis();
            l = DSTHelper.dateTimeThatIsCloseToButBeforeTheDSTPeriodBegins(calendar2).getTimeInMillis();
        } else {
            l = calendar2.getTimeInMillis();
            l2 = DSTHelper.dateTimeThatIsInTheNextDSTPeriod(calendar2).getTimeInMillis();
        }
        Date date = new Date(0L);
        while (l2 - l > 1L) {
            long l3 = (l + l2) / 2L;
            date.setTime(l3);
            if (timeZone.inDaylightTime(date)) {
                l2 = l3;
                continue;
            }
            l = l3;
        }
        calendar2.setTimeInMillis(l2);
        return calendar2;
    }

    public static boolean isInDSTtoStdTimeTransitionPeriod(Calendar calendar) {
        long l;
        Calendar calendar2;
        long l2;
        long l3;
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        TimeZone timeZone = calendar.getTimeZone();
        if (DSTHelper.inDaylightTime(calendar)) {
            l3 = calendar.getTimeInMillis();
            l2 = calendar.get(16);
            calendar2 = (Calendar)calendar.clone();
            calendar2.add(11, 24);
            if (DSTHelper.inDaylightTime(calendar2)) {
                return false;
            }
            l = calendar2.getTimeInMillis();
        } else {
            l = calendar.getTimeInMillis();
            calendar2 = (Calendar)calendar.clone();
            calendar2.add(11, -24);
            if (!DSTHelper.inDaylightTime(calendar2)) {
                return false;
            }
            l3 = calendar2.getTimeInMillis();
            l2 = calendar2.get(16);
        }
        Date date = new Date(0L);
        while (l - l3 > 1L) {
            long l4 = (l3 + l) / 2L;
            date.setTime(l4);
            if (timeZone.inDaylightTime(date)) {
                l3 = l4;
                continue;
            }
            l = l4;
        }
        long l5 = l;
        long l6 = l5 - l2;
        long l7 = l5 + l2 - 1L;
        return calendar.getTimeInMillis() >= l6 && calendar.getTimeInMillis() <= l7;
    }

    public static Calendar replaceTime(Calendar calendar, LocalHHMM localHHMM) throws InvalidDateTimeException {
        ValidationHelper.checkForNull((String)"Calendar", (Object)calendar);
        ValidationHelper.checkForNull((String)"New time", (Object)((Object)localHHMM));
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(11, localHHMM.getHourOfDay());
        calendar2.set(12, localHHMM.getMinuteOfHour());
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        DSTHelper.dstCheck(calendar2, localHHMM);
        return calendar2;
    }

    private static void dstCheck(Calendar calendar, LocalHHMM localHHMM) throws InvalidDateTimeException {
        int n;
        int n2 = DSTHelper.toHHMM(calendar);
        if (n2 != (n = localHHMM.toInt())) {
            String string;
            MovedInvalidDateTime movedInvalidDateTime;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String string2 = simpleDateFormat.format(calendar.getTime());
            String string3 = localHHMM.toString();
            if (DSTHelper.isDueToDST()) {
                movedInvalidDateTime = new MovedInvalidDateTime(DSTHelper.dstBegins(calendar), localHHMM);
                DSTHelper.validateDSTAdjustment(calendar, movedInvalidDateTime);
                string = MessageUtil.formatMsg((String)"An invalid date/time, caused by the switch to Daylight Saving Time, has been detected. {0} {1} does not exist.", (Object[])new Object[]{string2, string3});
            } else {
                movedInvalidDateTime = new MovedInvalidDateTime(calendar, localHHMM);
                string = MessageUtil.formatMsg((String)"An invalid date/time has been detected. {0} {1} does not exist.", (Object[])new Object[]{string2, string3});
            }
            throw new InvalidDateTimeException(string, movedInvalidDateTime, DSTHelper.isDueToDST());
        }
        if (DSTHelper.isInDSTtoStdTimeTransitionPeriod(calendar) && !DSTHelper.inDaylightTime(calendar)) {
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.add(11, -24);
            long l = calendar2.get(16);
            if (l == 0L) {
                throw new IllegalStateException("Program error. Expected a non-zero DST offset value.");
            }
            calendar.setTimeInMillis(calendar.getTimeInMillis() - l);
        }
    }

    private static Calendar dateTimeThatIsCloseToButBeforeTheDSTPeriodBegins(Calendar calendar) {
        if (!DSTHelper.inDaylightTime(calendar)) {
            throw new IllegalArgumentException("Usage error. The input date/time must be in Daylight Saving Time.");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, -2);
        Calendar calendar3 = (Calendar)calendar.clone();
        while (DSTHelper.inDaylightTime(calendar3) && calendar3.after(calendar2)) {
            calendar3.add(5, -1);
        }
        if (DSTHelper.inDaylightTime(calendar3)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not detect a Standard Time to Daylight Saving Time transition within 2 years of {0}.", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime())}));
        }
        return calendar3;
    }

    private static Calendar dateTimeThatIsInTheNextDSTPeriod(Calendar calendar) {
        if (DSTHelper.inDaylightTime(calendar)) {
            throw new IllegalArgumentException("Usage error. The input date/time must not be in Daylight Saving Time.");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, 2);
        Calendar calendar3 = (Calendar)calendar.clone();
        while (!DSTHelper.inDaylightTime(calendar3) && calendar3.before(calendar2)) {
            calendar3.add(5, 1);
        }
        if (!DSTHelper.inDaylightTime(calendar3)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not detect a Daylight Saving Time to Standard Time transition within 2 years of {0}.", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime())}));
        }
        return calendar3;
    }

    private static boolean inDaylightTime(Calendar calendar) {
        return calendar.getTimeZone().inDaylightTime(calendar.getTime());
    }

    private static boolean isDueToDST() {
        return true;
    }

    private static int toHHMM(Calendar calendar) {
        return calendar.get(11) * 100 + calendar.get(12);
    }

    private static LocalHHMM toLocalHHMM(Calendar calendar) {
        return new LocalHHMM(calendar.get(11), calendar.get(12));
    }

    private static void validateDSTAdjustment(Calendar calendar, MovedInvalidDateTime movedInvalidDateTime) {
        int n;
        long l = Math.abs(calendar.getTimeInMillis() - movedInvalidDateTime.getTimeInMillis());
        if (l > (long)(n = movedInvalidDateTime.get(16))) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error. The Daylight Saving Time adjustment to {0}, resulting in {1}, exceeds the DST offset of {2} milliseconds.", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(movedInvalidDateTime.getTime()), n}));
        }
    }

    private DSTHelper() {
    }
}

