/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.reports;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public class ReportOutput {
    public static final String DEFAULT_REPORTS_DIR_NAME = "report_queue";
    public static final int VAL_PDF = 0;
    public static final int VAL_XLS = 1;
    public static final int VAL_ODT = 2;
    public static final int VAL_CSV = 3;
    public static final int VAL_HTML = 4;
    private static final String TYPE_CSV = ".csv";
    private static final String TYPE_HTML = ".html";
    private static final String TYPE_ODT = ".odt";
    private static final String TYPE_PDF = ".pdf";
    private static final String TYPE_XLS = ".xls";

    public static enum OutputType implements PersistableEnum<Integer>
    {
        PDF(0),
        XLS(1),
        ODT(2),
        CSV(3),
        HTML(4);

        private int outputType;
        private static PersistanceCodeToEnumMap<Integer, OutputType> map;

        private OutputType(int n2) {
            this.outputType = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.outputType;
        }

        public static OutputType persistanceCodeToEnum(int n) {
            OutputType outputType = map.get(n);
            if (outputType == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return outputType;
        }

        public static OutputType getOutputType(String string) {
            ValidationHelper.checkForNullAndBlank((String)"Output type", (String)string);
            int n = Integer.parseInt(string);
            switch (n) {
                case 0: {
                    return PDF;
                }
                case 1: {
                    return XLS;
                }
                case 2: {
                    return ODT;
                }
                case 3: {
                    return CSV;
                }
                case 4: {
                    return HTML;
                }
            }
            throw new IllegalStateException("The Output type " + string + " is not supported.");
        }

        public String getReportTypeExtension() {
            switch (this.outputType) {
                case 0: {
                    return ReportOutput.TYPE_PDF;
                }
                case 1: {
                    return ReportOutput.TYPE_XLS;
                }
                case 2: {
                    return ReportOutput.TYPE_ODT;
                }
                case 3: {
                    return ReportOutput.TYPE_CSV;
                }
                case 4: {
                    return ReportOutput.TYPE_HTML;
                }
            }
            throw new IllegalStateException("The Output type " + this.outputType + " is not supported.");
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])OutputType.values());
        }
    }
}

